/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.analysis.AAFrequency;
import jalview.analysis.CodingUtils;
import jalview.analysis.Rna;
import jalview.analysis.StructureFrequency;
import jalview.api.AlignViewportI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.ProfilesI;
import jalview.renderer.AnnotationRendererFactory;
import jalview.renderer.AwtRenderPanelI;
import jalview.renderer.ResidueShader;
import jalview.renderer.ResidueShaderI;
import jalview.renderer.api.AnnotationRendererFactoryI;
import jalview.renderer.api.AnnotationRowRendererI;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ZappoColourScheme;
import jalview.util.Platform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jibble.epsgraphics.EpsGraphics2D;

public class AnnotationRenderer {
    private static final int UPPER_TO_LOWER = 32;
    private static final int CHAR_A = 65;
    private static final int CHAR_Z = 90;
    private final boolean debugRedraw;
    private int charWidth;
    private int endRes;
    private int charHeight;
    private boolean validCharWidth;
    private boolean hasHiddenColumns;
    private FontMetrics fm;
    private final boolean USE_FILL_ROUND_RECT = Platform.isAMacAndNotJS();
    boolean av_renderHistogram = true;
    boolean av_renderProfile = true;
    boolean av_normaliseProfile = false;
    boolean av_infoHeight = false;
    ResidueShaderI profcolour = null;
    private ColumnSelection columnSelection;
    private HiddenColumns hiddenColumns;
    private ProfilesI hconsensus;
    private Map<String, ProfilesI> hSSconsensus;
    private Hashtable<String, Object>[] complementConsensus;
    private Hashtable<String, Object>[] hStrucConsensus;
    private boolean av_ignoreGapsConsensus;
    private boolean renderingVectors = false;
    private boolean glyphLineDrawn = false;
    private boolean av_ignoreBelowBackground;
    private Image fadedImage;
    private ImageObserver annotationPanel;
    private int imgWidth;
    private int sOffset;
    private int visHeight;
    private boolean useClip = true;
    private boolean canClip = false;
    boolean rna = false;
    private AnnotationRendererFactoryI rendererFactoryI;
    public static final Color GLYPHLINE_COLOR = Color.gray;
    public static final Color SHEET_COLOUR = Color.green;
    public static final Color HELIX_COLOUR = Color.red;
    public static final Color STEM_COLOUR = Color.blue;

    public AnnotationRenderer() {
        this(false);
    }

    public AnnotationRenderer(boolean debugRedraw) {
        this.debugRedraw = debugRedraw;
    }

    public void dispose() {
        this.hiddenColumns = null;
        this.hconsensus = null;
        this.hSSconsensus = null;
        this.complementConsensus = null;
        this.hStrucConsensus = null;
        this.fadedImage = null;
        this.annotationPanel = null;
        this.rendererFactoryI = null;
    }

    void drawStemAnnot(Graphics g, Annotation[] row_annotations, int lastSSX, int x, int y, int iconOffset, int startRes, int column, boolean validRes, boolean validEnd) {
        boolean diffdownstream;
        int sCol = lastSSX / this.charWidth + this.hiddenColumns.visibleToAbsoluteColumn(startRes);
        int x1 = lastSSX;
        int x2 = x * this.charWidth;
        char dc = column == 0 || row_annotations[column - 1] == null ? (char)' ' : (char)row_annotations[column - 1].secondaryStructure;
        boolean diffupstream = sCol == 0 || row_annotations[sCol - 1] == null || dc != row_annotations[sCol - 1].secondaryStructure || !validEnd;
        boolean bl = diffdownstream = !validRes || !validEnd || row_annotations[column] == null || dc != row_annotations[column].secondaryStructure;
        if (diffupstream || diffdownstream) {
            this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
        }
        g.setColor(STEM_COLOUR);
        if (column > 0 && Rna.isClosingParenthesis(dc)) {
            if (diffupstream) {
                this.fillPolygon(g, new int[]{lastSSX + 5, lastSSX + 5, lastSSX}, new int[]{y + iconOffset + 1, y + 13 + iconOffset, y + 7 + iconOffset}, 3);
                x1 += 5;
            }
            if (diffdownstream) {
                --x2;
            }
        } else {
            if (diffdownstream) {
                this.fillPolygon(g, new int[]{x2 - 6, x2 - 6, x2 - 1}, new int[]{y + iconOffset + 1, y + 13 + iconOffset, y + 7 + iconOffset}, 3);
                x2 -= 5;
            }
            if (diffupstream) {
                ++x1;
            }
        }
        this.unsetAntialias(g);
        this.fillRect(g, x1, y + 4 + iconOffset, x2 - x1, 6);
    }

    void drawNotCanonicalAnnot(Graphics g, Color nonCanColor, Annotation[] row_annotations, int lastSSX, int x, int y, int iconOffset, int startRes, int column, boolean validRes, boolean validEnd) {
        boolean diffdownstream;
        int sCol = lastSSX / this.charWidth + this.hiddenColumns.visibleToAbsoluteColumn(startRes);
        int x1 = lastSSX;
        int x2 = x * this.charWidth;
        String dc = column == 0 || row_annotations[column - 1] == null ? "" : row_annotations[column - 1].displayCharacter;
        boolean diffupstream = sCol == 0 || row_annotations[sCol - 1] == null || !dc.equals(row_annotations[sCol - 1].displayCharacter) || !validEnd;
        boolean bl = diffdownstream = !validRes || !validEnd || row_annotations[column] == null || !dc.equals(row_annotations[column].displayCharacter);
        if (diffupstream || diffdownstream) {
            this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
        }
        g.setColor(nonCanColor);
        if (column > 0 && Rna.isClosingParenthesis(dc)) {
            if (diffupstream) {
                this.fillPolygon(g, new int[]{lastSSX + 5, lastSSX + 5, lastSSX}, new int[]{y + iconOffset + 1, y + 13 + iconOffset, y + 7 + iconOffset}, 3);
                x1 += 5;
            }
            if (diffdownstream) {
                --x2;
            }
        } else {
            if (diffdownstream) {
                this.fillPolygon(g, new int[]{x2 - 6, x2 - 6, x2 - 1}, new int[]{y + iconOffset + 1, y + 13 + iconOffset, y + 7 + iconOffset}, 3);
                x2 -= 5;
            }
            if (diffupstream) {
                ++x1;
            }
        }
        this.unsetAntialias(g);
        this.fillRect(g, x1, y + 4 + iconOffset, x2 - x1, 6);
    }

    public void updateFromAwtRenderPanel(AwtRenderPanelI annotPanel, AlignViewportI av) {
        this.fm = annotPanel.getFontMetrics();
        this.annotationPanel = annotPanel;
        this.fadedImage = annotPanel.getFadedImage();
        this.imgWidth = annotPanel.getFadedImageWidth();
        int[] bounds = annotPanel.getVisibleVRange();
        if (bounds != null) {
            this.sOffset = bounds[0];
            this.visHeight = bounds[1];
            this.useClip = this.visHeight == 0 ? false : this.canClip;
        } else {
            this.useClip = false;
        }
        this.rendererFactoryI = AnnotationRendererFactory.getRendererFactory();
        this.updateFromAlignViewport(av);
    }

    public void updateFromAlignViewport(AlignViewportI av) {
        this.charWidth = av.getCharWidth();
        this.endRes = av.getRanges().getEndRes();
        this.charHeight = av.getCharHeight();
        this.hasHiddenColumns = av.hasHiddenColumns();
        this.validCharWidth = av.isValidCharWidth();
        this.av_renderHistogram = av.isShowConsensusHistogram();
        this.av_renderProfile = av.isShowSequenceLogo();
        this.av_normaliseProfile = av.isNormaliseSequenceLogo();
        this.profcolour = av.getResidueShading();
        if (this.profcolour == null || this.profcolour.getColourScheme() == null) {
            ResidueColourScheme col = av.getAlignment().isNucleotide() ? new NucleotideColourScheme() : new ZappoColourScheme();
            this.profcolour = new ResidueShader(col);
        }
        this.columnSelection = av.getColumnSelection();
        this.hiddenColumns = av.getAlignment().getHiddenColumns();
        this.hconsensus = av.getSequenceConsensusHash();
        this.hSSconsensus = av.getSequenceSSConsensusHash();
        this.complementConsensus = av.getComplementConsensusHash();
        this.hStrucConsensus = av.getRnaStructureConsensusHash();
        this.av_ignoreGapsConsensus = av.isIgnoreGapsConsensus();
        this.av_ignoreBelowBackground = av.isIgnoreBelowBackground();
        this.av_infoHeight = av.isInfoLetterHeight();
    }

    int[] getProfileFor(AlignmentAnnotation aa, int column) {
        if ("HMM".equals(aa.getCalcId())) {
            HiddenMarkovModel hmm = aa.sequenceRef.getHMM();
            return AAFrequency.extractHMMProfile(hmm, column, this.av_ignoreBelowBackground, this.av_infoHeight);
        }
        if (aa.autoCalculated && (aa.label.startsWith("Consensus") || aa.label.startsWith("cDNA Consensus"))) {
            boolean forComplement = aa.label.startsWith("cDNA Consensus");
            if (aa.groupRef != null && aa.groupRef.getConsensusData() != null && aa.groupRef.isShowSequenceLogo()) {
                return AAFrequency.extractProfile(aa.groupRef.getConsensusData().get(column), aa.groupRef.getIgnoreGapsConsensus());
            }
            if (aa.groupRef == null && aa.sequenceRef == null) {
                if (forComplement) {
                    return AAFrequency.extractCdnaProfile(this.complementConsensus[column], this.av_ignoreGapsConsensus);
                }
                return AAFrequency.extractProfile(this.hconsensus.get(column), this.av_ignoreGapsConsensus);
            }
        }
        if (aa.autoCalculated && aa.label.startsWith("Secondary Structure Consensus")) {
            if (aa.groupRef != null && aa.groupRef.hSSConsensusProfileMap != null && aa.groupRef.isShowSequenceLogo()) {
                for (String source : aa.groupRef.hSSConsensusProfileMap.keySet()) {
                    if (!aa.description.startsWith(source)) continue;
                    return AAFrequency.extractProfile(aa.groupRef.hSSConsensusProfileMap.get(source).get(column), aa.groupRef.getIgnoreGapsConsensus());
                }
            }
            if (this.hSSconsensus != null && aa.groupRef == null) {
                for (String source : this.hSSconsensus.keySet()) {
                    if (!aa.description.startsWith(source)) continue;
                    return AAFrequency.extractProfile(this.hSSconsensus.get(source).get(column), this.av_ignoreGapsConsensus);
                }
            }
        }
        if (aa.autoCalculated && aa.label.startsWith("StrucConsensus") && aa.groupRef == null && aa.sequenceRef == null && this.hStrucConsensus != null && this.hStrucConsensus.length > column) {
            return StructureFrequency.extractProfile(this.hStrucConsensus[column], this.av_ignoreGapsConsensus);
        }
        return null;
    }

    public boolean drawComponent(AwtRenderPanelI annotPanel, AlignViewportI av, Graphics g, int activeRow, int startRes, int endRes) {
        if (g instanceof EpsGraphics2D || g instanceof SVGGraphics2D) {
            this.setVectorRendering(true);
        }
        Graphics2D g2d = (Graphics2D)g;
        long stime = System.currentTimeMillis();
        boolean usedFaded = false;
        this.updateFromAwtRenderPanel(annotPanel, av);
        this.fm = g.getFontMetrics();
        AlignmentAnnotation[] aa = av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return false;
        }
        int x = 0;
        int y = 0;
        int column = 0;
        int iconOffset = 0;
        boolean validRes = false;
        boolean validEnd = false;
        boolean labelAllCols = false;
        boolean scaleColLabel = false;
        AlignmentAnnotation consensusAnnot = av.getAlignmentConsensusAnnotation();
        AlignmentAnnotation structConsensusAnnot = av.getAlignmentStrucConsensusAnnotation();
        AlignmentAnnotation complementConsensusAnnot = av.getComplementConsensusAnnotation();
        List<AlignmentAnnotation> ssConsensusAnnot = av.getAlignmentSecondaryStructureConsensusAnnotation();
        BitSet graphGroupDrawn = new BitSet();
        int charOffset = 0;
        int yfrom = 0;
        int f_i = 0;
        int yto = 0;
        int f_to = 0;
        boolean clipst = false;
        boolean clipend = false;
        for (int i = 0; i < aa.length; ++i) {
            AlignmentAnnotation row = aa[i];
            boolean renderHistogram = true;
            boolean renderProfile = false;
            boolean normaliseProfile = false;
            boolean isRNA = row.isRNA();
            if (row.groupRef != null && (row == row.groupRef.getConsensus() || row.groupRef.getSSConsensus(null) != null && row.groupRef.getSSConsensus(null).contains(row))) {
                renderHistogram = row.groupRef.isShowConsensusHistogram();
                renderProfile = row.groupRef.isShowSequenceLogo();
                normaliseProfile = row.groupRef.isNormaliseSequenceLogo();
            } else if (row == consensusAnnot || row == structConsensusAnnot || row == complementConsensusAnnot || ssConsensusAnnot != null && ssConsensusAnnot.contains(row)) {
                renderHistogram = this.av_renderHistogram;
                renderProfile = this.av_renderProfile;
                normaliseProfile = this.av_normaliseProfile;
            } else if ("HMM".equals(row.getCalcId())) {
                if (row.groupRef != null) {
                    renderHistogram = row.groupRef.isShowInformationHistogram();
                    renderProfile = row.groupRef.isShowHMMSequenceLogo();
                    normaliseProfile = row.groupRef.isNormaliseHMMSequenceLogo();
                } else {
                    renderHistogram = av.isShowInformationHistogram();
                    renderProfile = av.isShowHMMSequenceLogo();
                    normaliseProfile = av.isNormaliseHMMSequenceLogo();
                }
            }
            Annotation[] row_annotations = row.annotations;
            if (!row.isForDisplay()) continue;
            labelAllCols = row.showAllColLabels;
            scaleColLabel = row.scaleColLabel;
            char lastSS = ' ';
            int lastSSX = 0;
            if (!this.useClip || y - this.charHeight < this.visHeight && y + row.height + this.charHeight * 2 >= this.sOffset) {
                if (!clipst) {
                    clipst = true;
                    yfrom = y;
                    f_i = i;
                }
                yto = y;
                f_to = i;
                if (row.graph > 0) {
                    if (row.graphGroup > -1 && graphGroupDrawn.get(row.graphGroup)) continue;
                    y += row.height;
                    if (row.hasText) {
                        iconOffset = this.charHeight - this.fm.getDescent();
                        y -= this.charHeight;
                    }
                } else {
                    iconOffset = row.hasText ? this.charHeight - this.fm.getDescent() : 0;
                }
                if (row.autoCalculated && av.isCalculationInProgress(row)) {
                    usedFaded = true;
                    g.drawImage(this.fadedImage, 0, (y += this.charHeight) - row.height, this.imgWidth, y, 0, y - row.height, this.imgWidth, y, this.annotationPanel);
                    g.setColor(Color.black);
                    continue;
                }
                this.glyphLineDrawn = false;
                int n = x = startRes == 0 ? 0 : -1;
                while (x < endRes - startRes) {
                    String displayChar;
                    if (this.hasHiddenColumns) {
                        column = this.hiddenColumns.visibleToAbsoluteColumn(startRes + x);
                        if (column > row_annotations.length - 1) {
                            break;
                        }
                    } else {
                        column = startRes + x;
                    }
                    validRes = row_annotations != null && row_annotations.length > column && row_annotations[column] != null;
                    String string = displayChar = validRes ? row_annotations[column].displayCharacter : null;
                    if (x > -1) {
                        this.unsetAntialias(g);
                        if (activeRow == i) {
                            g.setColor(Color.red);
                            if (this.columnSelection != null && this.columnSelection.contains(column)) {
                                this.fillRect(g, x * this.charWidth, y, this.charWidth, this.charHeight);
                            }
                        }
                        if (row.getInvalidStrucPos() > (long)x) {
                            g.setColor(Color.orange);
                            this.fillRect(g, x * this.charWidth, y, this.charWidth, this.charHeight);
                        } else if (row.getInvalidStrucPos() == (long)x) {
                            g.setColor(Color.orange.darker());
                            this.fillRect(g, x * this.charWidth, y, this.charWidth, this.charHeight);
                        }
                        if (this.validCharWidth && validRes && displayChar != null && displayChar.length() > 0) {
                            float fmWidth = this.fm.charsWidth(displayChar.toCharArray(), 0, displayChar.length());
                            boolean scaledToFit = false;
                            float fmScaling = 1.0f;
                            if (scaleColLabel && fmWidth > (float)this.charWidth) {
                                scaledToFit = true;
                                fmScaling = this.charWidth;
                                fmScaling /= fmWidth;
                                fmWidth = this.charWidth;
                            }
                            charOffset = (int)(((float)this.charWidth - fmWidth) / 2.0f);
                            if (row_annotations[column].colour == null) {
                                g2d.setColor(Color.black);
                            } else {
                                g2d.setColor(row_annotations[column].colour);
                            }
                            int xPos = x * this.charWidth + charOffset;
                            int yPos = y + iconOffset;
                            g2d.translate(xPos, yPos);
                            if (scaledToFit) {
                                g2d.transform(AffineTransform.getScaleInstance(fmScaling, 1.0));
                            }
                            this.setAntialias(g);
                            if (column == 0 || row.graph > 0) {
                                g2d.drawString(displayChar, 0, 0);
                            } else if (row_annotations[column - 1] == null || labelAllCols || !displayChar.equals(row_annotations[column - 1].displayCharacter) || displayChar.length() < 2 && row_annotations[column].secondaryStructure == ' ') {
                                g2d.drawString(displayChar, 0, 0);
                            }
                            if (scaledToFit) {
                                g2d.transform(AffineTransform.getScaleInstance(1.0 / (double)fmScaling, 1.0));
                            }
                            g2d.translate(-xPos, -yPos);
                        }
                    }
                    if (row.hasIcons) {
                        int ssLowerCase;
                        char ss;
                        char c = ss = validRes ? (char)row_annotations[column].secondaryStructure : (char)'-';
                        if (ss == '(' && displayChar.indexOf(41) > -1) {
                            ss = ')';
                        }
                        if (ss == '[' && displayChar.indexOf(93) > -1) {
                            ss = ']';
                        }
                        if (ss == '{' && displayChar.indexOf(125) > -1) {
                            ss = '}';
                        }
                        if (ss == '<' && displayChar.indexOf(60) > -1) {
                            ss = '>';
                        }
                        if (isRNA && ss >= 'A' && ss <= 'Z' && displayChar.indexOf(ssLowerCase = ss + 32) > -1) {
                            ss = (char)ssLowerCase;
                        }
                        if (!validRes || ss != lastSS) {
                            if (x > -1) {
                                switch (lastSS) {
                                    case '(': 
                                    case ')': {
                                        this.drawStemAnnot(g, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                                        break;
                                    }
                                    case 'H': {
                                        if (!isRNA) {
                                            this.drawHelixAnnot(g, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                                            break;
                                        }
                                    }
                                    case 'E': {
                                        if (!isRNA) {
                                            this.drawSheetAnnot(g, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                                            break;
                                        }
                                    }
                                    case '<': 
                                    case '>': 
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'F': 
                                    case 'G': 
                                    case 'I': 
                                    case 'J': 
                                    case 'K': 
                                    case 'L': 
                                    case 'M': 
                                    case 'N': 
                                    case 'O': 
                                    case 'P': 
                                    case 'Q': 
                                    case 'R': 
                                    case 'S': 
                                    case 'T': 
                                    case 'U': 
                                    case 'V': 
                                    case 'W': 
                                    case 'X': 
                                    case 'Y': 
                                    case 'Z': 
                                    case '[': 
                                    case ']': 
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': 
                                    case 'g': 
                                    case 'h': 
                                    case 'i': 
                                    case 'j': 
                                    case 'k': 
                                    case 'l': 
                                    case 'm': 
                                    case 'n': 
                                    case 'o': 
                                    case 'p': 
                                    case 'q': 
                                    case 'r': 
                                    case 's': 
                                    case 't': 
                                    case 'u': 
                                    case 'v': 
                                    case 'w': 
                                    case 'x': 
                                    case 'y': 
                                    case 'z': 
                                    case '{': 
                                    case '}': {
                                        Color nonCanColor = this.getNotCanonicalColor(lastSS);
                                        this.drawNotCanonicalAnnot(g, nonCanColor, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                                        break;
                                    }
                                    default: {
                                        if (this.isVectorRendering()) {
                                            this.drawGlyphLine(g, lastSSX, endRes - x, y, iconOffset);
                                            this.glyphLineDrawn = true;
                                            break;
                                        }
                                        this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
                                    }
                                }
                            }
                            lastSS = validRes ? ss : (char)' ';
                            if (x > -1) {
                                lastSSX = x * this.charWidth;
                            }
                        }
                    }
                    ++column;
                    ++x;
                }
                if (column >= row_annotations.length) {
                    column = row_annotations.length - 1;
                    validEnd = false;
                } else {
                    validEnd = true;
                }
                validRes = row_annotations != null && row_annotations.length > column && row_annotations[column] != null;
                if (row.hasIcons) {
                    switch (lastSS) {
                        case 'H': {
                            if (!isRNA) {
                                this.drawHelixAnnot(g, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                                break;
                            }
                        }
                        case 'E': {
                            if (!isRNA) {
                                this.drawSheetAnnot(g, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                                break;
                            }
                        }
                        case '(': 
                        case ')': {
                            this.drawStemAnnot(g, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                            break;
                        }
                        case '<': 
                        case '>': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'G': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '[': 
                        case ']': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': 
                        case '{': 
                        case '}': {
                            Color nonCanColor = this.getNotCanonicalColor(lastSS);
                            this.drawNotCanonicalAnnot(g, nonCanColor, row_annotations, lastSSX, x, y, iconOffset, startRes, column, validRes, validEnd);
                            break;
                        }
                        default: {
                            if (this.isVectorRendering()) {
                                this.drawGlyphLine(g, lastSSX, endRes - x, y, iconOffset);
                                this.glyphLineDrawn = true;
                                break;
                            }
                            this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
                        }
                    }
                }
                if (row.graph > 0 && row.graphHeight > 0) {
                    if (row.graph == 2) {
                        if (row.graphGroup > -1 && !graphGroupDrawn.get(row.graphGroup)) {
                            int gg;
                            float groupmax = -999999.0f;
                            float groupmin = 9999999.0f;
                            for (gg = 0; gg < aa.length; ++gg) {
                                if (aa[gg].graphGroup != row.graphGroup) continue;
                                if (aa[gg] != row) {
                                    aa[gg].visible = false;
                                }
                                if (aa[gg].graphMax > groupmax) {
                                    groupmax = aa[gg].graphMax;
                                }
                                if (!(aa[gg].graphMin < groupmin)) continue;
                                groupmin = aa[gg].graphMin;
                            }
                            for (gg = 0; gg < aa.length; ++gg) {
                                if (aa[gg].graphGroup != row.graphGroup) continue;
                                this.drawLineGraph(g, aa[gg], aa[gg].annotations, startRes, endRes, y, groupmin, groupmax, row.graphHeight);
                            }
                            graphGroupDrawn.set(row.graphGroup);
                        } else {
                            this.drawLineGraph(g, row, row_annotations, startRes, endRes, y, row.graphMin, row.graphMax, row.graphHeight);
                        }
                    } else if (row.graph == 1) {
                        this.drawBarGraph(g, row, row_annotations, startRes, endRes, row.graphMin, row.graphMax, y, renderHistogram, renderProfile, normaliseProfile);
                    } else {
                        AnnotationRowRendererI renderer = this.rendererFactoryI.getRendererFor(row);
                        if (renderer != null) {
                            renderer.renderRow(g, this.charWidth, this.charHeight, this.hasHiddenColumns, av, this.hiddenColumns, this.columnSelection, row, row_annotations, startRes, endRes, row.graphMin, row.graphMax, y);
                        }
                        if (this.debugRedraw) {
                            if (renderer == null) {
                                System.err.println("No renderer found for " + row.toString());
                            } else {
                                Console.warn("rendered with " + renderer.getClass().toString());
                            }
                        }
                    }
                }
            } else if (clipst && !clipend) {
                clipend = true;
            }
            if (row.graph > 0 && row.hasText) {
                y += this.charHeight;
            }
            if (row.graph != 0) continue;
            y += aa[i].height;
        }
        if (this.debugRedraw) {
            if (this.canClip) {
                if (clipst) {
                    Console.warn("Start clip at : " + yfrom + " (index " + f_i + ")");
                }
                if (clipend) {
                    Console.warn("End clip at : " + yto + " (index " + f_to + ")");
                }
            }
            Console.warn("Annotation Rendering time:" + (System.currentTimeMillis() - stime));
        }
        return !usedFaded;
    }

    void drawGlyphLine(Graphics g, int lastSSX, int x, int y, int iconOffset) {
        if (this.glyphLineDrawn) {
            return;
        }
        this.unsetAntialias(g);
        g.setColor(GLYPHLINE_COLOR);
        g.fillRect(lastSSX, y + 6 + iconOffset, x * this.charWidth - lastSSX, 2);
    }

    void drawSheetAnnot(Graphics g, Annotation[] row, int lastSSX, int x, int y, int iconOffset, int startRes, int column, boolean validRes, boolean validEnd) {
        if (!validEnd || !validRes || row == null || row[column] == null || row[column].secondaryStructure != 'E') {
            this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
            g.setColor(SHEET_COLOUR);
            this.fillRect(g, lastSSX, y + 4 + iconOffset, x * this.charWidth - lastSSX - 4, 6);
            this.fillPolygon(g, new int[]{x * this.charWidth - 6, x * this.charWidth - 6, x * this.charWidth - 1}, new int[]{y + iconOffset + 1, y + 13 + iconOffset, y + 7 + iconOffset}, 3);
        } else {
            g.setColor(SHEET_COLOUR);
            this.fillRect(g, lastSSX, y + 4 + iconOffset, x * this.charWidth - lastSSX, 6);
        }
    }

    void drawHelixAnnot(Graphics g, Annotation[] row, int lastSSX, int x, int y, int iconOffset, int startRes, int column, boolean validRes, boolean validEnd) {
        boolean rightEnd;
        int sCol = lastSSX / this.charWidth + this.hiddenColumns.visibleToAbsoluteColumn(startRes);
        int x1 = lastSSX;
        int x2 = x * this.charWidth;
        if (this.USE_FILL_ROUND_RECT || this.isVectorRendering()) {
            this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
            g.setColor(HELIX_COLOUR);
            this.setAntialias(g);
            int ofs = this.charWidth / 2;
            this.fillRoundRect(g, lastSSX, y + 3 + iconOffset, x2 - x1 - 1, 8, 8, 8);
            if (sCol != 0 && row[sCol - 1] != null && row[sCol - 1].secondaryStructure == 'H') {
                this.fillRoundRect(g, lastSSX, y + 3 + iconOffset, x2 - x1 - ofs, 8, 0, 0);
            }
            if (validRes && row[column] != null && row[column].secondaryStructure == 'H') {
                this.fillRoundRect(g, lastSSX + ofs, y + 3 + iconOffset, x2 - x1 - ofs, 8, 0, 0);
            }
            return;
        }
        boolean leftEnd = sCol == 0 || row[sCol - 1] == null || row[sCol - 1].secondaryStructure != 'H';
        boolean bl = rightEnd = !validRes || row[column] == null || row[column].secondaryStructure != 'H';
        if (leftEnd || rightEnd) {
            this.drawGlyphLine(g, lastSSX, x, y, iconOffset);
        }
        g.setColor(HELIX_COLOUR);
        if (leftEnd) {
            this.fillArc(g, lastSSX, y + 3 + iconOffset, this.charWidth, 8, 90, 180);
            x1 += this.charWidth / 2;
        }
        if (rightEnd) {
            this.fillArc(g, (x - 1) * this.charWidth, y + 3 + iconOffset, this.charWidth, 8, 270, 180);
            x2 -= this.charWidth / 2;
        }
        this.fillRect(g, x1, y + 3 + iconOffset, x2 - x1, 8);
    }

    void drawLineGraph(Graphics g, AlignmentAnnotation _aa, Annotation[] aa_annotations, int sRes, int eRes, int y, float min, float max, int graphHeight) {
        if (sRes > aa_annotations.length) {
            return;
        }
        BasicStroke roundStroke = new BasicStroke(1.0f, 1, 1);
        BasicStroke squareStroke = new BasicStroke(1.0f, 2, 0);
        Graphics2D g2d = (Graphics2D)g;
        Stroke prevStroke = g2d.getStroke();
        g2d.setStroke(roundStroke);
        int x = 0;
        if (eRes < this.endRes) {
            ++eRes;
        }
        eRes = Math.min(eRes, aa_annotations.length);
        if (sRes == 0) {
            ++x;
        }
        int y1 = y;
        int y2 = y;
        float range = max - min;
        if (min < 0.0f) {
            y2 = y - (int)((0.0f - min / range) * (float)graphHeight);
        }
        g.setColor(Color.gray);
        this.drawLine(g, squareStroke, x * this.charWidth - this.charWidth, y2, (eRes - sRes) * this.charWidth, y2);
        eRes = Math.min(eRes, aa_annotations.length);
        int aaMax = aa_annotations.length - 1;
        while (x < eRes - sRes) {
            int column = sRes + x;
            if (this.hasHiddenColumns) {
                column = this.hiddenColumns.visibleToAbsoluteColumn(column);
            }
            if (column > aaMax) break;
            if (aa_annotations[column] == null) {
                ++x;
                continue;
            }
            if (aa_annotations[column].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa_annotations[column].colour);
            }
            if (aa_annotations[column - 1] == null && aa_annotations.length > column + 1 && aa_annotations[column + 1] == null) {
                y1 = y - (int)((aa_annotations[column].value - min) / range * (float)graphHeight);
                this.drawLine(g, x * this.charWidth + this.charWidth / 4, y1, x * this.charWidth + 3 * this.charWidth / 4, y1);
                ++x;
                continue;
            }
            if (aa_annotations[column - 1] == null) {
                ++x;
                continue;
            }
            y1 = y - (int)((aa_annotations[column - 1].value - min) / range * (float)graphHeight);
            y2 = y - (int)((aa_annotations[column].value - min) / range * (float)graphHeight);
            this.drawLine(g, (x - 1) * this.charWidth + this.charWidth / 2, y1, x * this.charWidth + this.charWidth / 2, y2);
            ++x;
        }
        if (_aa.threshold != null) {
            g.setColor(_aa.threshold.colour);
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke s = new BasicStroke(1.0f, 2, 1, 3.0f, new float[]{5.0f, 3.0f}, 0.0f);
            y2 = (int)((float)y - (_aa.threshold.value - min) / range * (float)graphHeight);
            this.drawLine(g, s, 0, y2, (eRes - sRes) * this.charWidth, y2);
        }
        g2d.setStroke(prevStroke);
    }

    void drawBarGraph(Graphics g, AlignmentAnnotation _aa, Annotation[] aa_annotations, int sRes, int eRes, float min, float max, int y, boolean renderHistogram, boolean renderProfile, boolean normaliseProfile) {
        boolean _aa_is_dssp3;
        if (sRes > aa_annotations.length) {
            return;
        }
        Font ofont = g.getFont();
        eRes = Math.min(eRes, aa_annotations.length);
        int x = 0;
        int y1 = y;
        int y2 = y;
        float range = max - min;
        if (min < 0.0f) {
            y2 = y - (int)((0.0f - min / range) * (float)_aa.graphHeight);
        }
        g.setColor(Color.gray);
        this.drawLine(g, x, y2, (eRes - sRes) * this.charWidth, y2);
        int aaMax = aa_annotations.length - 1;
        boolean bl = _aa_is_dssp3 = _aa.autoCalculated && _aa.label.startsWith("Secondary Structure Consensus");
        while (x < eRes - sRes) {
            int[] profl;
            int column = sRes + x;
            if (this.hasHiddenColumns) {
                column = this.hiddenColumns.visibleToAbsoluteColumn(column);
            }
            if (column > aaMax) break;
            if (aa_annotations[column] == null) {
                ++x;
                continue;
            }
            if (aa_annotations[column].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa_annotations[column].colour);
            }
            y1 = y - (int)((aa_annotations[column].value - min) / range * (float)_aa.graphHeight);
            if (renderHistogram) {
                if (y1 - y2 > 0) {
                    this.fillRect(g, x * this.charWidth, y2, this.charWidth, y1 - y2);
                } else {
                    this.fillRect(g, x * this.charWidth, y1, this.charWidth, y2 - y1);
                }
            }
            if (renderProfile && (profl = this.getProfileFor(_aa, column)) != null && profl[2] != 0) {
                double normaliseFactor;
                boolean isStructureProfile = profl[0] == 1;
                boolean isCdnaProfile = profl[0] == 2;
                float ht = normaliseProfile ? (float)(y - _aa.graphHeight) : (float)y1;
                double d = normaliseFactor = normaliseProfile ? (double)_aa.graphHeight : (double)(y2 - y1);
                char[] dc = new char[isStructureProfile ? 2 : (isCdnaProfile ? 3 : 1)];
                double asc = this.fm.getAscent();
                double dec = this.fm.getDescent();
                double fht = this.fm.getHeight();
                double scale = 1.0f / (normaliseProfile ? (float)profl[2] : 100.0f);
                float ht2 = ht;
                int c = 3;
                int last = profl[1];
                for (int i = 0; i < last; ++i) {
                    int hght;
                    String s;
                    if (isStructureProfile) {
                        dc[0] = (char)profl[c++];
                        dc[1] = (char)profl[c++];
                        s = new String(dc);
                    } else if (isCdnaProfile) {
                        CodingUtils.decodeCodon2(profl[c++], dc);
                        s = new String(dc);
                    } else {
                        dc[0] = (char)profl[c++];
                        s = new String(dc);
                    }
                    int percent = profl[c++];
                    if (percent == 0) continue;
                    double newHeight = normaliseFactor * scale * (double)percent;
                    Color colour = null;
                    if (isCdnaProfile) {
                        String codonTranslation = ResidueProperties.codonTranslate(s);
                        colour = this.profcolour.findColour(codonTranslation.charAt(0), column, null);
                    } else {
                        colour = _aa_is_dssp3 ? this.profcolour.findSSColour(dc[0], column) : this.profcolour.findColour(dc[0], column, null);
                    }
                    g.setColor(colour == Color.white ? Color.lightGray : colour);
                    double sx = 1.0f * (float)this.charWidth / (float)this.fm.charsWidth(dc, 0, dc.length);
                    double sy = newHeight / asc;
                    double newAsc = asc * sy;
                    double newDec = dec * sy;
                    if (Platform.isJS()) {
                        hght = (int)((double)ht2 + (newAsc - newDec));
                        Graphics2D gg = (Graphics2D)g;
                        int xShift = (int)Math.round((double)(x * this.charWidth) / sx);
                        int yShift = (int)Math.round((double)hght / sy);
                        gg.transform(AffineTransform.getScaleInstance(sx, sy));
                        gg.drawString(s, xShift, yShift);
                        gg.transform(AffineTransform.getScaleInstance(1.0 / sx, 1.0 / sy));
                        ht2 = (float)((double)ht2 + newHeight);
                        continue;
                    }
                    hght = (int)((double)ht + (newAsc - newDec));
                    Font font = ofont.deriveFont(AffineTransform.getScaleInstance(sx, sy));
                    g.setFont(font);
                    g.drawChars(dc, 0, dc.length, x * this.charWidth, hght);
                    g.setFont(ofont);
                    ht = (float)((double)ht + newHeight);
                }
            }
            ++x;
        }
        if (_aa.threshold != null) {
            g.setColor(_aa.threshold.colour);
            BasicStroke s = new BasicStroke(1.0f, 2, 1, 3.0f, new float[]{5.0f, 3.0f}, 0.0f);
            y2 = (int)((float)y - (_aa.threshold.value - min) / range * (float)_aa.graphHeight);
            this.drawLine(g, s, 0, y2, (eRes - sRes) * this.charWidth, y2);
        }
    }

    public void drawGraph(Graphics g, AlignmentAnnotation _aa, Annotation[] aa_annotations, int width, int y, int sRes, int eRes) {
        eRes = Math.min(eRes, aa_annotations.length);
        g.setColor(Color.white);
        this.fillRect(g, 0, 0, width, y);
        g.setColor(new Color(0, 0, 180));
        int x = 0;
        for (int j = sRes; j < eRes; ++j) {
            if (aa_annotations[j] != null) {
                if (aa_annotations[j].colour == null) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(aa_annotations[j].colour);
                }
                int height = (int)(aa_annotations[j].value / _aa.graphMax * (float)y);
                if (height > y) {
                    height = y;
                }
                this.fillRect(g, x, y - height, this.charWidth, height);
            }
            x += this.charWidth;
        }
    }

    Color getNotCanonicalColor(char lastss) {
        switch (lastss) {
            case '{': 
            case '}': {
                return new Color(255, 125, 5);
            }
            case '[': 
            case ']': {
                return new Color(245, 115, 10);
            }
            case '<': 
            case '>': {
                return new Color(235, 135, 15);
            }
            case 'A': 
            case 'a': {
                return new Color(225, 105, 20);
            }
            case 'B': 
            case 'b': {
                return new Color(215, 145, 30);
            }
            case 'C': 
            case 'c': {
                return new Color(205, 95, 35);
            }
            case 'D': 
            case 'd': {
                return new Color(195, 155, 45);
            }
            case 'E': 
            case 'e': {
                return new Color(185, 85, 55);
            }
            case 'F': 
            case 'f': {
                return new Color(175, 165, 65);
            }
            case 'G': 
            case 'g': {
                return new Color(170, 75, 75);
            }
            case 'H': 
            case 'h': {
                return new Color(160, 175, 85);
            }
            case 'I': 
            case 'i': {
                return new Color(150, 65, 95);
            }
            case 'J': 
            case 'j': {
                return new Color(140, 185, 105);
            }
            case 'K': 
            case 'k': {
                return new Color(130, 55, 110);
            }
            case 'L': 
            case 'l': {
                return new Color(120, 195, 120);
            }
            case 'M': 
            case 'm': {
                return new Color(110, 45, 130);
            }
            case 'N': 
            case 'n': {
                return new Color(100, 205, 140);
            }
            case 'O': 
            case 'o': {
                return new Color(90, 35, 150);
            }
            case 'P': 
            case 'p': {
                return new Color(85, 215, 160);
            }
            case 'Q': 
            case 'q': {
                return new Color(75, 25, 170);
            }
            case 'R': 
            case 'r': {
                return new Color(65, 225, 180);
            }
            case 'S': 
            case 's': {
                return new Color(55, 15, 185);
            }
            case 'T': 
            case 't': {
                return new Color(45, 235, 195);
            }
            case 'U': 
            case 'u': {
                return new Color(35, 5, 205);
            }
            case 'V': 
            case 'v': {
                return new Color(25, 245, 215);
            }
            case 'W': 
            case 'w': {
                return new Color(15, 0, 225);
            }
            case 'X': 
            case 'x': {
                return new Color(10, 255, 235);
            }
            case 'Y': 
            case 'y': {
                return new Color(5, 150, 245);
            }
            case 'Z': 
            case 'z': {
                return new Color(0, 80, 255);
            }
        }
        Console.info("This is not a interaction : " + lastss);
        return null;
    }

    private void fillPolygon(Graphics g, int[] xpoints, int[] ypoints, int n) {
        this.setAntialias(g);
        g.fillPolygon(xpoints, ypoints, n);
    }

    private void fillRect(Graphics g, int a, int b, int c, int d) {
        this.unsetAntialias(g);
        g.fillRect(a, b, c, d);
    }

    private void fillRoundRect(Graphics g, int a, int b, int c, int d, int e, int f) {
        this.setAntialias(g);
        g.fillRoundRect(a, b, c, d, e, f);
    }

    private void fillArc(Graphics g, int a, int b, int c, int d, int e, int f) {
        this.setAntialias(g);
        g.fillArc(a, b, c, d, e, f);
    }

    private void drawLine(Graphics g, Stroke s, int a, int b, int c, int d) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke p = g2d.getStroke();
        g2d.setStroke(s);
        this.drawLine(g, a, b, c, d);
        g2d.setStroke(p);
    }

    private void drawLine(Graphics g, int a, int b, int c, int d) {
        this.setAntialias(g);
        g.drawLine(a, b, c, d);
    }

    private void setAntialias(Graphics g) {
        if (this.isVectorRendering()) {
            return;
        }
        if (Cache.getDefault("ANTI_ALIAS", true)) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    private void unsetAntialias(Graphics g) {
        if (this.isVectorRendering()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void setVectorRendering(boolean b) {
        this.renderingVectors = b;
    }

    public boolean isVectorRendering() {
        return this.renderingVectors;
    }
}

