/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Console;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.Desktop;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.Rangetype;
import jalview.structure.StructureSelectionManager;
import jalview.util.MapList;
import java.util.ArrayList;
import java.util.Vector;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.SequenceMapping;
import uk.ac.vamsas.objects.core.SequenceType;

public class Sequencemapping
extends Rangetype {
    private SequenceType from;
    private DataSet ds;
    private Mapping mjvmapping;

    public Sequencemapping(VamsasAppDatastore datastore, SequenceMapping sequenceMapping) {
        super(datastore, (Vobject)sequenceMapping, MapList.class);
        Console.error("Not implemented: Jalview Update Alcodon Mapping:TODO!");
        this.doJvUpdate();
    }

    public Sequencemapping(VamsasAppDatastore datastore, Mapping mjvmapping, SequenceType from, DataSet ds) {
        super(datastore, mjvmapping.getMap(), SequenceMapping.class);
        Console.error("Not implemented: Jalview Update Alcodon Mapping:TODO!");
        this.from = from;
        this.ds = ds;
        this.mjvmapping = mjvmapping;
        this.validate();
        this.doSync();
    }

    public void validate() {
        SequenceMapping sequenceMapping = (SequenceMapping)this.vobj;
        if (sequenceMapping == null) {
            return;
        }
        if (this.from != null && sequenceMapping.getLoc() != this.from) {
            Console.warn("Probable IMPLEMENTATION ERROR: " + this.from + " doesn't match the local mapping sequence.");
        }
        if (this.ds != null && sequenceMapping.is__stored_in_document() && sequenceMapping.getV_parent() != this.ds) {
            Console.warn("Probable IMPLEMENTATION ERROR: " + this.ds + " doesn't match the parent of the bound sequence mapping object.");
        }
    }

    @Override
    public void addToDocument() {
        this.add(this.mjvmapping, this.from, this.ds);
    }

    @Override
    public void addFromDocument() {
        this.add((SequenceMapping)this.vobj);
    }

    @Override
    public void conflict() {
        this.conflict(this.mjvmapping, (SequenceMapping)this.vobj);
    }

    @Override
    public void updateToDoc() {
        this.update(this.mjvmapping, (SequenceMapping)this.vobj);
    }

    @Override
    public void updateFromDoc() {
        this.update((SequenceMapping)this.vobj, (Mapping)this.jvobj);
    }

    private void conflict(Mapping mjvmapping, SequenceMapping sequenceMapping) {
        Console.errPrintln("Conflict in update of sequenceMapping " + sequenceMapping.getVorbaId());
    }

    private void add(Mapping mjvmapping, SequenceType from, DataSet ds) {
        SequenceI jvto = mjvmapping.getTo();
        while (jvto.getDatasetSequence() != null) {
            jvto = jvto.getDatasetSequence();
        }
        SequenceType to = (SequenceType)this.getjv2vObj(jvto);
        if (to == null) {
            Console.warn("FIXME NONFATAL - do a second update: Ignoring Forward Reference to seuqence not yet bound to vamsas seuqence object");
            return;
        }
        SequenceMapping sequenceMapping = new SequenceMapping();
        sequenceMapping.setLoc((Object)from);
        sequenceMapping.setMap((Object)to);
        boolean dnaToProt = false;
        boolean sense = false;
        if (((Sequence)sequenceMapping.getLoc()).getDictionary().equals("info:iubmb.org/nucleosides")) {
            if (((Sequence)sequenceMapping.getMap()).getDictionary().equals("info:iubmb.org/aminoacids")) {
                dnaToProt = true;
                sense = true;
            }
        } else if (((Sequence)sequenceMapping.getMap()).getDictionary().equals("info:iubmb.org/nucleosides")) {
            dnaToProt = true;
            sense = false;
        }
        if (!dnaToProt) {
            Console.warn("Ignoring Mapping - don't support protein to protein mapping in vamsas document yet.");
            return;
        }
        if (ds == null) {
            ds = sense ? (DataSet)((Vobject)sequenceMapping.getLoc()).getV_parent() : (DataSet)((Vobject)sequenceMapping.getMap()).getV_parent();
        }
        if (sense) {
            this.initMapType((MapType)sequenceMapping, mjvmapping.getMap(), true);
        } else {
            this.initMapType((MapType)sequenceMapping, mjvmapping.getMap().getInverse(), true);
        }
        ds.addSequenceMapping(sequenceMapping);
        sequenceMapping.setProvenance(this.dummyProvenance("user defined coding region translation"));
        this.bindjvvobj(mjvmapping.getMap(), (Vobject)sequenceMapping);
        Console.debug("Successfully created mapping " + sequenceMapping.getVorbaId());
    }

    private void update(SequenceMapping sequenceMapping, Mapping mjvmapping) {
        Console.error("Not implemented: Update DBRef Mapping from Jalview");
    }

    private void update(Mapping mjvmapping, SequenceMapping sequenceMapping) {
        Console.error("Not implemented: Jalview Update Sequence DBRef Mapping");
    }

    private void add(SequenceMapping sequenceMapping) {
        SequenceI from = null;
        SequenceI to = null;
        boolean dnaToProt = false;
        boolean sense = false;
        Sequence sdloc = null;
        Sequence sdmap = null;
        sdloc = sequenceMapping.getLoc() instanceof AlignmentSequence ? (Sequence)((AlignmentSequence)sequenceMapping.getLoc()).getRefid() : (Sequence)sequenceMapping.getLoc();
        sdmap = sequenceMapping.getMap() instanceof AlignmentSequence ? (Sequence)((AlignmentSequence)sequenceMapping.getMap()).getRefid() : (Sequence)sequenceMapping.getMap();
        if (sdloc == null || sdmap == null) {
            Console.info("Ignoring non sequence-sequence mapping");
            return;
        }
        Object mobj = this.getvObj2jv((Vobject)sdloc);
        if (mobj instanceof SequenceI) {
            from = (SequenceI)mobj;
        }
        if ((mobj = this.getvObj2jv((Vobject)sdmap)) instanceof SequenceI) {
            to = (SequenceI)mobj;
        }
        if (from == null || to == null) {
            Console.error("Probable Vamsas implementation error : unbound dataset sequences involved in a mapping are being parsed!");
            return;
        }
        if (sdloc.getDictionary().equals("info:iubmb.org/nucleosides")) {
            if (sdmap.getDictionary().equals("info:iubmb.org/aminoacids")) {
                dnaToProt = true;
                sense = true;
            }
        } else if (sdmap.getDictionary().equals("info:iubmb.org/nucleosides")) {
            dnaToProt = true;
            sense = false;
        }
        AlignmentI dsLoc = (AlignmentI)this.getvObj2jv(sdloc.getV_parent());
        AlignmentI dsMap = (AlignmentI)this.getvObj2jv(sdmap.getV_parent());
        AlignedCodonFrame acf = new AlignedCodonFrame();
        if (dsLoc != null && dsLoc != dsMap) {
            dsLoc.addCodonFrame(acf);
        }
        if (dsMap != null) {
            dsMap.addCodonFrame(acf);
        }
        MapList mapping = null;
        if (dnaToProt) {
            if (!sense) {
                mapping = this.parsemapType((MapType)sequenceMapping, 1, 3);
                mapping = new MapList(mapping.getToRanges(), mapping.getFromRanges(), mapping.getToRatio(), mapping.getFromRatio());
                acf.addMap(to, from, mapping);
            } else {
                mapping = this.parsemapType((MapType)sequenceMapping, 3, 1);
                acf.addMap(from, to, mapping);
            }
        } else {
            mapping = this.parsemapType((MapType)sequenceMapping, 1, 1);
            acf.addMap(from, to, mapping);
        }
        this.bindjvvobj(mapping, (Vobject)sequenceMapping);
        StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance()).registerMapping(acf);
    }

    private void matchConjugateDBRefs(SequenceI from, SequenceI to, MapList smap) {
        if (from.getDBRefs() == null && to.getDBRefs() == null) {
            if (Console.isDebugEnabled()) {
                Console.debug("Not matching conjugate refs for " + from.getName() + " and " + to.getName());
            }
            return;
        }
        if (Console.isDebugEnabled()) {
            Console.debug("Matching conjugate refs for " + from.getName() + " and " + to.getName());
        }
        Sequence.DBModList<DBRefEntry> fdb = from.getDBRefs();
        ArrayList<DBRefEntry> tdb = new ArrayList<DBRefEntry>(to.getDBRefs());
        int tdblen = to.getDBRefs().size();
        Vector matched = new Vector();
        MapList smapI = smap.getInverse();
        int fn = fdb.size();
        for (int f = 0; f < fn; ++f) {
            DBRefEntry fe = (DBRefEntry)fdb.get(f);
            Mapping fmp = fe.getMap();
            boolean fmpnnl = fmp != null;
            boolean smapfromlocal2fe = fmpnnl ? smap.equals(fmp.getMap()) : false;
            boolean smapfromfemap2local = fmpnnl ? smapI.equals(fmp.getMap()) : false;
            for (int t = 0; t < tdblen; ++t) {
                boolean smaptotemap2local;
                boolean tmpnnl;
                DBRefEntry te = (DBRefEntry)tdb.get(t);
                if (te == null || !fe.getSource().equals(te.getSource()) || !fe.getAccessionId().equals(te.getAccessionId())) continue;
                Mapping tmp = te.getMap();
                boolean bl = tmpnnl = tmp != null;
                if (!tmpnnl || tmp.getTo() != null) {
                    // empty if block
                }
                boolean smaptolocal2tm = tmpnnl ? smap.equals(tmp.getMap()) : false;
                boolean bl2 = smaptotemap2local = tmpnnl ? smapI.equals(fmp.getMap()) : false;
                if (smapfromlocal2fe && smaptotemap2local) {
                    fmp.setTo(to);
                    tmp.setTo(from);
                    continue;
                }
                if (!smapfromfemap2local || !smaptolocal2tm) continue;
                fmp.setTo(to);
            }
        }
    }
}

