/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.io.vamsas.DatastoreItem;
import jalview.log.JLoggerLog4j;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class DatastoreRegistry
implements AutoCloseable {
    protected static JLoggerLog4j log = JLoggerLog4j.getLogger(DatastoreRegistry.class);
    IdentityHashMap dsObjReg = new IdentityHashMap();
    IdentityHashMap dsItemReg = new IdentityHashMap();

    public boolean isInvolvedInDsitem(Object obj) {
        return obj instanceof DatastoreItem ? this.dsItemReg.containsKey(obj) : this.dsObjReg.containsKey(obj);
    }

    public DatastoreItem getDatastoreItemFor(Object obj) {
        if (obj instanceof DatastoreItem) {
            log.debug("Returning DatastoreItem self reference.");
            return (DatastoreItem)obj;
        }
        return (DatastoreItem)this.dsObjReg.get(obj);
    }

    synchronized void registerDsObj(DatastoreItem dsitem) {
        Object[] dsregitem = (Object[])this.dsItemReg.get(dsitem);
        if (dsregitem == null) {
            dsregitem = new Object[]{dsitem.jvobj, dsitem.vobj};
            this.dsItemReg.put(dsitem, dsregitem);
            this.dsObjReg.put(dsitem.jvobj, dsitem);
            this.dsObjReg.put(dsitem.vobj, dsitem);
        } else {
            if (dsitem.jvobj != dsregitem[0]) {
                if (dsregitem[0] != null) {
                    this.dsObjReg.remove(dsregitem[0]);
                }
                if ((dsregitem[0] = dsitem.jvobj) != null) {
                    this.dsObjReg.put(dsregitem[0], dsitem);
                }
            }
            if (dsitem.vobj != dsregitem[1]) {
                if (dsregitem[1] != null) {
                    this.dsObjReg.remove(dsregitem[1]);
                }
                if ((dsregitem[1] = dsitem.vobj) != null) {
                    this.dsObjReg.put(dsregitem[1], dsitem);
                }
            }
        }
    }

    public synchronized Object[] removeDsObj(DatastoreItem dsitem) {
        Object[] dsregitem = null;
        dsregitem = (Object[])this.dsItemReg.remove(dsitem);
        if (dsregitem != null) {
            if (dsregitem[0] != null) {
                this.dsObjReg.remove(dsregitem[0]);
            }
            if (dsregitem[1] != null) {
                this.dsObjReg.remove(dsregitem[1]);
            }
        }
        return dsregitem;
    }

    @Override
    public void close() {
        if (this.dsObjReg != null) {
            Iterator items = this.dsObjReg.entrySet().iterator();
            while (items.hasNext()) {
                Object[] vals = (Object[])items.next().getValue();
                vals[0] = null;
                vals[1] = null;
            }
            items = null;
            this.dsObjReg.clear();
        }
        if (this.dsItemReg != null) {
            this.dsItemReg.clear();
        }
    }
}

