/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.cache;

import jalview.bin.Cache;
import jalview.io.cache.AppCache;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class JvCacheableInputBox<E> {
    protected JComboBox<String> comboBox;
    protected JTextField textField;
    protected JTextComponent textComponent;
    protected String cacheKey;
    protected AppCache appCache;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem menuItemClearCache = new JMenuItem();
    volatile boolean enterWasPressed = false;
    private String prototypeDisplayValue;

    public boolean wasEnterPressed() {
        return this.enterWasPressed;
    }

    public JvCacheableInputBox(String newCacheKey, int length) {
        boolean useTextField;
        this.cacheKey = newCacheKey;
        this.prototypeDisplayValue = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        if (length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                sb.append("X");
            }
            this.setPrototypeDisplayValue(sb.toString());
        }
        if (useTextField = Platform.isJS()) {
            this.appCache = null;
            this.textField = new JTextField();
            this.textComponent = this.textField;
            FontMetrics fm = this.textField.getFontMetrics(this.textField.getFont());
            this.textField.setPreferredSize(new Dimension(fm.stringWidth(this.prototypeDisplayValue), fm.getHeight() + 4));
        } else {
            this.appCache = AppCache.getInstance();
            this.comboBox = new JComboBox();
            this.textComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            this.comboBox.setEditable(true);
            this.comboBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    JvCacheableInputBox.this.enterWasPressed = false;
                    if (e.getKeyCode() == 10) {
                        JvCacheableInputBox.this.enterWasPressed = true;
                    }
                }
            });
            this.comboBox.setPrototypeDisplayValue(this.prototypeDisplayValue);
            this.initCachePopupMenu();
            this.initCache(newCacheKey);
            this.updateCache();
        }
    }

    private void initCache(String cacheKey) {
        if (this.appCache == null) {
            return;
        }
        String delimitedCacheStr = Cache.getProperty(cacheKey);
        if (delimitedCacheStr == null || delimitedCacheStr.isEmpty()) {
            return;
        }
        List<String> persistedCacheItems = Arrays.asList(delimitedCacheStr.split(";"));
        LinkedHashSet<String> foundCacheItems = this.appCache.getAllCachedItemsFor(cacheKey);
        if (foundCacheItems == null) {
            foundCacheItems = new LinkedHashSet();
        }
        for (String cacheItem : persistedCacheItems) {
            foundCacheItems.add(cacheItem);
        }
        this.appCache.putCache(cacheKey, foundCacheItems);
    }

    private void initCachePopupMenu() {
        if (this.appCache == null) {
            return;
        }
        this.menuItemClearCache.setFont(new Font("Verdana", 0, 12));
        this.menuItemClearCache.setText(MessageManager.getString("action.clear_cached_items"));
        this.menuItemClearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JvCacheableInputBox.this.setSelectedItem("");
                JvCacheableInputBox.this.appCache.deleteCacheItems(JvCacheableInputBox.this.cacheKey);
                JvCacheableInputBox.this.updateCache();
            }
        });
        this.popup.add(this.menuItemClearCache);
        this.comboBox.setComponentPopupMenu(this.popup);
        this.comboBox.add(this.popup);
    }

    static boolean isInteger(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void updateCache() {
        if (this.appCache == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JvCacheableInputBox.this.comboBox.setEnabled(false);
                int cacheLimit = Integer.parseInt(JvCacheableInputBox.this.appCache.getCacheLimit(JvCacheableInputBox.this.cacheKey));
                String userInput = JvCacheableInputBox.this.getUserInput();
                if (userInput != null && !userInput.isEmpty()) {
                    LinkedHashSet<String> foundCache = JvCacheableInputBox.this.appCache.getAllCachedItemsFor(JvCacheableInputBox.this.cacheKey);
                    foundCache.remove(userInput);
                    foundCache.add(userInput);
                    JvCacheableInputBox.this.appCache.putCache(JvCacheableInputBox.this.cacheKey, foundCache);
                }
                String lastSearch = userInput;
                if (JvCacheableInputBox.this.comboBox.getItemCount() > 0) {
                    JvCacheableInputBox.this.comboBox.removeAllItems();
                }
                LinkedHashSet<String> cacheItems = JvCacheableInputBox.this.appCache.getAllCachedItemsFor(JvCacheableInputBox.this.cacheKey);
                ArrayList<String> reversedCacheItems = new ArrayList<String>();
                reversedCacheItems.addAll(cacheItems);
                cacheItems = null;
                Collections.reverse(reversedCacheItems);
                if (lastSearch.isEmpty()) {
                    JvCacheableInputBox.this.comboBox.addItem("");
                }
                if (reversedCacheItems != null && !reversedCacheItems.isEmpty()) {
                    LinkedHashSet<String> foundCache = JvCacheableInputBox.this.appCache.getAllCachedItemsFor(JvCacheableInputBox.this.cacheKey);
                    boolean prune = reversedCacheItems.size() > cacheLimit;
                    int count = 1;
                    boolean limitExceeded = false;
                    for (String cacheItem : reversedCacheItems) {
                        boolean bl = limitExceeded = count++ > cacheLimit;
                        if (prune) {
                            if (limitExceeded) {
                                foundCache.remove(cacheItem);
                                continue;
                            }
                            JvCacheableInputBox.this.comboBox.addItem(cacheItem);
                            continue;
                        }
                        JvCacheableInputBox.this.comboBox.addItem(cacheItem);
                    }
                    JvCacheableInputBox.this.appCache.putCache(JvCacheableInputBox.this.cacheKey, foundCache);
                }
                JvCacheableInputBox.this.setSelectedItem(lastSearch.isEmpty() ? "" : lastSearch);
                JvCacheableInputBox.this.comboBox.setEnabled(true);
            }
        });
    }

    public void persistCache() {
        if (this.appCache == null) {
            return;
        }
        this.appCache.persistCache(this.cacheKey);
    }

    public String getUserInput() {
        if (this.comboBox == null) {
            return this.textField.getText().trim();
        }
        Object item = this.comboBox.getEditor().getItem();
        return item == null ? "" : item.toString().trim();
    }

    public JComponent getComponent() {
        return this.comboBox == null ? this.textField : this.comboBox;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.comboBox == null) {
            this.textField.addActionListener(actionListener);
        } else {
            this.comboBox.addActionListener(actionListener);
        }
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textComponent.getDocument().addDocumentListener(listener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.textComponent.addFocusListener(focusListener);
    }

    public void addKeyListener(KeyListener kl) {
        this.textComponent.addKeyListener(kl);
    }

    public void addCaretListener(CaretListener caretListener) {
        this.textComponent.addCaretListener(caretListener);
    }

    public void setEditable(boolean b) {
        if (this.comboBox != null) {
            this.comboBox.setEditable(b);
        }
    }

    public void setPrototypeDisplayValue(String string) {
        this.prototypeDisplayValue = string;
        if (this.comboBox != null) {
            this.comboBox.setPrototypeDisplayValue(string);
        }
    }

    public void setSelectedItem(String userInput) {
        if (this.comboBox != null) {
            this.comboBox.setSelectedItem(userInput);
        }
    }

    public boolean isPopupVisible() {
        return this.comboBox != null && this.comboBox.isPopupVisible();
    }

    public void addItem(String item) {
        if (this.comboBox != null) {
            this.comboBox.addItem(item);
        }
    }
}

