/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import com.stevesoft.pat.Regex;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import jalview.analysis.Rna;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class RnamlFile
extends AlignFile {
    public String id;
    protected ArrayList<RNA> result;

    public RnamlFile() {
    }

    public RnamlFile(String inFile, DataSourceType type) throws IOException {
        super(inFile, type);
    }

    public RnamlFile(FileParse source) throws IOException {
        super(source);
    }

    public BufferedReader CreateReader() throws FileNotFoundException {
        FileReader fr = null;
        fr = new FileReader(this.inFile);
        BufferedReader r = new BufferedReader(fr);
        return r;
    }

    @Override
    public void parse() throws IOException {
        if (System.getProperty("java.version").indexOf("1.6") > -1 || System.getProperty("java.version").indexOf("1.5") > -1) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        }
        try {
            this._parse();
        }
        catch (ExceptionPermissionDenied pdx) {
            this.errormessage = MessageManager.formatMessage("exception.rnaml_couldnt_access_datasource", new String[]{pdx.getMessage()});
            throw new IOException(pdx);
        }
        catch (ExceptionLoadingFailed lf) {
            this.errormessage = MessageManager.formatMessage("exception.ranml_couldnt_process_data", new String[]{lf.getMessage()});
            throw new IOException(lf);
        }
        catch (ExceptionFileFormatOrSyntax iff) {
            this.errormessage = MessageManager.formatMessage("exception.ranml_invalid_file", new String[]{iff.getMessage()});
            throw new IOException(iff);
        }
        catch (Exception x) {
            this.error = true;
            this.errormessage = MessageManager.formatMessage("exception.ranml_problem_parsing_data", new String[]{x.getMessage()});
            throw new IOException(this.errormessage, x);
        }
    }

    public void _parse() throws FileNotFoundException, ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        this.result = RNAFactory.loadSecStrRNAML((Reader)this.getReader());
        SequenceI[] sqs = new SequenceI[this.result.size()];
        for (int i = 0; i < this.result.size(); ++i) {
            RNA current = this.result.get(i);
            String rna = current.getStructDBN(true);
            String seq = current.getSeq();
            int begin = 1;
            int end = seq.length();
            this.id = current.getName();
            if (this.id == null || this.id.trim().length() == 0) {
                this.id = this.safeName(this.getDataName());
                if (this.result.size() > 1) {
                    this.id = this.id + "." + i;
                }
            }
            sqs[i] = new Sequence(this.id, seq, begin, end);
            if (seq.length() != end - begin + 1) {
                sqs[i].setEnd(sqs[i].findPosition(sqs[i].getLength()));
            }
            String[] annot = new String[rna.length()];
            Annotation[] ann = new Annotation[rna.length()];
            for (int j = 0; j < rna.length(); ++j) {
                annot[j] = "" + rna.charAt(j);
            }
            for (int k = 0; k < rna.length(); ++k) {
                ann[k] = new Annotation(annot[k], "", Rna.getRNASecStrucState(annot[k]).charAt(0), 0.0f);
            }
            AlignmentAnnotation align = new AlignmentAnnotation("Secondary Structure", (String)(current.getID().trim().length() > 0 ? "Secondary Structure for " + current.getID() : ""), ann);
            sqs[i].addAlignmentAnnotation(align);
            sqs[i].setRNA(this.result.get(i));
            this.annotations.addElement(align);
        }
        this.setSeqs(sqs);
    }

    @Override
    public String print(SequenceI[] s, boolean jvSuffix) {
        return "not yet implemented";
    }

    public List<RNA> getRNA() {
        return this.result;
    }

    private String safeName(String dataName) {
        int b = 0;
        b = dataName.lastIndexOf(".");
        if (b > 0) {
            dataName = dataName.substring(0, b - 1);
        }
        b = 0;
        Regex m = Platform.newRegex("[\\/]?([-A-Za-z0-9]+)\\.?");
        String mm = dataName;
        while (m.searchFrom(dataName, b)) {
            mm = m.stringMatched();
            b = m.matchedTo();
        }
        return mm;
    }
}

