/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui.structurechooser;

import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.service.pdb.PDBFTSRestClient;
import jalview.gui.structurechooser.StructureChooserQuerySource;
import jalview.jbgui.FilterOption;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JTable;

public class PDBStructureChooserQuerySource
extends StructureChooserQuerySource {
    private static int MAX_QLENGTH = 7820;
    protected FTSRestRequest lastPdbRequest;
    protected FTSRestClientI pdbRestClient = PDBFTSRestClient.getInstance();

    public PDBStructureChooserQuerySource() {
        this.docFieldPrefs = new FTSDataColumnPreferences(FTSDataColumnPreferences.PreferenceSource.STRUCTURE_CHOOSER, PDBFTSRestClient.getInstance());
    }

    @Override
    public String buildQuery(SequenceI seq) {
        Sequence.DBModList<DBRefEntry> refs;
        boolean isPDBRefsFound = false;
        boolean isUniProtRefsFound = false;
        StringBuilder queryBuilder = new StringBuilder();
        LinkedHashSet<String> seqRefs = new LinkedHashSet<String>();
        HashSet<String> pdbids = new HashSet<String>();
        if (seq.getAllPDBEntries() != null && queryBuilder.length() < MAX_QLENGTH) {
            for (PDBEntry entry : seq.getAllPDBEntries()) {
                if (!PDBStructureChooserQuerySource.isValidSeqName(entry.getId())) continue;
                String id = entry.getId().toLowerCase(Locale.ROOT);
                queryBuilder.append("pdb_id:").append(id).append(" OR ");
                isPDBRefsFound = true;
                pdbids.add(id);
            }
        }
        if ((refs = seq.getDBRefs()) != null && refs.size() != 0) {
            int nb = refs.size();
            for (int ib = 0; ib < nb; ++ib) {
                DBRefEntry dbRef = (DBRefEntry)refs.get(ib);
                if (!PDBStructureChooserQuerySource.isValidSeqName(PDBStructureChooserQuerySource.getDBRefId(dbRef)) || queryBuilder.length() >= MAX_QLENGTH) continue;
                if (dbRef.getSource().equalsIgnoreCase("UNIPROT")) {
                    queryBuilder.append("uniprot_accession:").append(PDBStructureChooserQuerySource.getDBRefId(dbRef)).append(" OR ");
                    queryBuilder.append("uniprot_id:").append(PDBStructureChooserQuerySource.getDBRefId(dbRef)).append(" OR ");
                    isUniProtRefsFound = true;
                    continue;
                }
                if (dbRef.getSource().equalsIgnoreCase("PDB")) {
                    String id = PDBStructureChooserQuerySource.getDBRefId(dbRef).toLowerCase(Locale.ROOT);
                    if (pdbids.contains(id)) continue;
                    queryBuilder.append("pdb_id:").append(id).append(" OR ");
                    isPDBRefsFound = true;
                    pdbids.add(id);
                    continue;
                }
                seqRefs.add(PDBStructureChooserQuerySource.getDBRefId(dbRef));
            }
        }
        if (!isPDBRefsFound && !isUniProtRefsFound) {
            String seqName = seq.getName();
            seqName = PDBStructureChooserQuerySource.sanitizeSeqName(seqName);
            String[] names = seqName.toLowerCase(Locale.ROOT).split("\\|");
            for (String name : names) {
                name.trim();
                if (!PDBStructureChooserQuerySource.isValidSeqName(name)) continue;
                seqRefs.add(name);
            }
            for (String seqRef : seqRefs) {
                queryBuilder.append("text:").append(seqRef).append(" OR ");
            }
        }
        int endIndex = queryBuilder.lastIndexOf(" OR ");
        if (queryBuilder.toString().length() < 6) {
            return null;
        }
        String query = queryBuilder.toString().substring(0, endIndex);
        return query;
    }

    public static String sanitizeSeqName(String seqName) {
        Objects.requireNonNull(seqName);
        return seqName.replaceAll("\\[\\d*\\]", "").replaceAll("[^\\dA-Za-z|_]", "").replaceAll("\\s+", "+");
    }

    static boolean isValidSeqName(String seqName) {
        String ignoreList = "pdb,uniprot,swiss-prot";
        if (seqName.length() < 3) {
            return false;
        }
        if (seqName.contains(":")) {
            return false;
        }
        seqName = seqName.toLowerCase(Locale.ROOT);
        for (String ignoredEntry : ignoreList.split(",")) {
            if (!seqName.contains(ignoredEntry)) continue;
            return false;
        }
        return true;
    }

    static String getDBRefId(DBRefEntry dbRef) {
        String ref = dbRef.getAccessionId().replaceAll("GO:", "");
        return ref;
    }

    @Override
    public FTSRestResponse fetchStructuresMetaData(SequenceI seq, Collection<FTSDataColumnI> wantedFields, FilterOption selectedFilterOpt, boolean b) throws Exception {
        FTSRestRequest pdbRequest = new FTSRestRequest();
        pdbRequest.setAllowEmptySeq(false);
        pdbRequest.setResponseSize(500);
        pdbRequest.setFieldToSearchBy("(");
        pdbRequest.setFieldToSortBy(selectedFilterOpt.getValue(), b);
        pdbRequest.setWantedFields(wantedFields);
        pdbRequest.setSearchTerm(this.buildQuery(seq) + ")");
        pdbRequest.setAssociatedSequence(seq);
        FTSRestResponse resultList = this.pdbRestClient.executeRequest(pdbRequest);
        this.lastPdbRequest = pdbRequest;
        return resultList;
    }

    @Override
    public List<FilterOption> getAvailableFilterOptions(String VIEWS_FILTER) {
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
        filters.add(new FilterOption("PDBe " + MessageManager.getString("label.best_quality"), "overall_quality", VIEWS_FILTER, false, this));
        filters.add(new FilterOption("PDBe " + MessageManager.getString("label.best_resolution"), "resolution", VIEWS_FILTER, false, this));
        filters.add(new FilterOption("PDBe " + MessageManager.getString("label.most_protein_chain"), "number_of_protein_chains", VIEWS_FILTER, false, this));
        filters.add(new FilterOption("PDBe " + MessageManager.getString("label.most_bound_molecules"), "number_of_bound_molecules", VIEWS_FILTER, false, this));
        filters.add(new FilterOption("PDBe " + MessageManager.getString("label.most_polymer_residues"), "number_of_polymer_residues", VIEWS_FILTER, true, this));
        return filters;
    }

    @Override
    public boolean needsRefetch(FilterOption selectedFilterOpt) {
        return false;
    }

    @Override
    public FTSRestResponse selectFirstRankedQuery(SequenceI seq, Collection<FTSData> collectedResults, Collection<FTSDataColumnI> wantedFields, String fieldToFilterBy, boolean b) throws Exception {
        FTSRestRequest pdbRequest = new FTSRestRequest();
        if (fieldToFilterBy.equalsIgnoreCase("uniprot_coverage")) {
            pdbRequest.setAllowEmptySeq(false);
            pdbRequest.setResponseSize(1);
            pdbRequest.setFieldToSearchBy("(");
            pdbRequest.setSearchTerm(this.buildQuery(seq) + ")");
            pdbRequest.setWantedFields(wantedFields);
            pdbRequest.setAssociatedSequence(seq);
            pdbRequest.setFacet(true);
            pdbRequest.setFacetPivot(fieldToFilterBy + ",entry_entity");
            pdbRequest.setFacetPivotMinCount(1);
        } else {
            pdbRequest.setAllowEmptySeq(false);
            pdbRequest.setResponseSize(1);
            pdbRequest.setFieldToSearchBy("(");
            pdbRequest.setFieldToSortBy(fieldToFilterBy, b);
            pdbRequest.setSearchTerm(this.buildQuery(seq) + ")");
            pdbRequest.setWantedFields(wantedFields);
            pdbRequest.setAssociatedSequence(seq);
        }
        FTSRestResponse resultList = this.pdbRestClient.executeRequest(pdbRequest);
        this.lastPdbRequest = pdbRequest;
        return resultList;
    }

    @Override
    public PDBEntry[] collectSelectedRows(JTable restable, int[] selectedRows, List<SequenceI> selectedSeqsToView) {
        int refSeqColIndex = restable.getColumn("Ref Sequence").getModelIndex();
        PDBEntry[] pdbEntriesToView = new PDBEntry[selectedRows.length];
        int count = 0;
        int idColumnIndex = -1;
        boolean fromTDB = true;
        idColumnIndex = restable.getColumn("PDB Id").getModelIndex();
        for (int row : selectedRows) {
            String pdbIdStr = restable.getValueAt(row, idColumnIndex).toString();
            SequenceI selectedSeq = (SequenceI)restable.getValueAt(row, refSeqColIndex);
            selectedSeqsToView.add(selectedSeq);
            PDBEntry pdbEntry = selectedSeq.getPDBEntry(pdbIdStr);
            if (pdbEntry == null) {
                pdbEntry = PDBStructureChooserQuerySource.getFindEntry(pdbIdStr, selectedSeq.getAllPDBEntries());
            }
            if (pdbEntry == null) {
                pdbEntry = new PDBEntry();
                pdbEntry.setId(pdbIdStr);
                pdbEntry.setType(PDBEntry.Type.MMCIF);
                selectedSeq.getDatasetSequence().addPDBId(pdbEntry);
            }
            pdbEntriesToView[count++] = pdbEntry;
        }
        return pdbEntriesToView;
    }

    @Override
    protected FTSRestRequest getLastFTSRequest() {
        return this.lastPdbRequest;
    }

    public FTSRestResponse executePDBFTSRestRequest(FTSRestRequest pdbRequest) throws Exception {
        return this.pdbRestClient.executeRequest(pdbRequest);
    }
}

