/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OptsAndParamsPage;
import jalview.gui.OptsParametersContainerI;
import jalview.util.MessageManager;
import jalview.ws.api.UIinfo;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.OptionI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.WsParamSetI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class WsJobParameters
extends JPanel
implements ItemListener,
ActionListener,
DocumentListener,
OptsParametersContainerI {
    private static final int PREFERRED_WIDTH = 540;
    private static final int DEFAULT_HEIGHT = 640;
    private static final String SVC_DEF = "Defaults";
    private int maxOptWidth = 200;
    private final CompletableFuture<Boolean> completionStage = new CompletableFuture();
    OptsAndParamsPage opanp;
    JPanel optionsPanel = new JPanel();
    JPanel paramsPanel = new JPanel();
    JPanel setNamePanel = new JPanel();
    JButton createpref = new JButton();
    JButton deletepref = new JButton();
    JButton revertpref = new JButton();
    JButton updatepref = new JButton();
    JComboBox<String> setName = new JComboBox();
    JTextArea setDescr = new JTextArea();
    JScrollPane paramPane = new JScrollPane();
    JButton startjob = JvSwingUtils.makeButton(MessageManager.getString("action.start_job"), MessageManager.getString("label.start_job_current_settings"), this::startjob_actionPerformed);
    JButton canceljob = JvSwingUtils.makeButton(MessageManager.getString("action.cancel_job"), MessageManager.getString("label.cancel_job_close_dialog"), this::canceljob_actionPerformed);
    ParamDatastoreI paramStore;
    boolean startJob = false;
    JFrame frame = null;
    UIinfo service;
    Hashtable<String, String> servicePresets = null;
    boolean settingDialog = false;
    private Hashtable<Object, Object> modifiedElements = new Hashtable();
    String lastParmSet = null;
    boolean isUserPreset = false;
    String curSetName = null;
    String lastSetName = null;
    String lastDescrText = null;

    public WsJobParameters(ParamDatastoreI store, WsParamSetI preset, List<ArgumentI> args) {
        this.opanp = new OptsAndParamsPage(this, true);
        this.jbInit();
        this.paramStore = store;
        this.service = null;
        this.initForService(preset, args);
        this.validate();
    }

    public WsJobParameters(ParamDatastoreI paramStorei, UIinfo service, WsParamSetI preset, List<ArgumentI> jobArgset) {
        this.opanp = new OptsAndParamsPage(this, false);
        this.jbInit();
        this.paramStore = paramStorei;
        if (this.paramStore == null && service != null) {
            this.paramStore = service.getParamStore();
        }
        this.service = service;
        this.initForService(preset, jobArgset);
        this.validate();
    }

    public CompletionStage<Boolean> showRunDialog() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(0);
        if (this.service != null) {
            this.frame.setTitle(MessageManager.formatMessage("label.edit_params_for", new String[]{this.service.getActionText()}));
        }
        Rectangle deskr = Desktop.getInstance().getBounds();
        Dimension pref = this.getPreferredSize();
        this.frame.setBounds(new Rectangle((int)(deskr.getCenterX() - (double)(pref.width / 2)), (int)(deskr.getCenterY() - (double)(pref.height / 2)), pref.width, pref.height));
        this.frame.setContentPane(this);
        this.frame.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.frame.setVisible(true);
        return this.completionStage;
    }

    private void jbInit() {
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent arg0) {
                WsJobParameters.this.refreshParamLayout();
            }

            @Override
            public void ancestorMoved(HierarchyEvent arg0) {
            }
        });
        this.updatepref = JvSwingUtils.makeButton(MessageManager.getString("action.update"), MessageManager.getString("label.update_user_parameter_set"), this::update_actionPerformed);
        this.deletepref = JvSwingUtils.makeButton(MessageManager.getString("action.delete"), MessageManager.getString("label.delete_user_parameter_set"), this::delete_actionPerformed);
        this.createpref = JvSwingUtils.makeButton(MessageManager.getString("action.create"), MessageManager.getString("label.create_user_parameter_set"), this::create_actionPerformed);
        this.revertpref = JvSwingUtils.makeButton(MessageManager.getString("action.revert"), MessageManager.getString("label.revert_changes_user_parameter_set"), this::revert_actionPerformed);
        JPanel setDetails = new JPanel();
        setDetails.setBorder(new TitledBorder(MessageManager.getString("label.details")));
        setDetails.setLayout(new BorderLayout());
        this.setDescr.setColumns(40);
        this.setDescr.setWrapStyleWord(true);
        this.setDescr.setLineWrap(true);
        this.setDescr.setBackground(this.getBackground());
        this.setDescr.setEditable(true);
        this.setDescr.getDocument().addDocumentListener(this);
        this.setDescr.setToolTipText(MessageManager.getString("label.edit_notes_parameter_set"));
        JScrollPane setDescrView = new JScrollPane();
        setDescrView.getViewport().setView(this.setDescr);
        this.setName.setEditable(true);
        this.setName.addItemListener(this);
        this.setName.getEditor().addActionListener(this);
        JPanel setNameInfo = new JPanel(new FlowLayout(0));
        GridBagLayout gbl = new GridBagLayout();
        this.setNamePanel.setLayout(gbl);
        JLabel setNameLabel = new JLabel(MessageManager.getString("label.current_parameter_set_name"));
        setNameLabel.setFont(new Font("Verdana", 0, 10));
        setNameInfo.add(setNameLabel);
        setNameInfo.add(this.setName);
        this.updatepref.setVisible(false);
        this.deletepref.setVisible(false);
        this.revertpref.setVisible(false);
        this.createpref.setVisible(false);
        JPanel setsavebuts = new JPanel();
        setsavebuts.setLayout(new FlowLayout(0, 10, 0));
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(2, 30));
        setsavebuts.add(spacer);
        setsavebuts.add(this.deletepref);
        setsavebuts.add(this.revertpref);
        setsavebuts.add(this.createpref);
        setsavebuts.add(this.updatepref);
        JPanel buttonArea = new JPanel(new GridLayout(1, 1));
        buttonArea.add(setsavebuts);
        this.setNamePanel.add(setNameInfo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 2;
        gbl.setConstraints(setNameInfo, gbc);
        this.setNamePanel.add(buttonArea);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbl.setConstraints(buttonArea, gbc);
        setDetails.add((Component)setDescrView, "Center");
        this.optionsPanel.setBorder(new TitledBorder(MessageManager.getString("label.options")));
        this.optionsPanel.setOpaque(true);
        this.paramsPanel.setBorder(new TitledBorder(MessageManager.getString("label.parameters")));
        this.paramsPanel.setOpaque(true);
        JPanel optsAndparams = new JPanel();
        optsAndparams.setLayout(new BorderLayout());
        optsAndparams.add((Component)this.optionsPanel, "North");
        optsAndparams.add((Component)this.paramsPanel, "Center");
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)optsAndparams, "Center");
        this.paramPane.getViewport().setView(jp);
        this.paramPane.setBorder(null);
        this.setLayout(new BorderLayout());
        JPanel jobPanel = new JPanel();
        jobPanel.setPreferredSize(null);
        jobPanel.setLayout(new BorderLayout());
        jobPanel.add((Component)setDetails, "North");
        jobPanel.add((Component)this.paramPane, "Center");
        this.add((Component)this.setNamePanel, "North");
        this.add((Component)jobPanel, "Center");
        JPanel dialogpanel = new JPanel();
        dialogpanel.add(this.startjob);
        dialogpanel.add(this.canceljob);
        int windowHeight = Desktop.getInstance() == null ? 640 : Desktop.getInstance().getHeight();
        this.setPreferredSize(new Dimension(540, windowHeight));
        this.add((Component)dialogpanel, "South");
        this.validate();
    }

    protected void revert_actionPerformed(ActionEvent e) {
        this.reInitDialog(this.lastParmSet);
        this.updateWebServiceMenus();
    }

    protected void update_actionPerformed(ActionEvent e) {
        if (this.isUserPreset) {
            String curname = ((String)this.setName.getSelectedItem()).trim();
            this._updatePreset(this.lastParmSet, curname);
            this.lastParmSet = curname;
            this.isUserPreset = true;
            this.initArgSetModified();
            this.syncSetNamesWithStore();
        }
    }

    private void _deleteUserPreset(String lastParmSet2) {
        this.paramStore.deletePreset(lastParmSet2);
    }

    protected void delete_actionPerformed(ActionEvent e) {
        if (this.isUserPreset) {
            this._deleteUserPreset(this.lastParmSet);
        }
        this.reInitDialog(null);
        this.updateWebServiceMenus();
    }

    protected void create_actionPerformed(ActionEvent e) {
        String curname = ((String)this.setName.getSelectedItem()).trim();
        if (curname.length() > 0) {
            this._storeCurrentPreset(curname);
            this.lastParmSet = curname;
            this.isUserPreset = true;
            this.reInitDialog(curname);
            this.initArgSetModified();
            this.updateWebServiceMenus();
        } else {
            Console.errPrintln("Invalid name. Not saved.");
        }
    }

    protected void canceljob_actionPerformed(ActionEvent e) {
        this.startJob = false;
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.completionStage.complete(false);
    }

    protected void startjob_actionPerformed(ActionEvent e) {
        this.startJob = true;
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.completionStage.complete(true);
    }

    void initForService(WsParamSetI paramSet, List<ArgumentI> jobArgset) {
        this.settingDialog = true;
        this.init(paramSet, jobArgset);
    }

    void init(WsParamSetI p, List<ArgumentI> jobArgset) {
        Hashtable<String, String> exnames = new Hashtable<String, String>();
        int iSize = this.setName.getItemCount();
        for (int i = 0; i < iSize; ++i) {
            exnames.put(this.setName.getItemAt(i), this.setName.getItemAt(i));
        }
        this.servicePresets = new Hashtable();
        if (!exnames.contains(SVC_DEF)) {
            this.setName.addItem(SVC_DEF);
            exnames.put(SVC_DEF, SVC_DEF);
            this.servicePresets.put(SVC_DEF, SVC_DEF);
        }
        for (WsParamSetI pr : this.paramStore.getPresets()) {
            if (!pr.isModifiable()) {
                this.servicePresets.put(pr.getName(), "preset");
            }
            if (exnames.contains(pr.getName())) continue;
            this.setName.addItem(pr.getName());
        }
        if (p != null) {
            this.reInitDialog(p.getName());
            this.initArgSetModified();
        } else if (jobArgset != null && jobArgset.size() > 0) {
            this.curSetName = "Supplied Settings";
            this.isUserPreset = false;
            this.updateTable(p, jobArgset);
            this.setName.setSelectedItem(this.curSetName);
            this.updateButtonDisplay();
        } else {
            this.curSetName = null;
            this.reInitDialog(null);
        }
        this.settingDialog = false;
    }

    private void updateTable(WsParamSetI p, List<ArgumentI> jobArgset) {
        boolean setDefaultParams = false;
        if (this.lastParmSet == null) {
            this.isUserPreset = false;
            this.lastSetName = SVC_DEF;
            this.setName.setSelectedItem(SVC_DEF);
        }
        if (p == null && SVC_DEF.equals("" + this.setName.getSelectedItem())) {
            setDefaultParams = true;
        }
        List<ArgumentI> args = this.paramStore.getServiceParameters();
        int cw = 0;
        boolean optset = false;
        for (ArgumentI myarg : args) {
            if (myarg instanceof ParameterI) {
                ParameterI parm = (ParameterI)myarg;
                this.opanp.addParameter(parm).validate();
                continue;
            }
            if (myarg instanceof OptionI) {
                OptionI opt = (OptionI)myarg;
                OptsAndParamsPage.OptionBox ob = this.opanp.addOption(opt);
                ob.resetToDefault(setDefaultParams);
                if (this.maxOptWidth < ob.getPreferredSize().width) {
                    this.maxOptWidth = ob.getPreferredSize().width;
                }
                ob.validate();
                cw += ob.getPreferredSize().width + 5;
                continue;
            }
            Console.errPrintln("Ignoring unknown service argument type " + myarg.getClass().getName());
        }
        args = null;
        if (p != null) {
            this.isUserPreset = false;
            this.lastSetName = p.getName();
            this.setName.setSelectedItem(this.lastSetName);
            this.lastDescrText = p.getDescription();
            this.setDescr.setText(this.lastDescrText);
            try {
                args = p.getArguments();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (jobArgset != null) {
            this.argSetModified(jobArgset, true);
            args = jobArgset;
        }
        if (args != null) {
            for (ArgumentI arg : args) {
                if (arg instanceof ParameterI) {
                    this.opanp.setParameter((ParameterI)arg);
                    continue;
                }
                if (!(arg instanceof OptionI)) continue;
                this.opanp.selectOption((OptionI)arg, arg.getValue());
            }
        }
        this.refreshParamLayout();
        this.revalidate();
    }

    private boolean isModified() {
        return this.modifiedElements.size() > 0;
    }

    private void initArgSetModified() {
        this.curSetName = null;
        this.modifiedElements.clear();
        this.updateButtonDisplay();
    }

    private void updateButtonDisplay() {
        boolean _update = false;
        boolean _create = false;
        boolean _delete = false;
        boolean _revert = false;
        if (this.modifiedElements.size() > 0) {
            _revert = true;
            _update = this.isUserPreset;
            if (!this.isUserPreset || this.modifiedElements.containsKey(this.setName)) {
                _create = true;
            }
        }
        _delete = this.isUserPreset;
        this.createpref.setVisible(_create);
        this.updatepref.setVisible(_update);
        this.deletepref.setVisible(_delete);
        this.revertpref.setVisible(_revert);
        this.validate();
    }

    @Override
    public void argSetModified(Object modifiedElement, boolean b) {
        if (this.settingDialog) {
            return;
        }
        if (!b) {
            this.modifiedElements.remove(modifiedElement);
        } else {
            if (b && modifiedElement == this.setName && this.modifiedElements.contains(modifiedElement)) {
                b = false;
            }
            this.modifiedElements.put(modifiedElement, modifiedElement);
        }
        if (b && this.modifiedElements.size() > 0) {
            this.makeSetNameValid(!this.isUserPreset);
            this.setNamePanel.revalidate();
        }
        this.updateButtonDisplay();
    }

    private boolean isServicePreset(String selectedItem) {
        return selectedItem.equals(SVC_DEF) || this.servicePresets.containsKey(selectedItem);
    }

    private void makeSetNameValid(boolean newuserset) {
        Object nm;
        boolean stn = this.settingDialog;
        boolean renamed = false;
        this.settingDialog = true;
        Object object = nm = this.curSetName != null ? this.curSetName : (String)this.setName.getSelectedItem();
        if (this.isServicePreset((String)nm)) {
            nm = "User " + (String)nm;
            renamed = true;
        }
        Object tnm = nm;
        if (newuserset) {
            int i = 0;
            while (this.paramStore.getPreset((String)tnm) != null) {
                tnm = (String)nm + " (" + ++i + ")";
                renamed = true;
            }
            if (i > 0) {
                nm = tnm;
            }
        }
        boolean makeupdate = false;
        int iS = this.setName.getItemCount();
        for (int i = 0; i < iS; ++i) {
            String snm = this.setName.getItemAt(i);
            if (!snm.equals(nm)) continue;
            makeupdate = true;
        }
        if (!makeupdate) {
            this.curSetName = nm;
            this.setName.addItem((String)this.curSetName);
            this.setName.setSelectedItem(this.curSetName);
        }
        if (renamed) {
            this.settingDialog = false;
            this.argSetModified(this.setName, renamed);
        }
        this.settingDialog = stn;
    }

    @Override
    public void refreshParamLayout() {
        boolean wrapAfterLast;
        int boxWidth;
        JPanel lastAdded;
        int currentWidth;
        int hgap;
        int rightMargin = 40;
        int availableWidth = this.paramPane.getViewport().getSize().width - 40 - this.optionsPanel.getBorder().getBorderInsets((Component)this.optionsPanel).left + this.optionsPanel.getBorder().getBorderInsets((Component)this.optionsPanel).right;
        if (this.opanp.getOptSet().size() > 0) {
            currentWidth = hgap = 5;
            this.optionsPanel.setLayout((LayoutManager)new MigLayout("nogrid", "", ""));
            this.optionsPanel.removeAll();
            lastAdded = null;
            for (OptsAndParamsPage.OptionBox optionBox : this.opanp.getOptSet().values()) {
                optionBox.validate();
                boxWidth = optionBox.getSize().width;
                boolean bl = wrapAfterLast = (currentWidth += boxWidth + hgap) > availableWidth && lastAdded != null;
                if (wrapAfterLast) {
                    this.optionsPanel.remove(lastAdded);
                    this.optionsPanel.add((Component)lastAdded, "wrap");
                    currentWidth = hgap + boxWidth;
                }
                this.optionsPanel.add(optionBox);
                lastAdded = optionBox;
            }
            this.optionsPanel.revalidate();
        } else {
            this.optionsPanel.setVisible(false);
        }
        if (this.opanp.getParamSet().size() > 0) {
            this.paramsPanel.removeAll();
            this.paramsPanel.setLayout((LayoutManager)new MigLayout("", "", ""));
            currentWidth = hgap = 5;
            lastAdded = null;
            for (OptsAndParamsPage.ParamBox paramBox : this.opanp.getParamSet().values()) {
                paramBox.validate();
                boxWidth = paramBox.getSize().width;
                boolean bl = wrapAfterLast = (currentWidth += boxWidth + hgap) > availableWidth && lastAdded != null;
                if (wrapAfterLast) {
                    this.paramsPanel.remove(lastAdded);
                    this.paramsPanel.add((Component)lastAdded, "wrap");
                    currentWidth = paramBox.getSize().width + hgap;
                }
                this.paramsPanel.add(paramBox);
                lastAdded = paramBox;
            }
            this.paramsPanel.revalidate();
        } else {
            this.paramsPanel.setVisible(false);
        }
        this.paramPane.getViewport().setAutoscrolls(true);
        this.paramPane.revalidate();
        this.revalidate();
    }

    public boolean isServiceDefaults() {
        return !this.isModified() && this.lastParmSet != null && this.lastParmSet.equals(SVC_DEF);
    }

    public List<ArgumentI> getJobParams() {
        return this.opanp.getCurrentSettings();
    }

    private void syncSetNamesWithStore() {
        int n = 0;
        Vector<String> items = new Vector<String>();
        while (n < this.setName.getItemCount()) {
            String item = this.setName.getItemAt(n);
            if (!item.equals(SVC_DEF) && !this.paramStore.presetExists(item)) {
                this.setName.removeItemAt(n);
                continue;
            }
            items.addElement(item);
            ++n;
        }
        if (!items.contains(SVC_DEF)) {
            this.setName.addItem(SVC_DEF);
        }
        for (WsParamSetI upn : this.paramStore.getPresets()) {
            if (items.contains(upn.getName())) continue;
            this.setName.addItem(upn.getName());
        }
    }

    private void reInitDialog(String nextPreset) {
        this.settingDialog = true;
        WsParamSetI pset = null;
        if (nextPreset != null && nextPreset.length() > 0) {
            pset = this.paramStore.getPreset(nextPreset);
        }
        if (pset != null) {
            if (pset.isModifiable()) {
                this.isUserPreset = true;
                this.setDescr.setText(pset.getDescription());
                this.updateTable(null, pset.getArguments());
                this.lastParmSet = nextPreset;
            } else {
                this.isUserPreset = false;
                this.setDescr.setText("");
                this.updateTable(pset, null);
                this.lastParmSet = nextPreset;
            }
        } else {
            this.isUserPreset = false;
            this.setDescr.setText("");
            this.updateTable(null, null);
            this.lastParmSet = SVC_DEF;
        }
        this.initArgSetModified();
        this.syncSetNamesWithStore();
        this.setName.setSelectedItem(this.lastParmSet);
        this.setNamePanel.validate();
        this.validate();
        this.settingDialog = false;
    }

    protected void updateWebServiceMenus() {
        if (Desktop.getInstance() == null) {
            return;
        }
        for (AlignFrame alignFrame : Desktop.getDesktopAlignFrames()) {
            alignFrame.buildWebServicesMenu();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.setName && e.getStateChange() == 1) {
            final String setname = (String)this.setName.getSelectedItem();
            if (Console.isDebugEnabled()) {
                Console.debug("Item state changed for " + setname + " (handling ? " + !this.settingDialog + ")");
            }
            if (this.settingDialog) {
                return;
            }
            if (setname == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WsJobParameters.this.doPreferenceComboStateChange(setname);
                }
            });
        }
    }

    private void doPreferenceComboStateChange(String setname) {
        if (this.isModified()) {
            String lsetname;
            String string = lsetname = this.curSetName != null ? this.curSetName : this.lastParmSet;
            if (lsetname.equals(setname)) {
                return;
            }
            this.settingDialog = true;
            Console.outPrintln("Prompting to save " + lsetname);
            if (JvOptionPane.showConfirmDialog(this, "Parameter set '" + lsetname + "' is modifed, and your changes will be lost.\nReally change preset ?", "Warning: Unsaved Changes", 2) != 0) {
                this.settingDialog = true;
                this.setName.setSelectedItem(lsetname);
                this.settingDialog = false;
                return;
            }
        }
        this.settingDialog = true;
        this.reInitDialog(setname);
        this.settingDialog = false;
    }

    private void _storeCurrentPreset(String curSetName2) {
        this.paramStore.storePreset(curSetName2, this.setDescr.getText(), this.getJobParams());
    }

    private void _updatePreset(String lastParmSet2, String curname) {
        this.paramStore.updatePreset(lastParmSet2, curname, this.setDescr.getText(), this.getJobParams());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component src;
        if (e.getSource() instanceof Component && (src = (Component)e.getSource()).getParent() == this.setName) {
            String newname = e.getActionCommand().trim();
            Object msg = null;
            if (this.isServicePreset(newname)) {
                String oldname = this.curSetName != null ? this.curSetName : this.lastParmSet;
                final WsJobParameters ourframe = this;
                this.settingDialog = true;
                this.setName.getEditor().setItem(oldname);
                this.settingDialog = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showMessageDialog(ourframe, MessageManager.getString("label.invalid_name_preset_exists"), MessageManager.getString("label.invalid_name"), 2);
                    }
                });
                return;
            }
            this.curSetName = newname;
            Console.errPrintln("New name for user setting " + this.curSetName + " (was " + this.setName.getSelectedItem() + ")");
            if (this.curSetName.equals(this.setName.getSelectedItem())) {
                this.curSetName = null;
            }
            if (this.curSetName != null) {
                this.argSetModified(this.setName, true);
                return;
            }
        }
    }

    private void checkDescrModified() {
        if (!this.settingDialog) {
            this.argSetModified(this.setDescr, this.lastDescrText == null ? this.setDescr.getText().trim().length() > 0 : !this.setDescr.getText().equals(this.lastDescrText));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDescrModified();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDescrModified();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDescrModified();
    }

    public WsParamSetI getPreset() {
        if (this.isUserPreset || this.isModified() || this.lastParmSet != null && this.lastParmSet.equals(SVC_DEF)) {
            return null;
        }
        return this.paramStore.getPreset(this.lastParmSet);
    }
}

