/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.Conservation;
import jalview.analysis.TreeModel;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.JalviewColourChooser;
import jalview.gui.PaintRefresher;
import jalview.gui.TreePanel;
import jalview.schemes.ColourSchemeI;
import jalview.structure.SelectionSource;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.MessageManager;
import jalview.ws.datamodel.MappableContactMatrixI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class TreeCanvas
extends JPanel
implements MouseListener,
Runnable,
Printable,
MouseMotionListener,
SelectionSource {
    public static final String PLACEHOLDER = " * ";
    private static final int DASHED_LINE_Y_OFFSET = 6;
    TreeModel tree;
    JScrollPane scrollPane;
    TreePanel tp;
    private AlignViewport av;
    private AlignmentPanel ap;
    Font font;
    FontMetrics fm;
    boolean fitToWindow = true;
    boolean showDistances = false;
    boolean showStructureProviderLabels = false;
    boolean showStructureProviderColouredLines = false;
    Map<String, Boolean> structureProviderColouredLineToggleState = new HashMap<String, Boolean>();
    boolean showBootstrap = false;
    boolean markPlaceholders = false;
    int offx = 20;
    int offy;
    private float threshold;
    int labelLengthThreshold = 4;
    String longestName;
    int labelLength = -1;
    private static final int COLOR_TRANSPARENCY_FOR_GROUP = 198;
    private static final int COLOR_TRANSPARENCY_FOR_COLOURED_LINES = 80;
    private static final int TREE_GROUP_DIM_MIN_X_INDEX = 0;
    private static final int TREE_GROUP_DIM_MIN_Y_INDEX = 1;
    private static final int TREE_GROUP_DIM_MAX_X_INDEX = 2;
    private static final int TREE_GROUP_DIM_MAX_Y_INDEX = 3;
    Map<BinaryNode, Rectangle> nameHash = new Hashtable<BinaryNode, Rectangle>();
    Map<BinaryNode, Rectangle> nodeHash = new Hashtable<BinaryNode, Rectangle>();
    BinaryNode highlightNode;
    boolean applyToAllViews = false;

    public TreeCanvas(TreePanel tp, AlignmentPanel ap, JScrollPane scroller) {
        this.tp = tp;
        this.av = ap.av;
        this.setAssociatedPanel(ap);
        this.font = this.av.getFont();
        this.scrollPane = scroller;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void clearSelectedLeaves() {
        Vector<BinaryNode> leaves = this.tp.getTree().findLeaves(this.tp.getTree().getTopNode());
        if (this.tp.isColumnWise()) {
            this.markColumnsFor(this.getAssociatedPanels(), leaves, Color.white, true);
        } else {
            for (AlignmentPanel ap : this.getAssociatedPanels()) {
                SequenceGroup selected = ap.av.getSelectionGroup();
                if (selected != null) {
                    for (int i = 0; i < leaves.size(); ++i) {
                        AlignmentAnnotation annot;
                        SequenceI seq = (SequenceI)leaves.elementAt(i).element();
                        if (selected.contains(seq)) {
                            selected.addOrRemove(seq, false);
                        }
                        if (!leaves.elementAt(i).hasAlignmentAnnotation() || !selected.containsAnnotation(annot = leaves.elementAt(i).getAlignmentAnnotation())) continue;
                        selected.addOrRemoveAnnotation(annot);
                    }
                    selected.recalcConservation();
                }
                ap.av.sendSelection();
            }
        }
        PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
        this.repaint();
    }

    public void treeSelectionChanged(SequenceI sequence, AlignmentAnnotation alignmentAnnotation) {
        boolean annotationSelected = false;
        AlignmentPanel[] aps = this.getAssociatedPanels();
        for (int a = 0; a < aps.length; ++a) {
            SequenceGroup selected = aps[a].av.getSelectionGroup();
            if (selected == null) {
                selected = new SequenceGroup();
                aps[a].av.setSelectionGroup(selected);
            }
            if (alignmentAnnotation != null) {
                annotationSelected = selected.addOrRemoveAnnotation(alignmentAnnotation);
            }
            selected.setEndRes(aps[a].av.getAlignment().getWidth() - 1);
            if (annotationSelected) {
                selected.addSequence(sequence, true);
                continue;
            }
            selected.addOrRemove(sequence, true);
        }
    }

    public void setTree(TreeModel tree) {
        ContactMatrixI cm;
        this.tree = tree;
        tree.findHeight(tree.getTopNode());
        Vector<BinaryNode> leaves = tree.findLeaves(tree.getTopNode());
        boolean has_placeholders = false;
        this.longestName = "";
        AlignmentAnnotation aa = this.tp.getAssocAnnotation();
        ContactMatrixI contactMatrixI = cm = aa != null ? this.av.getContactMatrix(aa) : null;
        if (cm != null && cm.hasCutHeight()) {
            this.threshold = (float)cm.getCutHeight();
        }
        for (int i = 0; i < leaves.size(); ++i) {
            BinaryNode lf = leaves.elementAt(i);
            if (lf instanceof SequenceNode && ((SequenceNode)lf).isPlaceholder()) {
                has_placeholders = true;
            }
            if (this.longestName.length() < lf.getDisplayName().length()) {
                this.longestName = PLACEHOLDER + lf.getDisplayName();
            }
            if (!this.tp.isColumnWise() || cm == null) continue;
            try {
                Color col = cm.getGroupColorForPosition(this.parseColumnNode(lf));
                this.setColor(lf, col.brighter());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setMarkPlaceholders(has_placeholders);
    }

    public void drawNode(Graphics g, BinaryNode node, double chunk, double wscale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        SequenceGroup colourGroup = null;
        Vector<BinaryNode> leaves = this.tree.findLeaves(node);
        this.gatherLabelsTo(node, leaves);
        if (node.left() == null && node.right() == null) {
            Color annotationColor = Color.WHITE;
            double height = node.height;
            double dist = node.dist;
            int xstart = (int)((height - dist) * wscale) + offx;
            int xend = (int)(height * wscale) + offx;
            int ypos = (int)((double)node.ycount * chunk) + offy;
            if (node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                SequenceGroup[] groupsWithSequence = null;
                if (this.ap.getAlignment() != null) {
                    groupsWithSequence = this.ap.getAlignment().findAllGroups(seq);
                }
                if (this.av.getSequenceColour(seq).equals(Color.white)) {
                    g.setColor(Color.black);
                } else if (node.hasLabel() && node.hasAlignmentAnnotation()) {
                    if (groupsWithSequence != null) {
                        for (SequenceGroup group : groupsWithSequence) {
                            if (!group.getAnnotationsFromTree().contains(node.getAlignmentAnnotation()) || !group.getName().startsWith("JTreeGroup:")) continue;
                            colourGroup = group;
                        }
                    }
                    if ((annotationColor = this.av.getAnnotationColour(node.getAlignmentAnnotation())) == Color.white) {
                        annotationColor = this.av.getSequenceColour(seq);
                    }
                    g.setColor(annotationColor.darker());
                    if (this.showStructureProviderColouredLines) {
                        g.setColor(Color.black);
                    }
                } else {
                    if (node.hasLabel() && groupsWithSequence != null) {
                        for (SequenceGroup group : groupsWithSequence) {
                            if (!group.getName().startsWith("JTreeGroup:")) continue;
                            colourGroup = group;
                        }
                    }
                    g.setColor(this.av.getSequenceColour(seq).darker());
                }
            } else {
                g.setColor(Color.black);
            }
            if (!node.hasLabel() || !this.showStructureProviderColouredLines) {
                g.drawLine(xstart, ypos, xend, ypos);
            }
            Object nodeLabel = "";
            if (this.showDistances && node.dist > 0.0) {
                nodeLabel = new Format("%g").form(node.dist);
            }
            if (this.showBootstrap && node.bootstrap > -1) {
                if (this.showDistances) {
                    nodeLabel = (String)nodeLabel + " : ";
                }
                nodeLabel = (String)nodeLabel + String.valueOf(node.bootstrap);
            }
            if (node.hasLabel() && this.showStructureProviderColouredLines) {
                this.drawLinesAndLabelsForSecondaryStructureProvider(g, node, xstart, xend, ypos, (String)nodeLabel);
            } else if (!((String)nodeLabel).equals("")) {
                g.drawString((String)nodeLabel, xstart + 2, ypos - 2);
            }
            String name = this.getNodeName(this.markPlaceholders, node);
            int charWidth = this.fm.stringWidth(name) + 3;
            int charHeight = this.font.getSize();
            Rectangle rect = new Rectangle(xend + 10, ypos - charHeight / 2, charWidth, charHeight);
            this.nameHash.put(node, rect);
            if (node.hasLabel() && this.showStructureProviderColouredLines) {
                g.setColor(Color.black);
            }
            boolean isSelected = false;
            if (this.tp.isColumnWise()) {
                isSelected = this.isColumnForNodeSelected(node);
            } else {
                SequenceGroup selected = this.av.getSelectionGroup();
                if (selected != null && selected.getSequences(null).contains(node.element()) && (node.getAlignmentAnnotation() == null || selected.getAnnotationsFromTree() == null || selected.getAnnotationsFromTree().isEmpty() || selected.getAnnotationsFromTree().contains(node.getAlignmentAnnotation()))) {
                    isSelected = true;
                }
            }
            if (isSelected) {
                g.setColor(Color.gray);
                g.fillRect(xend + 10, ypos - charHeight / 2, charWidth, charHeight);
                g.setColor(Color.white);
            }
            g.drawString(name, xend + 10, ypos + this.fm.getDescent());
            g.setColor(Color.black);
        } else {
            this.drawNode(g, node.left(), chunk, wscale, width, offx, offy);
            this.drawNode(g, node.right(), chunk, wscale, width, offx, offy);
            double height = node.height;
            double dist = node.dist;
            int xstart = (int)((height - dist) * wscale) + offx;
            int xend = (int)(height * wscale) + offx;
            int ypos = (int)((double)node.ycount * chunk) + offy;
            if (node.hasLabel() && this.showStructureProviderColouredLines) {
                g.setColor(Color.black);
            } else {
                g.setColor(node.color.darker());
                g.drawLine(xstart, ypos, xend, ypos);
            }
            int ystart = (node.left() == null ? 0 : (int)((double)node.left().ycount * chunk)) + offy;
            int yend = (node.right() == null ? 0 : (int)((double)node.right().ycount * chunk)) + offy;
            Rectangle pos = new Rectangle(xend - 2, ypos - 2, 5, 5);
            this.nodeHash.put(node, pos);
            g.drawLine((int)(height * wscale) + offx, ystart, (int)(height * wscale) + offx, yend);
            Object nodeLabel = "";
            if (this.showDistances && node.dist > 0.0) {
                nodeLabel = new Format("%g").form(node.dist);
            }
            if (this.showBootstrap && node.bootstrap > -1) {
                if (this.showDistances) {
                    nodeLabel = (String)nodeLabel + " : ";
                }
                nodeLabel = (String)nodeLabel + String.valueOf(node.bootstrap);
            }
            boolean labelHandled = false;
            if (node.hasLabel()) {
                if (this.showStructureProviderColouredLines) {
                    this.drawLinesAndLabelsForSecondaryStructureProvider(g, node, xstart, xend, ypos, (String)nodeLabel);
                    labelHandled = true;
                }
                if (this.showStructureProviderLabels && node.count > 3 && node.parent() != null && node.left() != null && node.right() != null && node.dist > 0.0) {
                    String label = node.getLabel();
                    if (label.length() > this.labelLengthThreshold) {
                        // empty if block
                    }
                    nodeLabel = label + " | " + (String)nodeLabel;
                    String[] lines = ((String)nodeLabel).split("\\|");
                    String longestLabelString = "";
                    int i = 0;
                    for (i = 0; i < lines.length; ++i) {
                        g.drawString(lines[i].trim(), xstart + 2, ypos - 2 - i * this.fm.getHeight());
                        if (longestLabelString.length() >= lines[i].trim().length()) continue;
                        longestLabelString = lines[i].trim();
                    }
                    labelHandled = true;
                }
            }
            if (!((String)nodeLabel).equals("") && !labelHandled) {
                g.drawString((String)nodeLabel, xstart + 2, ypos - 2);
            }
            if (node == this.highlightNode) {
                g.fillRect(xend - 3, ypos - 3, 6, 6);
            } else {
                g.fillRect(xend - 2, ypos - 2, 4, 4);
            }
        }
    }

    private String getNodeName(boolean isPlaceholder, BinaryNode node) {
        if (isPlaceholder && node instanceof SequenceNode && ((SequenceNode)node).isPlaceholder()) {
            return PLACEHOLDER + node.getDisplayName();
        }
        return node.getDisplayName();
    }

    private void updateGroupBoxDimensions(Graphics g, BinaryNode node, double chunk, double wscale, int offx, int offy, Set<SequenceGroup> currentTreeGroups, HashMap<Integer, ArrayList<Integer>> boxGroupColouringDim) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            SequenceGroup colourGroup = this.findTreeGroupForNode(node);
            if (colourGroup != null) {
                ArrayList<Object> boxDims;
                double height = node.height;
                int xend = (int)(height * wscale) + offx;
                int ypos = (int)((double)node.ycount * chunk) + offy;
                String name = this.getNodeName(this.markPlaceholders, node);
                int charWidth = this.fm.stringWidth(name) + 3;
                int charHeight = this.font.getSize();
                int newBoxMaxY = ypos - charHeight / 2 + charHeight;
                int newBoxMaxX = xend + 10 + charWidth;
                int newBoxMinX = xend + 10;
                int newBoxMinY = ypos - charHeight / 2;
                if (boxGroupColouringDim.get(colourGroup.hashCode()) == null) {
                    boxDims = new ArrayList();
                    for (int i = 0; i < 4; ++i) {
                        boxDims.add(-1);
                    }
                    boxGroupColouringDim.put(colourGroup.hashCode(), boxDims);
                }
                boxDims.set(0, (Integer)(boxDims = boxGroupColouringDim.get(colourGroup.hashCode())).get(0) == -1 ? xend + 1 : Math.min((Integer)boxDims.get(0), newBoxMinX));
                boxDims.set(1, (Integer)boxDims.get(1) == -1 ? newBoxMinY : Math.min((Integer)boxDims.get(1), newBoxMinY));
                boxDims.set(2, (Integer)boxDims.get(2) == -1 ? newBoxMaxX : Math.max((Integer)boxDims.get(2), newBoxMaxX));
                boxDims.set(3, (Integer)boxDims.get(3) == -1 ? newBoxMaxY : Math.max((Integer)boxDims.get(3), newBoxMaxY));
                currentTreeGroups.add(colourGroup);
            }
        } else {
            this.updateGroupBoxDimensions(g, node.left(), chunk, wscale, offx, offy, currentTreeGroups, boxGroupColouringDim);
            this.updateGroupBoxDimensions(g, node.right(), chunk, wscale, offx, offy, currentTreeGroups, boxGroupColouringDim);
        }
    }

    private SequenceGroup findTreeGroupForNode(BinaryNode node) {
        block5: {
            SequenceGroup[] groupsWithSequence;
            if (!(node.element() instanceof SequenceI)) {
                return null;
            }
            SequenceI seq = (SequenceI)node.element();
            SequenceGroup[] sequenceGroupArray = groupsWithSequence = this.ap.getAlignment() != null ? this.ap.getAlignment().findAllGroups(seq) : null;
            if (groupsWithSequence == null || !node.hasLabel()) break block5;
            if (!this.av.getSequenceColour(seq).equals(Color.white) && node.hasAlignmentAnnotation()) {
                for (SequenceGroup group : groupsWithSequence) {
                    if (!group.getAnnotationsFromTree().contains(node.getAlignmentAnnotation()) || !group.getName().startsWith("JTreeGroup:")) continue;
                    return group;
                }
            } else {
                for (SequenceGroup group : groupsWithSequence) {
                    if (!group.getName().startsWith("JTreeGroup:")) continue;
                    return group;
                }
            }
        }
        return null;
    }

    private void drawLinesAndLabelsForSecondaryStructureProvider(Graphics g, BinaryNode node, int xstart, int xend, int ypos, String nodeLabel) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(4.0f, 0, 1));
        String label = node.getLabel();
        Object[] lines = (String[])Arrays.stream(label.split("\\|")).map(String::trim).toArray(String[]::new);
        Arrays.sort(lines);
        int mid = lines.length / 2;
        for (int i = 0; i < mid / 2; ++i) {
            Object temp = lines[i];
            lines[i] = lines[mid - 1 - i];
            lines[mid - 1 - i] = temp;
        }
        int firstHalfLinesCount = mid;
        this.drawSecondaryStructureProviderLinesSection(g2d, (String[])lines, 0, mid, xstart, xend, ypos - 6, true);
        this.drawVerticalLineAndLabel(g, xstart, ypos, firstHalfLinesCount, true, nodeLabel);
        int secondHalfLinesCount = lines.length - mid;
        this.drawSecondaryStructureProviderLinesSection(g2d, (String[])lines, mid, lines.length, xstart, xend, ypos, false);
        this.drawVerticalLineAndLabel(g, xstart, ypos, secondHalfLinesCount, false, nodeLabel);
        g2d.dispose();
    }

    private void drawSecondaryStructureProviderLinesSection(Graphics2D g2d, String[] lines, int start, int end, int xstart, int xend, int baseY, boolean above) {
        int i = start;
        int j = 0;
        while (i < end) {
            boolean colourState;
            int adjustedY = above ? baseY - (i - start) * 6 : baseY + (i - start) * 6;
            Boolean greyOutStateObj = this.structureProviderColouredLineToggleState.get(lines[i].toUpperCase().trim());
            boolean bl = colourState = greyOutStateObj == null || greyOutStateObj == false;
            if (colourState) {
                Map<String, Color> secondaryStructureProviderColorMap = this.tp.getSecondaryStructureProviderColorMap();
                Color providerColor = secondaryStructureProviderColorMap.getOrDefault(lines[i].toUpperCase().trim(), Color.BLACK);
                g2d.setColor(providerColor);
            } else {
                g2d.setColor(new Color(Color.LIGHT_GRAY.getRed(), Color.LIGHT_GRAY.getGreen(), Color.LIGHT_GRAY.getBlue(), 80));
            }
            g2d.drawLine(xstart, adjustedY, xend, adjustedY);
            ++i;
            ++j;
        }
    }

    private void drawVerticalLineAndLabel(Graphics g, int xstart, int ypos, int linesCount, boolean above, String nodeLabel) {
        int adjustment = linesCount * 6 + 2;
        int adjustedY = ypos + (above ? -adjustment : adjustment - 6);
        g.drawLine(xstart, ypos, xstart, adjustedY);
        if (above && !nodeLabel.equals("")) {
            g.drawString(nodeLabel, xstart + 2, adjustedY - 2);
        }
    }

    public Object findElement(int x, int y, boolean node) {
        Rectangle rect;
        for (Map.Entry<BinaryNode, Rectangle> entry : this.nameHash.entrySet()) {
            rect = entry.getValue();
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            if (!node) {
                return entry.getKey().element();
            }
            return entry.getKey();
        }
        for (Map.Entry<BinaryNode, Rectangle> entry : this.nodeHash.entrySet()) {
            rect = entry.getValue();
            if (x < rect.x || x > rect.x + rect.width || y < rect.y || y > rect.y + rect.height) continue;
            return entry.getKey();
        }
        return null;
    }

    public void pickNodes(Rectangle pickBox) {
        int width = this.getWidth();
        int height = this.getHeight();
        BinaryNode top = this.tree.getTopNode();
        double wscale = ((double)width * 0.8 - (double)(this.offx * 2)) / this.tree.getMaxHeight();
        if (top.count == 0) {
            top.count = top.left().count + top.right().count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        this.pickNode(pickBox, top, chunk, wscale, width, this.offx, this.offy);
    }

    public void pickNode(Rectangle pickBox, BinaryNode node, float chunk, double wscale, int width, int offx, int offy) {
        if (node == null) {
            return;
        }
        if (node.left() == null && node.right() == null) {
            double height = node.height;
            int xend = (int)(height * wscale) + offx;
            int ypos = (int)(node.ycount * chunk) + offy;
            if (pickBox.contains(new Point(xend, ypos)) && node.element() instanceof SequenceI) {
                SequenceI seq = (SequenceI)node.element();
                SequenceGroup sg = this.av.getSelectionGroup();
                if (sg != null) {
                    sg.addOrRemove(seq, true);
                }
            }
        } else {
            this.pickNode(pickBox, node.left(), chunk, wscale, width, offx, offy);
            this.pickNode(pickBox, node.right(), chunk, wscale, width, offx, offy);
        }
    }

    public void setColor(BinaryNode node, Color c) {
        if (node == null) {
            return;
        }
        node.color = c;
        if (node.element() instanceof SequenceI) {
            SequenceI seq = (SequenceI)node.element();
            AlignmentAnnotation annotation = node.getAlignmentAnnotation();
            AlignmentPanel[] aps = this.getAssociatedPanels();
            if (aps != null) {
                for (int a = 0; a < aps.length; ++a) {
                    aps[a].av.setSequenceColour(seq, c);
                    if (annotation == null) continue;
                    aps[a].av.setAnnotationColour(annotation, c);
                }
            }
        }
        this.setColor(node.left(), c);
        this.setColor(node.right(), c);
    }

    void startPrinting() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        PageFormat pf;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat defaultPage = printJob.defaultPage();
        if (defaultPage == (pf = printJob.pageDialog(defaultPage))) {
            return;
        }
        printJob.setPrintable(this, pf);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
        pg.setFont(this.font);
        pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int pwidth = (int)pf.getImageableWidth();
        int pheight = (int)pf.getImageableHeight();
        int noPages = this.getHeight() / pheight;
        if (pi > noPages) {
            return 1;
        }
        if (pwidth > this.getWidth()) {
            pwidth = this.getWidth();
        }
        if (this.fitToWindow) {
            if (pheight > this.getHeight()) {
                pheight = this.getHeight();
            }
            noPages = 0;
        } else {
            FontMetrics fm = pg.getFontMetrics(this.font);
            int height = fm.getHeight() * this.nameHash.size();
            pg.translate(0, -pi * pheight);
            pg.setClip(0, pi * pheight, pwidth, pi * pheight + pheight);
            pheight = height;
        }
        this.draw(pg, pwidth, pheight);
        return 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.font);
        if (this.tree == null) {
            g.drawString(MessageManager.getString("label.calculating_tree") + "....", 20, this.getHeight() / 2);
        } else {
            this.fm = g.getFontMetrics(this.font);
            int nameCount = this.nameHash.size();
            if (nameCount == 0) {
                this.repaint();
            }
            if (this.fitToWindow || !this.fitToWindow && this.scrollPane.getHeight() > this.fm.getHeight() * nameCount + this.offy) {
                this.draw(g, this.scrollPane.getWidth(), this.scrollPane.getHeight());
                this.setPreferredSize(null);
            } else {
                this.setPreferredSize(new Dimension(this.scrollPane.getWidth(), this.fm.getHeight() * nameCount));
                this.draw(g, this.scrollPane.getWidth(), this.fm.getHeight() * nameCount);
            }
            this.scrollPane.revalidate();
        }
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void draw(Graphics g1, int width, int height) {
        Graphics2D g2 = (Graphics2D)g1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        g2.setFont(this.font);
        if (this.longestName == null || this.tree == null) {
            g2.drawString("Calculating tree.", 20, 20);
            return;
        }
        this.offy = this.font.getSize() + 10;
        this.fm = g2.getFontMetrics(this.font);
        this.labelLength = this.fm.stringWidth(this.longestName) + 20;
        double wscale = (double)(width - this.labelLength - this.offx * 2) / this.tree.getMaxHeight();
        BinaryNode top = this.tree.getTopNode();
        if (top.count == 0) {
            top.count = top.left().count + top.right().count;
        }
        float chunk = (float)(height - this.offy) / (float)top.count;
        if (this.showStructureProviderColouredLines) {
            this.drawGroupColourBoxes(g2, this.tree.getTopNode(), chunk, wscale, this.offx, this.offy);
        }
        this.drawNode(g2, this.tree.getTopNode(), chunk, wscale, width, this.offx, this.offy);
        if (this.threshold != 0.0f) {
            if (this.av.getCurrentTree() == this.tree) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.gray);
            }
            int x = (int)(this.threshold * (float)(this.getWidth() - this.labelLength - 2 * this.offx) + (float)this.offx);
            g2.drawLine(x, 0, x, this.getHeight());
        }
    }

    private void drawGroupColourBoxes(Graphics g2, BinaryNode node, double chunk, double wscale, int offx, int offy) {
        HashSet<SequenceGroup> currentTreeGroups = new HashSet<SequenceGroup>();
        HashMap<Integer, ArrayList<Integer>> boxGroupColouringDim = new HashMap<Integer, ArrayList<Integer>>();
        this.updateGroupBoxDimensions(g2, this.tree.getTopNode(), chunk, wscale, offx, offy, currentTreeGroups, boxGroupColouringDim);
        Color prevColour = g2.getColor();
        for (SequenceGroup treeGroup : currentTreeGroups) {
            ArrayList<Integer> boxDims = boxGroupColouringDim.get(treeGroup.hashCode());
            if (treeGroup.idColour == null) continue;
            Color treeGroupColor = treeGroup.idColour.brighter();
            g2.setColor(new Color(treeGroupColor.getRed(), treeGroupColor.getGreen(), treeGroupColor.getBlue(), 198));
            int x = boxDims.get(0);
            int y = boxDims.get(1) - 2;
            int width = boxDims.get(2) - boxDims.get(0);
            int height = boxDims.get(3) - boxDims.get(1) + 4;
            g2.fillRect(x, y, width, height);
        }
        g2.setColor(prevColour);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.highlightNode != null) {
                this.chooseSubtreeColour();
            }
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.highlightNode == null) {
            return;
        }
        if (evt.getClickCount() > 1) {
            this.tree.swapNodes(this.highlightNode);
            this.tree.reCount(this.tree.getTopNode());
            this.tree.findHeight(this.tree.getTopNode());
        } else {
            Vector<BinaryNode> leaves = this.tree.findLeaves(this.highlightNode);
            if (this.tp.isColumnWise()) {
                this.markColumnsFor(this.getAssociatedPanels(), leaves, Color.red, false);
            } else {
                for (int i = 0; i < leaves.size(); ++i) {
                    SequenceI seq = (SequenceI)leaves.elementAt(i).element();
                    if (leaves.get(i).hasAlignmentAnnotation()) {
                        this.treeSelectionChanged(seq, leaves.get(i).getAlignmentAnnotation());
                        continue;
                    }
                    this.treeSelectionChanged(seq, null);
                }
            }
            this.av.sendSelection();
        }
        PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
        this.repaint();
    }

    void chooseSubtreeColour() {
        String ttl = MessageManager.getString("label.select_subtree_colour");
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                TreeCanvas.this.setColor(TreeCanvas.this.highlightNode, c);
                PaintRefresher.Refresh(TreeCanvas.this.tp, TreeCanvas.this.ap.av.getSequenceSetId());
                TreeCanvas.this.repaint();
            }
        };
        JalviewColourChooser.showColourChooser(this, ttl, this.highlightNode.color, listener);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.av.setCurrentTree(this.tree);
        Object ob = this.findElement(evt.getX(), evt.getY(), false);
        int mouseX = evt.getX();
        int mouseY = evt.getY();
        if (ob instanceof BinaryNode) {
            this.highlightNode = (BinaryNode)ob;
            this.setToolTipText("<html>" + MessageManager.getString("label.highlightnode"));
            this.repaint();
        } else {
            if (this.highlightNode != null) {
                this.highlightNode = null;
                this.setToolTipText(null);
                this.repaint();
            }
            this.setToolTipText(null);
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ect) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        this.av.setCurrentTree(this.tree);
        if (e.isPopupTrigger()) {
            if (this.highlightNode != null) {
                this.chooseSubtreeColour();
            }
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        int x = e.getX();
        Object ob = this.findElement(x, y = e.getY(), true);
        if (ob instanceof BinaryNode && ((BinaryNode)ob).element() != null) {
            if (((BinaryNode)ob).hasAlignmentAnnotation()) {
                this.treeSelectionChanged((SequenceI)((BinaryNode)ob).element(), ((BinaryNode)ob).getAlignmentAnnotation());
            } else {
                this.treeSelectionChanged((SequenceI)((BinaryNode)ob).element(), null);
            }
            PaintRefresher.Refresh(this.tp, this.getAssociatedPanel().av.getSequenceSetId());
            this.repaint();
            this.av.sendSelection();
            return;
        }
        if (!(ob instanceof BinaryNode)) {
            if (this.tree.getMaxHeight() != 0.0) {
                this.threshold = (float)(x - this.offx) / (float)(this.getWidth() - this.labelLength - 2 * this.offx);
                List<BinaryNode> groups = this.tree.groupNodes(this.threshold);
                this.setColor(this.tree.getTopNode(), Color.black);
                AlignmentPanel[] aps = this.getAssociatedPanels();
                for (int a = 0; a < aps.length; ++a) {
                    aps[a].av.setSelectionGroup(null);
                    aps[a].av.getAlignment().deleteAllGroups();
                    aps[a].av.clearSequenceColours();
                    aps[a].av.clearAnnotationColours();
                    if (aps[a].av.getCodingComplement() != null) {
                        aps[a].av.getCodingComplement().setSelectionGroup(null);
                        aps[a].av.getCodingComplement().getAlignment().deleteAllGroups();
                        aps[a].av.getCodingComplement().clearSequenceColours();
                    }
                    aps[a].av.setUpdateStructures(true);
                }
                this.colourGroups(groups);
                if (groups.isEmpty()) {
                    this.threshold = 0.0f;
                }
            }
            Console.log.debug("Tree cut threshold set at:" + this.threshold);
            PaintRefresher.Refresh(this.tp, this.getAssociatedPanel().av.getSequenceSetId());
            this.repaint();
        }
    }

    void colourGroups(List<BinaryNode> groups) {
        AlignmentAnnotation aa;
        AlignmentPanel[] aps = this.getAssociatedPanels();
        ArrayList<BitSet> colGroups = new ArrayList<BitSet>();
        HashMap<BitSet, Color> colors = new HashMap<BitSet, Color>();
        for (int i = 0; i < groups.size(); ++i) {
            Color col = ColorUtils.getColorForIndex(i);
            this.setColor(groups.get(i), col.brighter());
            Vector<BinaryNode> l = this.tree.findLeaves(groups.get(i));
            if (!this.tp.isColumnWise()) {
                this.createSeqGroupFor(aps, l, col, groups.get(i).getLabel());
                continue;
            }
            BitSet gp = this.createColumnGroupFor(l, col);
            colGroups.add(gp);
            colors.put(gp, col);
        }
        if (this.tp.isColumnWise() && (aa = this.tp.getAssocAnnotation()) != null) {
            ContactMatrixI cm = this.av.getContactMatrix(aa);
            if (cm != null) {
                cm.updateGroups(colGroups);
                for (BitSet gp : colors.keySet()) {
                    cm.setColorForGroup(gp, (Color)colors.get(gp));
                }
            }
            cm.transferGroupColorsTo(aa);
        }
        for (int a = 0; a < aps.length; ++a) {
            aps[a].updateAnnotation();
            AlignViewportI codingComplement = aps[a].av.getCodingComplement();
            if (codingComplement == null) continue;
            ((AlignmentPanel)((AlignViewport)codingComplement).getAlignPanel()).updateAnnotation();
        }
    }

    private void gatherLabelsTo(BinaryNode binaryNode, Vector<BinaryNode> l) {
        LinkedHashSet<String> labelsForNode = new LinkedHashSet<String>();
        for (BinaryNode leaf : l) {
            if (!leaf.hasLabel()) continue;
            labelsForNode.add(leaf.getLabel());
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String label : labelsForNode) {
            if (!first) {
                sb.append(" | ");
            }
            first = false;
            sb.append(label);
        }
        binaryNode.setLabel(sb.toString());
    }

    private int parseColumnNode(BinaryNode bn) throws NumberFormatException {
        return Integer.parseInt(bn.getName().substring(bn.getName().indexOf("c") + 1));
    }

    private boolean isColumnForNodeSelected(BinaryNode bn) {
        SequenceI rseq = this.tp.assocAnnotation.sequenceRef;
        int colm = -1;
        try {
            colm = this.parseColumnNode(bn);
        }
        catch (Exception e) {
            return false;
        }
        if (this.av == null || this.av.getAlignment() == null) {
            return false;
        }
        ColumnSelection cs = this.av.getColumnSelection();
        HiddenColumns hc = this.av.getAlignment().getHiddenColumns();
        AlignmentAnnotation aa = this.tp.getAssocAnnotation();
        int offp = -1;
        if (aa != null) {
            ContactMatrixI cm = this.av.getContactMatrix(aa);
            if (cm instanceof MappableContactMatrixI) {
                MappableContactMatrixI mcm = (MappableContactMatrixI)cm;
                int[] pos = mcm.getMappedPositionsFor(rseq, colm + 1);
                if (pos != null) {
                    offp = rseq.findIndex(pos[0]);
                }
            } else {
                offp = colm;
            }
        }
        if (offp <= 0) {
            return false;
        }
        offp -= 2;
        if (!this.av.hasHiddenColumns()) {
            return cs.contains(offp);
        }
        if (hc.isVisible(offp)) {
            return cs.contains(offp);
        }
        return false;
    }

    private BitSet createColumnGroupFor(Vector<BinaryNode> l, Color col) {
        BitSet gp = new BitSet();
        for (BinaryNode bn : l) {
            int colm = -1;
            if (bn.element() != null && bn.element() instanceof Integer) {
                colm = (Integer)bn.element();
            } else {
                try {
                    colm = this.parseColumnNode(bn);
                }
                catch (Exception e) {
                    continue;
                }
            }
            gp.set(colm);
        }
        return gp;
    }

    private void markColumnsFor(AlignmentPanel[] aps, Vector<BinaryNode> l, Color col, boolean clearSelected) {
        SequenceI rseq = this.tp.assocAnnotation.sequenceRef;
        if (this.av == null || this.av.getAlignment() == null) {
            return;
        }
        ColumnSelection cs = this.av.getColumnSelection();
        HiddenColumns hc = this.av.getAlignment().getHiddenColumns();
        ContactMatrixI cm = this.av.getContactMatrix(this.tp.assocAnnotation);
        MappableContactMatrixI mcm = null;
        if (cm instanceof MappableContactMatrixI) {
            mcm = (MappableContactMatrixI)cm;
        }
        for (BinaryNode bn : l) {
            int offp;
            int colm = -1;
            try {
                colm = Integer.parseInt(bn.getName().substring(bn.getName().indexOf("c") + 1));
            }
            catch (Exception e) {
                continue;
            }
            if (mcm != null) {
                int[] seqpos = mcm.getMappedPositionsFor(rseq, colm);
                if (seqpos == null) continue;
                offp = rseq.findIndex(seqpos[0]) - 1;
            } else {
                int n = offp = rseq != null ? rseq.findIndex(rseq.getStart() + colm) : colm;
            }
            if (this.av.hasHiddenColumns() && !hc.isVisible(offp)) continue;
            if (clearSelected || cs.contains(offp)) {
                cs.removeElement(offp);
                continue;
            }
            cs.addElement(offp);
        }
        PaintRefresher.Refresh(this.tp, this.av.getSequenceSetId());
    }

    public void createSeqGroupFor(AlignmentPanel[] aps, Vector<BinaryNode> l, Color col, String label) {
        Vector<SequenceI> sequences = new Vector<SequenceI>();
        ArrayList<AlignmentAnnotation> annotationInGroup = new ArrayList<AlignmentAnnotation>();
        for (int j = 0; j < l.size(); ++j) {
            SequenceI s1 = (SequenceI)l.elementAt(j).element();
            if (!sequences.contains(s1)) {
                sequences.addElement(s1);
            }
            if (l.elementAt(j).getAlignmentAnnotation() == null || annotationInGroup.contains(l.elementAt(j).getAlignmentAnnotation())) continue;
            annotationInGroup.add(l.elementAt(j).getAlignmentAnnotation());
        }
        ColourSchemeI cs = null;
        SequenceGroup _sg = new SequenceGroup(sequences, null, cs, true, true, false, 0, this.av.getAlignment().getWidth() - 1);
        for (AlignmentAnnotation annot : annotationInGroup) {
            _sg.addAnnotationFromTree(annot);
        }
        if (label != null && !label.isEmpty()) {
            List<SequenceGroup> existingGroups = this.av.getAlignment().getGroups();
            label = AlignmentUtils.reduceLabelLength(label);
            String newGroupName = "JTreeGroup:" + label;
            int noOfGroupsWithSameName = 0;
            for (SequenceGroup sg : existingGroups) {
                if (!sg.getName().equals(newGroupName) && !sg.getName().matches(newGroupName + " \\d+")) continue;
                ++noOfGroupsWithSameName;
                if (!sg.getName().equals(newGroupName)) continue;
                String updatedGroupName = sg.getName() + " " + noOfGroupsWithSameName;
                sg.setName(updatedGroupName);
            }
            if (noOfGroupsWithSameName > 0) {
                newGroupName = newGroupName + " " + ++noOfGroupsWithSameName;
            }
            _sg.setName(newGroupName);
        } else {
            _sg.setName("JTreeGroup:" + _sg.hashCode());
        }
        _sg.setIdColour(col);
        for (int a = 0; a < aps.length; ++a) {
            SequenceGroup sg = new SequenceGroup(_sg);
            AlignViewport viewport = aps[a].av;
            if (viewport.getGlobalColourScheme() != null) {
                cs = viewport.getGlobalColourScheme().getInstance(viewport, sg);
                sg.setColourScheme(cs);
                sg.getGroupColourScheme().setThreshold(viewport.getResidueShading().getThreshold(), viewport.isIgnoreGapsConsensus());
                if (viewport.getResidueShading().conservationApplied()) {
                    Conservation c = new Conservation("Group", sg.getSequences(null), sg.getStartRes(), sg.getEndRes());
                    c.calculate();
                    c.verdict(false, viewport.getConsPercGaps());
                    sg.cs.setConservation(c);
                }
                if (viewport.getResidueShading().isConsensusSecondaryStructureColouring()) {
                    sg.getGroupColourScheme().setConsensusSecondaryStructureThreshold(viewport.getResidueShading().getThreshold());
                    sg.getGroupColourScheme().setConsensusSecondaryStructureColouring(true);
                }
            }
            viewport.setUpdateStructures(true);
            viewport.addSequenceGroup(sg);
        }
    }

    public void setShowDistances(boolean state) {
        this.showDistances = state;
        this.repaint();
    }

    public void hideStructureProviders(boolean state) {
        if (state) {
            this.showStructureProviderColouredLines = false;
            this.showStructureProviderLabels = false;
            this.repaint();
        }
    }

    public void setShowStructureProviderColouredLines(boolean state) {
        this.showStructureProviderColouredLines = state;
        if (state) {
            this.showStructureProviderLabels = false;
        }
        this.repaint();
    }

    public void setShowStructureProviderLabels(boolean state) {
        this.showStructureProviderLabels = state;
        if (state) {
            this.showStructureProviderColouredLines = false;
        }
        this.repaint();
    }

    public void toggleStructureProviderColouredLine(String provider, boolean state) {
        this.structureProviderColouredLineToggleState.put(provider.toUpperCase().trim(), state);
        this.repaint();
    }

    public void setShowBootstrap(boolean state) {
        this.showBootstrap = state;
        this.repaint();
    }

    public void setMarkPlaceholders(boolean state) {
        this.markPlaceholders = state;
        this.repaint();
    }

    AlignmentPanel[] getAssociatedPanels() {
        if (this.applyToAllViews) {
            return PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        }
        return new AlignmentPanel[]{this.getAssociatedPanel()};
    }

    public AlignmentPanel getAssociatedPanel() {
        return this.ap;
    }

    public void setAssociatedPanel(AlignmentPanel ap) {
        this.ap = ap;
    }

    public AlignViewport getViewport() {
        return this.av;
    }

    public void setViewport(AlignViewport av) {
        this.av = av;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public boolean isApplyToAllViews() {
        return this.applyToAllViews;
    }

    public void setApplyToAllViews(boolean applyToAllViews) {
        this.applyToAllViews = applyToAllViews;
    }
}

