/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.gui.AlignmentPanel;
import jalview.gui.OverviewCanvas;
import jalview.gui.ProgressPanel;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.OverviewDimensions;
import jalview.viewmodel.OverviewDimensionsHideHidden;
import jalview.viewmodel.OverviewDimensionsShowHidden;
import jalview.viewmodel.ViewportListenerI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class OverviewPanel
extends JPanel
implements Runnable,
ViewportListenerI {
    protected OverviewDimensions od;
    private OverviewCanvas oviewCanvas;
    private AlignViewportI av;
    private AlignmentPanel ap;
    private JInternalFrame internalFrame;
    protected JCheckBoxMenuItem displayToggle;
    protected boolean showHidden = true;
    protected boolean draggingBox = false;
    private Dimension dim;
    private boolean showProgress = !Platform.isJS();
    protected ProgressPanel progressPanel;

    private void createOverviewDimensions() {
        boolean showAnnotation = this.av.isShowAnnotation() && this.av.getAlignmentConservationAnnotation() != null;
        this.od = this.showHidden ? new OverviewDimensionsShowHidden(this.av.getRanges(), showAnnotation, this.dim) : new OverviewDimensionsHideHidden(this.av.getRanges(), showAnnotation, this.dim);
    }

    public OverviewPanel(AlignmentPanel alPanel, Dimension dim, boolean isShowHidden) {
        this.av = alPanel.av;
        this.ap = alPanel;
        this.dim = dim;
        this.showHidden = isShowHidden;
        this.createOverviewDimensions();
        this.setLayout(new BorderLayout());
        this.progressPanel = new ProgressPanel("OverviewUpdate", MessageManager.getString("label.oview_calc"), this.getWidth());
        this.add((Component)this.progressPanel, "South");
        this.oviewCanvas = new OverviewCanvas(this.od, this.av, this.progressPanel);
        this.add((Component)this.oviewCanvas, "Center");
        this.av.getRanges().addPropertyChangeListener(this);
        this.setPreferredSize(new Dimension(this.od.getWidth(), this.od.getHeight()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (OverviewPanel.this.getWidth() == OverviewPanel.this.od.getWidth() && OverviewPanel.this.getHeight() == OverviewPanel.this.od.getHeight() + OverviewPanel.this.progressPanel.getHeight()) {
                    OverviewPanel.this.updateOverviewImage();
                } else {
                    if (OverviewPanel.this.getWidth() > 0 && OverviewPanel.this.getHeight() > 0) {
                        OverviewPanel.this.od.setWidth(OverviewPanel.this.getWidth());
                        OverviewPanel.this.od.setHeight(OverviewPanel.this.getHeight() - OverviewPanel.this.progressPanel.getHeight());
                    }
                    OverviewPanel.this.setPreferredSize(new Dimension(OverviewPanel.this.od.getWidth(), OverviewPanel.this.od.getHeight() + OverviewPanel.this.progressPanel.getHeight()));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (!SwingUtilities.isRightMouseButton(evt)) {
                    if (OverviewPanel.this.draggingBox) {
                        OverviewPanel.this.od.adjustViewportFromMouse(evt.getX(), evt.getY(), OverviewPanel.this.av.getAlignment().getHiddenSequences(), OverviewPanel.this.av.getAlignment().getHiddenColumns());
                    } else {
                        OverviewPanel.this.od.updateViewportFromMouse(evt.getX(), evt.getY(), OverviewPanel.this.av.getAlignment().getHiddenSequences(), OverviewPanel.this.av.getAlignment().getHiddenColumns());
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                if (OverviewPanel.this.od.isPositionInBox(evt.getX(), evt.getY())) {
                    OverviewPanel.this.getParent().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    OverviewPanel.this.getParent().setCursor(Cursor.getPredefinedCursor(1));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (Platform.isWinRightButton(evt)) {
                    OverviewPanel.this.showPopupMenu(evt);
                    return;
                }
                if (SwingUtilities.isRightMouseButton(evt)) {
                    return;
                }
                if (!OverviewPanel.this.od.isPositionInBox(evt.getX(), evt.getY())) {
                    OverviewPanel.this.draggingBox = false;
                    OverviewPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                    OverviewPanel.this.od.updateViewportFromMouse(evt.getX(), evt.getY(), OverviewPanel.this.av.getAlignment().getHiddenSequences(), OverviewPanel.this.av.getAlignment().getHiddenColumns());
                    OverviewPanel.this.getParent().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    OverviewPanel.this.draggingBox = true;
                    OverviewPanel.this.od.setDragPoint(evt.getX(), evt.getY(), OverviewPanel.this.av.getAlignment().getHiddenSequences(), OverviewPanel.this.av.getAlignment().getHiddenColumns());
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    OverviewPanel.this.showPopupMenu(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.draggingBox = false;
            }
        });
        if (Platform.isJS()) {
            this.updateOverviewImage();
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OverviewPanel.this.toggleHiddenColumns();
                OverviewPanel.this.displayToggle.setSelected(OverviewPanel.this.showHidden);
            }
        };
        this.displayToggle = new JCheckBoxMenuItem(MessageManager.getString("label.togglehidden"));
        this.displayToggle.setEnabled(true);
        this.displayToggle.setSelected(this.showHidden);
        popup.add(this.displayToggle);
        this.displayToggle.addActionListener(menuListener);
        popup.show(this, e.getX(), e.getY());
    }

    protected void toggleHiddenColumns() {
        this.showHidden = !this.showHidden;
        this.createOverviewDimensions();
        this.oviewCanvas.resetOviewDims(this.od);
        this.updateOverviewImage();
        this.setBoxPosition();
    }

    public void updateOverviewImage() {
        if (this.oviewCanvas == null) {
            return;
        }
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.od.setWidth(this.getWidth());
            this.od.setHeight(this.getHeight() - this.progressPanel.getHeight());
        }
        this.setPreferredSize(new Dimension(this.od.getWidth(), this.od.getHeight() + this.progressPanel.getHeight()));
        if (this.oviewCanvas.restartDraw()) {
            return;
        }
        Thread thread = new Thread(this);
        thread.start();
        this.repaint();
    }

    @Override
    public void run() {
        if (this.oviewCanvas != null) {
            this.oviewCanvas.draw(this.av.isShowSequenceFeatures(), this.av.isShowAnnotation() && this.av.getAlignmentConservationAnnotation() != null, this.ap.getSeqPanel().seqCanvas.getFeatureRenderer());
            this.setBoxPosition();
        }
    }

    private void setBoxPositionOnly() {
        if (this.od != null) {
            int oldX = this.od.getBoxX();
            int oldY = this.od.getBoxY();
            int oldWidth = this.od.getBoxWidth();
            int oldHeight = this.od.getBoxHeight();
            this.od.setBoxPosition(this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
            this.repaint(oldX - 1, oldY - 1, oldWidth + 2, oldHeight + 2);
            this.repaint(this.od.getBoxX(), this.od.getBoxY(), this.od.getBoxWidth(), this.od.getBoxHeight());
        }
    }

    private void setBoxPosition() {
        if (this.od != null) {
            this.od.setBoxPosition(this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setBoxPositionOnly();
    }

    protected void dispose() {
        try {
            if (this.av != null) {
                this.av.getRanges().removePropertyChangeListener(this);
            }
            this.oviewCanvas.dispose();
            ((JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this)).setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            this.progressPanel = null;
            this.av = null;
            this.oviewCanvas = null;
            this.ap = null;
            this.od = null;
            this.internalFrame = null;
        }
    }

    public boolean isShowHiddenRegions() {
        return this.showHidden;
    }

    public OverviewCanvas getCanvas() {
        return this.oviewCanvas;
    }

    public void setTitle(String title) {
        this.internalFrame.setTitle(title);
    }

    public String getTitle() {
        return this.internalFrame.getTitle();
    }

    public void setFrameBounds(int xpos, int ypos, int width, int height) {
        this.internalFrame.setBounds(xpos, ypos, width, height);
    }

    public Rectangle getFrameBounds() {
        return this.internalFrame.getBounds();
    }

    public void close() {
        this.internalFrame.dispose();
    }

    public void setInternalFrame(JInternalFrame frame) {
        this.internalFrame = frame;
    }
}

