/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.util.ChannelProperties;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.dialogrunner.DialogRunnerI;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class JvOptionPane
extends JOptionPane
implements DialogRunnerI,
PropertyChangeListener {
    private static final long serialVersionUID = -3019167117756785229L;
    private static Object mockResponse = 2;
    private static boolean interactiveMode = true;
    public static final Runnable NULLCALLABLE = () -> {};
    private Component parentComponent;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private JDialog dialog = null;
    private Map<Object, Runnable> callbacks = new HashMap<Object, Runnable>();
    private int timeout = -1;
    List<Object> ourOptions;
    private static final long defaultTimeout = 500L;

    public void setTimeout(int i) {
        this.timeout = i;
    }

    public JvOptionPane(Component parent) {
        this.parentComponent = Platform.isJS() ? this : parent;
        this.setIcon(null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showConfirmDialog(parentComponent, message) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, icon) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalConfirmDialog(parentComponent, message) : (Integer)JvOptionPane.getMockResponse();
    }

    public static int showInternalConfirmDialog(Component parentComponent, String message, String title, int optionType) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        switch (optionType) {
            default: 
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, icon);
    }

    public static int showOptionDialog(Component parentComponent, String message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
    }

    public static void showMessageDialog(Component parentComponent, String message) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message);
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, JvOptionPane.getPrefix(messageType) + message, title, messageType);
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType, Icon icon) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message) {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message);
    }

    public static void showInternalMessageDialog(Component parentComponent, String message, String title, int messageType) {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, JvOptionPane.getPrefix(messageType) + message, title, messageType);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        if (!JvOptionPane.isInteractiveMode()) {
            JvOptionPane.outputMessage(message);
            return;
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon);
    }

    public static String showInputDialog(Object message) throws HeadlessException {
        if (!JvOptionPane.isInteractiveMode()) {
            return JvOptionPane.getMockResponse().toString();
        }
        return JOptionPane.showInputDialog(message);
    }

    public static String showInputDialog(String message, String initialSelectionValue) {
        if (!JvOptionPane.isInteractiveMode()) {
            return JvOptionPane.getMockResponse().toString();
        }
        return JOptionPane.showInputDialog(message, (Object)initialSelectionValue);
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        if (!JvOptionPane.isInteractiveMode()) {
            return JvOptionPane.getMockResponse().toString();
        }
        return JOptionPane.showInputDialog(message, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, String message) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, (Object)message) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInputDialog(Component parentComponent, String message, String initialSelectionValue) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInputDialog(Component parentComponent, String message, String title, int messageType) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, title, messageType) : JvOptionPane.getMockResponse().toString();
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInternalInputDialog(Component parentComponent, String message) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalInputDialog(parentComponent, message) : JvOptionPane.getMockResponse().toString();
    }

    public static String showInternalInputDialog(Component parentComponent, String message, String title, int messageType) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalInputDialog(parentComponent, JvOptionPane.getPrefix(messageType) + message, title, messageType) : JvOptionPane.getMockResponse().toString();
    }

    public static Object showInternalInputDialog(Component parentComponent, String message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        return JvOptionPane.isInteractiveMode() ? JOptionPane.showInternalInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue) : JvOptionPane.getMockResponse().toString();
    }

    private static void outputMessage(Object message) {
        Console.outPrintln(">>> JOption Message : " + message.toString());
    }

    public static Object getMockResponse() {
        return mockResponse;
    }

    public static void setMockResponse(Object mockOption) {
        mockResponse = mockOption;
    }

    public static void resetMock() {
        JvOptionPane.setMockResponse(2);
        JvOptionPane.setInteractiveMode(true);
    }

    public static boolean isInteractiveMode() {
        return interactiveMode;
    }

    public static void setInteractiveMode(boolean interactive) {
        interactiveMode = interactive;
    }

    private static String getPrefix(int messageType) {
        String prefix = "";
        if (Platform.isJS()) {
            switch (messageType) {
                case 2: {
                    prefix = "WARNING! ";
                    break;
                }
                case 0: {
                    prefix = "ERROR! ";
                    break;
                }
                default: {
                    prefix = "Note: ";
                }
            }
        }
        return prefix;
    }

    public static JvOptionPane newOptionDialog() {
        return new JvOptionPane(null);
    }

    public static JvOptionPane newOptionDialog(Component parentComponent) {
        return new JvOptionPane(parentComponent);
    }

    public void showDialog(String message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        this.showDialog(message, title, optionType, messageType, icon, options, initialValue, true);
    }

    public void showDialog(Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean modal) {
        this.showDialog(message, title, optionType, messageType, icon, options, initialValue, modal, null);
    }

    public void showDialog(Object message, String title, final int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean modal, JButton[] buttons) {
        if (!JvOptionPane.isInteractiveMode()) {
            this.handleResponse(JvOptionPane.getMockResponse());
            return;
        }
        this.ourOptions = Arrays.asList(options);
        if (modal) {
            boolean useButtons = false;
            Object initialValueButton = null;
            if (buttons != null) {
                if (buttons.length != options.length) {
                    Console.error("Supplied buttons array not the same length as supplied options array.");
                } else {
                    Thread timeoutThreadF;
                    Thread timeoutThread = null;
                    for (int i = 0; i < options.length; ++i) {
                        Object o = options[i];
                        JButton jb = buttons[i];
                        if (!o.equals(initialValue)) continue;
                        if (this.timeout > 0 && jb != null && jb instanceof JButton) {
                            timeoutThread = new Thread(() -> {
                                try {
                                    Thread.sleep(this.timeout);
                                }
                                catch (InterruptedException e) {
                                    Console.trace("Dialog timeout interrupted.  Probably a button pressed.");
                                }
                                jb.doClick();
                            });
                        }
                        initialValueButton = jb;
                        break;
                    }
                    if ((timeoutThreadF = timeoutThread) != null) {
                        timeoutThreadF.start();
                    }
                    int[] buttonActions = new int[]{0, 1, 2};
                    for (int i = 0; i < options.length; ++i) {
                        Object o = options[i];
                        Console.trace("Setting button " + i + " to '" + o.toString() + "'");
                        JButton jb = buttons[i];
                        final int buttonAction = buttonActions[i];
                        final Runnable action = this.callbacks.get(buttonAction);
                        jb.setText((String)o);
                        jb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                boolean raiseParent;
                                Object obj;
                                if (timeoutThreadF != null) {
                                    timeoutThreadF.interrupt();
                                }
                                if ((obj = e.getSource()) == null || !(obj instanceof Component)) {
                                    Console.warn("Could not find Component source of event object " + obj);
                                    return;
                                }
                                Container joptionpaneObject = SwingUtilities.getAncestorOfClass(JOptionPane.class, (Component)obj);
                                if (joptionpaneObject == null || !(joptionpaneObject instanceof JOptionPane)) {
                                    Console.warn("Could not find JOptionPane ancestor of event object " + obj);
                                    return;
                                }
                                JOptionPane joptionpane = (JOptionPane)joptionpaneObject;
                                joptionpane.setValue(buttonAction);
                                if (action != null) {
                                    new Thread(action).start();
                                }
                                joptionpane.transferFocusBackward();
                                joptionpane.setVisible(false);
                                boolean bl = raiseParent = JvOptionPane.this.parentComponent != null;
                                if (buttonAction == 2) {
                                    raiseParent = false;
                                }
                                if (optionType == 0 && buttonAction == 1) {
                                    raiseParent = false;
                                }
                                if (raiseParent) {
                                    JvOptionPane.this.parentComponent.requestFocus();
                                    if (JvOptionPane.this.parentComponent instanceof JInternalFrame) {
                                        JInternalFrame jif = (JInternalFrame)JvOptionPane.this.parentComponent;
                                        jif.show();
                                        jif.moveToFront();
                                        jif.grabFocus();
                                    } else if (JvOptionPane.this.parentComponent instanceof Window) {
                                        Window w = (Window)JvOptionPane.this.parentComponent;
                                        w.toFront();
                                        w.requestFocus();
                                    }
                                }
                                joptionpane.setVisible(false);
                            }
                        });
                    }
                    useButtons = true;
                }
            }
            int response = JOptionPane.showOptionDialog(this.parentComponent, message, title, optionType, messageType, icon, useButtons ? buttons : options, useButtons ? initialValueButton : initialValue);
            if (!Platform.isJS()) {
                Console.debug("Handling response for " + response);
                this.handleResponse(response);
            }
        } else {
            final JOptionPane joptionpane = new JOptionPane();
            int[] buttonActions = new int[]{0, 1, 2};
            if (options == null) {
                ArrayList<String> options_default = new ArrayList<String>();
                options_default.add(UIManager.getString("OptionPane.yesButtonText"));
                if (optionType == 0 || optionType == 1) {
                    options_default.add(UIManager.getString("OptionPane.noButtonText"));
                }
                if (optionType == 1) {
                    options_default.add(UIManager.getString("OptionPane.cancelButtonText"));
                }
                options = options_default.toArray();
            }
            ArrayList<JButton> options_btns = new ArrayList<JButton>();
            JButton initialValue_btn = null;
            if (!Platform.isJS()) {
                for (int i = 0; i < options.length && i < 3; ++i) {
                    Object o = options[i];
                    final int buttonAction = buttonActions[i];
                    final Runnable action = this.callbacks.get(buttonAction);
                    JButton jb = new JButton();
                    jb.setText((String)o);
                    jb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean raiseParent;
                            joptionpane.setValue(buttonAction);
                            if (action != null) {
                                new Thread(action).start();
                            }
                            joptionpane.transferFocusBackward();
                            joptionpane.setVisible(false);
                            boolean bl = raiseParent = JvOptionPane.this.parentComponent != null;
                            if (buttonAction == 2) {
                                raiseParent = false;
                            }
                            if (optionType == 0 && buttonAction == 1) {
                                raiseParent = false;
                            }
                            if (raiseParent) {
                                JvOptionPane.this.parentComponent.requestFocus();
                                if (JvOptionPane.this.parentComponent instanceof JInternalFrame) {
                                    JInternalFrame jif = (JInternalFrame)JvOptionPane.this.parentComponent;
                                    jif.show();
                                    jif.moveToFront();
                                    jif.grabFocus();
                                } else if (JvOptionPane.this.parentComponent instanceof Window) {
                                    Window w = (Window)JvOptionPane.this.parentComponent;
                                    w.toFront();
                                    w.requestFocus();
                                }
                            }
                            joptionpane.setVisible(false);
                        }
                    });
                    options_btns.add(jb);
                    if (!o.equals(initialValue)) continue;
                    initialValue_btn = jb;
                }
            }
            joptionpane.setMessage(message);
            joptionpane.setMessageType(messageType);
            joptionpane.setOptionType(optionType);
            joptionpane.setIcon(icon);
            joptionpane.setOptions(Platform.isJS() ? options : options_btns.toArray());
            joptionpane.setInitialValue(Platform.isJS() ? initialValue : initialValue_btn);
            JDialog dialog = joptionpane.createDialog(this.parentComponent, title);
            dialog.setIconImages(ChannelProperties.getIconList());
            dialog.setModalityType(modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
            this.setDialog(dialog);
        }
    }

    public void showInternalDialog(Object mainPanel, String title, int yesNoCancelOption, int questionMessage, Icon icon, Object[] options, String initresponse) {
        if (!JvOptionPane.isInteractiveMode()) {
            this.handleResponse(JvOptionPane.getMockResponse());
        }
        this.setOptionType(yesNoCancelOption);
        this.setMessageType(questionMessage);
        this.setIcon(icon);
        this.setInitialValue(initresponse);
        this.setOptions(options);
        this.setMessage(mainPanel);
        this.ourOptions = Arrays.asList(options);
        if (this.parentComponent != this && (this.parentComponent != null || Desktop.getInstance() != null)) {
            JInternalFrame jif = this.createInternalFrame(this.parentComponent != null ? this.parentComponent : Desktop.getInstance(), title);
            if (this.parentComponent instanceof AlignFrame) {
                Desktop.addModal((AlignFrame)this.parentComponent, jif);
            }
            jif.setFrameIcon(null);
            jif.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameActivated(InternalFrameEvent arg0) {
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent arg0) {
                    JvOptionPane.this.internalDialogHandleResponse();
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent arg0) {
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent arg0) {
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent arg0) {
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent arg0) {
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent arg0) {
                }
            });
            jif.setVisible(true);
            JvOptionPane.startModal(jif);
            return;
        }
        JDialog dialog = this.createDialog(this.parentComponent, title);
        dialog.setIconImages(ChannelProperties.getIconList());
        dialog.setVisible(true);
        this.internalDialogHandleResponse();
    }

    private void internalDialogHandleResponse() {
        Object value = this.getValue();
        if (value == null || value instanceof Integer && (Integer)value == -1) {
            return;
        }
        String responseString = value.toString();
        int response = this.ourOptions.indexOf(responseString);
        if (!Platform.isJS()) {
            this.handleResponse(response);
        }
    }

    @Override
    public JvOptionPane setResponseHandler(Object response, Runnable action) {
        if (action == null) {
            action = NULLCALLABLE;
        }
        this.callbacks.put(response, action);
        return this;
    }

    public void setDialog(JDialog d) {
        this.dialog = d;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public static int showDialogOnTop(String label, String actionString, int JOPTIONPANE_OPTION, int JOPTIONPANE_MESSAGETYPE) {
        return JvOptionPane.showDialogOnTop(null, label, actionString, JOPTIONPANE_OPTION, JOPTIONPANE_MESSAGETYPE);
    }

    public static int showDialogOnTop(Component dialogParentComponent, String label, String actionString, int JOPTIONPANE_OPTION, int JOPTIONPANE_MESSAGETYPE) {
        if (!JvOptionPane.isInteractiveMode()) {
            return (Integer)JvOptionPane.getMockResponse();
        }
        JFrame dialogParent = new JFrame();
        if (dialogParentComponent == null) {
            dialogParent.setIconImages(ChannelProperties.getIconList());
            dialogParent.setAlwaysOnTop(true);
        }
        int answer = JOptionPane.showConfirmDialog(dialogParentComponent == null ? dialogParent : dialogParentComponent, label, actionString, JOPTIONPANE_OPTION, JOPTIONPANE_MESSAGETYPE);
        if (dialogParentComponent == null) {
            dialogParent.setAlwaysOnTop(false);
            dialogParent.dispose();
        }
        return answer;
    }

    public void showDialogOnTopAsync(String label, String actionString, int JOPTIONPANE_OPTION, int JOPTIONPANE_MESSAGETYPE, Icon icon, Object[] options, Object initialValue, boolean modal) {
        JFrame frame = new JFrame();
        frame.setIconImages(ChannelProperties.getIconList());
        this.showDialogOnTopAsync(frame, label, actionString, JOPTIONPANE_OPTION, JOPTIONPANE_MESSAGETYPE, icon, options, initialValue, modal);
    }

    public void showDialogOnTopAsync(JFrame dialogParent, Object label, String actionString, int JOPTIONPANE_OPTION, int JOPTIONPANE_MESSAGETYPE, Icon icon, Object[] options, Object initialValue, boolean modal) {
        this.showDialogOnTopAsync(dialogParent, label, actionString, JOPTIONPANE_OPTION, JOPTIONPANE_MESSAGETYPE, icon, options, initialValue, modal, null);
    }

    public void showDialogOnTopAsync(JFrame dialogParent, Object label, String actionString, int JOPTIONPANE_OPTION, int JOPTIONPANE_MESSAGETYPE, Icon icon, Object[] options, Object initialValue, boolean modal, JButton[] buttons) {
        this.showDialogOnTopAsync(dialogParent, label, actionString, JOPTIONPANE_OPTION, JOPTIONPANE_MESSAGETYPE, icon, options, initialValue, modal, buttons, true);
    }

    public void showDialogOnTopAsync(JFrame dialogParent, Object label, String actionString, int JOPTIONPANE_OPTION, int JOPTIONPANE_MESSAGETYPE, Icon icon, Object[] options, Object initialValue, boolean modal, JButton[] buttons, boolean dispose) {
        if (!JvOptionPane.isInteractiveMode()) {
            this.handleResponse(JvOptionPane.getMockResponse());
            return;
        }
        boolean parentOnTop = dialogParent.isAlwaysOnTop();
        dialogParent.setAlwaysOnTop(true);
        this.parentComponent = dialogParent;
        this.showDialog(label, actionString, JOPTIONPANE_OPTION, JOPTIONPANE_MESSAGETYPE, icon, options, initialValue, modal, buttons);
        dialogParent.setAlwaysOnTop(parentOnTop);
        if (dispose) {
            dialogParent.setAlwaysOnTop(false);
            dialogParent.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        int ourOption = this.ourOptions.indexOf(newValue);
        if (ourOption >= 0) {
            this.handleResponse(ourOption);
        } else {
            this.handleResponse(newValue);
        }
    }

    @Override
    public void handleResponse(Object response) {
        if (response != null && !response.equals(response)) {
            return;
        }
        Runnable action = this.callbacks.get(response);
        if (action != null) {
            try {
                this.executor.submit(action);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.parentComponent != null) {
                this.parentComponent.requestFocus();
            }
        }
    }

    public JDialog createDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean modal) {
        return this.createDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue, modal, null);
    }

    public JDialog createDialog(final Component parentComponent, Object message, String title, final int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean modal, JButton[] buttons) {
        if (!JvOptionPane.isInteractiveMode()) {
            this.handleResponse(JvOptionPane.getMockResponse());
            return null;
        }
        JButton[] optionsButtons = null;
        JButton initialValueButton = null;
        final JOptionPane joptionpane = new JOptionPane();
        int[] buttonActions = new int[]{0, 1, 2};
        if (options == null) {
            ArrayList<String> options_default = new ArrayList<String>();
            options_default.add(UIManager.getString("OptionPane.yesButtonText"));
            if (optionType == 0 || optionType == 1) {
                options_default.add(UIManager.getString("OptionPane.noButtonText"));
            }
            if (optionType == 1) {
                options_default.add(UIManager.getString("OptionPane.cancelButtonText"));
            }
            options = options_default.toArray();
        }
        if (!Platform.isJS()) {
            if ((optionType == 0 || optionType == 1 || optionType == 2 || optionType == 0 || optionType == -1) && options.length < 1 || (optionType == 0 || optionType == 2) && options.length < 2 || optionType == 1 && options.length < 3) {
                Console.warn("JvOptionPane: not enough options for dialog type");
            }
            optionsButtons = new JButton[options.length];
            for (int i = 0; i < options.length && i < 3; ++i) {
                Object o = options[i];
                final int buttonAction = buttonActions[i];
                final Runnable action = this.callbacks.get(buttonAction);
                JButton jb = buttons != null && buttons.length > i && buttons[i] != null ? buttons[i] : new JButton();
                jb.setText((String)o);
                jb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean raiseParent;
                        joptionpane.setValue(buttonAction);
                        if (action != null) {
                            new Thread(action).start();
                        }
                        joptionpane.transferFocusBackward();
                        joptionpane.setVisible(false);
                        boolean bl = raiseParent = parentComponent != null;
                        if (buttonAction == 2) {
                            raiseParent = false;
                        }
                        if (optionType == 0 && buttonAction == 1) {
                            raiseParent = false;
                        }
                        if (raiseParent) {
                            parentComponent.requestFocus();
                            if (parentComponent instanceof JInternalFrame) {
                                JInternalFrame jif = (JInternalFrame)parentComponent;
                                jif.show();
                                jif.moveToFront();
                                jif.grabFocus();
                            } else if (parentComponent instanceof Window) {
                                Window w = (Window)parentComponent;
                                w.toFront();
                                w.requestFocus();
                            }
                        }
                        joptionpane.setVisible(false);
                    }
                });
                optionsButtons[i] = jb;
                if (!o.equals(initialValue)) continue;
                initialValueButton = jb;
            }
        }
        joptionpane.setMessage(message);
        joptionpane.setMessageType(messageType);
        joptionpane.setOptionType(optionType);
        joptionpane.setIcon(icon);
        joptionpane.setOptions(Platform.isJS() ? options : optionsButtons);
        joptionpane.setInitialValue(Platform.isJS() ? initialValue : initialValueButton);
        JDialog dialog = joptionpane.createDialog(parentComponent, title);
        dialog.setIconImages(ChannelProperties.getIconList());
        dialog.setModalityType(modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        dialog.setDefaultCloseOperation(2);
        this.setDialog(dialog);
        return dialog;
    }

    public static boolean clickButton(JFrame frame, int buttonType) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startModal(JInternalFrame f) {
        JPanel modalInterceptor = new JPanel();
        modalInterceptor.setOpaque(false);
        JLayeredPane lp = JLayeredPane.getLayeredPaneAbove(f);
        lp.setLayer(modalInterceptor, JLayeredPane.MODAL_LAYER);
        modalInterceptor.setBounds(0, 0, lp.getWidth(), lp.getHeight());
        modalInterceptor.addMouseListener(new MouseAdapter(){});
        modalInterceptor.addMouseMotionListener(new MouseMotionAdapter(){});
        lp.add(modalInterceptor);
        f.toFront();
        JMenuBar menubar = null;
        if (Platform.isLinux()) {
            JRootPane rootpane = Desktop.getInstance().getRootPane();
            menubar = rootpane.getJMenuBar();
        }
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            if (menubar != null) {
                JvOptionPane.setMenusEnabled(menubar, false);
            }
            while (!f.isClosed()) {
                if (EventQueue.isDispatchThread()) {
                    AWTEvent ev = queue.getNextEvent();
                    if (ev instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)ev)).dispatch();
                        continue;
                    }
                    if (ev instanceof KeyEvent && ((KeyEvent)ev).isControlDown() && menubar != null) {
                        JvOptionPane.setMenusEnabled(menubar, true);
                        ((Component)ev.getSource()).dispatchEvent(ev);
                        JvOptionPane.setMenusEnabled(menubar, false);
                        continue;
                    }
                    if (ev.getSource() instanceof MenuComponent) {
                        ((MenuComponent)ev.getSource()).dispatchEvent(ev);
                        continue;
                    }
                    if (!(ev.getSource() instanceof Component)) continue;
                    ((Component)ev.getSource()).dispatchEvent(ev);
                    continue;
                }
                Thread.yield();
            }
        }
        catch (InterruptedException parent) {
        }
        finally {
            if (menubar != null) {
                JvOptionPane.setMenusEnabled(menubar, true);
            }
            lp.remove(modalInterceptor);
            f.setVisible(false);
            try {
                f.setClosed(true);
            }
            catch (PropertyVetoException e) {
                f.doDefaultCloseAction();
            }
            Container parent = f.getParent();
            if (parent != null) {
                parent.remove(f);
            }
        }
    }

    public static JvOptionPane frameDialog(Object message, String title, int messageType, String[] buttonsTextS, String defaultButtonS, List<Runnable> handlers, boolean modal) {
        String defaultButton;
        String[] buttonsText;
        JFrame parent = new JFrame();
        JvOptionPane jvop = JvOptionPane.newOptionDialog();
        if (buttonsTextS == null) {
            String ok = MessageManager.getString("action.ok");
            buttonsText = new String[]{ok};
            defaultButton = ok;
        } else {
            buttonsText = buttonsTextS;
            defaultButton = defaultButtonS;
        }
        JButton[] buttons = new JButton[buttonsText.length];
        for (int i = 0; i < buttonsText.length; ++i) {
            buttons[i] = new JButton();
            buttons[i].setText(buttonsText[i]);
            Console.trace("DISABLING BUTTON " + buttons[i].getText());
            buttons[i].setEnabled(false);
            buttons[i].setVisible(false);
        }
        int dialogType = -1;
        dialogType = buttonsText.length == 1 ? 0 : (buttonsText.length == 2 ? 0 : 1);
        jvop.setResponseHandler(0, handlers != null && handlers.size() > 0 ? handlers.get(0) : NULLCALLABLE);
        if (dialogType == 0 || dialogType == 1) {
            jvop.setResponseHandler(1, handlers != null && handlers.size() > 1 ? handlers.get(1) : NULLCALLABLE);
        }
        if (dialogType == 1) {
            jvop.setResponseHandler(2, handlers != null && handlers.size() > 2 ? handlers.get(2) : NULLCALLABLE);
        }
        int dt = dialogType;
        new Thread(() -> jvop.showDialog(message, title, dt, messageType, null, buttonsText, defaultButton, modal, buttons)).start();
        return jvop;
    }

    private static void setMenusEnabled(JMenuBar menubar, boolean b) {
        for (int i = 0; i < menubar.getMenuCount(); ++i) {
            JMenu menu = menubar.getMenu(i);
            menu.setEnabled(b);
        }
    }

    public boolean waitForHandlerToFinish() {
        return this.waitForHandlerToFinish(500L);
    }

    public boolean waitForHandlerToFinish(long timeout) {
        if (this.executor != null) {
            try {
                return this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Console.trace("Action was interrupted", e);
            }
        }
        return true;
    }
}

