/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.AnnotationSorter;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureColourI;
import jalview.api.FeatureSettingsModelI;
import jalview.api.FeaturesDisplayedI;
import jalview.api.ViewStyleI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.commands.CommandI;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationColumnChooser;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.SplitFrame;
import jalview.gui.UserDefinedColours;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.IdentifyFile;
import jalview.renderer.ResidueShader;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.UserColourScheme;
import jalview.structure.SelectionSource;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasSource;
import jalview.util.ColorUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.AutoCalcSetting;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class AlignViewport
extends AlignmentViewport<AlignmentPanel>
implements SelectionSource {
    public static final int NO_SPLIT = 0;
    public static final int SPLIT_FRAME = 1;
    public static final int NEW_WINDOW = 2;
    Font font;
    boolean cursorMode = false;
    boolean antiAlias = false;
    private Rectangle explodedGeometry = null;
    private String viewName = null;
    private boolean gatherViewsHere = false;
    private AnnotationColumnChooser annotationColumnSelectionState;
    boolean validCharWidth;
    public boolean followSelection = true;
    private Hashtable<String, AutoCalcSetting> calcIdParams = new Hashtable();

    public AlignViewport(AlignmentI al) {
        super(al);
        this.init();
    }

    public AlignViewport(AlignmentI al, String seqsetid) {
        this(al, seqsetid, null);
    }

    public AlignViewport(AlignmentI al, String seqsetid, String viewid) {
        super(al);
        this.sequenceSetID = seqsetid;
        this.viewId = viewid;
        if (seqsetid != null) {
            Console.debug("Setting viewport's sequence set id : " + this.sequenceSetID);
        }
        if (this.viewId != null) {
            Console.debug("Setting viewport's view id : " + this.viewId);
        }
        this.init();
    }

    public AlignViewport(AlignmentI al, HiddenColumns hiddenColumns) {
        super(al);
        if (hiddenColumns != null) {
            al.setHiddenColumns(hiddenColumns);
        }
        this.init();
    }

    public AlignViewport(AlignmentI al, HiddenColumns hiddenColumns, String seqsetid) {
        this(al, hiddenColumns, seqsetid, null);
    }

    public AlignViewport(AlignmentI al, HiddenColumns hiddenColumns, String seqsetid, String viewid) {
        super(al);
        this.sequenceSetID = seqsetid;
        this.viewId = viewid;
        if (seqsetid != null) {
            Console.debug("Setting viewport's sequence set id : " + this.sequenceSetID);
        }
        if (this.viewId != null) {
            Console.debug("Setting viewport's view id : " + this.viewId);
        }
        if (hiddenColumns != null) {
            al.setHiddenColumns(hiddenColumns);
        }
        this.init();
    }

    private void applyViewProperties() {
        this.antiAlias = Cache.getDefault("ANTI_ALIAS", true);
        this.viewStyle.setShowJVSuffix(Cache.getDefault("SHOW_JVSUFFIX", true));
        this.setShowAnnotation(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.setRightAlignIds(Cache.getDefault("RIGHT_ALIGN_IDS", false));
        this.setCentreColumnLabels(Cache.getDefault("CENTRE_COLUMN_LABELS", false));
        this.autoCalculateConsensusAndConservation = Cache.getDefault("AUTO_CALC_CONSENSUS", true);
        this.setPadGaps(Cache.getDefault("PAD_GAPS", true));
        this.setShowNPFeats(Cache.getDefault("SHOW_NPFEATS_TOOLTIP", true));
        this.setShowDBRefs(Cache.getDefault("SHOW_DBREFS_TOOLTIP", true));
        this.viewStyle.setSeqNameItalics(Cache.getDefault("ID_ITALICS", true));
        this.viewStyle.setWrapAlignment(Cache.getDefault("WRAP_ALIGNMENT", false));
        this.viewStyle.setShowUnconserved(Cache.getDefault("SHOW_UNCONSERVED", false));
        this.sortByTree = Cache.getDefault("SORT_BY_TREE", false);
        this.followSelection = Cache.getDefault("FOLLOW_SELECTIONS", true);
        this.sortAnnotationsBy = AnnotationSorter.SequenceAnnotationOrder.valueOf(Cache.getDefault("SORT_ANNOTATIONS", AnnotationSorter.SequenceAnnotationOrder.NONE.name()));
        this.showAutocalculatedAbove = Cache.getDefault("SHOW_AUTOCALC_ABOVE", false);
        this.viewStyle.setScaleProteinAsCdna(Cache.getDefault("SCALE_PROTEIN_TO_CDNA", true));
        this.viewStyle.setShowStructureProvider(Cache.getDefault("SHOW_STRUCTURE_PROVIDER", false));
    }

    void init() {
        this.applyViewProperties();
        String fontName = Cache.getDefault("FONT_NAME", "SansSerif");
        String fontStyle = Cache.getDefault("FONT_STYLE", "0");
        String fontSize = Cache.getDefault("FONT_SIZE", "10");
        int style = 0;
        if (fontStyle.equals("bold")) {
            style = 1;
        } else if (fontStyle.equals("italic")) {
            style = 2;
        }
        this.setFont(new Font(fontName, style, Integer.parseInt(fontSize)), true);
        this.alignment.setGapCharacter(Cache.getDefault("GAP_SYMBOL", "-").charAt(0));
        if (this.hconsensus == null && !this.isDataset) {
            if (!this.alignment.isNucleotide()) {
                this.showConservation = Cache.getDefault("SHOW_CONSERVATION", true);
                this.showQuality = Cache.getDefault("SHOW_QUALITY", true);
                this.showGroupConservation = Cache.getDefault("SHOW_GROUP_CONSERVATION", false);
            }
            this.showConsensusHistogram = Cache.getDefault("SHOW_CONSENSUS_HISTOGRAM", true);
            this.showSequenceLogo = Cache.getDefault("SHOW_CONSENSUS_LOGO", true);
            this.normaliseSequenceLogo = Cache.getDefault("NORMALISE_CONSENSUS_LOGO", false);
            this.setShowHMMSequenceLogo(this.showSequenceLogo);
            this.setNormaliseHMMSequenceLogo(this.normaliseSequenceLogo);
            this.setShowInformationHistogram(this.showConsensusHistogram);
            this.showGroupConsensus = Cache.getDefault("SHOW_GROUP_CONSENSUS", false);
            this.showConsensus = Cache.getDefault("SHOW_IDENTITY", true);
            this.showSSConsensus = Cache.getDefault("SHOW_SS_CONSENSUS", false);
            this.showOccupancy = Cache.getDefault("SHOW_OCCUPANCY", true);
        }
        this.initAutoAnnotation();
        String colourProperty = this.alignment.isNucleotide() ? "DEFAULT_COLOUR_NUC" : "DEFAULT_COLOUR_PROT";
        String schemeName = Cache.getProperty(colourProperty);
        if (schemeName == null) {
            schemeName = Cache.getDefault("DEFAULT_COLOUR", "None");
        }
        ColourSchemeI colourScheme = ColourSchemeProperty.getColourScheme(this, this.alignment, schemeName);
        this.residueShading = new ResidueShader(colourScheme);
        if (colourScheme instanceof UserColourScheme) {
            this.residueShading = new ResidueShader(UserDefinedColours.loadDefaultColours());
            this.residueShading.setThreshold(0, this.isIgnoreGapsConsensus());
        }
        if (this.residueShading != null) {
            this.residueShading.setConsensus(this.hconsensus);
            this.residueShading.setSSConsensusProfileMap(this.hSSConsensusProfileMap);
        }
        this.setColourAppliesToAllGroups(true);
    }

    @Override
    public void setFont(Font f, boolean setGrid) {
        this.font = f;
        Container c = new Container();
        if (setGrid) {
            FontMetrics fm = c.getFontMetrics(this.font);
            int ww = fm.charWidth('M');
            this.setCharHeight(fm.getHeight());
            this.setCharWidth(ww);
        }
        this.viewStyle.setFontName(this.font.getName());
        this.viewStyle.setFontStyle(this.font.getStyle());
        this.viewStyle.setFontSize(this.font.getSize());
        this.validCharWidth = true;
    }

    @Override
    public void setViewStyle(ViewStyleI settingsForView) {
        super.setViewStyle(settingsForView);
        this.setFont(new Font(this.viewStyle.getFontName(), this.viewStyle.getFontStyle(), this.viewStyle.getFontSize()), false);
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void setAlignment(AlignmentI align) {
        this.replaceMappings(align);
        super.setAlignment(align);
    }

    public void replaceMappings(AlignmentI align) {
        this.deregisterMappings();
        if (align != null) {
            StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance());
            ssm.registerMappings(align.getCodonFrames());
        }
        if (this.alignment != null && align != null) {
            this.alignment.setCodonFrames(align.getCodonFrames());
        }
    }

    protected void deregisterMappings() {
        List<AlignedCodonFrame> mappings;
        AlignmentI al = this.getAlignment();
        if (al != null && (mappings = al.getCodonFrames()) != null) {
            StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance());
            for (AlignedCodonFrame acf : mappings) {
                if (!this.noReferencesTo(acf)) continue;
                ssm.deregisterMapping(acf);
            }
        }
    }

    @Override
    public char getGapCharacter() {
        return this.getAlignment().getGapCharacter();
    }

    public void setGapCharacter(char gap) {
        if (this.getAlignment() != null) {
            this.getAlignment().setGapCharacter(gap);
        }
    }

    public long[] getUndoRedoHash() {
        if (this.historyList == null || this.redoList == null) {
            return new long[]{-1L, -1L};
        }
        return new long[]{this.historyList.hashCode(), this.redoList.hashCode()};
    }

    public boolean isUndoRedoHashModified(long[] undoredo) {
        if (undoredo == null) {
            return true;
        }
        long[] cstate = this.getUndoRedoHash();
        if (cstate.length != undoredo.length) {
            return true;
        }
        for (int i = 0; i < cstate.length; ++i) {
            if (cstate[i] == undoredo[i]) continue;
            return true;
        }
        return false;
    }

    public boolean getFollowSelection() {
        return this.followSelection;
    }

    @Override
    public void sendSelection() {
        StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance()).sendSelection(new SequenceGroup(this.getSelectionGroup()), new ColumnSelection(this.getColumnSelection()), new HiddenColumns(this.getAlignment().getHiddenColumns()), this);
    }

    public boolean getSortByTree() {
        return this.sortByTree;
    }

    public void setSortByTree(boolean sort) {
        this.sortByTree = sort;
    }

    @Override
    public StructureSelectionManager getStructureSelectionManager() {
        return StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance());
    }

    @Override
    public boolean isNormaliseSequenceLogo() {
        return this.normaliseSequenceLogo;
    }

    @Override
    public void setNormaliseSequenceLogo(boolean state) {
        this.normaliseSequenceLogo = state;
    }

    @Override
    public boolean isValidCharWidth() {
        return this.validCharWidth;
    }

    public AutoCalcSetting getCalcIdSettingsFor(String calcId) {
        return this.calcIdParams.get(calcId);
    }

    public void setCalcIdSettingsFor(String calcId, AutoCalcSetting settings, boolean needsUpdate) {
        this.calcIdParams.put(calcId, settings);
        if (needsUpdate) {
            Console.debug("trigger update for " + calcId);
        }
    }

    @Override
    public void mirrorCommand(CommandI command, boolean undo, StructureSelectionManager ssm, VamsasSource source) {
        if (!(source instanceof AlignViewportI) || ((AlignViewportI)((Object)source)).getCodingComplement() != this) {
            return;
        }
        CommandI mappedCommand = ssm.mapCommand(command, undo, this.getAlignment(), this.getGapCharacter());
        if (mappedCommand != null) {
            AlignmentI[] views = ((AlignmentPanel)this.getAlignPanel()).alignFrame.getViewAlignments();
            mappedCommand.doCommand(views);
            ((AlignmentPanel)this.getAlignPanel()).alignmentChanged();
        }
    }

    public void addAlignment(AlignmentI toAdd, String title) {
        toAdd.setDataset(null);
        this.getAlignment().realiseMappings(toAdd.getSequences());
        if (Cache.getDefault("ENABLE_SPLIT_FRAME", true) && AlignmentUtils.isMappable(toAdd, this.getAlignment())) {
            this.openLinkedAlignment(toAdd, title);
            return;
        }
        this.addDataToAlignment(toAdd);
    }

    void addDataToAlignment(AlignmentI toAdd) {
        AlignmentI al = this.getAlignment();
        String gap = String.valueOf(al.getGapCharacter());
        for (int i = 0; i < toAdd.getHeight(); ++i) {
            SequenceI seq = toAdd.getSequenceAt(i);
            al.addSequence(seq);
        }
        for (ContactMatrixI cm : toAdd.getContactMaps()) {
            al.addContactList(cm);
        }
        this.ranges.setEndSeq(this.getAlignment().getHeight() - 1);
        this.notifyAlignment();
    }

    public void addFile(File file, FileFormatI format) {
        this.addFile(file, format, true);
    }

    public void addFile(File file, FileFormatI format, boolean async) {
        DataSourceType protocol = AppletFormatAdapter.checkProtocol(file);
        if (format == null) {
            try {
                format = new IdentifyFile().identify(file, protocol);
            }
            catch (FileFormatException e1) {
                Console.error("Unknown file format for '" + file + "'");
            }
        } else if (FileFormats.getInstance().isIdentifiable(format)) {
            try {
                format = new IdentifyFile().identify(file, protocol);
            }
            catch (FileFormatException e) {
                Console.error("Unknown file format for '" + file + "'", e);
            }
        }
        new FileLoader().LoadFile(this, file, DataSourceType.FILE, format, async);
    }

    public void addFile(File file) {
        this.addFile(file, null);
    }

    protected void openLinkedAlignment(AlignmentI al, String title) {
        Object[] options = new String[]{MessageManager.getString("action.no"), MessageManager.getString("label.split_window"), MessageManager.getString("label.new_window")};
        String question = JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.open_split_window?"));
        AlignViewport us = this;
        JvOptionPane dialog = JvOptionPane.newOptionDialog(Desktop.getDesktopPane()).setResponseHandler(0, () -> this.addDataToAlignment(al)).setResponseHandler(1, () -> AlignViewport.openLinkedAlignmentAs(((AlignmentPanel)this.getAlignPanel()).alignFrame, new Alignment(this.getAlignment()), al, title, 1)).setResponseHandler(2, () -> AlignViewport.openLinkedAlignmentAs(null, this.getAlignment(), al, title, 2));
        dialog.showDialog(question, MessageManager.getString("label.open_split_window"), -1, -1, null, options, options[0]);
    }

    public static void openLinkedAlignmentAs(AlignFrame thisFrame, AlignmentI thisAlignment, AlignmentI al, String title, int mode) {
        AlignmentI protein = al.isNucleotide() ? thisAlignment : al;
        AlignmentI cdna = al.isNucleotide() ? al : thisAlignment;
        al.setDataset(null);
        AlignmentUtils.mapProteinAlignmentToCdna(protein, cdna);
        AlignFrame newAlignFrame = new AlignFrame(al, 700, 500);
        newAlignFrame.setTitle(title);
        newAlignFrame.setStatus(MessageManager.formatMessage("label.successfully_loaded_file", title));
        if (mode == 2) {
            Desktop.addInternalFrame(newAlignFrame, title, 700, 500);
        }
        try {
            newAlignFrame.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (mode == 1) {
            al.alignAs(thisAlignment);
            AlignViewport.openSplitFrame(thisFrame, newAlignFrame, thisAlignment);
        }
    }

    protected static AlignmentI openSplitFrame(AlignFrame thisFrame, AlignFrame newAlignFrame, AlignmentI complement) {
        AlignFrame copyMe = new AlignFrame(complement, 700, 500);
        copyMe.setTitle(thisFrame.getTitle());
        AlignmentI al = newAlignFrame.viewport.getAlignment();
        AlignFrame proteinFrame = al.isNucleotide() ? copyMe : newAlignFrame;
        AlignFrame cdnaFrame = al.isNucleotide() ? newAlignFrame : copyMe;
        cdnaFrame.setVisible(true);
        proteinFrame.setVisible(true);
        String linkedTitle = MessageManager.getString("label.linked_view_title");
        SplitFrame splitFrame = new SplitFrame(cdnaFrame, proteinFrame);
        Desktop.addInternalFrame(splitFrame, linkedTitle, -1, -1);
        return proteinFrame.viewport.getAlignment();
    }

    public AnnotationColumnChooser getAnnotationColumnSelectionState() {
        return this.annotationColumnSelectionState;
    }

    public void setAnnotationColumnSelectionState(AnnotationColumnChooser currentAnnotationColumnSelectionState) {
        this.annotationColumnSelectionState = currentAnnotationColumnSelectionState;
    }

    @Override
    public void setIdWidth(int i) {
        super.setIdWidth(i);
        AlignmentPanel ap = (AlignmentPanel)this.getAlignPanel();
        if (ap != null) {
            Dimension idw = ap.getIdPanel().getIdCanvas().getPreferredSize();
            idw.width = i;
            ap.getIdPanel().getIdCanvas().setPreferredSize(idw);
        }
    }

    public Rectangle getExplodedGeometry() {
        return this.explodedGeometry;
    }

    public void setExplodedGeometry(Rectangle explodedPosition) {
        this.explodedGeometry = explodedPosition;
    }

    public boolean isGatherViewsHere() {
        return this.gatherViewsHere;
    }

    public void setGatherViewsHere(boolean gatherViewsHere) {
        this.gatherViewsHere = gatherViewsHere;
    }

    public void scrollComplementaryAlignment() {
        SearchResults sr = new SearchResults();
        int verticalOffset = this.findComplementScrollTarget(sr);
        if (!sr.isEmpty()) {
            AlignmentPanel complementPanel = (AlignmentPanel)((AlignViewport)this.getCodingComplement()).getAlignPanel();
            complementPanel.setToScrollComplementPanel(false);
            complementPanel.scrollToCentre(sr, verticalOffset);
            complementPanel.setToScrollComplementPanel(true);
        }
    }

    protected boolean noReferencesTo(AlignedCodonFrame acf) {
        AlignFrame[] frames = Desktop.getDesktopAlignFrames();
        if (frames == null) {
            return true;
        }
        for (AlignFrame af : frames) {
            if (af.isClosed()) continue;
            for (AlignmentViewPanel alignmentViewPanel : af.getAlignPanels()) {
                AlignmentI al = alignmentViewPanel.getAlignment();
                if (al == null || !al.getCodonFrames().contains(acf)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void applyFeaturesStyle(FeatureSettingsModelI featureSettings) {
        this.transferFeaturesStyles(featureSettings, false);
    }

    @Override
    public void mergeFeaturesStyle(FeatureSettingsModelI featureSettings) {
        this.transferFeaturesStyles(featureSettings, true);
    }

    private void transferFeaturesStyles(FeatureSettingsModelI featureSettings, boolean mergeOnly) {
        if (featureSettings == null) {
            return;
        }
        FeatureRenderer fr = ((AlignmentPanel)this.getAlignPanel()).getSeqPanel().seqCanvas.getFeatureRenderer();
        ArrayList<String> origRenderOrder = new ArrayList<String>();
        ArrayList<String> origGroups = new ArrayList<String>();
        origRenderOrder.addAll(fr.getRenderOrder());
        origGroups.addAll(fr.getFeatureGroups());
        fr.findAllFeatures(true);
        List<String> renderOrder = fr.getRenderOrder();
        FeaturesDisplayedI displayed = fr.getFeaturesDisplayed();
        if (!mergeOnly) {
            displayed.clear();
        }
        for (String type : renderOrder) {
            FeatureColourI preferredColour = featureSettings.getFeatureColour(type);
            FeatureMatcherSetI preferredFilters = featureSettings.getFeatureFilters(type);
            FeatureColourI origColour = fr.getFeatureStyle(type);
            if (mergeOnly && origRenderOrder.contains(type) && origColour != null && (origColour.isGraduatedColour() || origColour.getColour() == null || !origColour.getColour().equals(ColorUtils.createColourFromName(type)))) continue;
            if (preferredColour != null) {
                fr.setColour(type, preferredColour);
            }
            if (!(preferredFilters == null || mergeOnly && fr.getFeatureFilter(type) == null)) {
                fr.setFeatureFilter(type, preferredFilters);
            }
            if (featureSettings.isFeatureDisplayed(type)) {
                displayed.setVisible(type);
                continue;
            }
            if (!featureSettings.isFeatureHidden(type)) continue;
            displayed.setHidden(type);
        }
        for (String group : fr.getFeatureGroups()) {
            if (mergeOnly && origGroups.contains(group)) continue;
            fr.setGroupVisibility(group, featureSettings.isGroupDisplayed(group));
        }
        if (!featureSettings.optimiseOrder()) {
            fr.orderFeatures(featureSettings);
        }
        fr.setTransparency(featureSettings.getTransparency());
        fr.notifyFeaturesChanged();
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

