/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignExportSettingsI;
import jalview.api.AlignViewportI;
import jalview.bin.Jalview;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.FileFormatI;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AlignExportOptions
extends JPanel {
    protected JCheckBox chkHiddenSeqs = new JCheckBox();
    protected JCheckBox chkHiddenCols = new JCheckBox();
    protected JCheckBox chkExportAnnots = new JCheckBox();
    protected JCheckBox chkExportFeats = new JCheckBox();
    protected JCheckBox chkExportGrps = new JCheckBox();
    protected AlignExportSettingsI settings;
    private boolean isComplexAlignFile;
    JvOptionPane dialog;

    public static boolean isNeeded(AlignViewportI viewport, FileFormatI format) {
        Jalview.getInstance();
        return !Jalview.isHeadlessMode() && (viewport.hasHiddenColumns() || viewport.hasHiddenRows() || format.isComplexAlignFile());
    }

    public AlignExportOptions(AlignViewportI viewport, FileFormatI format, AlignExportSettingsI defaults) {
        this.settings = defaults;
        this.isComplexAlignFile = format.isComplexAlignFile();
        this.init(viewport.hasHiddenRows(), viewport.hasHiddenColumns());
        this.dialog = JvOptionPane.newOptionDialog(Desktop.getDesktopPane());
    }

    public void showDialog() {
        Object[] options = new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
        this.dialog.showInternalDialog(this, MessageManager.getString("label.export_settings"), 2, -1, null, options, MessageManager.getString("action.ok"));
    }

    public void setResponseAction(Object response, Runnable action) {
        this.dialog.setResponseHandler(response, action);
    }

    void checkAllAction(boolean isSelected) {
        boolean set = this.chkHiddenSeqs.isEnabled() && isSelected;
        this.chkHiddenSeqs.setSelected(set);
        this.settings.setExportHiddenSequences(set);
        set = this.chkHiddenCols.isEnabled() && isSelected;
        this.chkHiddenCols.setSelected(set);
        this.settings.setExportHiddenColumns(set);
        set = this.isComplexAlignFile && this.chkExportAnnots.isEnabled() && isSelected;
        this.chkExportAnnots.setSelected(set);
        this.settings.setExportAnnotations(set);
        set = this.isComplexAlignFile && this.chkExportFeats.isEnabled() && isSelected;
        this.chkExportFeats.setSelected(set);
        this.settings.setExportFeatures(set);
        set = this.isComplexAlignFile && this.chkExportGrps.isEnabled() && isSelected;
        this.chkExportGrps.setSelected(set);
        this.settings.setExportGroups(set);
    }

    private void init(boolean hasHiddenSeq, boolean hasHiddenCols) {
        this.chkHiddenSeqs.setText(MessageManager.getString("action.export_hidden_sequences"));
        this.chkHiddenSeqs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignExportOptions.this.settings.setExportHiddenSequences(AlignExportOptions.this.chkHiddenSeqs.isSelected());
            }
        });
        this.chkHiddenCols.setText(MessageManager.getString("action.export_hidden_columns"));
        this.chkHiddenCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignExportOptions.this.settings.setExportHiddenColumns(AlignExportOptions.this.chkHiddenCols.isSelected());
            }
        });
        this.chkExportAnnots.setText(MessageManager.getString("action.export_annotations"));
        this.chkExportAnnots.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignExportOptions.this.settings.setExportAnnotations(AlignExportOptions.this.chkExportAnnots.isSelected());
            }
        });
        this.chkExportFeats.setText(MessageManager.getString("action.export_features"));
        this.chkExportFeats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignExportOptions.this.settings.setExportFeatures(AlignExportOptions.this.chkExportFeats.isSelected());
            }
        });
        this.chkExportGrps.setText(MessageManager.getString("action.export_groups"));
        this.chkExportGrps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignExportOptions.this.settings.setExportGroups(AlignExportOptions.this.chkExportGrps.isSelected());
            }
        });
        final JCheckBox chkAll = new JCheckBox(MessageManager.getString("action.select_all"));
        JPanel hiddenRegionConfPanel = new JPanel(new BorderLayout());
        JPanel complexExportPanel = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        chkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AlignExportOptions.this.checkAllAction(chkAll.isSelected());
            }
        });
        hiddenRegionConfPanel.add((Component)this.chkHiddenSeqs, "Center");
        hiddenRegionConfPanel.add((Component)this.chkHiddenCols, "South");
        this.chkHiddenSeqs.setEnabled(hasHiddenSeq);
        this.chkHiddenCols.setEnabled(hasHiddenCols);
        complexExportPanel.add((Component)this.chkExportAnnots, "North");
        complexExportPanel.add((Component)this.chkExportFeats, "Center");
        complexExportPanel.add((Component)this.chkExportGrps, "South");
        JPanel actionPanel = new JPanel(new FlowLayout(1));
        actionPanel.add(chkAll);
        JPanel optionsPanel = new JPanel();
        if (this.isComplexAlignFile) {
            optionsPanel.add(complexExportPanel);
        }
        if (hasHiddenSeq || hasHiddenCols) {
            optionsPanel.add(hiddenRegionConfPanel);
        }
        this.add((Component)optionsPanel, "North");
        this.add((Component)actionPanel, "South");
    }
}

