/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.core;

import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.core.DecimalFormatTableCellRenderer;
import jalview.fts.core.FTSRestRequest;
import java.util.Collection;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FTSRestResponse {
    private int numberOfItemsFound;
    private String responseTime;
    private Collection<FTSData> searchSummary;

    public int getNumberOfItemsFound() {
        return this.numberOfItemsFound;
    }

    public void setNumberOfItemsFound(int itemFound) {
        this.numberOfItemsFound = itemFound;
    }

    public String getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;
    }

    public Collection<FTSData> getSearchSummary() {
        return this.searchSummary;
    }

    public void setSearchSummary(Collection<FTSData> searchSummary) {
        this.searchSummary = searchSummary;
    }

    public static DefaultTableModel getTableModel(FTSRestRequest request, Collection<FTSData> summariesList) {
        final FTSDataColumnI[] cols = request.getWantedFields().toArray(new FTSDataColumnI[0]);
        final int colOffset = request.getAssociatedSequence() == null ? 0 : 1;
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (colOffset == 1 && columnIndex == 0) {
                    return SequenceI.class;
                }
                return cols[columnIndex - colOffset].getDataType().getDataTypeClass();
            }
        };
        if (request.getAssociatedSequence() != null) {
            tableModel.addColumn("Ref Sequence");
        }
        for (FTSDataColumnI field : request.getWantedFields()) {
            tableModel.addColumn(field.getName());
        }
        for (FTSData res : summariesList) {
            tableModel.addRow(res.getSummaryData());
        }
        return tableModel;
    }

    public static void configureTableColumn(JTable tbl_summary, Collection<FTSDataColumnI> wantedFields, Map<String, Integer> columnPrefs) {
        for (FTSDataColumnI wantedField : wantedFields) {
            try {
                tbl_summary.getColumn(wantedField.getName()).setMinWidth(wantedField.getMinWidth());
                tbl_summary.getColumn(wantedField.getName()).setMaxWidth(wantedField.getMaxWidth());
                int prefedWidth = columnPrefs.get(wantedField.getName()) == null ? wantedField.getPreferredWidth() : columnPrefs.get(wantedField.getName()).intValue();
                tbl_summary.getColumn(wantedField.getName()).setPreferredWidth(prefedWidth);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (wantedField.getDataType().getDataTypeClass() == Double.class) {
                DecimalFormatTableCellRenderer dfr = new DecimalFormatTableCellRenderer(wantedField.getDataType().isFormtted(), wantedField.getDataType().getSignificantFigures());
                tbl_summary.getColumn(wantedField.getName()).setCellRenderer(dfr);
                continue;
            }
            if (wantedField.getDataType().getDataTypeClass() != Integer.class) continue;
            DecimalFormatTableCellRenderer dfr = new DecimalFormatTableCellRenderer(wantedField.getDataType().isFormtted(), wantedField.getDataType().getSignificantFigures());
            tbl_summary.getColumn(wantedField.getName()).setCellRenderer(dfr);
        }
    }
}

