/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.datamodel.CigarBase;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.util.ShiftList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SeqCigar
extends CigarSimple {
    private int start;
    private int end;
    private SequenceI refseq = null;
    private SeqsetUtils.SequenceInfo seqProps;
    private Hashtable selGroups = null;

    public SequenceI getRefSeq() {
        return this.refseq;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int findPosition(int column) {
        int w = 0;
        int p = this.refseq.findPosition(this.start);
        if (column < 0) {
            return -1;
        }
        if (this.range != null) {
            for (int i = 0; i < this.length; ++i) {
                if (this.operation[i] == 'M' || this.operation[i] == 'D') {
                    p += this.range[i];
                }
                if (this.operation[i] != 'M' && this.operation[i] != 'I') continue;
                int ew = w + this.range[i];
                if (column < ew) {
                    if (this.operation[i] == 'I') {
                        return -1;
                    }
                    return p - (ew - column);
                }
                w = ew;
            }
        }
        return -1;
    }

    @Override
    public String getSequenceString(char GapChar) {
        return this.length == 0 ? "" : (String)this.getSequenceAndDeletions(this.refseq.getSequenceAsString(this.start, this.end), GapChar)[0];
    }

    public SequenceI getSeq(char GapChar) {
        if (this.refseq == null || this.length == 0) {
            return null;
        }
        Object[] edit_result = this.getSequenceAndDeletions(this.refseq.getSequenceAsString(this.start, this.end), GapChar);
        if (edit_result == null) {
            throw new Error(MessageManager.getString("error.implementation_error_unexpected_null_from_get_sequence_and_deletions"));
        }
        int[] bounds = (int[])edit_result[1];
        Sequence seq = new Sequence(this.refseq.getName(), (String)edit_result[0], this.refseq.getStart() + this.start + bounds[0], this.refseq.getStart() + this.start + (bounds[2] == 0 ? -1 : bounds[2]));
        seq.setDescription(this.refseq.getDescription());
        int sstart = seq.getStart();
        int send = seq.getEnd();
        if (this.seqProps != null) {
            SeqsetUtils.SeqCharacterUnhash(seq, this.seqProps);
        }
        seq.setDatasetSequence(this.refseq);
        seq.setStart(sstart);
        seq.setEnd(send);
        return seq;
    }

    private boolean _setSeq(SequenceI seq, boolean initialDeletion, int _s, int _e) {
        boolean hasgaps = false;
        if (seq == null) {
            throw new Error(MessageManager.getString("error.implementation_error_set_seq_null"));
        }
        if (_s < 0) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_s", new String[]{Integer.valueOf(_s).toString()}));
        }
        String seq_string = seq.getSequenceAsString();
        if (_e == 0 || _e < _s || _e > seq_string.length()) {
            _e = seq_string.length();
        }
        this.start = seq.findPosition(_s) - seq.getStart();
        this.end = seq.findPosition(_e) - seq.getStart();
        int l_ungapped = this.end - this.start;
        SequenceI ds = seq.getDatasetSequence();
        if (ds == null) {
            String ungapped = AlignSeq.extractGaps(Comparison.GapChars, new String(seq_string));
            l_ungapped = ungapped.length();
            ds = l_ungapped == seq.getLength() ? seq : new Sequence(seq.getName(), ungapped, seq.getStart(), seq.getStart() + ungapped.length() - 1);
        }
        if (ds.getStart() < seq.getStart()) {
            int offset = seq.getStart() - ds.getStart();
            if (initialDeletion) {
                this.addDeleted(_s + offset);
                this.start = 0;
                this.end += offset;
            } else {
                this.start += offset;
                this.end += offset;
            }
        }
        if (l_ungapped != _e - _s) {
            hasgaps = true;
        }
        this.refseq = ds;
        this.seqProps = SeqsetUtils.SeqCharacterHash(seq);
        if (this.end > ds.getLength()) {
            throw new Error(MessageManager.getString("error.implementation_error_seqcigar_possible"));
        }
        return hasgaps;
    }

    public SeqCigar(SequenceI seq, char[] operation, int[] range) {
        if (seq == null) {
            throw new Error(MessageManager.getString("error.implmentation_bug_seq_null"));
        }
        if (operation.length != range.length) {
            throw new Error(MessageManager.getString("error.implementation_bug_cigar_operation_list_range_list"));
        }
        if (operation != null) {
            this.operation = new char[operation.length + this._inc_length];
            this.range = new int[operation.length + this._inc_length];
            if (this._setSeq(seq, false, 0, 0)) {
                throw new Error(MessageManager.getString("error.not_yet_implemented_cigar_object_from_cigar_string"));
            }
            int i = this.length;
            for (int j = 0; j < operation.length; ++j) {
                char op = operation[j];
                if (op != 'M' && op != 'I' && op != 'D') {
                    throw new Error(MessageManager.formatMessage("error.implementation_bug_cigar_operation", new String[]{Integer.valueOf(j).toString(), Integer.valueOf(op).toString(), Integer.valueOf(77).toString(), Integer.valueOf(73).toString(), Integer.valueOf(68).toString()}));
                }
                this.operation[i] = op;
                this.range[i] = range[j];
                ++i;
            }
            this.length += operation.length;
        } else {
            this.operation = null;
            this.range = null;
            this.length = 0;
            if (this._setSeq(seq, false, 0, 0)) {
                throw new Error(MessageManager.getString("error.not_yet_implemented_cigar_object_from_cigar_string"));
            }
        }
    }

    public void addMatch(int range) {
        this.addOperation('M', range);
    }

    protected static void addSequenceOps(CigarBase cigar, SequenceI seq, int startpos, int endpos, boolean initialDeletions) {
        char op = '\u0000';
        int range = 0;
        int p = 0;
        int res = seq.getLength();
        if (!initialDeletions) {
            p = startpos;
        }
        while (p <= endpos) {
            boolean isGap;
            boolean bl = isGap = p < res ? Comparison.isGap(seq.getCharAt(p)) : true;
            if (startpos <= p && p <= endpos) {
                if (isGap) {
                    if (range > 0 && op != 'I') {
                        cigar.addOperation(op, range);
                        range = 0;
                    }
                    op = 'I';
                    ++range;
                } else {
                    if (range > 0 && op != 'M') {
                        cigar.addOperation(op, range);
                        range = 0;
                    }
                    op = 'M';
                    ++range;
                }
            } else if (!isGap) {
                if (range > 0 && op != 'D') {
                    cigar.addOperation(op, range);
                    range = 0;
                }
                op = 'D';
                ++range;
            }
            ++p;
        }
        if (range > 0) {
            cigar.addOperation(op, range);
        }
    }

    public SeqCigar(SequenceI seq) {
        if (seq == null) {
            throw new Error(MessageManager.getString("error.implementation_error_for_new_cigar"));
        }
        this._setSeq(seq, false, 0, 0);
        SeqCigar.addSequenceOps(this, seq, 0, seq.getLength() - 1, false);
    }

    public SeqCigar(SequenceI seq, int start, int end) {
        if (seq == null) {
            throw new Error(MessageManager.getString("error.implementation_error_for_new_cigar"));
        }
        this._setSeq(seq, false, start, end + 1);
        SeqCigar.addSequenceOps(this, seq, start, end, false);
    }

    public static SeqCigar parseCigar(SequenceI seq, String cigarString) throws Exception {
        Object[] opsandrange = SeqCigar.parseCigarString(cigarString);
        return new SeqCigar(seq, (char[])opsandrange[0], (int[])opsandrange[1]);
    }

    public static SequenceI[] createAlignmentSequences(SeqCigar[] alseqs, char gapCharacter, HiddenColumns hidden, int[] segments) {
        int i;
        SequenceI[] seqs = new SequenceI[alseqs.length];
        StringBuffer[] g_seqs = new StringBuffer[alseqs.length];
        String[] alseqs_string = new String[alseqs.length];
        Object[] gs_regions = new Object[alseqs.length];
        for (int i2 = 0; i2 < alseqs.length; ++i2) {
            alseqs_string[i2] = alseqs[i2].getRefSeq().getSequenceAsString(alseqs[i2].start, alseqs[i2].end);
            gs_regions[i2] = alseqs[i2].getSequenceAndDeletions(alseqs_string[i2], gapCharacter);
            if (gs_regions[i2] == null) {
                throw new Error(MessageManager.formatMessage("error.implementation_error_cigar_seq_no_operations", new String[]{Integer.valueOf(i2).toString()}));
            }
            g_seqs[i2] = new StringBuffer((String)((Object[])gs_regions[i2])[0]);
        }
        ShiftList shifts = new ShiftList();
        for (i = 0; i < alseqs.length; ++i) {
            Object[] gs_region = (Object[])((Object[])gs_regions[i])[2];
            if (gs_region == null) continue;
            for (int hr = 0; hr < gs_region.length; ++hr) {
                int[] region = (int[])gs_region[hr];
                char[] insert = new char[region[1] - region[0] + 1];
                for (int s = 0; s < insert.length; ++s) {
                    insert[s] = gapCharacter;
                }
                int inspos = shifts.shift(region[2]);
                for (int s = 0; s < alseqs.length; ++s) {
                    if (s != i) {
                        if (g_seqs[s].length() <= inspos) {
                            for (int l = inspos - g_seqs[s].length(); l > 0; --l) {
                                g_seqs[s].append(gapCharacter);
                            }
                        }
                        g_seqs[s].insert(inspos, insert);
                        continue;
                    }
                    g_seqs[s].insert(inspos, alseqs_string[i].substring(region[0], region[1] + 1));
                }
                shifts.addShift(region[2], insert.length);
                if (segments != null) continue;
                hidden.hideColumns(inspos, inspos + insert.length - 1);
            }
        }
        for (i = 0; i < alseqs.length; ++i) {
            int[] bounds = (int[])((Object[])gs_regions[i])[1];
            SequenceI ref = alseqs[i].getRefSeq();
            seqs[i] = new Sequence(ref.getName(), g_seqs[i].toString(), ref.getStart() + alseqs[i].start + bounds[0], ref.getStart() + alseqs[i].start + (bounds[2] == 0 ? -1 : bounds[2]));
            seqs[i].setDatasetSequence(ref);
            seqs[i].setDescription(ref.getDescription());
        }
        if (segments != null) {
            for (i = 0; i < segments.length; i += 3) {
                hidden.hideColumns(segments[i + 1], segments[i + 1] + segments[i + 2] - 1);
            }
        }
        return seqs;
    }

    public void setGroupMembership(Object group) {
        if (this.selGroups == null) {
            this.selGroups = new Hashtable();
        }
        this.selGroups.put(group, new int[0]);
    }

    public boolean removeGroupMembership(Object group) {
        if (this.selGroups != null && this.selGroups.containsKey(group)) {
            this.selGroups.remove(group);
            return true;
        }
        return false;
    }

    public void clearMemberships() {
        if (this.selGroups != null) {
            this.selGroups.clear();
        }
        this.selGroups = null;
    }

    public Object[] getAllMemberships() {
        if (this.selGroups == null) {
            return null;
        }
        Object[] mmbs = new Object[this.selGroups.size()];
        Enumeration en = this.selGroups.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            mmbs[i] = en.nextElement();
            ++i;
        }
        return mmbs;
    }

    public boolean isMemberOf(Object sgr) {
        return this.selGroups != null && this.selGroups.get(sgr) != null;
    }
}

