/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.AverageDistanceEngine;
import jalview.bin.Console;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.GroupSetI;
import jalview.io.NewickFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;

public class GroupSet
implements GroupSetI {
    List<BitSet> groups = Arrays.asList(new BitSet[0]);
    String newick = null;
    boolean abs = false;
    double thresh = 0.0;
    String treeType = null;
    HashMap<BitSet, Color> colorMap = new HashMap();

    public GroupSet(GroupSet grps) {
        this.abs = grps.abs;
        this.colorMap = new HashMap<BitSet, Color>(grps.colorMap);
        this.groups = new ArrayList<BitSet>(grps.groups);
        this.newick = grps.newick;
        this.thresh = grps.thresh;
        this.treeType = grps.treeType;
    }

    public GroupSet() {
    }

    public GroupSet(boolean abs2, float thresh2, List<BitSet> groups2, String treeType2, String newick2) {
        this.abs = abs2;
        this.thresh = thresh2;
        this.groups = groups2;
        this.treeType = treeType2;
        this.newick = newick2;
    }

    @Override
    public boolean hasGroups() {
        return this.groups != null;
    }

    @Override
    public String getNewick() {
        return this.newick;
    }

    @Override
    public boolean hasTree() {
        return this.newick != null && this.newick.length() > 0;
    }

    @Override
    public void updateGroups(List<BitSet> colGroups) {
        if (colGroups != null) {
            this.groups = colGroups;
        }
    }

    @Override
    public BitSet getGroupsFor(int column) {
        if (this.groups != null) {
            for (BitSet gp : this.groups) {
                if (!gp.get(column)) continue;
                return gp;
            }
        }
        BitSet bs = new BitSet();
        bs.set(column);
        return bs;
    }

    @Override
    public Color getColourForGroup(BitSet bs) {
        if (bs == null) {
            return Color.white;
        }
        Color groupCol = this.colorMap.get(bs);
        if (groupCol == null) {
            return Color.white;
        }
        return groupCol;
    }

    @Override
    public void setColorForGroup(BitSet bs, Color color) {
        this.colorMap.put(bs, color);
    }

    @Override
    public void restoreGroups(List<BitSet> newgroups, String treeMethod, String tree, double thresh2) {
        this.treeType = treeMethod;
        this.groups = newgroups;
        this.thresh = thresh2;
        this.newick = tree;
    }

    @Override
    public boolean hasCutHeight() {
        return this.groups != null && this.thresh != 0.0;
    }

    @Override
    public double getCutHeight() {
        return this.thresh;
    }

    @Override
    public String getTreeMethod() {
        return this.treeType;
    }

    public static GroupSet makeGroups(ContactMatrixI matrix, boolean autoCut) {
        return GroupSet.makeGroups(matrix, autoCut, 0.0f, autoCut);
    }

    public static GroupSet makeGroups(ContactMatrixI matrix, boolean auto, float thresh, boolean abs) {
        List<BinaryNode> nodegroups;
        AverageDistanceEngine clusterer = new AverageDistanceEngine(null, null, matrix, true);
        double height = clusterer.findHeight(clusterer.getTopNode());
        Console.debug("Column tree height: " + height);
        String newick = new NewickFile(clusterer.getTopNode(), false, true).print();
        String treeType = "UPGMA";
        Console.trace("Newick string\n" + newick);
        float cut = -1.0f;
        if (auto) {
            double rootw = 0.0;
            int p = 2;
            BinaryNode bn = clusterer.getTopNode();
            while (p-- > 0 & bn.left() != null) {
                if (bn.left() != null) {
                    bn = bn.left();
                }
                if (bn.left() == null) continue;
                rootw = bn.height;
            }
            cut = thresh = Math.max((float)(rootw / height) - 0.01f, 0.0f);
            nodegroups = clusterer.groupNodes(thresh);
        } else if (abs ? height > (double)thresh : 0.0f < thresh && thresh < 1.0f) {
            cut = abs ? thresh : (float)((double)thresh * height);
            Console.debug("Threshold " + cut + " for height=" + height);
            nodegroups = clusterer.groupNodes(cut);
        } else {
            nodegroups = new ArrayList<BinaryNode>();
            nodegroups.add(clusterer.getTopNode());
        }
        ArrayList<BitSet> groups = new ArrayList<BitSet>();
        for (BinaryNode root : nodegroups) {
            BitSet gpset = new BitSet();
            for (BinaryNode leaf : clusterer.findLeaves(root)) {
                gpset.set((Integer)leaf.element());
            }
            groups.add(gpset);
        }
        GroupSet grps = new GroupSet(abs, cut == -1.0f ? thresh : cut, groups, treeType, newick);
        return grps;
    }

    @Override
    public List<BitSet> getGroups() {
        return this.groups;
    }
}

