/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.api.AlignmentRowsCollectionI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AllRowsIterator;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.SequenceI;
import java.util.Iterator;

public class AllRowsCollection
implements AlignmentRowsCollectionI {
    int start;
    int end;
    AlignmentI alignment;
    HiddenSequences hidden;

    public AllRowsCollection(int s, int e, AlignmentI al) {
        this.start = s;
        this.end = e;
        this.alignment = al;
        this.hidden = al.getHiddenSequences();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new AllRowsIterator(this.start, this.end, this.alignment);
    }

    @Override
    public boolean isHidden(int seq) {
        return this.hidden.isHidden(seq);
    }

    @Override
    public SequenceI getSequence(int seq) {
        return this.alignment.getSequenceAtAbsoluteIndex(seq);
    }

    @Override
    public boolean hasHidden() {
        return this.hidden.getSize() > 0;
    }
}

