/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.Console;
import jalview.bin.HiDPISetting;
import jalview.bin.MemorySetting;
import jalview.bin.argparser.Arg;
import jalview.util.ChannelProperties;
import jalview.util.ErrorLog;
import jalview.util.LaunchUtils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class Launcher {
    private static final String startClass = "jalview.bin.Jalview";
    private static final String headlessProperty = "java.awt.headless";
    private static final String macosHeadlessProperty = "apple.awt.UIElement";
    private static final String[] assumeHeadlessArgs = new String[]{"headless", "output", "image", "structureimage"};

    public static void main(String[] args) {
        String scalePropertyArg;
        long maxMemLong;
        if (!LaunchUtils.checkJavaVersion()) {
            Console.errPrintln("WARNING - The Java version being used (Java " + LaunchUtils.getJavaVersion() + ") may lead to problems. This installation of Jalview should be used with Java " + LaunchUtils.getJavaCompileVersion() + ".");
        }
        ErrorLog.setPrefix("LAUNCHER - ");
        String jvmmempc = null;
        String jvmmemmax = null;
        boolean debug = false;
        boolean wait = true;
        boolean quiet = false;
        boolean headless = false;
        boolean assumeheadless = false;
        boolean gui = false;
        boolean help = false;
        boolean stdout = false;
        boolean launcherstop = false;
        boolean launcherprint = false;
        boolean launcherwait = false;
        ArrayList<String> arguments = new ArrayList<String>();
        String previousArg = null;
        for (String arg : args) {
            if (!arg.equals("--debug")) continue;
            debug = true;
        }
        for (String arg : args) {
            if (arg.equals("--quiet")) {
                quiet = true;
            } else if (arg.equals("--gui")) {
                gui = true;
            } else if (arg.equals("--help")) {
                help = true;
            } else if (arg.equals("--version")) {
                help = true;
            }
            if (!assumeheadless) {
                for (String a : assumeHeadlessArgs) {
                    if (!arg.equals("--" + a) && !arg.startsWith("--" + a + "=")) continue;
                    assumeheadless = true;
                }
            }
            if (arg.equals("--output=-") || arg.equals("-") && "--output".equals(previousArg)) {
                stdout = true;
            }
            if (debug) {
                if (arg.equals("--launcherprint")) {
                    launcherprint = true;
                } else if (arg.equals("--launcherstop")) {
                    launcherstop = true;
                } else if (arg.equals("--launcherwait")) {
                    launcherwait = true;
                } else if (arg.equals("--launchernowait")) {
                    wait = false;
                }
            }
            previousArg = arg;
            if (arg.startsWith("--launcher")) continue;
            String jvmmempcArg = Arg.JVMMEMPC.getName();
            String jvmmemmaxArg = Arg.JVMMEMMAX.getName();
            if (arg.startsWith("-" + jvmmempcArg + "=")) {
                jvmmempc = arg.substring(jvmmempcArg.length() + 2);
                continue;
            }
            if (arg.startsWith("-" + jvmmemmaxArg + "=")) {
                jvmmemmax = arg.substring(jvmmemmaxArg.length() + 2);
                continue;
            }
            if (arg.startsWith("--" + jvmmempcArg + "=")) {
                jvmmempc = arg.substring(jvmmempcArg.length() + 3);
                continue;
            }
            if (arg.startsWith("--" + jvmmemmaxArg + "=")) {
                jvmmemmax = arg.substring(jvmmemmaxArg.length() + 3);
                continue;
            }
            arguments.add(arg);
        }
        headless = help ? true : (gui ? false : assumeheadless);
        ErrorLog.setQuiet(quiet);
        String appName = ChannelProperties.getProperty("app_name");
        String javaBin = LaunchUtils.findJavaBin(true);
        ArrayList<String> removeJvmArgs = new ArrayList<String>();
        ArrayList<String> addJvmArgs = new ArrayList<String>();
        Object memSetting = null;
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        boolean useCustomisedSettings = LaunchUtils.getBooleanUserPreference("MEMORY_CUSTOMISED_SETTINGS");
        if (useCustomisedSettings) {
            if (jvmmempc == null) {
                jvmmempc = LaunchUtils.getUserPreference(MemorySetting.MEMORY_JVMMEMPC);
            }
            if (jvmmemmax == null) {
                jvmmemmax = LaunchUtils.getUserPreference(MemorySetting.MEMORY_JVMMEMMAX);
            }
        }
        boolean memSet = false;
        boolean dockIcon = false;
        boolean dockName = false;
        boolean headlessProp = false;
        boolean macosHeadlessProp = false;
        for (int i = 0; i < jvmArgs.size(); ++i) {
            String arg = jvmArgs.get(i);
            if (arg.startsWith("-Xmx")) {
                if (jvmmempc != null || jvmmemmax != null) continue;
                memSetting = arg;
                memSet = true;
                continue;
            }
            if (arg.startsWith("-Xdock:icon")) {
                dockIcon = true;
                continue;
            }
            if (arg.startsWith("-Xdock:name")) {
                dockName = true;
                continue;
            }
            if (arg.startsWith("-Djava.awt.headless=")) {
                headlessProp = true;
                continue;
            }
            if (!arg.startsWith("-Dapple.awt.UIElement=")) continue;
            macosHeadlessProp = true;
        }
        if (!memSet && (maxMemLong = MemorySetting.getMemorySetting(jvmmemmax, jvmmempc)) > 0L) {
            memSetting = "-Xmx" + Long.toString(maxMemLong);
            memSet = true;
            addJvmArgs.add((String)memSetting);
            removeJvmArgs.add("-Xmx");
        }
        if (LaunchUtils.isMac) {
            if (!dockIcon) {
                String dockIconPath = System.getProperty("launcher.appdir", ".") + File.separator + "resource" + File.separator + "jalview_logo.png";
                addJvmArgs.add("-Xdock:icon=" + dockIconPath);
            }
            if (!dockName) {
                addJvmArgs.add("-Xdock:name=" + appName);
                addJvmArgs.add("-Dcom.apple.mrj.application.apple.menu.about.name=" + appName);
            }
        }
        if (headless && !headlessProp) {
            System.setProperty(headlessProperty, "true");
            if (help) {
                addJvmArgs.add("-Djava.awt.headless=true");
            }
        }
        if (headless && LaunchUtils.isMac && !macosHeadlessProp) {
            System.setProperty(macosHeadlessProperty, "true");
            addJvmArgs.add("-Dapple.awt.UIElement=true");
        }
        if ((scalePropertyArg = HiDPISetting.getScalePropertyArg()) != null) {
            ErrorLog.errPrintln("Running jalview.bin.Jalview with scale setting " + scalePropertyArg);
            addJvmArgs.add(scalePropertyArg);
        }
        int exitValue = LaunchUtils.startNewJvm(javaBin, removeJvmArgs, addJvmArgs, null, null, null, startClass, null, null, arguments, launcherprint, launcherwait, launcherstop, debug, quiet);
        ErrorLog.errPrintln("JVM exited with value " + exitValue);
    }
}

