/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.Console;
import jalview.util.Platform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ApplicationSingletonProvider {
    private static Map<Class<? extends ApplicationSingletonI>, ApplicationSingletonI> singletons = new HashMap<Class<? extends ApplicationSingletonI>, ApplicationSingletonI>();

    private ApplicationSingletonProvider() {
    }

    private static Map<Class<? extends ApplicationSingletonI>, ApplicationSingletonI> getContextMap() {
        ThreadGroup g = Platform.isJS() ? Thread.currentThread().getThreadGroup() : null;
        Map<Class<? extends ApplicationSingletonI>, ApplicationSingletonI> map = singletons;
        if (map == null) {
            map = new HashMap<Class<? extends ApplicationSingletonI>, ApplicationSingletonI>();
        }
        return map;
    }

    public static <T extends ApplicationSingletonI> T getInstance(Class<T> c) {
        Map<Class<? extends ApplicationSingletonI>, ApplicationSingletonI> map = ApplicationSingletonProvider.getContextMap();
        if (map.containsKey(c)) {
            return (T)map.get(c);
        }
        ApplicationSingletonI o = null;
        try {
            Constructor<T> con = c.getDeclaredConstructor(new Class[0]);
            con.setAccessible(true);
            o = (ApplicationSingletonI)con.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Console.error("Failed to create singleton for " + c.toString() + ", error was: " + e.toString());
            e.printStackTrace();
        }
        ApplicationSingletonProvider.getContextMap().put(c, o);
        return (T)o;
    }

    public static void removeInstance(Class<? extends ApplicationSingletonI> c) {
        Map<Class<? extends ApplicationSingletonI>, ApplicationSingletonI> map = ApplicationSingletonProvider.getContextMap();
        if (map != null) {
            map.remove(c);
        }
    }

    public static interface ApplicationSingletonI {
    }
}

