/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.Cache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppletParams
extends HashMap<String, Object> {
    private static final String[] params = new String[]{"alignpdbfiles", "ANNOTATIONCOLOUR_MAX", "ANNOTATIONCOLOUR_MIN", "annotations", "APPLICATION_URL", "automaticScrolling", "centrecolumnlabels", "debug", "defaultColour", "defaultColourNuc", "defaultColourProt", "embedded", "enableSplitFrame", "externalstructureviewer", "features", "file", "file2", "format", "heightScale", "hidefeaturegroups", "jalviewhelpurl", "jnetfile", "jpredfile", "label", "linkLabel_", "linkLabel_1", "linkURL_", "nojmol", "normaliseLogo", "normaliseSequenceLogo", "oninit", "PDBFILE", "PDBSEQ", "relaxedidmatch", "resolvetocodebase", "RGB", "scaleProteinAsCdna", "scoreFile", "separator", "sequence", "showAnnotation", "showbutton", "showConsensus", "showConsensusHistogram", "showConservation", "showfeaturegroups", "showFeatureSettings", "showFullId", "showGroupConsensus", "showGroupConservation", "showOccupancy", "showQuality", "showSequenceLogo", "showTreeBootstraps", "showTreeDistances", "showUnconserved", "showUnlinkedTreeNodes", "sortBy", "sortByTree", "tree", "treeFile", "upperCase", "userDefinedColour", "widthScale", "windowHeight", "windowWidth", "wrap"};

    public String getParam(String param, String def) {
        Object val = this.get(param);
        return val != null ? val.toString() : def;
    }

    public AppletParams(String outerHTML) {
        String[] tokens = outerHTML.split("<param");
        outerHTML = tokens[0];
        String code = AppletParams.getAttr(outerHTML, "code");
        if (!code.equals("jalview.bin.JalviewLite")) {
            return;
        }
        int i = tokens.length;
        while (--i > 0) {
            String param = tokens[i];
            String key = AppletParams.getAttr(param, "name");
            if (key == null) continue;
            String value = AppletParams.getAttr(param, "value");
            System.out.println("AppletParams " + key + " = \"" + value + "\"");
            this.put(key, value);
        }
        this.put("_width", AppletParams.getAttr(outerHTML, "width"));
        this.put("_height", AppletParams.getAttr(outerHTML, "height"));
        this.put("_id", AppletParams.getAttr(outerHTML, "id"));
        this.put("_name", AppletParams.getAttr(outerHTML, "name"));
        this.put("_archive", AppletParams.getAttr(outerHTML, "archive"));
        this.put("_code", code);
    }

    public AppletParams() {
    }

    public static AppletParams getAppletParams(Map<String, Object> map, List<String> vargs) {
        AppletParams appletParams = new AppletParams();
        Object resourcePath = AppletParams.getString(map, "resourcePath");
        if (resourcePath == null) {
            resourcePath = "";
        }
        if (((String)resourcePath).length() > 0 && !((String)resourcePath).endsWith("/")) {
            resourcePath = (String)resourcePath + "/";
        }
        int i = params.length;
        while (--i >= 0) {
            String prefName = params[i];
            Object value = map.get(prefName);
            if (value == null) continue;
            AppletParams.addParam(vargs, prefName, value, appletParams, (String)resourcePath);
        }
        return appletParams;
    }

    private static String getString(Map<String, Object> map, String key) {
        Object o = map.get(key);
        return o == null ? null : o.toString();
    }

    public static AppletParams getAppletParams(String[] args, List<String> vargs) {
        AppletParams appletParams = new AppletParams();
        Object resourcePath = "";
        int i = args.length;
        while (--i > 0) {
            if (!args[i].startsWith("name=\"Info.resourcePath\"")) continue;
            resourcePath = AppletParams.getAttr(args[i], "value");
            if (((String)resourcePath).length() <= 0 || ((String)resourcePath).endsWith("/")) break;
            resourcePath = (String)resourcePath + "/";
            break;
        }
        for (i = 1; i < args.length; ++i) {
            String arg = args[i].trim();
            if (!arg.startsWith("name=")) continue;
            String prefName = AppletParams.getAttr(arg, "name");
            String value = AppletParams.getAttr(arg, "value");
            AppletParams.addParam(vargs, prefName, value, appletParams, (String)resourcePath);
        }
        return appletParams;
    }

    private static void addParam(List<String> vargs, String prefName, Object value, AppletParams appletParams, String resourcePath) {
        String appletName;
        String argName = null;
        switch (appletName = prefName.toLowerCase()) {
            case "file": {
                argName = "open";
                prefName = null;
                value = resourcePath + value;
                break;
            }
            case "file2": {
                argName = "open2";
                prefName = null;
                value = resourcePath + value;
                break;
            }
            case "oninit": 
            case "hidefeaturegroups": {
                argName = null;
                prefName = null;
                break;
            }
            case "tree": 
            case "treefile": {
                argName = "tree";
                prefName = null;
                value = resourcePath + value;
                break;
            }
            case "features": 
            case "jnetfile": 
            case "jpredfile": 
            case "pdbfile": 
            case "scorefile": 
            case "sequence": 
            case "annotations": {
                argName = null;
                prefName = null;
                value = resourcePath + value;
                break;
            }
            case "defaultcolour": {
                prefName = "DEFAULT_COLOUR";
                break;
            }
            case "defaultcolournuc": {
                prefName = "DEFAULT_COLOUR_NUC";
                break;
            }
            case "defaultcolourprot": {
                prefName = "DEFAULT_COLOUR_PROT";
                break;
            }
            case "annotationcolour_max": {
                prefName = "ANNOTATIONCOLOUR_MAX";
                break;
            }
            case "annotationcolour_min": {
                prefName = "ANNOTATIONCOLOUR_MIN";
                break;
            }
            case "enablesplitframe": {
                prefName = "ENABLE_SPLIT_FRAME";
                break;
            }
            case "centrecolumnlabels": {
                prefName = "CENTRE_COLUMN_LABELS";
                break;
            }
            case "sortby": {
                prefName = "SORT_ALIGNMENT";
                break;
            }
            case "normalisesequencelogo": {
                prefName = "NORMALISE_CONSENSUS_LOGO";
                break;
            }
            case "relaxedidmatch": {
                prefName = "RELAXEDSEQIDMATCHING";
                break;
            }
            case "scaleproteinascdna": {
                prefName = "SCALE_PROTEIN_TO_CDNA";
                break;
            }
            case "userdefinedcolour": {
                argName = "colour";
                prefName = "USER_DEFINED_COLOURS";
                break;
            }
            case "wrap": {
                prefName = "WRAP_ALIGNMENT";
                break;
            }
            case "sortbytree": {
                argName = prefName;
                prefName = "SORT_BY_TREE";
                value = AppletParams.checkTF(value);
                break;
            }
            case "pdbseq": 
            case "alignpdbfiles": {
                prefName = null;
                break;
            }
            case "format": {
                argName = prefName;
                break;
            }
            case "separator": {
                argName = prefName;
                break;
            }
            case "rgb": {
                prefName = null;
                break;
            }
            case "externalstructureviewer": {
                break;
            }
            case "application_url": {
                break;
            }
            case "automaticscrolling": {
                break;
            }
            case "heightscale": {
                break;
            }
            case "jalviewhelpurl": {
                break;
            }
            case "label": {
                break;
            }
            case "linklabel_": {
                prefName = "linkLabel_";
                break;
            }
            case "linklabel_1": {
                prefName = "linkLabel_1";
                break;
            }
            case "linkurl_": {
                prefName = "linkURL_";
                break;
            }
            case "nojmol": 
            case "normaliselogo": 
            case "resolvetocodebase": 
            case "uppercase": 
            case "widthscale": 
            case "windowheight": 
            case "windowwidth": {
                prefName = null;
                break;
            }
            case "debug": 
            case "embedded": 
            case "showbutton": {
                value = AppletParams.checkTF(value);
                break;
            }
            case "showannotation": {
                prefName = "SHOW_ANNOTATIONS";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showconsensus": {
                prefName = "SHOW_CONSENSUS_LOGO";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showconsensushistogram": {
                prefName = "SHOW_CONSENSUS_HISTOGRAM";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showconservation": {
                prefName = "SHOW_CONSERVATION";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showgroupconsensus": {
                prefName = "SHOW_GROUP_CONSENSUS";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showgroupconservation": {
                prefName = "SHOW_GROUP_CONSERVATION";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showoccupancy": {
                prefName = "SHOW_OCCUPANCY";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showquality": {
                prefName = "SHOW_QUALITY";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showsequencelogo": {
                prefName = "SHOW_CONSENSUS_LOGO";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showunconserved": {
                prefName = "SHOW_UNCONSERVED";
                value = AppletParams.checkTF(value);
                break;
            }
            case "showfeaturegroups": 
            case "showfeaturesettings": 
            case "showfullid": 
            case "showtreebootstraps": 
            case "showtreedistances": 
            case "showunlinkedtreenodes": {
                value = AppletParams.checkTF(value);
                break;
            }
            default: {
                if (!appletName.startsWith("pdbfile") && (!appletName.startsWith("sequence") || !Character.isDigit(appletName.charAt(appletName.length() - 1)))) break;
                argName = null;
                prefName = null;
                value = resourcePath + value;
            }
        }
        if (value != null && argName != null) {
            vargs.add(argName);
            if (value != "true") {
                vargs.add(value.toString());
            }
        }
        if (value == null) {
            value = "false";
        }
        System.out.println("AppletParams propName=" + prefName + " argName=" + argName + " appletName=" + appletName + " value=" + value);
        if (appletName != null) {
            appletParams.put(appletName, value);
        }
        if (prefName != null) {
            Cache.setPropertyNoSave(prefName, value.toString());
        }
    }

    private static String checkTF(Object value) {
        return ("" + value).toLowerCase() == "true" ? "true" : null;
    }

    private static String getAttr(String tag, String attr) {
        int pt = tag.indexOf(attr + "=\"");
        if (pt < 0) {
            System.out.println("AppletParams did not read " + attr + " in " + tag);
            return null;
        }
        int pt1 = pt + attr.length() + 2;
        int pt2 = tag.indexOf("\"", pt1);
        return pt < 0 ? null : tag.substring(pt1, pt2);
    }

    public static void main(String[] args) {
        new AppletParams("<applet\r\n    code=\"jalview.bin.JalviewLite\" width=\"140\" height=\"35\"\r\n    archive=\"jalviewApplet.jar,JmolApplet-14.6.4_2016.10.26.jar,java-json.jar,json_simple-1.1.jar\">  \r\n  <param name=\"permissions\" value=\"sandbox\"/>\r\n  <param name=\"file\" value=\"uniref50.fa\"/>\r\n  <param name=\"treeFile\" value=\"ferredoxin.nw\"/>\r\n  <param name=\"userDefinedColour\" value=\"C=yellow; R,K,H=FF5555; D,E=5555FF\"/>\r\n  <param name=\"sortByTree\" value=\"True\"/>\r\n  <param name=\"showSequenceLogo\" value=\"true\"/>\r\n  <param name=\"showGroupConsensus\" value=\"true\"/>\r\n  <param name=\"showFullId\" value=\"false\"/>\r\n    <param name=\"linkLabel_1\" value=\"Uniprot\"/>\r\n    <param name=\"linkUrl_1\" value=\"http://www.uniprot.org/uniprot/$SEQUENCE_ID$\"/>\r\n    <param name=\"linkLabel_2\" value=\"EMBL-EBI Search\"/>\r\n    <param name=\"linkUrl_2\" value=\"http://www.ebi.ac.uk/ebisearch/search.ebi?db=allebi&query=$SEQUENCE_ID$\"/>\r\n    <param name=\"APPLICATION_URL\" value=\"http://www.jalview.org/services/launchApp\"/>\r\n     </applet>");
    }
}

