/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.ScoreManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class IOHelper {
    static File getFile(String[] cmd, String key, boolean mustExist) throws IOException {
        assert (key != null && key.trim().length() != 0);
        String[] stringArray = cmd;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String c;
            String filename = c = stringArray[i];
            if (!(filename = filename.trim()).toLowerCase().startsWith(key + "=")) continue;
            filename = filename.substring((key + "=").length());
            File file = new File(filename);
            if (mustExist && !file.exists()) {
                System.out.println(key + " file " + file.getAbsolutePath() + " does not exist");
                return null;
            }
            if (!mustExist && !file.exists()) {
                file.createNewFile();
            }
            if (!file.canRead()) {
                System.out.println("Cannot read " + key + " file " + file.getAbsolutePath());
                return null;
            }
            return file;
        }
        return null;
    }

    static List<String> loadParameters(File paramsfile) throws IOException {
        assert (paramsfile != null && paramsfile.exists());
        BufferedReader reader = new BufferedReader(new FileReader(paramsfile));
        String line = null;
        ArrayList<String> params = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            params.add(line);
        }
        return params;
    }

    static Writer getWriter(File file) throws IOException {
        assert (file != null && file.exists());
        return new FileWriter(file);
    }

    static void writeOut(Writer writer, Alignment align) {
        try {
            ClustalAlignmentUtil.writeClustalAlignment(writer, align);
        }
        catch (IOException e) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void writeOut(Writer writer, ScoreManager results) {
        if (results == null) {
            return;
        }
        try {
            results.writeOut(writer);
        }
        catch (IOException e) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

