/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Range;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Score
implements Comparable<Score> {
    static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.UK);
    private final String method;
    private TreeSet<Range> ranges = new TreeSet();
    private ArrayList<Float> scores = new ArrayList(0);

    private Score() {
        this.method = "";
    }

    public Score(Enum<?> method, ArrayList<Float> scores) {
        this.method = method.toString();
        this.scores = new ArrayList<Float>(scores);
    }

    public Score(Enum<?> method, ArrayList<Float> scores, TreeSet<Range> ranges) {
        this.method = method.toString();
        this.ranges = ranges;
        this.scores = scores;
    }

    public Score(Enum<?> method, TreeSet<Range> ranges) {
        this.method = method.toString();
        this.ranges = ranges;
    }

    public Score(Enum<?> method, float[] scores) {
        this.method = method.toString();
        this.scores = this.toList(scores);
    }

    private ArrayList<Float> toList(float[] values) {
        ArrayList<Float> vlist = new ArrayList<Float>();
        for (float v : values) {
            vlist.add(new Float(v));
        }
        return vlist;
    }

    public String getMethod() {
        return this.method;
    }

    public ArrayList<Float> getScores() {
        return this.scores;
    }

    public TreeSet<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(TreeSet<Range> ranges) {
        this.ranges = ranges;
    }

    public String toString() {
        return "Score [method=" + this.method + ", ranges=" + this.ranges + ", scores=" + this.scores + "]";
    }

    public int hashCode() {
        int prime = 7;
        int result = 1;
        result = 7 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 7 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        result = 7 * result + (this.scores == null ? 0 : this.scores.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Score other = (Score)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.ranges == null ? other.ranges != null : !this.ranges.equals(other.ranges)) {
            return false;
        }
        return !(this.scores == null ? other.scores != null : !this.scores.equals(other.scores));
    }

    public static void write(TreeSet<Score> scores, Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer must be provided!");
        }
        for (Score score : scores) {
            writer.write("#" + score.method);
            int count = score.ranges.size();
            for (Range range : score.ranges) {
                writer.write(" " + range.toString());
                if (--count == 0) continue;
                writer.write(",");
            }
            for (Float scoreVal : score.scores) {
                writer.write(" " + NUMBER_FORMAT.format(scoreVal));
            }
            writer.write("\n");
            writer.flush();
        }
        writer.flush();
    }

    @Override
    public int compareTo(Score o) {
        if (this.method.compareTo(o.method) != 0) {
            return this.method.compareTo(o.method);
        }
        int pass = new Integer(this.scores.size()).compareTo(new Integer(o.scores.size()));
        if (pass != 0) {
            return pass;
        }
        for (int i = 0; i < this.scores.size(); ++i) {
            pass = this.scores.get(i).compareTo(o.scores.get(i));
            if (pass == 0) continue;
            return pass * -1;
        }
        pass = new Integer(this.ranges.size()).compareTo(new Integer(o.ranges.size()));
        if (pass != 0) {
            return pass;
        }
        Iterator<Range> thisRange = this.ranges.iterator();
        Iterator<Range> oRange = o.ranges.iterator();
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range oR;
            Range tR = thisRange.next();
            if (tR.compareTo(oR = oRange.next()) == 0) continue;
            return tR.compareTo(oR);
        }
        return 0;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
        NUMBER_FORMAT.setMaximumFractionDigits(3);
    }
}

