/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Vector;

public class ModeleColorMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4055062096061553106L;
    private Vector<Color> _map;
    private Vector<Double> _values;
    public static final Color DEFAULT_COLOR = Color.GREEN;

    public ModeleColorMap() {
        this(new Vector<Color>(), new Vector<Double>());
    }

    public ModeleColorMap(Vector<Color> vector, Vector<Double> vector2) {
        this._map = vector;
        this._values = vector2;
    }

    public void addColor(double d, Color color) {
        int n = Arrays.binarySearch(this._values.toArray(), (Object)d);
        if (n < 0) {
            int n2 = -n - 1;
            this._map.insertElementAt(color, n2);
            this._values.insertElementAt(d, n2);
        }
    }

    public double getMinValue() {
        if (this._values.size() > 0) {
            return this._values.get(0);
        }
        return 0.0;
    }

    public double getMaxValue() {
        if (this._values.size() > 0) {
            return this._values.get(this._values.size() - 1);
        }
        return 0.0;
    }

    public Color getMinColor() {
        if (this._map.size() > 0) {
            return this._map.get(0);
        }
        return DEFAULT_COLOR;
    }

    public Color getMaxColor() {
        if (this._map.size() > 0) {
            return this._map.get(this._map.size() - 1);
        }
        return DEFAULT_COLOR;
    }

    public int getNumColors() {
        return this._map.size();
    }

    public Color getColorAt(int n) {
        return this._map.get(n);
    }

    public Double getValueAt(int n) {
        return this._values.get(n);
    }

    public Color getColorForValue(double d) {
        Color color;
        if (d <= this.getMinValue()) {
            color = this.getMinColor();
        } else if (d >= this.getMaxValue()) {
            color = this.getMaxColor();
        } else {
            int n = Arrays.binarySearch(this._values.toArray(), (Object)d);
            if (n >= 0) {
                color = this._map.get(n);
            } else {
                int n2 = -n - 1;
                Color color2 = this._map.get(n2);
                double d2 = this._values.get(n2);
                if (n2 > 0) {
                    Color color3 = this._map.get(n2 - 1);
                    double d3 = this._values.get(n2 - 1);
                    double d4 = (d3 - d) / (d3 - d2);
                    color = new Color((int)(d4 * (double)color2.getRed() + (1.0 - d4) * (double)color3.getRed()), (int)(d4 * (double)color2.getGreen() + (1.0 - d4) * (double)color3.getGreen()), (int)(d4 * (double)color2.getBlue() + (1.0 - d4) * (double)color3.getBlue()));
                } else {
                    color = color2;
                }
            }
        }
        return color;
    }

    public static ModeleColorMap energyColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(1.0, new Color(128, 50, 50).brighter());
        modeleColorMap.addColor(0.9, new Color(255, 50, 50).brighter());
        modeleColorMap.addColor(0.65, new Color(255, 255, 50).brighter());
        modeleColorMap.addColor(0.55, new Color(20, 255, 50).brighter());
        modeleColorMap.addColor(0.2, new Color(50, 50, 255).brighter());
        modeleColorMap.addColor(0.0, new Color(50, 50, 128).brighter());
        return modeleColorMap;
    }

    public static ModeleColorMap viennaColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, new Color(0, 80, 220));
        modeleColorMap.addColor(0.1, new Color(0, 139, 220));
        modeleColorMap.addColor(0.2, new Color(0, 220, 218));
        modeleColorMap.addColor(0.3, new Color(0, 220, 123));
        modeleColorMap.addColor(0.4, new Color(0, 220, 49));
        modeleColorMap.addColor(0.5, new Color(34, 220, 0));
        modeleColorMap.addColor(0.6, new Color(109, 220, 0));
        modeleColorMap.addColor(0.7, new Color(199, 220, 0));
        modeleColorMap.addColor(0.8, new Color(220, 165, 0));
        modeleColorMap.addColor(0.9, new Color(220, 86, 0));
        modeleColorMap.addColor(1.0, new Color(220, 0, 0));
        return modeleColorMap;
    }

    public static ModeleColorMap bwColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, Color.white);
        modeleColorMap.addColor(1.0, Color.gray.darker());
        return modeleColorMap;
    }

    public static ModeleColorMap greenColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, Color.gray.brighter().brighter());
        modeleColorMap.addColor(1.0, Color.green.darker());
        return modeleColorMap;
    }

    public static ModeleColorMap blueColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, Color.gray.brighter().brighter());
        modeleColorMap.addColor(1.0, Color.blue);
        return modeleColorMap;
    }

    public static ModeleColorMap redColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, Color.gray.brighter().brighter());
        modeleColorMap.addColor(1.0, Color.red);
        return modeleColorMap;
    }

    public static ModeleColorMap heatColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, Color.yellow);
        modeleColorMap.addColor(1.0, Color.red);
        return modeleColorMap;
    }

    public static ModeleColorMap rockNRollColorMap() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap.addColor(0.0, Color.red.brighter());
        modeleColorMap.addColor(1.0, Color.black);
        modeleColorMap.addColor(2.0, Color.green.brighter());
        return modeleColorMap;
    }

    public static ModeleColorMap defaultColorMap() {
        return ModeleColorMap.energyColorMap();
    }

    public static ModeleColorMap parseColorMap(String string) {
        String[] stringArray = string.split("[;,]");
        if (stringArray.length == 1) {
            String string2 = stringArray[0].toLowerCase();
            for (NamedColorMapTypes namedColorMapTypes : NamedColorMapTypes.values()) {
                if (!string2.equals(namedColorMapTypes.getId().toLowerCase())) continue;
                return namedColorMapTypes.getColorMap();
            }
            return ModeleColorMap.defaultColorMap();
        }
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            if (stringArray2.length != 2) continue;
            try {
                Double d = Double.parseDouble(stringArray2[0]);
                Color color = Color.decode(stringArray2[1]);
                modeleColorMap.addColor(d, color);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (modeleColorMap.getNumColors() > 1) {
            return modeleColorMap;
        }
        return ModeleColorMap.defaultColorMap();
    }

    public void setMinValue(double d) {
        this.rescale(d, this.getMaxValue());
    }

    public void setMaxValue(double d) {
        this.rescale(this.getMinValue(), d);
    }

    public void rescale(double d, double d2) {
        double d3 = this.getMinValue();
        double d4 = this.getMaxValue();
        double d5 = d4 - d3;
        if (d2 != d) {
            d2 = Math.max(d2, d + 1.0);
            for (int i = 0; i < this._values.size(); ++i) {
                double d6 = this._values.get(i);
                this._values.set(i, d + (d2 - d) * (d6 - d3) / d5);
            }
        }
    }

    public ModeleColorMap clone() {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        modeleColorMap._map = (Vector)this._map.clone();
        modeleColorMap._values = (Vector)this._values.clone();
        return modeleColorMap;
    }

    public boolean equals(ModeleColorMap modeleColorMap) {
        if (this.getNumColors() != modeleColorMap.getNumColors()) {
            return false;
        }
        for (int i = 0; i < this.getNumColors(); ++i) {
            if (this.getColorAt(i).equals(modeleColorMap.getColorAt(i)) && this.getValueAt(i).equals(modeleColorMap.getValueAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getParamEncoding() {
        String string = "";
        Formatter formatter = new Formatter();
        for (int i = 0; i < this.getNumColors(); ++i) {
            if (i != 0) {
                formatter.format(",", new Object[0]);
            }
            formatter.format("%.2f:#%02X%02X%02X", this._values.get(i), this._map.get(i).getRed(), this._map.get(i).getGreen(), this._map.get(i).getBlue());
        }
        return formatter.out().toString();
    }

    public String toString() {
        return this.getParamEncoding();
    }

    public static enum NamedColorMapTypes {
        RED("red", ModeleColorMap.redColorMap()),
        BLUE("blue", ModeleColorMap.blueColorMap()),
        GREEN("green", ModeleColorMap.greenColorMap()),
        HEAT("heat", ModeleColorMap.heatColorMap()),
        ENERGY("energy", ModeleColorMap.energyColorMap()),
        ROCKNROLL("rocknroll", ModeleColorMap.rockNRollColorMap()),
        VIENNA("vienna", ModeleColorMap.viennaColorMap()),
        BW("bw", ModeleColorMap.bwColorMap());

        String _id;
        ModeleColorMap _cm;

        private NamedColorMapTypes(String string2, ModeleColorMap modeleColorMap) {
            this._id = string2;
            this._cm = modeleColorMap;
        }

        public String getId() {
            return this._id;
        }

        public ModeleColorMap getColorMap() {
            return this._cm;
        }

        public String toString() {
            return this._id;
        }
    }
}

