/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import uk.ac.vamsas.client.AppDataOutputStream;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaIdFactory;
import uk.ac.vamsas.client.VorbaXmlBinder;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SessionFile;
import uk.ac.vamsas.client.simpleclient.SimpleDocument;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.client.simpleclient.VamsasFile;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.DocumentStuff;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;
import uk.ac.vamsas.objects.utils.document.VersionEntries;

public class VamsasArchive {
    private static Log log = LogFactory.getLog((Class)VamsasArchive.class);
    File archive = null;
    SessionFile rchive = null;
    File original = null;
    SessionFile odoclock = null;
    Lock destinationLock = null;
    VamsasArchiveReader odoc = null;
    boolean vamsasdocument = true;
    ZipOutputStream newarchive = null;
    Hashtable entries = null;
    private boolean virginArchive = false;
    File originalBackup = null;
    boolean donotdeletebackup = false;
    private final int _TRANSFER_BUFFER = 16384;
    protected SimpleDocument vorba = null;
    private VamsasDocument _doc = null;

    public static Vobject[] getOriginalRoots(VamsasArchive ths) throws IOException, MarshalException, ValidationException {
        VamsasArchiveReader oReader = ths.getOriginalArchiveReader();
        if (oReader != null) {
            if (oReader.isValid()) {
                InputStreamReader vdoc = new InputStreamReader(oReader.getVamsasDocumentStream());
                VamsasDocument doc = VamsasDocument.unmarshal(vdoc);
                if (doc != null) {
                    return doc.getVAMSAS();
                }
            } else {
                InputStream vxmlis = oReader.getVamsasXmlStream();
                if (vxmlis != null) {
                    BufferedInputStream ixml = new BufferedInputStream(oReader.getVamsasXmlStream());
                    InputStreamReader vxml = new InputStreamReader(ixml);
                    Vobject[] root = new VAMSAS[]{VAMSAS.unmarshal(vxml)};
                    if (root[0] != null) {
                        return root;
                    }
                }
            }
        }
        return null;
    }

    public static VamsasDocument getOriginalVamsasDocument(VamsasArchive ths) throws IOException, MarshalException, ValidationException {
        return VamsasArchive.getOriginalVamsasDocument(ths, null);
    }

    public static VamsasDocument getOriginalVamsasDocument(VamsasArchive ths, VorbaIdFactory vorba) throws IOException, MarshalException, ValidationException {
        VamsasArchiveReader oReader = ths.getOriginalArchiveReader();
        if (oReader != null) {
            ths.setVorba(vorba);
            return ths.vorba.getVamsasDocument(oReader);
        }
        return null;
    }

    public VamsasArchive(File archive, boolean vamsasdocument) throws IOException {
        this(archive, false, vamsasdocument, null);
    }

    public VamsasArchive(File archive, boolean vamsasdocument, boolean overwrite) throws IOException {
        this(archive, overwrite, vamsasdocument, null);
    }

    public VamsasArchive(VamsasFile archive, boolean vamsasdocument, boolean overwrite) throws IOException {
        this(archive.sessionFile, overwrite, vamsasdocument, archive);
    }

    public VamsasArchive(VamsasFile archive) throws IOException {
        this(archive, true, false);
    }

    public VamsasArchive(File archive, boolean overwrite, boolean vamsasdocument, SessionFile extantLock) throws IOException {
        if (archive == null || archive != null && (!archive.getAbsoluteFile().getParentFile().canWrite() || archive.exists() && !archive.canWrite())) {
            log.fatal((Object)("Expect Badness! -- Invalid parameters for VamsasArchive constructor:" + (archive != null ? "File cannot be overwritten." : "Null Object not valid constructor parameter")));
            return;
        }
        this.vamsasdocument = vamsasdocument;
        if (archive.exists() && !overwrite) {
            this.original = archive;
            if (extantLock != null) {
                this.odoclock = extantLock;
                if (this.odoclock.fileLock == null || !this.odoclock.fileLock.isLocked()) {
                    this.odoclock.lockFile();
                }
            } else {
                this.odoclock = new SessionFile(archive);
            }
            this.odoclock.lockFile();
            this.archive = null;
            this.virginArchive = false;
            try {
                this.accessOriginal();
            }
            catch (IOException e) {
                throw new IOException("Lock failed for existing archive" + archive);
            }
        } else {
            this.original = null;
            this.archive = archive;
            this.rchive = extantLock != null ? extantLock : new SessionFile(archive);
            this.rchive.lockFile();
            if (this.rchive.fileLock == null || !this.rchive.fileLock.isLocked()) {
                throw new IOException("Lock failed for new archive" + archive);
            }
            this.rchive.fileLock.getRaFile().setLength(0L);
            this.virginArchive = true;
        }
        this.openArchive();
    }

    private void accessOriginal() throws IOException {
        if (this.original != null && this.original.exists()) {
            if (this.odoclock == null) {
                this.odoclock = new SessionFile(this.original);
            }
            this.odoclock.lockFile();
            if (this.odoc == null) {
                this.odoc = new VamsasArchiveReader(this.original);
            }
        }
    }

    private boolean addEntry(String entry) {
        if (this.entries == null) {
            this.entries = new Hashtable();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("validating '" + entry + "' in hash for " + this));
        }
        if (this.entries.containsKey(entry)) {
            return false;
        }
        this.entries.put(entry, new Integer(this.entries.size()));
        return true;
    }

    private boolean addValidEntry(String entry) throws IOException {
        ZipEntry je = new ZipEntry(entry);
        if (!this.addEntry(entry)) {
            return false;
        }
        this.newarchive.flush();
        this.newarchive.putNextEntry(je);
        return true;
    }

    public File backupFile() {
        if (!this.virginArchive) {
            this.makeBackup();
            this.donotdeletebackup = true;
            return this.original != null ? this.originalBackup : null;
        }
        return null;
    }

    public boolean cancelArchive() {
        if (this.newarchive != null) {
            try {
                this.newarchive.closeEntry();
                this.newarchive.putNextEntry(new ZipEntry("deleted"));
                this.newarchive.closeEntry();
                this.newarchive.close();
            }
            catch (Exception e) {
                log.debug((Object)"Whilst closing newarchive", (Throwable)e);
            }
            if (!this.virginArchive) {
                try {
                    this.recoverBackup();
                }
                catch (Exception e) {
                    log.warn((Object)("Problems when trying to cancel Archive " + this.archive.getAbsolutePath()), (Throwable)e);
                    return false;
                }
            }
        } else {
            log.warn((Object)("Client Error: cancelArchive called before archive(" + this.original.getAbsolutePath() + ") has been opened!"));
        }
        this.closeAndReset();
        return true;
    }

    private void closeAndReset() {
        if (this.rchive != null) {
            this.rchive.unlockFile();
            this.rchive = null;
        }
        if (this.original != null) {
            if (this.odoc != null) {
                this.odoc.close();
                this.odoc = null;
            }
            if (this.archive != null) {
                this.archive.delete();
            }
            if (this.odoclock != null) {
                this.odoclock.unlockFile();
                this.odoclock = null;
            }
        }
        this.removeBackup();
        this.newarchive = null;
        this.original = null;
        this.entries = null;
    }

    public void closeArchive() throws IOException {
        if (this.newarchive != null) {
            this.newarchive.flush();
            this.newarchive.closeEntry();
            if (!this.isDocumentWritten()) {
                log.warn((Object)("Premature closure of archive '" + this.archive.getAbsolutePath() + "': No document has been written."));
            }
            this.newarchive.finish();
            this.newarchive.flush();
            this.updateOriginal();
            this.closeAndReset();
        } else {
            log.warn((Object)"Attempt to close archive that has not been opened for writing.");
        }
    }

    public AppDataOutputStream getAppDataStream(String appdataReference) throws IOException {
        if (this.newarchive == null) {
            throw new IOException("Attempt to write to closed VamsasArchive object.");
        }
        if (this.addValidEntry(appdataReference)) {
            return new AppDataOutputStream(this.newarchive);
        }
        return null;
    }

    protected String getDocumentJarEntry() {
        if (this.vamsasdocument) {
            return "vamsasDocument.xml";
        }
        return "vamsas.xml";
    }

    public PrintWriter getDocumentOutputStream() throws IOException {
        if (this.newarchive == null) {
            this.openArchive();
        }
        if (!this.isDocumentWritten()) {
            try {
                if (this.addValidEntry(this.getDocumentJarEntry())) {
                    return new PrintWriter(new OutputStreamWriter((OutputStream)this.newarchive, "UTF-8"));
                }
            }
            catch (Exception e) {
                log.warn((Object)"Problems opening XML document JarEntry stream", (Throwable)e);
            }
        } else {
            throw new IOException("Vamsas Document output stream is already written.");
        }
        return null;
    }

    public VamsasArchiveReader getOriginalArchiveReader() throws IOException {
        if (!this.virginArchive) {
            this.accessOriginal();
            return this.odoc;
        }
        return null;
    }

    public Vobject[] getOriginalRoots() throws IOException, MarshalException, ValidationException {
        return VamsasArchive.getOriginalRoots(this);
    }

    public VamsasDocument getVamsasDocument() throws IOException, MarshalException, ValidationException {
        return this.getVamsasDocument("org.vamsas.simpleclient.VamsasArchive", "Created new empty document", null);
    }

    public VamsasDocument getVamsasDocument(String provenance_user, String provenance_action, String version) throws IOException, MarshalException, ValidationException {
        if (this._doc != null) {
            return this._doc;
        }
        this._doc = VamsasArchive.getOriginalVamsasDocument(this, this.getVorba());
        if (this._doc != null) {
            return this._doc;
        }
        if (provenance_user == null) {
            provenance_user = "org.vamsas.simpleclient.VamsasArchive";
        }
        if (provenance_action == null) {
            provenance_action = "Created new empty document";
        }
        if (version == null) {
            version = VersionEntries.latestVersion();
        }
        this._doc = DocumentStuff.newVamsasDocument(new VAMSAS[]{new VAMSAS()}, ProvenanceStuff.newProvenance(provenance_user, provenance_action), version);
        return this._doc;
    }

    public VorbaIdFactory getVorba() {
        if (this.vorba == null) {
            this.vorba = new SimpleDocument("simpleclient.VamsasArchive");
        }
        return this.vorba.getVorba();
    }

    protected boolean isDocumentWritten() {
        if (this.newarchive == null) {
            log.warn((Object)"isDocumentWritten() called for unopened archive.");
        }
        return this.entries != null && this.entries.containsKey(this.getDocumentJarEntry());
    }

    private void makeBackup() {
        if (!this.virginArchive && this.originalBackup == null && this.original != null && this.original.exists()) {
            try {
                this.accessOriginal();
                this.originalBackup = this.odoclock.backupSessionFile(null, this.original.getName(), ".bak", this.original.getParentFile());
            }
            catch (IOException e) {
                log.warn((Object)"Problem whilst making a backup of original archive.", (Throwable)e);
            }
        }
    }

    private void openArchive() throws IOException {
        if (this.newarchive != null) {
            log.warn((Object)"openArchive() called multiple times.");
            throw new IOException("Vamsas Archive '" + this.archive.getAbsolutePath() + "' is already open.");
        }
        if (this.archive == null && (this.virginArchive || this.original == null)) {
            log.warn((Object)"openArchive called on uninitialised VamsasArchive object.");
            throw new IOException("Badly initialised VamsasArchive object - no archive file specified.");
        }
        if (!this.virginArchive) {
            this.accessOriginal();
            this.archive = File.createTempFile(this.original.getName(), ".new", this.original.getParentFile());
        } else if (this.archive.exists()) {
            log.warn((Object)"New archive file name already in use! Possible lock failure imminent?");
        }
        if (this.rchive == null) {
            this.rchive = new SessionFile(this.archive);
        }
        if (!this.rchive.lockFile()) {
            throw new IOException("Failed to get lock on file " + this.archive);
        }
        this.newarchive = new ZipOutputStream(this.rchive.fileLock.getBufferedOutputStream(true));
        this.entries = new Hashtable();
    }

    public void putVamsasDocument(VamsasDocument doc) throws IOException, MarshalException, ValidationException {
        this.putVamsasDocument(doc, this.getVorba());
    }

    public void putVamsasDocument(VamsasDocument doc, VorbaIdFactory vorba) throws IOException, MarshalException, ValidationException {
        if (this.vamsasdocument) {
            doc.setVersion(VersionEntries.latestVersion());
        }
        VorbaXmlBinder.putVamsasDocument(this.getDocumentOutputStream(), vorba, doc);
    }

    private void recoverBackup() throws Exception {
        if (this.originalBackup != null) {
            if (this.rchive == null) {
                this.rchive = new SessionFile(this.original);
            }
            SessionFile bckup = new SessionFile(this.originalBackup);
            this.rchive.updateFrom(null, bckup);
            bckup.unlockFile();
            bckup = null;
            this.removeBackup();
        }
    }

    private void removeBackup() {
        if (this.originalBackup != null) {
            log.debug((Object)("Removing backup in " + this.originalBackup.getAbsolutePath()));
            if (!this.donotdeletebackup && !this.originalBackup.delete()) {
                log.info((Object)("VamsasArchive couldn't remove temporary backup " + this.originalBackup.getAbsolutePath()));
            }
            this.originalBackup = null;
        }
    }

    public void setVorba(VorbaIdFactory Vorba) {
        if (Vorba != null) {
            if (this.vorba == null) {
                this.vorba = new SimpleDocument(Vorba);
            } else {
                this.vorba.setVorba(Vorba);
            }
        } else {
            this.getVorba();
        }
    }

    public boolean transferAppDataEntry(String AppDataReference2) throws IOException {
        return this.transferAppDataEntry(AppDataReference2, AppDataReference2);
    }

    protected boolean _validNewAppDataReference(String newAppDataReference) throws IOException {
        if (newAppDataReference == null) {
            throw new IOException("null newAppDataReference!");
        }
        if (this.entries.containsKey(newAppDataReference)) {
            log.warn((Object)("Attempt to write '" + newAppDataReference + "' twice! - IGNORED"));
            return false;
        }
        return true;
    }

    public boolean transferAppDataEntry(String AppDataReference2, String NewAppDataReference) throws IOException {
        if (this.original == null || !this.original.exists()) {
            log.warn((Object)"No backup archive exists.");
            return false;
        }
        if (AppDataReference2 == null) {
            throw new IOException("null AppDataReference!");
        }
        if (!this._validNewAppDataReference(NewAppDataReference)) {
            return false;
        }
        this.accessOriginal();
        InputStream adstream = this.odoc.getAppdataStream(AppDataReference2);
        if (adstream == null) {
            log.warn((Object)("AppDataReference '" + AppDataReference2 + "' doesn't exist in backup archive."));
            return false;
        }
        AppDataOutputStream adout = this.getAppDataStream(NewAppDataReference);
        int written = -1;
        long count = 0L;
        byte[] buffer = new byte[16384];
        do {
            if ((written = adstream.read(buffer)) <= -1) continue;
            ((OutputStream)adout).write(buffer, 0, written);
            log.debug((Object)("Transferring " + written + "."));
            count += (long)written;
        } while (written > -1);
        log.debug((Object)("Sucessfully transferred AppData for '" + AppDataReference2 + "' as '" + NewAppDataReference + "' (" + count + " bytes)"));
        return true;
    }

    public boolean writeAppdataFromStream(String AppDataReference2, InputStream adstream) throws IOException {
        if (!this._validNewAppDataReference(AppDataReference2)) {
            log.warn((Object)"Invalid AppDataReference passed to writeAppdataFromStream");
            throw new IOException("Invalid AppDataReference! (null, or maybe non-unique)!");
        }
        if (AppDataReference2 == null) {
            log.warn((Object)"null appdata passed.");
            throw new IOException("Null AppDataReference");
        }
        AppDataOutputStream adout = this.getAppDataStream(AppDataReference2);
        int written = -1;
        long count = 0L;
        byte[] buffer = new byte[16384];
        do {
            if ((written = adstream.read(buffer)) <= -1) continue;
            ((OutputStream)adout).write(buffer, 0, written);
            log.debug((Object)("Transferring " + written + "."));
            count += (long)written;
        } while (written > -1);
        return true;
    }

    public boolean transferRemainingAppDatas() throws IOException {
        boolean transfered = false;
        if (this.original == null || !this.original.exists()) {
            log.warn((Object)"No backup archive exists.");
            return false;
        }
        this.accessOriginal();
        if (this.getVorba() != null) {
            Vector originalRefs = null;
            try {
                originalRefs = this.vorba.getReferencedEntries(this.getVamsasDocument(), this.getOriginalArchiveReader());
            }
            catch (Exception e) {
                log.warn((Object)"Problems accessing original document entries!", (Throwable)e);
            }
            if (originalRefs != null) {
                Iterator ref = originalRefs.iterator();
                while (ref.hasNext()) {
                    String oldentry = (String)ref.next();
                    if (oldentry == null || this.entries.containsKey(oldentry)) continue;
                    log.debug((Object)("Transferring remaining entry '" + oldentry + "'"));
                    transfered |= this.transferAppDataEntry(oldentry);
                }
            }
        }
        return transfered;
    }

    private void updateOriginal() {
        if (!this.virginArchive) {
            if (this.odoc != null) {
                this.odoc.close();
                this.odoc = null;
            }
            this.makeBackup();
            try {
                this.odoclock.updateFrom(null, this.rchive);
            }
            catch (IOException e) {
                File backupFile = this.backupFile();
                if (backupFile != null) {
                    log.error((Object)("Problem updating archive from temporary file! - backup left in '" + this.backupFile().getAbsolutePath() + "'"), (Throwable)e);
                }
                log.error((Object)"Problems updating, and failed to even make a backup file. Ooops!", (Throwable)e);
            }
            this.removeBackup();
        }
    }
}

