/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.LockFactory;

public class FileWatcher {
    private File subject = null;
    private long[] lastStat;
    boolean waslocked = false;
    boolean exists = false;
    private Lock subjectLock = null;

    private void clearLock() {
        if (this.subjectLock != null) {
            this.subjectLock.release();
        }
        this.subjectLock = null;
    }

    private boolean checkLock() {
        if (this.subject != null && this.subject.exists()) {
            if (this.subjectLock != null) {
                this.subjectLock.release();
            }
            this.subjectLock = LockFactory.tryLock(this.subject);
            if (this.subjectLock.isLocked()) {
                return false;
            }
            this.clearLock();
            return true;
        }
        return false;
    }

    private long[] getStat(File subject) {
        return new long[]{subject.lastModified(), subject.length()};
    }

    private boolean compStat(long[] stat, long[] newstat) {
        return stat[0] == newstat[0] && stat[1] == newstat[1];
    }

    private boolean check() {
        if (this.subject != null) {
            if (!this.subject.exists()) {
                if (this.exists && !this.waslocked) {
                    this.exists = false;
                    return true;
                }
                return false;
            }
            long[] newStat = this.getStat(this.subject);
            if (!this.checkLock()) {
                if (!this.exists || !this.compStat(this.lastStat, newStat)) {
                    this.waslocked = false;
                    this.exists = true;
                    this.lastStat = newStat;
                    return true;
                }
                return false;
            }
            this.waslocked = true;
            return false;
        }
        return false;
    }

    public void setState() {
        if (this.subject != null && (this.exists = this.subject.exists())) {
            this.lastStat = this.getStat(this.subject);
            this.waslocked = false;
        }
    }

    public FileWatcher(File subject) {
        this.subject = subject;
        this.setState();
    }

    public boolean hasChanged() {
        boolean res = this.check();
        this.clearLock();
        return res;
    }

    public Lock getChangedState() {
        boolean res = this.check();
        if (res) {
            return this.subjectLock;
        }
        this.clearLock();
        return null;
    }

    public long[] getCurrentState() {
        return this.getStat(this.subject);
    }

    public boolean diffState(long[] a, long[] b) {
        return this.compStat(a, b);
    }

    public File getSubject() {
        return this.subject;
    }
}

