/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.datamodel.StructureViewerModel;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.AssociatePdbFileWithSeq;
import jalview.gui.ChimeraViewFrame;
import jalview.gui.ChimeraXViewFrame;
import jalview.gui.Desktop;
import jalview.gui.PymolViewer;
import jalview.gui.StructureViewerBase;
import jalview.io.DataSourceType;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureSelectionManager;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StructureViewer {
    private static final String UNKNOWN_VIEWER_TYPE = "Unknown structure viewer type ";
    StructureSelectionManager ssm;
    private boolean superposeAdded = true;
    private boolean async = true;
    JalviewStructureDisplayI sview = null;

    public void setAsync(boolean b) {
        this.async = b;
    }

    public StructureViewer(StructureSelectionManager structureSelectionManager) {
        this.ssm = structureSelectionManager;
    }

    public static StructureViewer reconfigure(JalviewStructureDisplayI display) {
        StructureViewer sv = new StructureViewer(display.getBinding().getSsm());
        sv.sview = display;
        return sv;
    }

    public String toString() {
        if (this.sview != null) {
            return this.sview.toString();
        }
        return "New View";
    }

    public static ViewerType getViewerType() {
        String viewType = Cache.getDefault("STRUCTURE_DISPLAY", ViewerType.JMOL.name());
        return ViewerType.valueOf(viewType);
    }

    public void setViewerType(ViewerType type) {
        Cache.setProperty("STRUCTURE_DISPLAY", type.name());
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry[] pdbs, SequenceI[] seqs, AlignmentPanel ap) {
        return this.viewStructures(pdbs, seqs, ap, null);
    }

    public JalviewStructureDisplayI viewStructures(String structureLocation, DataSourceType type, SequenceI seq, AlignmentPanel ap, boolean prompt, StructureImportSettings.TFType tft, String paeFileSource, boolean forceHeadless, boolean showRefAnnotations, boolean doXferSettings, boolean tempAlignStructures) {
        PDBEntry fileEntry = new AssociatePdbFileWithSeq().associatePdbWithSeq(structureLocation, type, seq, prompt, Desktop.instance, tft, paeFileSource, doXferSettings);
        return this.viewStructures(new PDBEntry[]{fileEntry}, new SequenceI[]{seq}, ap, null, tempAlignStructures);
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry[] pdbs, SequenceI[] seqs, AlignmentPanel ap, ViewerType viewerType) {
        return this.viewStructures(pdbs, seqs, ap, viewerType, this.superposeAdded);
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry[] pdbs, SequenceI[] seqs, final AlignmentPanel ap, ViewerType viewerType, boolean thisSuperpose) {
        JalviewStructureDisplayI viewer = this.onlyOnePdb(pdbs, seqs, ap, thisSuperpose);
        if (viewer != null) {
            return viewer;
        }
        if (viewerType == null) {
            viewerType = StructureViewer.getViewerType();
        }
        Map<PDBEntry, SequenceI[]> seqsForPdbs = this.getSequencesForPdbs(pdbs, seqs);
        final PDBEntry[] pdbsForFile = seqsForPdbs.keySet().toArray(new PDBEntry[seqsForPdbs.size()]);
        final SequenceI[][] theSeqs = (SequenceI[][])seqsForPdbs.values().toArray((T[])new SequenceI[seqsForPdbs.size()][]);
        if (this.sview != null) {
            this.sview.setAlignAddedStructures(thisSuperpose);
            Runnable viewRunnable = new Runnable(){

                @Override
                public void run() {
                    for (int pdbep = 0; pdbep < pdbsForFile.length; ++pdbep) {
                        PDBEntry pdb = pdbsForFile[pdbep];
                        if (StructureViewer.this.sview.addAlreadyLoadedFile(theSeqs[pdbep], null, ap, pdb.getId())) continue;
                        StructureViewer.this.sview.addToExistingViewer(pdb, theSeqs[pdbep], null, ap, pdb.getId());
                    }
                    StructureViewer.this.sview.updateTitleAndMenus();
                }
            };
            if (this.async) {
                new Thread(viewRunnable).start();
            } else {
                viewRunnable.run();
            }
            return this.sview;
        }
        if (viewerType.equals((Object)ViewerType.JMOL)) {
            this.sview = new AppJmol(ap, this.superposeAdded, pdbsForFile, theSeqs);
        } else if (viewerType.equals((Object)ViewerType.CHIMERA)) {
            this.sview = new ChimeraViewFrame(pdbsForFile, this.superposeAdded, theSeqs, ap);
        } else if (viewerType.equals((Object)ViewerType.CHIMERAX)) {
            this.sview = new ChimeraXViewFrame(pdbsForFile, this.superposeAdded, theSeqs, ap);
        } else if (viewerType.equals((Object)ViewerType.PYMOL)) {
            this.sview = new PymolViewer(pdbsForFile, this.superposeAdded, theSeqs, ap);
        } else {
            Console.error(UNKNOWN_VIEWER_TYPE + StructureViewer.getViewerType().toString());
        }
        return this.sview;
    }

    Map<PDBEntry, SequenceI[]> getSequencesForPdbs(PDBEntry[] pdbs, SequenceI[] seqs) {
        if (pdbs == null || seqs == null || pdbs.length != seqs.length) {
            return null;
        }
        HashMap<String, PDBEntry> pdbsSeen = new HashMap<String, PDBEntry>();
        LinkedHashMap pdbSeqs = new LinkedHashMap();
        for (int i = 0; i < pdbs.length; ++i) {
            PDBEntry pdb = pdbs[i];
            SequenceI seq = seqs[i];
            String pdbFile = pdb.getFile();
            if (pdbFile == null || pdbFile.length() == 0) {
                pdbFile = pdb.getId();
            }
            if (!pdbsSeen.containsKey(pdbFile)) {
                pdbsSeen.put(pdbFile, pdb);
                pdbSeqs.put(pdb, new ArrayList());
            } else {
                pdb = (PDBEntry)pdbsSeen.get(pdbFile);
            }
            List seqsForPdb = (List)pdbSeqs.get(pdb);
            if (seqsForPdb.contains(seq)) continue;
            seqsForPdb.add(seq);
        }
        LinkedHashMap<PDBEntry, SequenceI[]> result = new LinkedHashMap<PDBEntry, SequenceI[]>();
        for (Map.Entry entry : pdbSeqs.entrySet()) {
            List theSeqs = (List)entry.getValue();
            result.put((PDBEntry)entry.getKey(), theSeqs.toArray(new SequenceI[theSeqs.size()]));
        }
        return result;
    }

    private JalviewStructureDisplayI onlyOnePdb(PDBEntry[] pdbs, SequenceI[] seqsForPdbs, AlignmentPanel ap) {
        return this.onlyOnePdb(pdbs, seqsForPdbs, ap, this.superposeAdded);
    }

    private JalviewStructureDisplayI onlyOnePdb(PDBEntry[] pdbs, SequenceI[] seqsForPdbs, AlignmentPanel ap, boolean thisSuperpose) {
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        if (pdbs == null || pdbs.length == 0) {
            return null;
        }
        int i = 0;
        String firstFile = pdbs[0].getFile();
        for (PDBEntry pdb : pdbs) {
            SequenceI pdbseq;
            String pdbFile = pdb.getFile();
            if (pdbFile == null || !pdbFile.equals(firstFile)) {
                return null;
            }
            if ((pdbseq = seqsForPdbs[i++]) == null) continue;
            seqs.add(pdbseq);
        }
        return this.viewStructures(pdbs[0], seqs.toArray(new SequenceI[seqs.size()]), ap, null, thisSuperpose);
    }

    public JalviewStructureDisplayI getJalviewStructureDisplay() {
        return this.sview;
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry pdb, SequenceI[] seqsForPdb, AlignmentPanel ap) {
        return this.viewStructures(pdb, seqsForPdb, ap, null);
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry pdb, SequenceI[] seqsForPdb, AlignmentPanel ap, ViewerType viewerType) {
        return this.viewStructures(pdb, seqsForPdb, ap, viewerType, this.superposeAdded);
    }

    public JalviewStructureDisplayI viewStructures(PDBEntry pdb, SequenceI[] seqsForPdb, AlignmentPanel ap, ViewerType viewerType, boolean thisSuperpose) {
        if (this.sview != null) {
            this.sview.setAlignAddedStructures(thisSuperpose);
            String pdbId = pdb.getId();
            if (!this.sview.addAlreadyLoadedFile(seqsForPdb, null, ap, pdbId)) {
                this.sview.addToExistingViewer(pdb, seqsForPdb, null, ap, pdbId);
            }
            this.sview.updateTitleAndMenus();
            this.sview.raiseViewer();
            return this.sview;
        }
        if (viewerType == null) {
            viewerType = StructureViewer.getViewerType();
        }
        if (viewerType.equals((Object)ViewerType.JMOL)) {
            this.sview = new AppJmol(pdb, seqsForPdb, null, ap);
        } else if (viewerType.equals((Object)ViewerType.CHIMERA)) {
            this.sview = new ChimeraViewFrame(pdb, seqsForPdb, null, ap);
        } else if (viewerType.equals((Object)ViewerType.CHIMERAX)) {
            this.sview = new ChimeraXViewFrame(pdb, seqsForPdb, null, ap);
        } else if (viewerType.equals((Object)ViewerType.PYMOL)) {
            this.sview = new PymolViewer(pdb, seqsForPdb, null, ap);
        } else {
            Console.error(UNKNOWN_VIEWER_TYPE + StructureViewer.getViewerType().toString());
        }
        return this.sview;
    }

    public void showAllChains() {
        if (this.sview != null) {
            this.sview.showAllChains();
        }
    }

    public void setPermanentTitle(String title) {
        if (this.sview != null) {
            this.sview.setPermanentTitle(title);
            this.sview.updateTitleAndMenus();
        }
    }

    public static JalviewStructureDisplayI createView(ViewerType type, AlignmentPanel alignPanel, StructureViewerModel viewerData, String sessionFile, String vid) {
        StructureViewerBase viewer = null;
        switch (type) {
            case JMOL: {
                viewer = new AppJmol(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            case CHIMERA: {
                viewer = new ChimeraViewFrame(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            case CHIMERAX: {
                viewer = new ChimeraXViewFrame(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            case PYMOL: {
                viewer = new PymolViewer(viewerData, alignPanel, sessionFile, vid);
                break;
            }
            default: {
                Console.error(UNKNOWN_VIEWER_TYPE + type.toString());
            }
        }
        return viewer;
    }

    public boolean isBusy() {
        return this.sview != null && !this.sview.hasMapping();
    }

    public boolean hasPdbId(String pDBid) {
        if (this.sview == null) {
            return false;
        }
        return this.sview.getBinding().hasPdbId(pDBid);
    }

    public boolean isVisible() {
        return this.sview != null && this.sview.isVisible();
    }

    public void setSuperpose(boolean alignAddedStructures) {
        this.superposeAdded = alignAddedStructures;
    }

    public static enum ViewerType {
        JMOL,
        CHIMERA,
        CHIMERAX,
        PYMOL;


        public static ViewerType getFromString(String viewerString) {
            ViewerType viewerType = null;
            if (!"none".equals(viewerString)) {
                for (ViewerType v : EnumSet.allOf(ViewerType.class)) {
                    if (!viewerString.equals(v.shortName())) continue;
                    viewerType = v;
                    break;
                }
            }
            return viewerType;
        }

        public String shortName() {
            return this.name().toLowerCase(Locale.ROOT).replaceAll(" ", "");
        }
    }
}

