/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationLabels;
import jalview.gui.Desktop;
import jalview.gui.IdCanvas;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.PaintRefresher;
import jalview.gui.PopupMenu;
import jalview.gui.Preferences;
import jalview.gui.SeqPanel;
import jalview.io.SequenceAnnotationReport;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.ViewportRanges;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class IdPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private IdCanvas idCanvas;
    protected AlignmentViewport av;
    protected AlignmentPanel alignPanel;
    ScrollThread scrollThread = null;
    int offy;
    int lastid = -1;
    boolean mouseDragging = false;
    private final SequenceAnnotationReport seqAnnotReport;

    public IdPanel(AlignViewport av, AlignmentPanel parent) {
        this.av = av;
        this.alignPanel = parent;
        this.setIdCanvas(new IdCanvas(av));
        this.seqAnnotReport = new SequenceAnnotationReport(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getIdCanvas(), "Center");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this.alignPanel.getSeqPanel());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        SeqPanel sp = this.alignPanel.getSeqPanel();
        SeqPanel.MousePos pos = sp.findMousePosition(e);
        if (pos.isOverAnnotation()) {
            AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
            AlignmentAnnotation annotation = anns[pos.annotationIndex];
            this.setToolTipText(AnnotationLabels.getTooltip(annotation));
            this.alignPanel.alignFrame.setStatus(AnnotationLabels.getStatusMessage(annotation, anns));
        } else {
            int seq = Math.max(0, pos.seqIndex);
            if (seq < this.av.getAlignment().getHeight()) {
                SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
                StringBuilder tip = new StringBuilder(64);
                tip.append(sequence.getDisplayId(true)).append(" ");
                this.seqAnnotReport.createTooltipAnnotationReport(tip, sequence, this.av.isShowDBRefs(), this.av.isShowNPFeats(), sp.seqCanvas.fr);
                this.setToolTipText(JvSwingUtils.wrapTooltip(true, tip.toString()));
                StringBuilder text = new StringBuilder();
                text.append("Sequence ").append(String.valueOf(seq + 1)).append(" ID: ").append(sequence.getName());
                this.alignPanel.alignFrame.setStatus(text.toString());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragging = true;
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        if (pos.isOverAnnotation()) {
            return;
        }
        int seq = Math.max(0, pos.seqIndex);
        if (seq < this.lastid) {
            this.selectSeqs(this.lastid - 1, seq);
        } else if (seq > this.lastid) {
            this.selectSeqs(this.lastid + 1, seq);
        }
        this.lastid = seq;
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2 || SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        int seq = pos.seqIndex;
        if (pos.isOverAnnotation() || seq < 0) {
            return;
        }
        String id = this.av.getAlignment().getSequenceAt(seq).getName();
        String url = Preferences.sequenceUrlLinks.getPrimaryUrl(id);
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.web_browser_not_found_unix"), MessageManager.getString("label.web_browser_not_found"), 2);
            ex.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.stopScrolling();
    }

    void stopScrolling() {
        if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging) {
            ViewportRanges ranges = this.av.getRanges();
            if (e.getY() < 0 && ranges.getStartSeq() > 0) {
                this.startScrolling(true);
            } else if (e.getY() >= this.getHeight() && ranges.getEndSeq() <= this.av.getAlignment().getHeight()) {
                this.startScrolling(false);
            }
        }
    }

    void startScrolling(boolean up) {
        this.scrollThread = new ScrollThread(up);
        if (Platform.isJS()) {
            final Timer t = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (IdPanel.this.scrollThread != null) {
                        IdPanel.this.scrollThread.scrollOnce();
                    }
                }
            });
            t.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (IdPanel.this.scrollThread == null) {
                        t.stop();
                    }
                }
            });
            t.start();
        } else {
            this.scrollThread.start();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e, pos);
            return;
        }
        if (Platform.isWinRightButton(e)) {
            return;
        }
        if (this.av.getSelectionGroup() == null || !Platform.isControlDown(e) && !e.isShiftDown() && this.av.getSelectionGroup() != null) {
            this.av.setSelectionGroup(new SequenceGroup());
            this.av.getSelectionGroup().setStartRes(0);
            this.av.getSelectionGroup().setEndRes(this.av.getAlignment().getWidth() - 1);
        }
        if (e.isShiftDown() && this.lastid != -1) {
            this.selectSeqs(this.lastid, pos.seqIndex);
        } else {
            this.selectSeq(pos.seqIndex);
        }
        this.av.isSelectionGroupChanged(true);
        this.alignPanel.paintAlignment(false, false);
    }

    void showPopupMenu(MouseEvent e, SeqPanel.MousePos pos) {
        if (pos.isOverAnnotation()) {
            this.showAnnotationMenu(e, pos);
            return;
        }
        Sequence sq = (Sequence)this.av.getAlignment().getSequenceAt(pos.seqIndex);
        if (sq != null) {
            PopupMenu pop = new PopupMenu(this.alignPanel, (SequenceI)sq, Preferences.getGroupURLLinks());
            pop.show(this, e.getX(), e.getY());
        }
    }

    void showAnnotationMenu(MouseEvent e, SeqPanel.MousePos pos) {
        if (pos.annotationIndex == -1) {
            return;
        }
        AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
        if (anns == null || pos.annotationIndex >= anns.length) {
            return;
        }
        AlignmentAnnotation ann = anns[pos.annotationIndex];
        if (!ann.label.contains("Consensus")) {
            return;
        }
        JPopupMenu pop = new JPopupMenu(MessageManager.getString("label.annotations"));
        AnnotationLabels.addConsensusMenuOptions(this.alignPanel, ann, pop);
        pop.show(this, e.getX(), e.getY());
    }

    void selectSeq(int seq) {
        this.lastid = seq;
        SequenceI pickedSeq = this.av.getAlignment().getSequenceAt(seq);
        this.av.getSelectionGroup().addOrRemove(pickedSeq, false);
    }

    void selectSeqs(int start, int end) {
        if (this.av.getSelectionGroup() == null) {
            return;
        }
        if (end >= this.av.getAlignment().getHeight()) {
            end = this.av.getAlignment().getHeight() - 1;
        }
        this.lastid = start;
        if (end < start) {
            int tmp = start;
            start = end;
            this.lastid = end = tmp;
        }
        for (int i = start; i <= end; ++i) {
            this.av.getSelectionGroup().addSequence(this.av.getAlignment().getSequenceAt(i), false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.scrollThread != null) {
            this.stopScrolling();
        }
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        this.mouseDragging = false;
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        this.av.sendSelection();
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e, pos);
        }
    }

    public void highlightSearchResults(List<SequenceI> list) {
        this.getIdCanvas().setHighlighted(list);
        if (list == null || list.isEmpty()) {
            return;
        }
        int index = this.av.getAlignment().findIndex(list.get(0));
        if (this.av.getRanges().getStartSeq() > index || this.av.getRanges().getEndSeq() < index) {
            this.av.getRanges().setStartSeq(index);
        }
    }

    public IdCanvas getIdCanvas() {
        return this.idCanvas;
    }

    public void setIdCanvas(IdCanvas idCanvas) {
        this.idCanvas = idCanvas;
    }

    class ScrollThread
    extends Thread {
        private boolean running = false;
        private boolean up;

        public ScrollThread(boolean up) {
            this.up = up;
            this.setName("IdPanel$ScrollThread$" + String.valueOf(up));
        }

        public void stopScrolling() {
            this.running = false;
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                this.running = this.scrollOnce();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            IdPanel.this.scrollThread = null;
        }

        boolean scrollOnce() {
            ViewportRanges ranges = IdPanel.this.av.getRanges();
            if (ranges.scrollUp(this.up)) {
                int toSeq = this.up ? ranges.getStartSeq() : ranges.getEndSeq();
                int fromSeq = toSeq < IdPanel.this.lastid ? IdPanel.this.lastid - 1 : IdPanel.this.lastid + 1;
                IdPanel.this.selectSeqs(fromSeq, toSeq);
                IdPanel.this.lastid = toSeq;
                IdPanel.this.alignPanel.paintAlignment(false, false);
                return true;
            }
            return false;
        }
    }
}

