/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import java.util.HashSet;
import java.util.Set;

enum Species {
    human(true),
    mouse(true),
    s_cerevisiae(true),
    cow(false),
    pig(false),
    rattus_norvegicus(true),
    celegans(true),
    sheep(false),
    horse(false),
    gorilla(false),
    rabbit(false),
    gibbon(false),
    dog(false),
    orangutan(false),
    xenopus_tropicalis(true),
    chimpanzee(false),
    cat(false),
    zebrafish(true),
    chicken(true),
    drosophila_melanogaster(true);

    static Set<Species> modelOrganisms;
    boolean modelOrganism;

    private Species(boolean model) {
        this.modelOrganism = model;
    }

    boolean isModelOrganism() {
        return this.modelOrganism;
    }

    public static Set<Species> getModelOrganisms() {
        return modelOrganisms;
    }

    static {
        modelOrganisms = new HashSet<Species>();
        for (Species s : Species.values()) {
            if (!s.isModelOrganism()) continue;
            modelOrganisms.add(s);
        }
    }
}

