/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.HiddenCursorPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StartRegionIterator
implements Iterator<Integer> {
    private int start;
    private int end;
    private int currentPosition = 0;
    private List<Integer> positions = null;

    StartRegionIterator(int lowerBound, int upperBound, List<int[]> hiddenColumns) {
        this(null, lowerBound, upperBound, hiddenColumns);
    }

    StartRegionIterator(HiddenCursorPosition pos, int lowerBound, int upperBound, List<int[]> hiddenColumns) {
        this.start = lowerBound;
        this.end = upperBound;
        if (hiddenColumns != null) {
            int[] region;
            int i;
            this.positions = new ArrayList<Integer>(hiddenColumns.size());
            int hiddenSoFar = 0;
            if (pos != null) {
                i = pos.getRegionIndex();
                hiddenSoFar = pos.getHiddenSoFar();
            } else {
                for (i = 0; i < hiddenColumns.size() && hiddenColumns.get(i)[0] < this.start + hiddenSoFar; ++i) {
                    region = hiddenColumns.get(i);
                    hiddenSoFar += region[1] - region[0] + 1;
                }
            }
            while (i < hiddenColumns.size() && hiddenColumns.get(i)[0] <= this.end + hiddenSoFar) {
                region = hiddenColumns.get(i);
                this.positions.add(region[0] - hiddenSoFar);
                hiddenSoFar += region[1] - region[0] + 1;
                ++i;
            }
        } else {
            this.positions = new ArrayList<Integer>();
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.positions.size();
    }

    @Override
    public Integer next() {
        int result = this.positions.get(this.currentPosition);
        ++this.currentPosition;
        return result;
    }
}

