/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class SecStrConsensus {
    public static int[] extractConsensus(ArrayList<ArrayList<SimpleBP>> bps) {
        int maxlength = 0;
        for (ArrayList<SimpleBP> strs : bps) {
            for (SimpleBP simpleBP : strs) {
                maxlength = Math.max(1 + Math.max(simpleBP.bp5, simpleBP.bp3), maxlength);
            }
        }
        ArrayList<Hashtable<Integer, Double>> seq = new ArrayList<Hashtable<Integer, Double>>();
        for (int i = 0; i < maxlength; ++i) {
            seq.add(new Hashtable());
        }
        for (ArrayList<SimpleBP> strs : bps) {
            for (SimpleBP bp : strs) {
                int i = bp.bp5;
                int j = bp.bp3;
                Hashtable<Integer, Double> h = seq.get(i);
                if (!h.containsKey(j)) {
                    h.put(j, 0.0);
                }
                h.put(j, h.get(j) + 1.0);
            }
        }
        double[][] mat = SecStrConsensus.fillMatrix(seq);
        ArrayList<SimpleBP> res = SecStrConsensus.backtrack(mat, seq);
        int[] nArray = new int[seq.size()];
        for (int i = 0; i < seq.size(); ++i) {
            nArray[i] = -1;
        }
        for (SimpleBP bp : res) {
            nArray[bp.bp5] = bp.bp3;
            nArray[bp.bp3] = bp.bp5;
        }
        return nArray;
    }

    private static boolean canBasePair(ArrayList<Hashtable<Integer, Double>> seq, int i, int k) {
        return seq.get(i).containsKey(k);
    }

    private static double basePairScore(ArrayList<Hashtable<Integer, Double>> seq, int i, int k) {
        return seq.get(i).get(k);
    }

    private static double[][] fillMatrix(ArrayList<Hashtable<Integer, Double>> seq) {
        int n = seq.size();
        double[][] tab = new double[n][n];
        for (int m = 1; m <= n; ++m) {
            for (int i = 0; i < n - m + 1; ++i) {
                int j = i + m - 1;
                tab[i][j] = 0.0;
                if (i >= j) continue;
                tab[i][j] = Math.max(tab[i][j], tab[i + 1][j]);
                for (int k = i + 1; k <= j; ++k) {
                    if (!SecStrConsensus.canBasePair(seq, i, k)) continue;
                    double fact1 = 0.0;
                    if (k > i + 1) {
                        fact1 = tab[i + 1][k - 1];
                    }
                    double fact2 = 0.0;
                    if (k < j) {
                        fact2 = tab[k + 1][j];
                    }
                    tab[i][j] = Math.max(tab[i][j], SecStrConsensus.basePairScore(seq, i, k) + fact1 + fact2);
                }
            }
        }
        return tab;
    }

    private static ArrayList<SimpleBP> backtrack(double[][] tab, ArrayList<Hashtable<Integer, Double>> seq) {
        return SecStrConsensus.backtrack(tab, seq, 0, seq.size() - 1);
    }

    private static ArrayList<SimpleBP> backtrack(double[][] tab, ArrayList<Hashtable<Integer, Double>> seq, int i, int j) {
        ArrayList<SimpleBP> result = new ArrayList<SimpleBP>();
        if (i < j) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            indices.add(-1);
            for (int k = i + 1; k <= j; ++k) {
                indices.add(k);
            }
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                if (k == -1) {
                    if (tab[i][j] != tab[i + 1][j]) continue;
                    result = SecStrConsensus.backtrack(tab, seq, i + 1, j);
                    continue;
                }
                if (!SecStrConsensus.canBasePair(seq, i, k)) continue;
                double fact1 = 0.0;
                if (k > i + 1) {
                    fact1 = tab[i + 1][k - 1];
                }
                double fact2 = 0.0;
                if (k < j) {
                    fact2 = tab[k + 1][j];
                }
                if (tab[i][j] != SecStrConsensus.basePairScore(seq, i, k) + fact1 + fact2) continue;
                result = SecStrConsensus.backtrack(tab, seq, i + 1, k - 1);
                result.addAll(SecStrConsensus.backtrack(tab, seq, k + 1, j));
                result.add(new SimpleBP(i, k));
            }
        } else if (i == j) {
            // empty if block
        }
        return result;
    }

    public static class SimpleBP {
        int bp5;
        int bp3;

        public SimpleBP() {
        }

        public SimpleBP(int i5, int i3) {
            this.bp5 = i5;
            this.bp3 = i3;
        }

        public void setBP5(int i5) {
            this.bp5 = i5;
        }

        public void setBP3(int i3) {
            this.bp3 = i3;
        }

        public int getBP5() {
            return this.bp5;
        }

        public int getBP3() {
            return this.bp3;
        }

        public String toString() {
            return "(" + this.bp5 + "," + this.bp3 + ")";
        }
    }
}

