/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.DisemblResult;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.GlobProtResult;
import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.AllTestSuit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SequenceUtilTester {
    @Test
    public void isNonAmbNucleotideSequence() {
        String dnaseq = "atgatTGACGCTGCTGatgtcgtgagtgga";
        AssertJUnit.assertTrue((boolean)SequenceUtil.isNonAmbNucleotideSequence(dnaseq));
        String dirtyDnaseq = "atgAGTggt\taGGTgc\ncgcACTgc gACtcgcGAt cgA ";
        AssertJUnit.assertTrue((boolean)SequenceUtil.isNonAmbNucleotideSequence(dirtyDnaseq));
        String nonDna = "atgfctgatgcatgcatgatgctga";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isNonAmbNucleotideSequence(nonDna));
        nonDna = "atgc1tgatgcatgcatgatgctga";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isNonAmbNucleotideSequence(nonDna));
        nonDna = "ARLGRVRWTQQRHAEAAVLLQQASDAAPEHPGIALWLGHALEDAGQAEAAAAAYTRAHQL";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isNonAmbNucleotideSequence(nonDna));
        AssertJUnit.assertFalse((boolean)SequenceUtil.isNonAmbNucleotideSequence(nonDna));
    }

    @Test
    public void CleanSequence() {
        String dirtySeq = "atgAGTggt\taGGTgc\ncgcAC\rTgc gACtcgcGAt cgA ";
        AssertJUnit.assertEquals((String)"atgAGTggtaGGTgccgcACTgcgACtcgcGAtcgA".toUpperCase(), (String)SequenceUtil.cleanSequence(dirtySeq));
    }

    @Test
    public void DeepCleanSequence() {
        String dirtySeq = "a!t?g.A;GTggt\ta12GGTgc\ncgc23AC\rTgc gAC<>.,?!|\\|/t@cg-c\u00acGA=_+(0){]}[:\u00a3$&^*\"t cgA ";
        AssertJUnit.assertEquals((String)"atgAGTggtaGGTgccgcACTgcgACtcgcGAtcgA".toUpperCase(), (String)SequenceUtil.deepCleanSequence(dirtySeq));
    }

    @Test
    public void isProteinSequence() {
        String dirtySeq = "atgAGTggt\taGGTgc\ncgcAC\rTgc gACtcgcGAt cgA ";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(dirtySeq));
        String notaSeq = "atgc1tgatgcatgcatgatgctga";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(notaSeq));
        String AAseq = "ARLGRVRWTQQRHAEAAVLLQQASDAAPEHPGIALWLGHALEDAGQAEAAAAAYTRAHQL";
        AssertJUnit.assertTrue((boolean)SequenceUtil.isProteinSequence(AAseq));
        AAseq = AAseq + "XU";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(AAseq));
    }

    @Test
    public void CleanProteinSequence() {
        String dirtySeq = "atgAGTggt\taGGTgc\ncgcAC\rTgc gACtcgcGAt cgA ";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(dirtySeq));
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(SequenceUtil.cleanProteinSequence(dirtySeq)));
        String notaSeq = "atgc1tgatgcatgcatgatgmctga";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(notaSeq));
        AssertJUnit.assertTrue((boolean)SequenceUtil.isProteinSequence(SequenceUtil.cleanProteinSequence(notaSeq)));
        String AAseq = "ARLGRVRWTQQRHAEAAVLLQQASDAAPEHPGIALWLGHALEDAGQAEAAAAAYTRAHQL";
        AssertJUnit.assertTrue((boolean)SequenceUtil.isProteinSequence(AAseq));
        AssertJUnit.assertTrue((boolean)SequenceUtil.isProteinSequence(SequenceUtil.cleanProteinSequence(AAseq)));
        AAseq = AAseq + "XU";
        AssertJUnit.assertFalse((boolean)SequenceUtil.isProteinSequence(AAseq));
        AssertJUnit.assertTrue((boolean)SequenceUtil.isProteinSequence(SequenceUtil.cleanProteinSequence(AAseq)));
    }

    @Test
    public void ReadWriteFasta() {
        try {
            FileInputStream fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "TO1381.fasta");
            AssertJUnit.assertNotNull((Object)fio);
            List<FastaSequence> fseqs = SequenceUtil.readFasta(fio);
            AssertJUnit.assertNotNull(fseqs);
            AssertJUnit.assertEquals((int)3, (int)fseqs.size());
            AssertJUnit.assertEquals((int)3, (int)fseqs.size());
            fio.close();
            FileOutputStream fou = new FileOutputStream(AllTestSuit.TEST_DATA_PATH + "TO1381.fasta.written");
            SequenceUtil.writeFasta(fou, fseqs);
            fou.close();
            FileOutputStream fou20 = new FileOutputStream(AllTestSuit.TEST_DATA_PATH + "TO1381.fasta20.written");
            SequenceUtil.writeFasta(fou20, fseqs, 21);
            fou20.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void testReadFastaWriteClustal() {
        try {
            FileInputStream fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "TO1381.fasta");
            AssertJUnit.assertNotNull((Object)fio);
            List<FastaSequence> fseqs = SequenceUtil.readFasta(fio);
            AssertJUnit.assertNotNull(fseqs);
            fio.close();
            char gapChar = '-';
            FileOutputStream fou = new FileOutputStream(AllTestSuit.TEST_DATA_PATH + "TO1381.aln.written");
            SequenceUtil.writeClustal(fou, fseqs, gapChar);
            fou.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void LoadJronnFile() {
        try {
            FileInputStream fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "jronn.out");
            Map<String, Score> aseqs = SequenceUtil.readJRonn(fio);
            AssertJUnit.assertNotNull(aseqs);
            AssertJUnit.assertEquals((int)aseqs.size(), (int)3);
            Score aseq = aseqs.get("Foobar");
            AssertJUnit.assertNotNull((Object)aseq);
            AssertJUnit.assertNotNull(aseq.getScores());
            AssertJUnit.assertEquals((int)aseq.getScores().size(), (int)aseq.getScores().size());
            fio.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (UnknownFileFormatException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void ReadDisemblResults() {
        HashMap _ranges = new HashMap();
        HashMap ranges = new HashMap();
        HashMap _values = new HashMap();
        HashMap<String, Float> values = new HashMap<String, Float>();
        HashSet<Range> rset = new HashSet<Range>();
        for (String[] se : new String[][]{{"34", "41"}, {"50", "58"}, {"83", "91"}, {"118", "127"}, {" 160", "169"}, {" 191", "220"}, {" 243", "252"}, {" 287", "343"}, {" 350", "391"}, {" 429", "485"}, {" 497", "506"}, {"539", "547"}}) {
            rset.add(new Range(se));
        }
        ranges.put(DisemblResult.COILS.toString(), rset);
        values.put(DisemblResult.COILS.toString(), Float.valueOf(0.8601f));
        rset = new HashSet();
        for (String[] se : new String[][]{{"355", "368"}}) {
            rset.add(new Range(se));
        }
        ranges.put(DisemblResult.REM465.toString(), rset);
        values.put(DisemblResult.REM465.toString(), Float.valueOf(0.88512f));
        rset = new HashSet();
        for (String[] se : new String[][]{{"190", "204"}}) {
            rset.add(new Range(se));
        }
        ranges.put(DisemblResult.HOTLOOPS.toString(), rset);
        values.put(DisemblResult.HOTLOOPS.toString(), Float.valueOf(0.37094f));
        _ranges.put("Foobar_dundeefriends", ranges);
        _values.put("Foobar_dundeefriends", values);
        try {
            FileInputStream fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "disembl.out");
            HashMap<String, Set<Score>> aseqs = SequenceUtil.readDisembl(fio);
            AssertJUnit.assertNotNull(aseqs);
            AssertJUnit.assertEquals((int)aseqs.size(), (int)3);
            ScoreManager sman = ScoreManager.newInstance(aseqs);
            for (String fs : aseqs.keySet()) {
                AssertJUnit.assertTrue((boolean)" Foobar_dundeefriends Foobar dundeefriends ".contains(fs));
                Set scores = (Set)aseqs.get(fs);
                AssertJUnit.assertEquals((int)scores.size(), (int)3);
                for (Score sc : scores) {
                    if (!_ranges.containsKey(fs)) continue;
                    AssertJUnit.assertEquals((String)("Checking range for Method " + sc.getMethod()), ((Map)_ranges.get(fs)).get(sc.getMethod()), sc.getRanges());
                    AssertJUnit.assertEquals((String)("Checking first value for Method " + sc.getMethod()), ((Map)_values.get(fs)).get(sc.getMethod()), (Object)sc.getScores().get(0));
                }
            }
            fio.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (UnknownFileFormatException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void ReadGlobPlotResults() {
        try {
            FileInputStream fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "globplot.out");
            HashMap<String, Set<Score>> aseqs = SequenceUtil.readGlobPlot(fio);
            AssertJUnit.assertNotNull(aseqs);
            AssertJUnit.assertEquals((int)aseqs.size(), (int)3);
            String fsdf = null;
            Set<Score> scores = null;
            for (String fs : aseqs.keySet()) {
                if ("Foobar_dundeefriends".contains(fs)) {
                    fsdf = fs;
                    scores = aseqs.get(fs);
                }
                AssertJUnit.assertEquals((int)scores.size(), (int)5);
            }
            ScoreManager sm = ScoreManager.newInstanceSingleSequence(scores);
            sm.writeOut(new PrintWriter(System.out, true));
            for (Score score : scores) {
                if (score.getMethod().equals(GlobProtResult.Disorder.toString())) {
                    AssertJUnit.assertEquals((int)score.getRanges().size(), (int)7);
                    AssertJUnit.assertTrue((boolean)score.getScores().isEmpty());
                }
                if (GlobProtResult.valueOf(score.getMethod()) != GlobProtResult.Dydx) continue;
                AssertJUnit.assertFalse((boolean)score.getScores().isEmpty());
                AssertJUnit.assertTrue((boolean)score.getRanges().isEmpty());
            }
            fio.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (UnknownFileFormatException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void ReadIUPredForShortAndLongDisorder() {
        try {
            Map<String, Score> scores = SequenceUtil.readIUPred(new File(AllTestSuit.TEST_DATA_PATH, "out.long"));
            ScoreManager man = ScoreManager.newInstanceSingleScore(scores);
            AssertJUnit.assertNotNull(scores);
            AssertJUnit.assertEquals((int)3, (int)scores.size());
            Score score = scores.get("Foobar_dundeefriends");
            AssertJUnit.assertNotNull((Object)score);
            AssertJUnit.assertEquals((int)0, (int)score.getRanges().size());
            AssertJUnit.assertEquals((int)568, (int)score.getScores().size());
            AssertJUnit.assertEquals((String)"Long", (String)score.getMethod());
            score = scores.get("Foobar");
            AssertJUnit.assertNotNull((Object)score);
            AssertJUnit.assertEquals((int)0, (int)score.getRanges().size());
            AssertJUnit.assertEquals((int)481, (int)score.getScores().size());
            AssertJUnit.assertEquals((String)"Long", (String)score.getMethod());
            score = scores.get("dundeefriends");
            AssertJUnit.assertNotNull((Object)score);
            AssertJUnit.assertEquals((int)0, (int)score.getRanges().size());
            AssertJUnit.assertEquals((int)513, (int)score.getScores().size());
            AssertJUnit.assertEquals((String)"Long", (String)score.getMethod());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (UnknownFileFormatException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void ReadIUPredForGlobDomain() {
        try {
            Map<String, Score> scores = SequenceUtil.readIUPred(new File(AllTestSuit.TEST_DATA_PATH, "output.glob"));
            AssertJUnit.assertNotNull(scores);
            AssertJUnit.assertEquals((int)2, (int)scores.size());
            ScoreManager man = ScoreManager.newInstanceSingleScore(scores);
            AssertJUnit.assertEquals((int)2, (int)man.getNumberOfSeq());
            Score score = scores.get("P53_HUMA");
            AssertJUnit.assertNotNull((Object)score);
            AssertJUnit.assertEquals((int)2, (int)score.getRanges().size());
            AssertJUnit.assertEquals((int)0, (int)score.getScores().size());
            AssertJUnit.assertEquals((String)"Glob", (String)score.getMethod());
            score = scores.get("Foobar_dundeefriends");
            AssertJUnit.assertEquals((int)0, (int)score.getRanges().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (UnknownFileFormatException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void ReadAAConResults() {
        try {
            FileInputStream inStream = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "aacon_results.txt");
            HashSet<Score> result = SequenceUtil.readAAConResults(inStream);
            ((InputStream)inStream).close();
            AssertJUnit.assertNotNull(result);
            AssertJUnit.assertEquals((int)result.size(), (int)18);
            inStream = new FileInputStream(AllTestSuit.TEST_DATA_PATH + "aacon_result_single.out");
            result = SequenceUtil.readAAConResults(inStream);
            ((InputStream)inStream).close();
            AssertJUnit.assertNotNull(result);
            AssertJUnit.assertEquals((int)result.size(), (int)1);
            AssertJUnit.assertEquals((int)result.iterator().next().getScores().size(), (int)568);
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
    }

    static enum Trial {
        one,
        two,
        three;

    }
}

