/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient.simpleapp;

import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.test.simpleclient.ArchiveClient;
import uk.ac.vamsas.test.simpleclient.ClientDoc;
import uk.ac.vamsas.test.simpleclient.simpleapp.VamsasDatastore;

public class VamsasClient
extends ArchiveClient {
    Log log = LogFactory.getLog((Class)VamsasClient.class);
    VamsasClientWatcher watcher = null;
    IdentityHashMap jv2vobj = null;
    Hashtable vobj2jv = null;

    public VamsasClient(File sessionPath) {
        super(System.getProperty("user.name"), System.getProperty("host.name"), "SimpleVamsasClientApp", "0.1", sessionPath);
    }

    public void initial_update() {
        this.log.info((Object)"Jalview loading the Vamsas Session.");
        ClientDoc cdoc = this.getUpdateable();
        this.updateJalview(cdoc);
        cdoc.closeDoc();
    }

    public void push_update() {
        this.watchForChange = false;
        try {
            Thread.sleep(WATCH_SLEEP);
        }
        catch (Exception e) {
            // empty catch block
        }
        ClientDoc cdoc = this.getUpdateable();
        this.updateVamsasDocument(cdoc);
        this.doUpdate(cdoc);
        cdoc.closeDoc();
        cdoc = null;
        this.watchForChange = true;
        this.startWatcher();
    }

    public void end_session() {
        this.watchForChange = false;
        try {
            Thread.sleep(WATCH_SLEEP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.info((Object)"VamsasClientApplication disconnecting from the Vamsas Session.");
    }

    public void updateJalview(ClientDoc cdoc) {
        this.ensureVamsasBindings();
        VamsasDatastore vds = new VamsasDatastore(cdoc, this.vobj2jv, this.jv2vobj, this.baseProvEntry());
        vds.updateToJalview();
    }

    private void ensureVamsasBindings() {
        if (this.jv2vobj == null) {
            this.jv2vobj = new IdentityHashMap();
            this.vobj2jv = new Hashtable();
        }
    }

    public void updateVamsasDocument(ClientDoc doc) {
        this.ensureVamsasBindings();
        VamsasDatastore vds = new VamsasDatastore(doc, this.vobj2jv, this.jv2vobj, this.baseProvEntry());
        vds.storeVAMSAS(new Object());
    }

    private Entry baseProvEntry() {
        Entry pentry = new Entry();
        pentry.setUser(this.getProvenanceUser());
        pentry.setApp(this.getClientHandle().getClientName());
        pentry.setDate(new Date());
        pentry.setAction("created");
        return pentry;
    }

    public static void main(String[] args) {
    }

    public void disableGui(boolean b) {
    }

    public void startWatcher() {
        if (this.watcher == null) {
            this.watcher = new VamsasClientWatcher(this);
        }
        Thread thr = new Thread(){

            public void run() {
                VamsasClient.this.watcher.start();
            }
        };
        thr.start();
    }

    protected class VamsasClientWatcher
    extends Thread
    implements Runnable {
        VamsasClient client = null;
        boolean running = false;

        VamsasClientWatcher(VamsasClient client) {
            this.client = client;
        }

        public void run() {
            this.running = true;
            while (this.client.watchForChange) {
                ClientDoc docio = this.client.watch(0L);
                if (docio == null) continue;
                this.client.disableGui(true);
                VamsasClient.this.log.debug((Object)"Updating VamsasClient app from changed vamsas document.");
                this.client.updateJalview(docio);
                VamsasClient.this.log.debug((Object)"Finished updating from document change.");
                docio.closeDoc();
                docio = null;
                this.client.disableGui(false);
            }
            this.running = false;
        }
    }
}

