/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.renderer.seqfeatures.FeatureRenderer;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import jalview.workers.AlignCalcWorker;
import jalview.workers.FeatureSetCounterI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

class ColumnCounterSetWorker
extends AlignCalcWorker {
    FeatureSetCounterI counter;

    public ColumnCounterSetWorker(AlignViewportI viewport, AlignmentViewPanel panel, FeatureSetCounterI counter) {
        super(viewport, panel);
        this.ourAnnots = new ArrayList();
        this.counter = counter;
        this.calcMan.registerWorker(this);
    }

    @Override
    public void run() {
        boolean annotationAdded;
        block14: {
            annotationAdded = false;
            try {
                this.calcMan.notifyStart(this);
                while (!this.calcMan.notifyWorking(this)) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (this.alignViewport.isClosed()) {
                    this.abortAndDestroy();
                    return;
                }
                if (this.alignViewport.getAlignment() == null) break block14;
                try {
                    annotationAdded = this.computeAnnotations();
                }
                catch (IndexOutOfBoundsException x) {
                    this.calcMan.workerComplete(this);
                    return;
                }
            }
            catch (OutOfMemoryError error) {
                this.ap.raiseOOMWarning("calculating feature counts", error);
                this.calcMan.disableWorker(this);
            }
            finally {
                this.calcMan.workerComplete(this);
            }
        }
        if (this.ap != null) {
            if (annotationAdded) {
                this.ap.adjustAnnotationHeight();
            }
            this.ap.paintAlignment(true, true);
        }
    }

    boolean computeAnnotations() {
        FeatureRenderer fr = new FeatureRenderer(this.alignViewport);
        AlignmentI alignment = this.alignViewport.getAlignment();
        int rows = this.counter.getNames().length;
        int width = alignment.getWidth();
        int height = alignment.getHeight();
        int[][] counts = new int[width][rows];
        int[] max = new int[rows];
        for (int crow = 0; crow < rows; ++crow) {
            max[crow] = 0;
        }
        int[] minC = this.counter.getMinColour();
        int[] maxC = this.counter.getMaxColour();
        Color minColour = new Color(minC[0], minC[1], minC[2]);
        Color maxColour = new Color(maxC[0], maxC[1], maxC[2]);
        for (int col = 0; col < width; ++col) {
            int crow;
            int[] count = counts[col];
            for (crow = 0; crow < rows; ++crow) {
                count[crow] = 0;
            }
            for (int row = 0; row < height; ++row) {
                int[] colcount = this.countFeaturesAt(alignment, col, row, fr);
                if (colcount == null) continue;
                for (int crow2 = 0; crow2 < rows; ++crow2) {
                    int n = crow2;
                    count[n] = count[n] + colcount[crow2];
                }
            }
            counts[col] = count;
            for (crow = 0; crow < rows; ++crow) {
                max[crow] = Math.max(count[crow], max[crow]);
            }
        }
        boolean annotationAdded = false;
        for (int anrow = 0; anrow < rows; ++anrow) {
            Annotation[] anns = new Annotation[width];
            long rmax = 0L;
            for (int i = 0; i < counts.length; ++i) {
                int count = counts[i][anrow];
                Color color = ColorUtils.getGraduatedColour(count, 0.0f, minColour, max[anrow], maxColour);
                String str = String.valueOf(count);
                anns[i] = new Annotation(str, str, '0', count, color);
                rmax = Math.max((long)count, rmax);
            }
            String description = this.counter.getDescriptions()[anrow];
            if (!alignment.findAnnotation(description).iterator().hasNext()) {
                annotationAdded = true;
            }
            AlignmentAnnotation ann = alignment.findOrCreateAnnotation(this.counter.getNames()[anrow], description, false, null, null);
            ann.description = description;
            ann.showAllColLabels = true;
            ann.scaleColLabel = true;
            ann.graph = 1;
            ann.annotations = anns;
            ann.graphMin = 0.0f;
            ann.graphMax = rmax;
            ann.validateRangeAndDisplay();
            if (this.ourAnnots.contains(ann)) continue;
            this.ourAnnots.add(ann);
        }
        return annotationAdded;
    }

    int[] countFeaturesAt(AlignmentI alignment, int col, int row, FeatureRenderer fr) {
        SequenceI seq = alignment.getSequenceAt(row);
        if (seq == null) {
            return null;
        }
        if (col >= seq.getLength()) {
            return null;
        }
        char res = seq.getCharAt(col);
        if (Comparison.isGap(res)) {
            return null;
        }
        List<SequenceFeature> features = fr.findFeaturesAtColumn(seq, col + 1);
        int[] count = this.counter.count(String.valueOf(res), features);
        return count;
    }

    @Override
    public void updateAnnotation() {
    }

    @Override
    public boolean isDeletable() {
        return true;
    }
}

