/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueColourScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;

public class TCoffeeColourScheme
extends ResidueColourScheme {
    IdentityHashMap<SequenceI, Color[]> seqMap;

    public TCoffeeColourScheme() {
    }

    public TCoffeeColourScheme(AnnotatedCollectionI alignment) {
        this.alignmentChanged(alignment, null);
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        AnnotatedCollectionI alcontext;
        ArrayList<AlignmentAnnotation> annots = new ArrayList<AlignmentAnnotation>();
        this.seqMap = new IdentityHashMap();
        AnnotatedCollectionI annotatedCollectionI = alcontext = alignment instanceof AlignmentI ? alignment : alignment.getContext();
        if (alcontext == null) {
            return;
        }
        int w = 0;
        for (AlignmentAnnotation al : alcontext.findAnnotation("TCoffeeScore")) {
            if (al.sequenceRef == null || al.belowAlignment) continue;
            annots.add(al);
            if (w < al.annotations.length) {
                w = al.annotations.length;
            }
            Color[] scores = new Color[al.annotations.length];
            int i = 0;
            for (Annotation an : al.annotations) {
                scores[i++] = an != null ? an.colour : Color.white;
            }
            this.seqMap.put(al.sequenceRef, scores);
        }
    }

    @Override
    public Color findColour(char c, int j, SequenceI seq) {
        if (this.seqMap == null) {
            return Color.WHITE;
        }
        Color[] cols = this.seqMap.get(seq);
        if (cols == null) {
            return Color.white;
        }
        if (j < 0 || j >= cols.length) {
            return Color.white;
        }
        return cols[j];
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI sg) {
        return new TCoffeeColourScheme(sg);
    }

    @Override
    public boolean isApplicableTo(AnnotatedCollectionI ac) {
        AnnotatedCollectionI alcontext;
        AnnotatedCollectionI annotatedCollectionI = alcontext = ac instanceof AlignmentI ? ac : ac.getContext();
        if (alcontext == null) {
            return false;
        }
        Iterable<AlignmentAnnotation> anns = alcontext.findAnnotation("TCoffeeScore");
        return anns.iterator().hasNext();
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.TCoffee.toString();
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

