/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.schemes.UserColourScheme;
import jalview.util.ColorUtils;
import java.awt.Color;

public class ColourSchemeProperty {
    public static Color[] rnaHelices = null;

    public static ColourSchemeI getColourScheme(AlignViewportI view, AnnotatedCollectionI forData, String name) {
        if ("None".equalsIgnoreCase(name)) {
            return null;
        }
        ColourSchemeI scheme = ColourSchemes.getInstance().getColourScheme(name, view, forData, null);
        if (scheme != null) {
            return scheme;
        }
        UserColourScheme ucs = new UserColourScheme(name);
        return ucs;
    }

    public static void initRnaHelicesShading(int n) {
        int j = 0;
        if (rnaHelices == null) {
            rnaHelices = new Color[n + 1];
        } else if (rnaHelices != null && rnaHelices.length <= n) {
            Color[] t = new Color[n + 1];
            System.arraycopy(rnaHelices, 0, t, 0, rnaHelices.length);
            j = rnaHelices.length;
            rnaHelices = t;
        } else {
            return;
        }
        while (j <= n) {
            ColourSchemeProperty.rnaHelices[j] = ColorUtils.generateRandomColor(Color.white);
            ++j;
        }
    }

    public static void resetRnaHelicesShading() {
        rnaHelices = null;
    }

    public static String getColourName(ColourSchemeI cs) {
        return cs == null ? "None" : cs.getSchemeName();
    }
}

