/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui.structurechooser;

import jalview.bin.Console;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.service.threedbeacons.TDB_FTSData;
import jalview.fts.service.threedbeacons.TDBeaconsFTSRestClient;
import jalview.gui.structurechooser.PDBStructureChooserQuerySource;
import jalview.gui.structurechooser.StructureChooserQuerySource;
import jalview.gui.structurechooser.TDBResultAnalyser;
import jalview.jbgui.FilterOption;
import jalview.structure.StructureImportSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JTable;

public class ThreeDBStructureChooserQuerySource
extends StructureChooserQuerySource {
    private Set<String> tdBeaconsFilters = null;
    private Set<String> defaultFilters = new LinkedHashSet<String>();
    public static final String FILTER_TDBEACONS_COVERAGE = "3d_beacons_coverage";
    public static final String FILTER_FIRST_BEST_COVERAGE = "3d_beacons_first_best_coverage";
    private static final String FILTER_SOURCE_PREFIX = "only_";
    protected FTSRestRequest lastTdbRequest;
    protected FTSRestClientI tdbRestClient;
    private FTSRestRequest lastPdbRequest;
    PDBStructureChooserQuerySource pdbQuerySource = null;

    public ThreeDBStructureChooserQuerySource() {
        this.defaultFilters.add(FILTER_TDBEACONS_COVERAGE);
        this.defaultFilters.add(FILTER_FIRST_BEST_COVERAGE);
        this.tdbRestClient = TDBeaconsFTSRestClient.getInstance();
        this.docFieldPrefs = new FTSDataColumnPreferences(FTSDataColumnPreferences.PreferenceSource.STRUCTURE_CHOOSER, TDBeaconsFTSRestClient.getInstance());
    }

    @Override
    public String buildQuery(SequenceI seq) {
        Sequence.DBModList<DBRefEntry> refs = seq.getDBRefs();
        int ib = ThreeDBStructureChooserQuerySource.checkUniprotRefs(refs);
        if (ib > -1) {
            return ThreeDBStructureChooserQuerySource.getDBRefId((DBRefEntry)refs.get(ib));
        }
        return null;
    }

    public static int checkUniprotRefs(List<DBRefEntry> refs) {
        boolean hasUniprot = false;
        if (refs != null && refs.size() != 0) {
            int nb = refs.size();
            for (int ib = 0; ib < nb; ++ib) {
                DBRefEntry dbRef = refs.get(ib);
                if (!dbRef.getSource().equalsIgnoreCase("UNIPROT")) continue;
                hasUniprot = true;
                if (!dbRef.isCanonical()) continue;
                return ib;
            }
        }
        return hasUniprot ? -1 : -2;
    }

    static boolean isValidSeqName(String seqName) {
        String ignoreList = "pdb,uniprot,swiss-prot";
        if (seqName.length() < 3) {
            return false;
        }
        if (seqName.contains(":")) {
            return false;
        }
        seqName = seqName.toLowerCase(Locale.ROOT);
        for (String ignoredEntry : ignoreList.split(",")) {
            if (!seqName.contains(ignoredEntry)) continue;
            return false;
        }
        return true;
    }

    static String getDBRefId(DBRefEntry dbRef) {
        String ref = dbRef.getAccessionId().replaceAll("GO:", "");
        return ref;
    }

    @Override
    public FTSRestResponse fetchStructuresMetaData(SequenceI seq, Collection<FTSDataColumnI> wantedFields, FilterOption selectedFilterOpt, boolean b) throws Exception {
        if (selectedFilterOpt != null && this.tdBeaconsFilter(selectedFilterOpt.getValue())) {
            FTSRestRequest tdbRequest = this.getTDBeaconsRequest(seq, wantedFields);
            FTSRestResponse resultList = this.tdbRestClient.executeRequest(tdbRequest);
            this.lastTdbRequest = tdbRequest;
            if (resultList != null) {
                List<FTSRestResponse> pdbResponse = this.fetchStructuresMetaDataFor(this.getPDBQuerySource(), resultList);
                resultList = this.joinResponses(resultList, pdbResponse);
            }
            return resultList;
        }
        FTSRestResponse resultList = this.getPDBQuerySource().fetchStructuresMetaData(seq, wantedFields, selectedFilterOpt, b);
        this.lastPdbRequest = this.lastTdbRequest = this.getPDBQuerySource().lastPdbRequest;
        return resultList;
    }

    private PDBStructureChooserQuerySource getPDBQuerySource() {
        if (this.pdbQuerySource == null) {
            this.pdbQuerySource = new PDBStructureChooserQuerySource();
        }
        return this.pdbQuerySource;
    }

    private FTSRestRequest getTDBeaconsRequest(SequenceI seq, Collection<FTSDataColumnI> wantedFields) {
        FTSRestRequest pdbRequest = new FTSRestRequest();
        pdbRequest.setAllowEmptySeq(false);
        pdbRequest.setResponseSize(500);
        pdbRequest.setWantedFields(wantedFields);
        String query = this.buildQuery(seq);
        if (query == null) {
            return null;
        }
        pdbRequest.setSearchTerm(query + ".json");
        pdbRequest.setAssociatedSequence(seq);
        return pdbRequest;
    }

    @Override
    public List<FilterOption> getAvailableFilterOptions(String VIEWS_FILTER) {
        List<FilterOption> filters = this.getPDBQuerySource().getAvailableFilterOptions(VIEWS_FILTER);
        this.tdBeaconsFilters = new LinkedHashSet<String>();
        this.tdBeaconsFilters.addAll(this.defaultFilters);
        filters.add(0, new FilterOption("Best 3D-Beacons Coverage", FILTER_FIRST_BEST_COVERAGE, VIEWS_FILTER, false, this));
        filters.add(1, new FilterOption("Multiple 3D-Beacons Coverage", FILTER_TDBEACONS_COVERAGE, VIEWS_FILTER, true, this));
        return filters;
    }

    @Override
    public void updateAvailableFilterOptions(String VIEWS_FILTER, List<FilterOption> xtantOptions, Collection<FTSData> tdbEntries) {
        if (tdbEntries != null && this.lastTdbRequest != null) {
            boolean hasPDBe = false;
            for (FTSData _row : tdbEntries) {
                TDB_FTSData row = (TDB_FTSData)_row;
                String provider = row.getProvider();
                FilterOption providerOpt = new FilterOption("3DB Provider - " + provider, FILTER_SOURCE_PREFIX + provider, VIEWS_FILTER, false, this);
                if (xtantOptions.contains(providerOpt)) continue;
                xtantOptions.add(1, providerOpt);
                this.tdBeaconsFilters.add(FILTER_SOURCE_PREFIX + provider);
                if (!"PDBe".equalsIgnoreCase(provider)) continue;
                hasPDBe = true;
            }
            if (!hasPDBe) {
                int op = 0;
                while (op < xtantOptions.size()) {
                    FilterOption filter = xtantOptions.get(op);
                    if (filter.getQuerySource() instanceof PDBStructureChooserQuerySource) {
                        xtantOptions.remove(op);
                        continue;
                    }
                    ++op;
                }
            }
        }
    }

    private boolean tdBeaconsFilter(String fieldToFilterBy) {
        return this.tdBeaconsFilters != null && this.tdBeaconsFilters.contains(fieldToFilterBy);
    }

    protected String remove_prefix(String fieldToFilterBy) {
        if (this.tdBeaconsFilters != null && this.tdBeaconsFilters.contains(fieldToFilterBy) && !this.defaultFilters.contains(fieldToFilterBy)) {
            return fieldToFilterBy.substring(FILTER_SOURCE_PREFIX.length());
        }
        return null;
    }

    @Override
    public boolean needsRefetch(FilterOption selectedFilterOpt) {
        return selectedFilterOpt == null || !this.tdBeaconsFilter(selectedFilterOpt.getValue()) && this.lastPdbRequest != this.lastTdbRequest;
    }

    @Override
    public FTSRestResponse selectFirstRankedQuery(SequenceI seq, Collection<FTSData> collectedResults, Collection<FTSDataColumnI> wantedFields, String fieldToFilterBy, boolean b) throws Exception {
        if (fieldToFilterBy != null && this.tdBeaconsFilter(fieldToFilterBy)) {
            TDBResultAnalyser analyser = new TDBResultAnalyser(seq, collectedResults, this.lastTdbRequest, fieldToFilterBy, this.remove_prefix(fieldToFilterBy));
            FTSRestResponse resultList = new FTSRestResponse();
            List<FTSData> filteredResponse = analyser.getFilteredResponse();
            List<FTSData> selectedStructures = analyser.selectStructures(filteredResponse);
            resultList.setNumberOfItemsFound(selectedStructures.size());
            resultList.setSearchSummary(selectedStructures);
            return resultList;
        }
        return this.getPDBQuerySource().selectFirstRankedQuery(seq, collectedResults, wantedFields, fieldToFilterBy, b);
    }

    @Override
    public PDBEntry[] collectSelectedRows(final JTable restable, int[] selectedRows, List<SequenceI> selectedSeqsToView) {
        int n;
        int refSeqColIndex = restable.getColumn("Ref Sequence").getModelIndex();
        PDBEntry[] pdbEntriesToView = new PDBEntry[selectedRows.length];
        int count = 0;
        int idColumnIndex = restable.getColumn("Model id").getModelIndex();
        int urlColumnIndex = restable.getColumn("Url").getModelIndex();
        int typeColumnIndex = restable.getColumn("Provider").getModelIndex();
        int humanUrl = restable.getColumn("Page URL").getModelIndex();
        int modelformat = restable.getColumn("Model Format").getModelIndex();
        int idx_mcat = restable.getColumn("Model Category").getModelIndex();
        int idx_mqual = restable.getColumn("Confidence").getModelIndex();
        int idx_mqualtype = restable.getColumn("Confidence Score Type").getModelIndex();
        int idx_mqualtypever = restable.getColumn("Confidence Score Version").getModelIndex();
        final int up_start_idx = restable.getColumn("Uniprot Start").getModelIndex();
        final int up_end_idx = restable.getColumn("Uniprot End").getModelIndex();
        int i = 0;
        Integer[] sellist = new Integer[selectedRows.length];
        Object[] objectArray = selectedRows;
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Integer row = objectArray[n];
            sellist[i++] = row;
        }
        Arrays.sort(sellist, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int o1_xt = (Integer)restable.getValueAt(o1, up_end_idx) - (Integer)restable.getValueAt(o1, up_start_idx);
                int o2_xt = (Integer)restable.getValueAt(o2, up_end_idx) - (Integer)restable.getValueAt(o2, up_start_idx);
                return o2_xt - o1_xt;
            }
        });
        objectArray = sellist;
        n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            StructureImportSettings.TFType tempfacType;
            int row = objectArray[n].intValue();
            String pdbIdStr = restable.getValueAt(row, idColumnIndex).toString();
            String urlStr = restable.getValueAt(row, urlColumnIndex).toString();
            String typeColumn = restable.getValueAt(row, typeColumnIndex).toString();
            String modelPage = humanUrl < 1 ? null : (String)restable.getValueAt(row, humanUrl);
            String modelCategory = idx_mcat < 1 ? null : (String)restable.getValueAt(row, idx_mcat);
            Double modelConf = idx_mqual < 1 ? null : (Double)restable.getValueAt(row, idx_mqual);
            String modelConfType = idx_mqualtype < 1 ? null : (String)restable.getValueAt(row, idx_mqualtype);
            String modelConfVer = idx_mqualtypever < 1 ? null : (String)restable.getValueAt(row, idx_mqualtypever);
            String tftype = modelConfType == null ? null : modelConfType.toUpperCase(Locale.ROOT);
            StructureImportSettings.TFType tFType = tempfacType = tftype == null ? null : StructureImportSettings.TFType.valueOf(tftype);
            if (tftype == null || "".equals(tftype) || StructureImportSettings.TFType.valueOf(tftype) == null) {
                if (typeColumn.toLowerCase(Locale.ROOT).startsWith("alpha") || tftype != null && tftype.startsWith("ALPHAFOLD")) {
                    tftype = StructureImportSettings.TFType.PLDDT.toString();
                    modelConfVer = null;
                }
                if (!typeColumn.toLowerCase(Locale.ROOT).startsWith("pdbe")) {
                    tftype = StructureImportSettings.TFType.QMEANDISCO.toString();
                }
            }
            String strucFormat = restable.getValueAt(row, modelformat).toString();
            SequenceI selectedSeq = (SequenceI)restable.getValueAt(row, refSeqColIndex);
            selectedSeqsToView.add(selectedSeq);
            PDBEntry pdbEntry = selectedSeq.getPDBEntry(pdbIdStr);
            if (pdbEntry == null) {
                pdbEntry = ThreeDBStructureChooserQuerySource.getFindEntry(pdbIdStr, selectedSeq.getAllPDBEntries());
            }
            if (pdbEntry == null) {
                pdbEntry = new PDBEntry();
                pdbEntry.setId(pdbIdStr);
                pdbEntry.setAuthoritative(true);
                try {
                    pdbEntry.setType(PDBEntry.Type.valueOf(strucFormat));
                }
                catch (Exception q) {
                    Console.warn("Unknown filetype for 3D Beacons Model from: " + strucFormat + " - " + pdbIdStr + " - " + modelPage);
                }
                if (!"PDBe".equalsIgnoreCase(typeColumn)) {
                    pdbEntry.setRetrievalUrl(urlStr);
                }
                pdbEntry.setProvider(typeColumn);
                if (modelPage != null) {
                    pdbEntry.setProviderPage(modelPage);
                }
                pdbEntry.setProviderCategory(modelCategory);
                if (tempfacType != null) {
                    pdbEntry.setTempFacType(tempfacType);
                }
                if (modelConf != null) {
                    pdbEntry.setModelConfidence(modelConf);
                }
                if (modelConfType != null) {
                    pdbEntry.setModelConfidenceType(modelConfType);
                }
                if (modelConfVer != null) {
                    pdbEntry.setModelConfidenceVersion(modelConfVer);
                }
                selectedSeq.getDatasetSequence().addPDBId(pdbEntry);
            }
            pdbEntriesToView[count++] = pdbEntry;
        }
        return pdbEntriesToView;
    }

    @Override
    protected FTSRestRequest getLastFTSRequest() {
        return this.lastTdbRequest;
    }

    public List<String> buildPDBFTSQueryFor(FTSRestResponse upResponse) {
        ArrayList<String> ftsQueries = new ArrayList<String>();
        HashSet<String> pdbIds = new HashSet<String>();
        int idx_modelId = this.getLastFTSRequest().getFieldIndex("Model id");
        int idx_provider = this.getLastFTSRequest().getFieldIndex("Provider");
        for (FTSData row : upResponse.getSearchSummary()) {
            String id = (String)row.getSummaryData()[idx_modelId];
            String provider = (String)row.getSummaryData()[idx_provider];
            if (!"PDBe".equalsIgnoreCase(provider)) continue;
            pdbIds.add(id);
        }
        StringBuilder sb = new StringBuilder();
        for (String pdbId : pdbIds) {
            if (sb.length() > 2500) {
                ftsQueries.add(sb.toString());
                sb.setLength(0);
            }
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(pdbId);
        }
        if (sb.length() > 0) {
            ftsQueries.add(sb.toString());
        }
        return ftsQueries;
    }

    public List<FTSRestResponse> fetchStructuresMetaDataFor(PDBStructureChooserQuerySource pdbquery, FTSRestResponse upResponse) throws Exception {
        List<String> pdb_Queries = this.buildPDBFTSQueryFor(upResponse);
        if (pdb_Queries.size() == 0) {
            return null;
        }
        ArrayList<FTSRestResponse> results = new ArrayList<FTSRestResponse>();
        for (String pdb_Query : pdb_Queries) {
            FTSRestRequest pdbRequest = new FTSRestRequest();
            pdbRequest.setAllowEmptySeq(false);
            pdbRequest.setResponseSize(500);
            pdbRequest.setFieldToSearchBy("(");
            pdbRequest.setWantedFields(pdbquery.getDocFieldPrefs().getStructureSummaryFields());
            pdbRequest.setSearchTerm(pdb_Query + ")");
            try {
                FTSRestResponse resultList = pdbquery.executePDBFTSRestRequest(pdbRequest);
                if (resultList.getNumberOfItemsFound() == 0) {
                    Console.info("Unexpectedly returned no results for pdbe query: " + pdb_Query);
                }
                results.add(resultList);
                this.lastPdbRequest = pdbRequest;
            }
            catch (Exception ex) {
                Console.error("PDBFTSQuery failed", ex);
            }
        }
        return results;
    }

    public FTSRestResponse joinResponses(FTSRestResponse upResponse, List<FTSRestResponse> pdbResponses) {
        boolean hasPdbResp = this.lastPdbRequest != null;
        int idx_provider = this.getLastFTSRequest().getFieldIndex("Provider");
        int idx_modelId = this.getLastFTSRequest().getFieldIndex("Model id");
        int pdbIdx = hasPdbResp ? this.lastPdbRequest.getFieldIndex("PDB Id") : -1;
        int pdbTitle_idx = hasPdbResp ? this.lastPdbRequest.getFieldIndex("Title") : -1;
        int tdbTitle_idx = this.getLastFTSRequest().getFieldIndex("Title");
        for (FTSData row : upResponse.getSearchSummary()) {
            String id = (String)row.getSummaryData()[idx_modelId];
            String provider = (String)row.getSummaryData()[idx_provider];
            if ("PDBe".equalsIgnoreCase(provider)) {
                if (!hasPdbResp) {
                    Console.outPrintln("Warning: seems like we couldn't get to the PDBe search interface.");
                    continue;
                }
                for (FTSRestResponse pdbResponse : pdbResponses) {
                    for (FTSData pdbrow : pdbResponse.getSearchSummary()) {
                        String pdbid = (String)pdbrow.getSummaryData()[pdbIdx];
                        if (!id.equalsIgnoreCase(pdbid)) continue;
                        row.getSummaryData()[tdbTitle_idx] = pdbrow.getSummaryData()[pdbTitle_idx];
                    }
                }
                continue;
            }
            row.getSummaryData()[tdbTitle_idx] = "Model from TDB";
        }
        return upResponse;
    }

    public TDB_FTSData getFTSDataFor(JTable restable, int selectedRow, Collection<FTSData> discoveredStructuresSet) {
        int idColumnIndex = restable.getColumn("Model id").getModelIndex();
        String modelId = (String)restable.getValueAt(selectedRow, idColumnIndex);
        for (FTSData row : discoveredStructuresSet) {
            if (!(row instanceof TDB_FTSData) || !((TDB_FTSData)row).getModelId().equals(modelId)) continue;
            return (TDB_FTSData)row;
        }
        return null;
    }
}

