/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.GeneLocus;
import jalview.datamodel.Mapping;
import jalview.ext.ensembl.EnsemblInfo;
import jalview.ext.ensembl.EnsemblLookup;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.util.MapList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

public class EnsemblMap
extends EnsemblRestClient {
    private static final String MAPPED = "mapped";
    private static final String MAPPINGS = "mappings";
    private static final String CDS = "cds";
    private static final String CDNA = "cdna";

    public EnsemblMap() {
    }

    public EnsemblMap(String domain) {
        super(domain);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    protected URL getAssemblyMapUrl(String species, String chromosome, String fromRef, String toRef, int startPos, int endPos) throws MalformedURLException {
        boolean forward = startPos <= endPos;
        int start = forward ? startPos : endPos;
        int end = forward ? endPos : startPos;
        String strand = forward ? "1" : "-1";
        String url = String.format("%s/map/%s/%s/%s:%d..%d:%s/%s?content-type=application/json", this.getDomain(), species, fromRef, chromosome, start, end, strand, toRef);
        return new URL(url);
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        return null;
    }

    public int[] getAssemblyMapping(String species, String chromosome, String fromRef, String toRef, int[] queryRange) {
        URL url = null;
        try {
            url = this.getAssemblyMapUrl(species, chromosome, fromRef, toRef, queryRange[0], queryRange[1]);
            return this.parseAssemblyMappingResponse(url);
        }
        catch (Throwable t) {
            Console.outPrintln("Error calling " + url + ": " + t.getMessage());
            return null;
        }
    }

    protected int[] parseAssemblyMappingResponse(URL url) {
        int[] result = null;
        try {
            Iterator rvals = (Iterator)this.getJSON(url, null, -1, 2, MAPPINGS);
            if (rvals == null) {
                return null;
            }
            while (rvals.hasNext()) {
                Map val = (Map)rvals.next();
                Map mapped = (Map)val.get(MAPPED);
                int start = Integer.parseInt(mapped.get("start").toString());
                int end = Integer.parseInt(mapped.get("end").toString());
                String strand = mapped.get("strand").toString();
                if ("1".equals(strand)) {
                    result = new int[]{start, end};
                    continue;
                }
                result = new int[]{end, start};
            }
        }
        catch (IOException | NumberFormatException | ParseException exception) {
            // empty catch block
        }
        return result;
    }

    public GeneLociI getCdsMapping(String division, String accession, int start, int end) {
        return this.getIdMapping(division, accession, start, end, CDS);
    }

    public GeneLociI getCdnaMapping(String division, String accession, int start, int end) {
        return this.getIdMapping(division, accession, start, end, CDNA);
    }

    GeneLociI getIdMapping(String division, String accession, int start, int end, String cdsOrCdna) {
        URL url = null;
        try {
            String domain = new EnsemblInfo().getDomain(division);
            if (domain != null) {
                url = this.getIdMapUrl(domain, accession, start, end, cdsOrCdna);
                return this.parseIdMappingResponse(url, accession, domain);
            }
            return null;
        }
        catch (Throwable t) {
            Console.outPrintln("Error calling " + url + ": " + t.getMessage());
            return null;
        }
    }

    URL getIdMapUrl(String domain, String accession, int start, int end, String cdsOrCdna) throws MalformedURLException {
        String url = String.format("%s/map/%s/%s/%d..%d?include_original_region=1&content-type=application/json", domain, cdsOrCdna, accession, start, end);
        return new URL(url);
    }

    GeneLociI parseIdMappingResponse(URL url, String accession, String domain) {
        try {
            Iterator rvals = (Iterator)this.getJSON(url, null, -1, 2, MAPPINGS);
            if (rvals == null) {
                return null;
            }
            String assembly = null;
            String chromosome = null;
            int fromEnd = 0;
            ArrayList<int[]> regions = new ArrayList<int[]>();
            while (rvals.hasNext()) {
                Map val = (Map)rvals.next();
                Map original = (Map)val.get("original");
                fromEnd = Integer.parseInt(original.get("end").toString());
                Map mapped = (Map)val.get(MAPPED);
                int start = Integer.parseInt(mapped.get("start").toString());
                int end = Integer.parseInt(mapped.get("end").toString());
                String ass = mapped.get("assembly_name").toString();
                if (assembly != null && !assembly.equals(ass)) {
                    Console.errPrintln("EnsemblMap found multiple assemblies - can't resolve");
                    return null;
                }
                assembly = ass;
                String chr = mapped.get("seq_region_name").toString();
                if (chromosome != null && !chromosome.equals(chr)) {
                    Console.errPrintln("EnsemblMap found multiple chromosomes - can't resolve");
                    return null;
                }
                chromosome = chr;
                String strand = mapped.get("strand").toString();
                if ("-1".equals(strand)) {
                    regions.add(new int[]{end, start});
                    continue;
                }
                regions.add(new int[]{start, end});
            }
            String species = new EnsemblLookup(domain).getSpecies(accession);
            String as = assembly;
            String chr = chromosome;
            List<int[]> fromRange = Collections.singletonList(new int[]{1, fromEnd});
            Mapping mapping = new Mapping(new MapList(fromRange, regions, 1, 1));
            return new GeneLocus(species == null ? "" : species, as, chr, mapping);
        }
        catch (IOException | NumberFormatException | ParseException exception) {
            return null;
        }
    }
}

