/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.ProfileI;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.SecondaryStructureCount;

public class Profile
implements ProfileI {
    private ResidueCount counts;
    private SecondaryStructureCount ssCounts;
    private int seqWithSSCount = -1;
    private int height;
    private int gapped;
    private int maxCount;
    private int maxSSCount;
    private String modalResidue;
    private String modalSS;

    public Profile(int seqCount, int gaps, int max, String modalRes) {
        this.height = seqCount;
        this.gapped = gaps;
        this.maxCount = max;
        this.modalResidue = modalRes;
    }

    public Profile(String modalSS, int ssCount, int gaps, int maxSSCount, int seqWithSSCount) {
        this.height = ssCount;
        this.gapped = gaps;
        this.maxSSCount = maxSSCount;
        this.modalSS = modalSS;
        this.setSeqWithSSCount(seqWithSSCount);
    }

    @Override
    public void setCounts(ResidueCount residueCounts) {
        this.counts = residueCounts;
    }

    @Override
    public void setSSCounts(SecondaryStructureCount secondaryStructureCount) {
        this.ssCounts = secondaryStructureCount;
    }

    @Override
    public float getPercentageIdentity(boolean ignoreGaps) {
        if (this.height == 0) {
            return 0.0f;
        }
        float pid = 0.0f;
        pid = ignoreGaps && this.gapped < this.height ? (float)this.maxCount * 100.0f / (float)(this.height - this.gapped) : (float)this.maxCount * 100.0f / (float)this.height;
        return pid;
    }

    @Override
    public float getSSPercentageIdentity(boolean ignoreGaps) {
        if (this.height == 0) {
            return 0.0f;
        }
        float ssPid = 0.0f;
        ssPid = ignoreGaps && this.gapped < this.height ? (float)this.maxSSCount * 100.0f / (float)(this.height - this.gapped) : (float)this.maxSSCount * 100.0f / (float)this.height;
        return ssPid;
    }

    @Override
    public ResidueCount getCounts() {
        return this.counts;
    }

    @Override
    public SecondaryStructureCount getSSCounts() {
        return this.ssCounts;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getGapped() {
        return this.gapped;
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public int getMaxSSCount() {
        return this.maxSSCount;
    }

    @Override
    public String getModalResidue() {
        return this.modalResidue;
    }

    @Override
    public String getModalSS() {
        return this.modalSS;
    }

    @Override
    public int getNonGapped() {
        return this.height - this.gapped;
    }

    @Override
    public int getSeqWithSSCount() {
        return this.seqWithSSCount;
    }

    public void setSeqWithSSCount(int seqWithSSCount) {
        this.seqWithSSCount = seqWithSSCount;
    }
}

