/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.APopupMenu;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.IdCanvas;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.Tooltip;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.urls.api.UrlProviderI;
import jalview.urls.applet.AppletUrlProviderFactory;
import jalview.util.Platform;
import jalview.viewmodel.AlignmentViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IdPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    protected IdCanvas idCanvas;
    protected AlignmentViewport av;
    protected AlignmentPanel alignPanel;
    ScrollThread scrollThread = null;
    int lastid = -1;
    boolean mouseDragging = false;
    UrlProviderI urlProvider = null;
    Tooltip tooltip;

    public IdPanel(AlignViewport viewport, AlignmentPanel parent) {
        this.av = viewport;
        this.alignPanel = parent;
        this.idCanvas = new IdCanvas(viewport);
        this.setLayout(new BorderLayout());
        this.add((Component)this.idCanvas, "Center");
        this.idCanvas.addMouseListener(this);
        this.idCanvas.addMouseMotionListener(this);
        HashMap<String, String> urlList = new HashMap<String, String>();
        if (viewport.applet != null) {
            for (int i = 1; i < 10; ++i) {
                String label = viewport.applet.getParameter("linkLabel_" + i);
                String url = viewport.applet.getParameter("linkURL_" + i);
                if (label == null) continue;
                urlList.put(label, url);
            }
            if (!urlList.isEmpty()) {
                String defaultUrl = viewport.applet.getParameter("linkLabel_1");
                AppletUrlProviderFactory factory = new AppletUrlProviderFactory(defaultUrl, urlList);
                this.urlProvider = factory.createUrlProvider();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int seq = this.alignPanel.seqPanel.findSeq(e);
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        StringBuffer tooltiptext = new StringBuffer();
        if (sequence == null) {
            return;
        }
        if (sequence.getDescription() != null) {
            tooltiptext.append(sequence.getDescription());
            tooltiptext.append("\n");
        }
        for (SequenceFeature sf : sequence.getFeatures().getNonPositionalFeatures(new String[0])) {
            boolean nl = false;
            if (sf.getFeatureGroup() != null) {
                tooltiptext.append(sf.getFeatureGroup());
                nl = true;
            }
            if (sf.getType() != null) {
                tooltiptext.append(" ");
                tooltiptext.append(sf.getType());
                nl = true;
            }
            if (sf.getDescription() != null) {
                tooltiptext.append(" ");
                tooltiptext.append(sf.getDescription());
                nl = true;
            }
            if (!Float.isNaN(sf.getScore()) && sf.getScore() != 0.0f) {
                tooltiptext.append(" Score = ");
                tooltiptext.append(sf.getScore());
                nl = true;
            }
            if (sf.getStatus() != null && sf.getStatus().length() > 0) {
                tooltiptext.append(" (");
                tooltiptext.append(sf.getStatus());
                tooltiptext.append(")");
                nl = true;
            }
            if (!nl) continue;
            tooltiptext.append("\n");
        }
        if (tooltiptext.length() == 0) {
            if (this.tooltip != null) {
                this.tooltip.setVisible(false);
            }
            this.tooltip = null;
            tooltiptext = null;
            return;
        }
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(sequence.getDisplayId(true) + "\n" + tooltiptext.toString(), this.idCanvas);
        } else {
            this.tooltip.setTip(sequence.getDisplayId(true) + "\n" + tooltiptext.toString());
        }
        tooltiptext = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragging = true;
        int seq = Math.max(0, this.alignPanel.seqPanel.findSeq(e));
        if (seq < this.lastid) {
            this.selectSeqs(this.lastid - 1, seq);
        } else if (seq > this.lastid) {
            this.selectSeqs(this.lastid + 1, seq);
        }
        this.lastid = seq;
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        int seq = this.alignPanel.seqPanel.findSeq(e);
        SequenceI sq = this.av.getAlignment().getSequenceAt(seq);
        if (sq == null) {
            return;
        }
        String id = sq.getName();
        if (this.urlProvider == null) {
            return;
        }
        String url = this.urlProvider.getPrimaryUrl(id);
        String target = this.urlProvider.getPrimaryTarget(id);
        try {
            this.alignPanel.alignFrame.showURL(url, target);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging && e.getY() < 0 && this.av.getRanges().getStartSeq() > 0) {
            this.scrollThread = new ScrollThread(true);
        }
        if (this.mouseDragging && e.getY() >= this.getSize().height && this.av.getAlignment().getHeight() > this.av.getRanges().getEndSeq()) {
            this.scrollThread = new ScrollThread(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() > 1) {
            return;
        }
        int y = e.getY();
        if (this.av.getWrapAlignment()) {
            y -= 2 * this.av.getCharHeight();
        }
        int seq = this.alignPanel.seqPanel.findSeq(e);
        if ((e.getModifiersEx() & 0x1000) == 4096) {
            SequenceI sq = this.av.getAlignment().getSequenceAt(seq);
            List<String> nlinks = this.urlProvider != null ? this.urlProvider.getLinksForMenu() : new ArrayList<String>();
            for (SequenceFeature sf : sq.getFeatures().getNonPositionalFeatures(new String[0])) {
                if (sf.links == null) continue;
                for (String link : sf.links) {
                    nlinks.add(link);
                }
            }
            APopupMenu popup = new APopupMenu(this.alignPanel, sq, nlinks);
            this.add(popup);
            popup.show(this, e.getX(), e.getY());
            return;
        }
        if (this.av.getSelectionGroup() == null || !Platform.isControlDown(e) && !e.isShiftDown() && this.av.getSelectionGroup() != null) {
            this.av.setSelectionGroup(new SequenceGroup());
            this.av.getSelectionGroup().setStartRes(0);
            this.av.getSelectionGroup().setEndRes(this.av.getAlignment().getWidth() - 1);
        }
        if (e.isShiftDown() && this.lastid != -1) {
            this.selectSeqs(this.lastid, seq);
        } else {
            this.selectSeq(seq);
        }
        this.alignPanel.paintAlignment(false, false);
    }

    void selectSeq(int seq) {
        this.lastid = seq;
        SequenceI pickedSeq = this.av.getAlignment().getSequenceAt(seq);
        this.av.getSelectionGroup().addOrRemove(pickedSeq, true);
    }

    void selectSeqs(int start, int end) {
        this.lastid = start;
        if (end >= this.av.getAlignment().getHeight()) {
            end = this.av.getAlignment().getHeight() - 1;
        }
        if (end < start) {
            int tmp = start;
            start = end;
            this.lastid = end = tmp;
        }
        if (this.av.getSelectionGroup() == null) {
            this.av.setSelectionGroup(new SequenceGroup());
        }
        for (int i = start; i <= end; ++i) {
            this.av.getSelectionGroup().addSequence(this.av.getAlignment().getSequenceAt(i), i == end);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
        }
        if (this.av.getSelectionGroup() != null) {
            this.av.getSelectionGroup().recalcConservation();
        }
        this.mouseDragging = false;
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        this.av.sendSelection();
    }

    public void highlightSearchResults(List<SequenceI> list) {
        this.idCanvas.setHighlighted(list);
        if (list == null || list.isEmpty()) {
            return;
        }
        int index = this.av.getAlignment().findIndex(list.get(0));
        if (this.av.getRanges().getStartSeq() > index || this.av.getRanges().getEndSeq() < index) {
            this.av.getRanges().setStartSeq(index);
        }
    }

    class ScrollThread
    extends Thread {
        boolean running = false;
        boolean up = true;

        public ScrollThread(boolean isUp) {
            this.up = isUp;
            this.start();
        }

        public void stopScrolling() {
            this.running = false;
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                if (IdPanel.this.av.getRanges().scrollUp(this.up)) {
                    int seq = IdPanel.this.av.getRanges().getStartSeq();
                    if (!this.up) {
                        seq = IdPanel.this.av.getRanges().getEndSeq();
                    }
                    if (seq < IdPanel.this.lastid) {
                        IdPanel.this.selectSeqs(IdPanel.this.lastid - 1, seq);
                    } else if (seq > IdPanel.this.lastid && seq < IdPanel.this.av.getAlignment().getHeight()) {
                        IdPanel.this.selectSeqs(IdPanel.this.lastid + 1, seq);
                    }
                    IdPanel.this.lastid = seq;
                } else {
                    this.running = false;
                }
                IdPanel.this.alignPanel.paintAlignment(true, false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

