/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimUtils;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraStructuralObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public class ChimeraResidue
implements ChimeraStructuralObject,
Comparable<ChimeraResidue> {
    public static final int SINGLE_LETTER = 0;
    public static final int THREE_LETTER = 1;
    public static final int FULL_NAME = 2;
    private String type;
    private String index;
    private String chainId;
    private int modelNumber;
    private int subModelNumber;
    protected int residueNumber;
    protected String insertionCode;
    private ChimeraModel chimeraModel;
    private Object userData;
    private static int displayType = 1;
    private boolean selected = false;

    public ChimeraResidue(String type, String index, int modelNumber) {
        this(type, index, modelNumber, 0);
    }

    public ChimeraResidue(String type, String index, int modelNumber, int subModelNumber) {
        this.type = type;
        this.index = index;
        this.modelNumber = modelNumber;
        this.subModelNumber = subModelNumber;
        this.splitInsertionCode(this.index);
    }

    public ChimeraResidue(String chimeraInputLine) {
        String[] split1 = chimeraInputLine.split(":");
        int numberOffset = split1[0].indexOf(35);
        String model = split1[0].substring(numberOffset + 1);
        int decimalOffset = model.indexOf(46);
        try {
            this.subModelNumber = 0;
            if (decimalOffset > 0) {
                this.subModelNumber = Integer.parseInt(model.substring(decimalOffset + 1));
                this.modelNumber = Integer.parseInt(model.substring(0, decimalOffset));
            } else {
                this.modelNumber = Integer.parseInt(model);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ChimeraResidue.class).error("Unexpected return from Chimera: " + model);
            this.modelNumber = -1;
        }
        String[] rTokens = split1[1].split(" ");
        this.type = rTokens[2];
        String[] iTokens = rTokens[0].split("\\.");
        if (iTokens.length > 0) {
            this.index = iTokens[0];
            this.chainId = iTokens.length > 1 ? iTokens[1] : "_";
        } else {
            this.index = rTokens[0];
        }
        this.splitInsertionCode(this.index);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public List<ChimeraStructuralObject> getChildren() {
        ArrayList<ChimeraStructuralObject> v = new ArrayList<ChimeraStructuralObject>();
        v.add(this);
        return v;
    }

    public String displayName() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (displayType == 2) {
            return ChimUtils.toFullName(this.type) + " " + this.index;
        }
        if (displayType == 0) {
            return ChimUtils.toSingleLetter(this.type) + " " + this.index;
        }
        if (displayType == 1) {
            return ChimUtils.toThreeLetter(this.type) + " " + this.index;
        }
        return this.type + " " + this.index;
    }

    @Override
    public String toSpec() {
        if (!this.chainId.equals("_")) {
            return "#" + this.modelNumber + ":" + this.index + "." + this.chainId;
        }
        return "#" + this.modelNumber + ":" + this.index + ".";
    }

    public String getIndex() {
        return this.index;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getType() {
        return this.type;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public int getSubModelNumber() {
        return this.subModelNumber;
    }

    @Override
    public ChimeraModel getChimeraModel() {
        return this.chimeraModel;
    }

    public void setChimeraModel(ChimeraModel chimeraModel) {
        this.chimeraModel = chimeraModel;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object data) {
        this.userData = data;
    }

    @Override
    public int compareTo(ChimeraResidue c2) {
        if (this.residueNumber < c2.residueNumber) {
            return -1;
        }
        if (this.residueNumber == c2.residueNumber) {
            if (this.insertionCode == null && c2.insertionCode == null) {
                return 0;
            }
            if (this.insertionCode == null) {
                return -1;
            }
            if (c2.insertionCode == null) {
                return 1;
            }
            return this.insertionCode.compareTo(c2.insertionCode);
        }
        return 1;
    }

    public void splitInsertionCode(String residue) {
        Pattern p = Pattern.compile("(\\d*)([A-Z]?)");
        Matcher m = p.matcher(residue);
        if (m.matches()) {
            this.residueNumber = Integer.parseInt(m.group(1));
            this.insertionCode = m.groupCount() > 1 ? m.group(2) : null;
        }
    }

    public static void setDisplayType(int type) {
        displayType = type;
    }

    public static int getDisplayType() {
        return displayType;
    }

    @Override
    public boolean hasSelectedChildren() {
        return false;
    }
}

