/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import compbio.data.sequence.ScoreManager;
import compbio.util.SysPrefs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class RNAStructScoreManager
extends ScoreManager {
    private RNAStructScoreManager() {
    }

    public RNAStructScoreManager(List<String> structs, List<TreeSet<Score>> data) {
        assert (structs.size() == data.size());
        ArrayList<ScoreManager.ScoreHolder> seqScores = new ArrayList<ScoreManager.ScoreHolder>();
        for (int i = 0; i < structs.size(); ++i) {
            seqScores.add(new ScoreManager.ScoreHolder(structs.get(i), (Set<Score>)data.get(i)));
        }
        this.seqScores = seqScores;
    }

    public static RNAStructScoreManager newInstance(List<String> structs, List<TreeSet<Score>> data) {
        return new RNAStructScoreManager(structs, data);
    }

    public List<String> getStructs() {
        ArrayList<String> structs = new ArrayList<String>();
        for (ScoreManager.ScoreHolder sch : this.seqScores) {
            structs.add(sch.id);
        }
        return structs;
    }

    public List<TreeSet<Score>> getData() {
        ArrayList<TreeSet<Score>> data = new ArrayList<TreeSet<Score>>();
        for (ScoreManager.ScoreHolder sch : this.seqScores) {
            data.add(sch.scores);
        }
        return data;
    }

    public String toString() {
        String out = "";
        out = out + this.getStructs().get(0) + SysPrefs.newlinechar;
        for (int i = 1; i < this.getStructs().size(); ++i) {
            out = out + this.getStructs().get(i).toString();
            if (this.getData().get(i).first().getScores().size() > 0) {
                ArrayList<Float> scores = this.getData().get(i).first().getScores();
                if (scores.size() >= 3) {
                    out = out + " (" + ((Float)scores.get(0)).toString() + " = " + ((Float)scores.get(1)).toString() + " + " + ((Float)scores.get(2)).toString() + ")" + SysPrefs.newlinechar;
                    continue;
                }
                if (this.getData().get(i).first().getMethod().equals("alifoldMEA")) {
                    out = out + " { " + ((Float)scores.get(0)).toString() + " MEA=" + ((Float)scores.get(1)).toString() + "}" + SysPrefs.newlinechar;
                    continue;
                }
                if (scores.size() < 2) continue;
                out = out + " [" + ((Float)scores.get(0)).toString() + ", " + ((Float)scores.get(1)).toString() + "]" + SysPrefs.newlinechar;
                continue;
            }
            out = out + SysPrefs.newlinechar;
        }
        if (this.getData().get(0).first().getScores().size() > 0) {
            Iterator<Score> iScores = this.getData().get(0).iterator();
            out = out + "Base Pairings followed by probability" + SysPrefs.newlinechar;
            for (int i = 0; i < this.getData().get(0).size(); ++i) {
                Score s = iScores.next();
                Range r = s.getRanges().first();
                Float score = s.getScores().get(0);
                out = out + String.format("%4d  %4d    %.1f%n", r.from, r.to, score);
            }
        }
        return out;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RNAStructScoreManager)) {
            return false;
        }
        RNAStructScoreManager other = (RNAStructScoreManager)obj;
        if (this.getStructs() == null ? other.getStructs() != null : !this.getStructs().equals(other.getStructs())) {
            return false;
        }
        return !(this.getData() == null ? other.getData() != null : !this.getData().equals(other.getData()));
    }
}

