/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.IClient;
import uk.ac.vamsas.client.IClientFactory;
import uk.ac.vamsas.client.InvalidSessionDocumentException;
import uk.ac.vamsas.client.InvalidSessionUrnException;
import uk.ac.vamsas.client.NoDefaultSessionException;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.simpleclient.SessionUrn;
import uk.ac.vamsas.client.simpleclient.SimpleClient;
import uk.ac.vamsas.client.simpleclient.SimpleSessionHandle;
import uk.ac.vamsas.client.simpleclient.SimpleSessionManager;
import uk.ac.vamsas.client.simpleclient.VamsasSession;

public class SimpleClientFactory
implements IClientFactory {
    private static Log log = LogFactory.getLog((Class)SimpleClientFactory.class);
    private File sessionArena = null;
    private String vamsasSubdirectoryName = ".vamsas";
    private SimpleSessionManager sessionManager = null;
    private static final String SESSION_LIST = "sessions.obj";

    public SimpleClientFactory() throws IOException {
        String userHomeDirectory = System.getProperty("user.home");
        if (userHomeDirectory == null || userHomeDirectory.length() < 1) {
            new IOException("Unable to detect user home directory");
        }
        String sessionArenaPath = userHomeDirectory.concat(File.separator.concat(this.vamsasSubdirectoryName));
        this.initSessionArena(sessionArenaPath);
    }

    public SimpleClientFactory(String path) throws IOException {
        this.initSessionArena(path);
    }

    private void initSessionArena(String path) throws IOException {
        File arenaFile = new File(path);
        if (!arenaFile.exists() && !arenaFile.mkdirs()) {
            this.sessionArena = null;
            throw new IOException("Unable to create a directory called " + path);
        }
        if (!(arenaFile.exists() && arenaFile.isDirectory() && arenaFile.canRead() && arenaFile.canWrite())) {
            this.sessionArena = null;
            throw new IOException("Cannot read and write to a directory called " + path);
        }
        this.sessionArena = arenaFile;
    }

    public IClient getIClient(ClientHandle applicationHandle) throws NoDefaultSessionException {
        return this.getIClient(applicationHandle, (UserHandle)null);
    }

    public IClient getIClient(ClientHandle applicationHandle, String sessionUrn) {
        log.debug((Object)("Trying to create session with URN " + sessionUrn));
        return this.getIClient(applicationHandle, null, sessionUrn);
    }

    private File convertSessionUrnToFile(String sessionUrn) throws InvalidSessionUrnException {
        if (sessionUrn == null) {
            log.debug((Object)"Incorrect URN: can not open session.");
            throw new InvalidSessionUrnException("SessionUrn was null");
        }
        SessionUrn urn = new SessionUrn(sessionUrn);
        SimpleSessionHandle[] sh = null;
        try {
            sh = this.getSessionManager().getSessionFor(urn);
        }
        catch (IOException e) {
            log.warn((Object)"Ignored IO Exception when trying to access sessionlist.", (Throwable)e);
        }
        File sesfile = null;
        if (sh != null) {
            if (sh.length == 1) {
                sesfile = new File(sh[0].getPhysLoc());
                sh[0] = null;
            } else {
                log.error((Object)("Raising exception for multiple session files corresponding to single URN (was : " + sessionUrn + ")"));
                throw new InvalidSessionUrnException("IMPLEMENTATION ERROR: Multiple session files available for URN (" + sessionUrn + ")");
            }
        }
        return sesfile;
    }

    public IClient getIClient(ClientHandle applicationHandle, UserHandle userId, String sessionUrn) {
        IClient client = null;
        try {
            File sessionDirectory = this.convertSessionUrnToFile(sessionUrn);
            log.debug((Object)("found session directory " + sessionDirectory.getAbsolutePath()));
            VamsasSession vamsasSession = new VamsasSession(sessionDirectory);
            client = this.initClient(sessionDirectory, userId, applicationHandle, null, null);
        }
        catch (MalformedURLException e) {
            log.error((Object)"error while creating new IClient: incorrect session urn", (Throwable)e);
            client = null;
        }
        catch (InvalidSessionDocumentException e) {
            log.error((Object)"error while creating new IClient: invalid session document", (Throwable)e);
            client = null;
        }
        catch (InvalidSessionUrnException e) {
            log.error((Object)"error while creating new IClient: incorrect session urn", (Throwable)e);
            client = null;
        }
        catch (IOException e) {
            log.error((Object)"error while creating new IClient: file access error", (Throwable)e);
            client = null;
        }
        return client;
    }

    private IClient initClient(File sessdir, UserHandle userId, ClientHandle clientHandle, File vamsasDocument, String preferredName) throws IOException, InvalidSessionUrnException, InvalidSessionDocumentException {
        SimpleClient client = null;
        VamsasSession vamsasSession = null;
        vamsasSession = vamsasDocument == null ? new VamsasSession(sessdir) : new VamsasSession(sessdir, vamsasDocument, preferredName);
        this.getSessionManager().addSession(vamsasSession.getSessionUrn());
        if (userId == null) {
            userId = new UserHandle(null, null);
        }
        if (userId.getFullName() == null) {
            userId.setFullName(System.getProperty("user.name", System.getProperty("USERNAME", "Joe Doe")));
        }
        if (userId.getOrganization() == null) {
            userId.setOrganization(System.getProperty("host.name", System.getProperty("HOSTNAME", "Unknown")));
        }
        if (clientHandle == null) {
            clientHandle = new ClientHandle("SimpleVamsasClientApp", "0.1");
        } else {
            if (clientHandle.getClientName() == null) {
                clientHandle.setClientName("SimpleVamsasClientApp");
            }
            if (clientHandle.getVersion() == null) {
                clientHandle.setVersion("0.1");
            }
        }
        client = new SimpleClient(userId, clientHandle, vamsasSession);
        vamsasSession.addClient(client);
        vamsasSession.setSessionManager(this.getSessionManager());
        return client;
    }

    public IClient getIClient(ClientHandle applicationHandle, UserHandle userId) throws NoDefaultSessionException {
        IClient client = null;
        if (this.sessionArena == null) {
            throw new Error("Improperly initialised SimpleClientFactory object - null sessionArena.");
        }
        ClientHandle clientHandle = applicationHandle;
        if (clientHandle == null) {
            clientHandle = new ClientHandle("SimpleVamsasClientApp", "0.1");
        } else {
            if (clientHandle.getClientName() == null) {
                clientHandle.setClientName("SimpleVamsasClientApp");
            }
            if (clientHandle.getVersion() == null) {
                clientHandle.setVersion("0.1");
            }
        }
        String[] availableSessions = this.getCurrentSessions();
        if (availableSessions != null) {
            if (availableSessions.length > 1) {
                StringBuffer sessionURNs = new StringBuffer("");
                for (int i = 0; i < availableSessions.length; ++i) {
                    sessionURNs.append(availableSessions[i] + " ");
                }
                throw new NoDefaultSessionException("Several sessions available, please pick one: " + sessionURNs);
            }
            if (availableSessions.length == 1) {
                return this.getIClient(clientHandle, availableSessions[0]);
            }
            log.debug((Object)"No active session found");
        }
        try {
            client = this.clientInNewSession(userId, clientHandle, null, null);
        }
        catch (Exception e) {
            throw new Error("IMPLEMENTATION ERROR: unexpected exception when creating a new session to connect to.", e);
        }
        return client;
    }

    private IClient clientInNewSession(UserHandle userId, ClientHandle clientHandle, File vamsasDocument, String preferredName) throws InvalidSessionDocumentException, InvalidSessionUrnException {
        IClient client = null;
        try {
            File sessdir;
            String sesspref = "";
            if (vamsasDocument != null) {
                sesspref = preferredName != null ? preferredName.replaceAll("([^-A-Za-z0-9]|\\.vdj)", "") : vamsasDocument.getName().replaceAll("([^-A-Za-z0-9]|\\.vdj)", "");
            }
            if ((sessdir = new File(this.sessionArena, (sesspref = sesspref + new Date().toString().replaceAll("[^-A-Za-z0-9]", "_")) + ".simpleclient")).exists()) {
                sessdir = File.createTempFile(sesspref, ".simpleclient", this.sessionArena);
            } else if (!sessdir.createNewFile()) {
                throw new Error("VAMSAS Implementation error : sesspref friendly session name is invalid on this platform - please tell the authors!");
            }
            log.debug((Object)"Creating new session  directory");
            if (!sessdir.delete() || !sessdir.mkdir()) {
                throw new IOException("Could not make session directory " + sessdir);
            }
            client = this.initClient(sessdir, userId, clientHandle, vamsasDocument, preferredName);
        }
        catch (IOException e) {
            log.error((Object)"error while creating new IClient", (Throwable)e);
        }
        catch (InvalidSessionUrnException e) {
            log.error((Object)"Unable to create new IClient. The new session urn is malformed.", (Throwable)e);
        }
        return client;
    }

    public String[] getCurrentSessions() {
        String[] sessions = null;
        try {
            sessions = this.getSessionManager().getCurrentSessions();
        }
        catch (IOException e) {
            log.error((Object)"Unable to get available sessions", (Throwable)e);
            sessions = null;
        }
        return sessions;
    }

    private SimpleSessionManager getSessionManager() throws IOException {
        if (this.sessionManager == null) {
            this.sessionManager = new SimpleSessionManager(new File(this.sessionArena, SESSION_LIST));
        }
        return this.sessionManager;
    }

    public IClient getNewSessionIClient(ClientHandle applicationHandle) {
        try {
            return this.clientInNewSession(null, applicationHandle, null, null);
        }
        catch (Exception e) {
            log.error((Object)"Failed to create new session for app with default user.", (Throwable)e);
            return null;
        }
    }

    public IClient getNewSessionIClient(ClientHandle applicationHandle, UserHandle userId) {
        try {
            return this.clientInNewSession(userId, applicationHandle, null, null);
        }
        catch (Exception e) {
            log.error((Object)"Failed to create new session for app and user.", (Throwable)e);
            return null;
        }
    }

    private void checkImportedDocument(File vamsasDocument) throws InvalidSessionDocumentException {
        if (!vamsasDocument.exists()) {
            throw new InvalidSessionDocumentException("File " + vamsasDocument + " does not exist");
        }
        if (!vamsasDocument.canRead()) {
            throw new InvalidSessionDocumentException("File " + vamsasDocument + " does not exist");
        }
    }

    public IClient openAsNewSessionIClient(ClientHandle applicationHandle, File vamsasDocument) throws InvalidSessionDocumentException {
        this.checkImportedDocument(vamsasDocument);
        try {
            return this.clientInNewSession(null, applicationHandle, vamsasDocument, null);
        }
        catch (InvalidSessionUrnException e) {
            throw new InvalidSessionDocumentException("Unexpected exception", e);
        }
    }

    public IClient openAsNewSessionIClient(ClientHandle applicationHandle, UserHandle userId, File vamsasDocument) throws InvalidSessionDocumentException {
        this.checkImportedDocument(vamsasDocument);
        try {
            return this.clientInNewSession(userId, applicationHandle, vamsasDocument, null);
        }
        catch (InvalidSessionUrnException e) {
            throw new InvalidSessionDocumentException("Unexpected exception", e);
        }
    }

    public IClient openAsNewSessionIClient(ClientHandle applicationHandle, File vamsasDocument, String sessionName) throws InvalidSessionDocumentException {
        this.checkImportedDocument(vamsasDocument);
        try {
            return this.clientInNewSession(null, applicationHandle, vamsasDocument, sessionName);
        }
        catch (InvalidSessionUrnException e) {
            throw new InvalidSessionDocumentException("Unexpected exception", e);
        }
    }

    public IClient openAsNewSessionIClient(ClientHandle applicationHandle, UserHandle userId, File vamsasDocument, String sessionName) throws InvalidSessionDocumentException {
        this.checkImportedDocument(vamsasDocument);
        try {
            return this.clientInNewSession(userId, applicationHandle, vamsasDocument, sessionName);
        }
        catch (InvalidSessionUrnException e) {
            throw new InvalidSessionDocumentException("Unexpected exception", e);
        }
    }
}

