/*
 * Decompiled with CFR 0.152.
 */
package org.jcolorbrewer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.jcolorbrewer.ColorBrewer;
import org.jcolorbrewer.ui.ColorPanelSelectionModel;
import org.jcolorbrewer.ui.DivergingColorPalettePanel;
import org.jcolorbrewer.ui.QualitativeColorPalettePanel;
import org.jcolorbrewer.ui.SequentialColorPalettePanel;

public class ColorPaletteChooserDialog
extends JDialog {
    private static final long serialVersionUID = -5953604049348574107L;
    protected Window parent = null;
    protected JPanel innerPanel = null;
    protected JColorChooser colorChooser = null;
    protected Color startingColor = Color.white;
    protected ColorBrewer startingColorBrewer = ColorBrewer.BrBG;
    protected boolean okWasPressed = false;

    public ColorPaletteChooserDialog() {
        this.parent = null;
        this.initialize();
    }

    public ColorPaletteChooserDialog(Frame parent) {
        super(parent, true);
        this.parent = parent;
        this.initialize();
    }

    public ColorPaletteChooserDialog(Dialog parent) {
        super(parent, true);
        this.parent = parent;
        this.initialize();
    }

    protected void initialize() {
        this.setTitle("Select color scheme");
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(10, 10, 10, 10))));
        pane.add((Component)this.innerPanel, "Center");
        JPanel colorsTab = new JPanel();
        colorsTab.setBorder(new EmptyBorder(10, 10, 10, 10));
        colorsTab.setLayout(new BorderLayout());
        this.innerPanel.add(colorsTab);
        ColorPanelSelectionModel model = new ColorPanelSelectionModel();
        this.colorChooser = new JColorChooser(model);
        AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[]{new SequentialColorPalettePanel(), new DivergingColorPalettePanel(), new QualitativeColorPalettePanel()};
        this.colorChooser.setChooserPanels(panels);
        this.colorChooser.setPreviewPanel(new JPanel());
        colorsTab.add((Component)this.colorChooser, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        colorsTab.add((Component)buttonPanel, "South");
        JPanel buttonGridPanel = new JPanel();
        buttonGridPanel.setLayout(new GridLayout(1, 3, 5, 0));
        buttonPanel.add(buttonGridPanel);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPaletteChooserDialog.this.setColorBrewer(ColorPaletteChooserDialog.this.startingColorBrewer);
            }
        });
        buttonGridPanel.add(resetButton);
        JButton okButton = new JButton("OK");
        okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPaletteChooserDialog.this.okWasPressed = true;
                ColorPaletteChooserDialog.this.setVisible(false);
            }
        });
        buttonGridPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPaletteChooserDialog.this.setColorBrewer(ColorPaletteChooserDialog.this.startingColorBrewer);
                ColorPaletteChooserDialog.this.okWasPressed = false;
                ColorPaletteChooserDialog.this.setVisible(false);
            }
        });
        buttonGridPanel.add(cancelButton);
        this.pack();
        this.validate();
    }

    @Override
    public void show() {
        int y;
        int x;
        Rectangle windowDim = this.getBounds();
        if (this.parent == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenDim = toolkit.getScreenSize();
            x = screenDim.width / 2 - windowDim.width / 2;
            y = screenDim.height / 2 - windowDim.height / 2;
        } else {
            Rectangle parentDim = this.parent.getBounds();
            x = parentDim.x + parentDim.width / 2 - windowDim.width / 2;
            y = parentDim.y + parentDim.height / 2 - windowDim.height / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setLocation(x, y);
        this.okWasPressed = false;
        super.show();
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.innerPanel != null) {
            this.innerPanel.setBackground(background);
        }
    }

    public boolean showDialog() {
        if (this.isModal()) {
            this.show();
            return this.okWasPressed;
        }
        this.setModal(true);
        this.show();
        boolean status = this.okWasPressed;
        this.setModal(false);
        return status;
    }

    public boolean wasOKPressed() {
        return this.okWasPressed;
    }

    public Color getColor() {
        return this.colorChooser.getColor();
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
        this.startingColor = color;
    }

    public void setColor(int red, int green, int blue) {
        this.startingColor = new Color(red, green, blue);
        this.colorChooser.setColor(this.startingColor);
    }

    public ColorBrewer getColorPalette() {
        ColorPanelSelectionModel model = (ColorPanelSelectionModel)this.colorChooser.getSelectionModel();
        return model.getColorBrewer();
    }

    public void setColorBrewer(ColorBrewer brewer) {
        ColorPanelSelectionModel model = (ColorPanelSelectionModel)this.colorChooser.getSelectionModel();
        model.setColorBrewer(brewer);
    }

    public static void main(String[] args) {
        ColorPaletteChooserDialog d = new ColorPaletteChooserDialog();
        d.show();
    }
}

