/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.dm;

import compbio.metadata.Option;
import jalview.util.MessageManager;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.dm.JabaOption;
import jalview.ws.jws2.dm.JabaParameter;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.ArrayList;
import java.util.List;

public class JabaWsParamSet
implements WsParamSetI {
    List<Option> jabaArguments;
    String name;
    String description;
    String[] applicableUrls;
    String sourceFile;
    boolean modifiable = true;

    public JabaWsParamSet(String storeSetName, String descr, List jobParams) {
        if (jobParams.size() > 0) {
            if (jobParams.get(0) instanceof Option) {
                this.jabaArguments = new ArrayList<Option>();
                this.jabaArguments.addAll(jobParams);
            } else {
                if (!this.allJaba(jobParams)) {
                    throw new Error(MessageManager.getString("error.cannot_create_jabaws_param_set"));
                }
                this.jabaArguments = JabaParamStore.getJabafromJwsArgs(jobParams);
            }
        }
        this.name = storeSetName;
        this.description = descr;
        this.sourceFile = null;
        this.applicableUrls = null;
    }

    public JabaWsParamSet() {
    }

    private boolean allJaba(List jobParams) {
        boolean allJaba = true;
        for (Object jp : jobParams) {
            if (jp instanceof JabaParameter || jp instanceof JabaOption) {
                allJaba &= true;
                continue;
            }
            allJaba = false;
            break;
        }
        return allJaba;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setApplicableUrls(String[] applicableUrls) {
        this.applicableUrls = applicableUrls;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public String[] getApplicableUrls() {
        return this.applicableUrls;
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(String newfile) {
        this.sourceFile = newfile;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public List<ArgumentI> getArguments() {
        return JabaParamStore.getJwsArgsfromJaba(this.jabaArguments);
    }

    @Override
    public void setArguments(List<ArgumentI> args) {
        if (!this.allJaba(args)) {
            throw new Error(MessageManager.getString("error.cannot_set_arguments_to_jabaws_param_set"));
        }
        this.jabaArguments = new ArrayList<Option>();
        for (ArgumentI rg : args) {
            this.jabaArguments.add(((JabaOption)rg).opt);
        }
    }

    public List<Option> getjabaArguments() {
        return this.jabaArguments;
    }

    public void setjabaArguments(List<Option> args) {
        this.jabaArguments = args;
    }
}

