/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.ArrayList;
import java.util.List;

public class ShiftList {
    private List<int[]> shifts = new ArrayList<int[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShift(int pos, int shift) {
        List<int[]> list = this.shifts;
        synchronized (list) {
            int sidx;
            int[] rshift = null;
            for (sidx = 0; sidx < this.shifts.size() && (rshift = this.shifts.get(sidx))[0] < pos; ++sidx) {
            }
            if (sidx == this.shifts.size()) {
                this.shifts.add(sidx, new int[]{pos, shift});
            } else {
                rshift[1] = rshift[1] + shift;
            }
        }
    }

    public int shift(int pos) {
        int[] rshift;
        if (this.shifts.size() == 0) {
            return pos;
        }
        int shifted = pos;
        int sidx = 0;
        while (sidx < this.shifts.size() && (rshift = this.shifts.get(sidx++))[0] <= pos) {
            shifted += rshift[1];
        }
        return shifted;
    }

    public synchronized void clear() {
        this.shifts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShiftList getInverse() {
        ShiftList inverse = new ShiftList();
        List<int[]> list = this.shifts;
        synchronized (list) {
            if (this.shifts != null) {
                for (int[] sh : this.shifts) {
                    if (sh == null) continue;
                    inverse.shifts.add(new int[]{sh[0], -sh[1]});
                }
            }
        }
        return inverse;
    }

    public static ShiftList parseMap(int[] gapMap) {
        ShiftList shiftList = null;
        if (gapMap != null && gapMap.length > 0) {
            shiftList = new ShiftList();
            int p = 0;
            for (int i = 0; i < gapMap.length; ++i) {
                if (p != gapMap[i]) {
                    shiftList.addShift(p, gapMap[i] - p);
                    p = gapMap[i];
                }
                ++p;
            }
        }
        return shiftList;
    }

    public List<int[]> getShifts() {
        return this.shifts;
    }
}

