/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import jalview.util.StringUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class ColorUtils {
    private static final int MAX_CACHE_SIZE = 1729;
    private static Map<String, Color> myColours = new HashMap<String, Color>();
    private static Map<String, Color> myHSBSpacedColours = new HashMap<String, Color>();
    private static final double GOLDEN_RATIO_CONJUGATE = 0.6180339887;
    private static final float DEFAULT_HSB_DISTANCE_THRESHOLD = 0.5f;
    private static float HSB_DISTANCE_THRESHOLD = 0.5f;
    private static final float DECREMENT_VAL_FOR_HSB_DISTANCE_THRESHOLD = 0.01f;
    private static final int MAX_ITERATION_FOR_ADJUSTING_COLOR = 100;
    private static final int POS_HUE = 0;
    private static final int POS_SATURATION = 1;
    private static final int POS_BRIGHTNESS = 2;
    private static final float HSB_HIGH_SATURATION = 0.75f;
    private static final float HSB_HIGH_BRIGHTNESS = 0.9f;

    public static final Color generateRandomColor(Color mix) {
        Random random = new Random();
        int red = random.nextInt(256);
        int green = random.nextInt(256);
        int blue = random.nextInt(256);
        if (mix != null) {
            red = (red + mix.getRed()) / 2;
            green = (green + mix.getGreen()) / 2;
            blue = (blue + mix.getBlue()) / 2;
        }
        Color color = new Color(red, green, blue);
        return color;
    }

    public static final Color getARandomColor() {
        Color col = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        return col;
    }

    public static Color getColorForIndex(int index) {
        float hue = (float)index * 0.618034f % 1.0f;
        return Color.getHSBColor(hue, 0.75f, 0.9f);
    }

    public static final String toTkCode(Color colour) {
        String colstring = "#" + (colour.getRed() < 16 ? "0" : "") + Integer.toHexString(colour.getRed()) + (colour.getGreen() < 16 ? "0" : "") + Integer.toHexString(colour.getGreen()) + (colour.getBlue() < 16 ? "0" : "") + Integer.toHexString(colour.getBlue());
        return colstring;
    }

    public static Color darkerThan(Color col) {
        return col == null ? null : col.darker().darker().darker();
    }

    public static Color brighterThan(Color col) {
        return col == null ? null : col.brighter().brighter().brighter();
    }

    public static Color getGraduatedColour(float value, float minValue, Color minColour, float maxValue, Color maxColour) {
        if (minValue == maxValue) {
            return minColour;
        }
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        float prop = (value - minValue) / (maxValue - minValue);
        float r = (float)minColour.getRed() + prop * (float)(maxColour.getRed() - minColour.getRed());
        float g = (float)minColour.getGreen() + prop * (float)(maxColour.getGreen() - minColour.getGreen());
        float b = (float)minColour.getBlue() + prop * (float)(maxColour.getBlue() - minColour.getBlue());
        return new Color(r / 255.0f, g / 255.0f, b / 255.0f);
    }

    public static Color bleachColour(Color colour, float bleachFactor) {
        if (bleachFactor >= 1.0f) {
            return Color.WHITE;
        }
        if (bleachFactor <= -1.0f) {
            return Color.BLACK;
        }
        if (bleachFactor == 0.0f) {
            return colour;
        }
        int red = colour.getRed();
        int green = colour.getGreen();
        int blue = colour.getBlue();
        if (bleachFactor > 0.0f) {
            red = (int)((float)red + (float)(255 - red) * bleachFactor);
            green = (int)((float)green + (float)(255 - green) * bleachFactor);
            blue = (int)((float)blue + (float)(255 - blue) * bleachFactor);
            return new Color(red, green, blue);
        }
        float factor = 1.0f + bleachFactor;
        red = (int)((float)red * factor);
        green = (int)((float)green * factor);
        blue = (int)((float)blue * factor);
        return new Color(red, green, blue);
    }

    public static Color parseColourString(String colour) {
        if (colour == null) {
            return null;
        }
        colour = colour.trim();
        Color col = null;
        if ("random".equals(colour)) {
            return ColorUtils.generateRandomColor(null);
        }
        try {
            int value = Integer.parseInt(colour, 16);
            col = new Color(value);
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        if (col == null) {
            col = ColorUtils.getAWTColorFromName(colour);
        }
        if (col == null) {
            try {
                String[] tokens = colour.split(",");
                if (tokens.length == 3) {
                    int r = Integer.parseInt(tokens[0].trim());
                    int g = Integer.parseInt(tokens[1].trim());
                    int b = Integer.parseInt(tokens[2].trim());
                    col = new Color(r, g, b);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return col;
    }

    public static Color createColourFromName(String name) {
        if (name == null) {
            return Color.white;
        }
        if (myColours.containsKey(name)) {
            return myColours.get(name);
        }
        int lsize = name.length();
        int start = 0;
        int end = lsize / 3;
        int rgbOffset = Math.abs(name.hashCode() % 10) * 15;
        int r = Math.abs(name.substring(start, end).hashCode() + rgbOffset) % 210 + 20;
        start = end;
        if ((end += lsize / 3) > lsize) {
            end = lsize;
        }
        int g = Math.abs(name.substring(start, end).hashCode() + rgbOffset) % 210 + 20;
        int b = Math.abs(name.substring(end).hashCode() + rgbOffset) % 210 + 20;
        Color color = new Color(r, g, b);
        if (myColours.size() < 1729) {
            myColours.put(name, color);
        }
        return color;
    }

    public static Color getAWTColorFromName(String name) {
        if (name == null) {
            return null;
        }
        Color col = null;
        switch (name = name.toLowerCase(Locale.ROOT)) {
            case "black": {
                col = Color.black;
                break;
            }
            case "blue": {
                col = Color.blue;
                break;
            }
            case "cyan": {
                col = Color.cyan;
                break;
            }
            case "darkgray": {
                col = Color.darkGray;
                break;
            }
            case "gray": {
                col = Color.gray;
                break;
            }
            case "green": {
                col = Color.green;
                break;
            }
            case "lightgray": {
                col = Color.lightGray;
                break;
            }
            case "magenta": {
                col = Color.magenta;
                break;
            }
            case "orange": {
                col = Color.orange;
                break;
            }
            case "pink": {
                col = Color.pink;
                break;
            }
            case "red": {
                col = Color.red;
                break;
            }
            case "white": {
                col = Color.white;
                break;
            }
            case "yellow": {
                col = Color.yellow;
            }
        }
        return col;
    }

    public static float[] getHSBRanges(String colourScheme) {
        float Hmin = 0.0f;
        float Hmax = 1.0f;
        float Smin = 0.6f;
        float Smax = 1.0f;
        float Bmin = 0.6f;
        float Bmax = 1.0f;
        if (!colourScheme.contains(ColourScheme.NONE.name())) {
            block14: for (String scheme : colourScheme.split(",")) {
                ColourScheme cs;
                Console.debug("Applying colourScheme component " + scheme);
                try {
                    cs = ColourScheme.valueOf(scheme);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    Console.warn("Did not recognise something in the colour scheme '" + colourScheme + "'");
                    return new float[]{Hmin, Hmax, Smin, Smax, Bmin, Bmax};
                }
                switch (cs) {
                    case AVOID_RED: {
                        Hmin = 0.15f;
                        Hmax = 0.85f;
                        continue block14;
                    }
                    case AVOID_GREEN: {
                        Hmin = 0.48f;
                        Hmax = 0.18f;
                        continue block14;
                    }
                    case AVOID_BLUE: {
                        Hmin = 0.81f;
                        Hmax = 0.51f;
                        continue block14;
                    }
                    case SATURATED: {
                        Smin = 1.0f;
                        Smax = 1.0f;
                        continue block14;
                    }
                    case DESATURATED: {
                        Smin = 0.2f;
                        Smax = 0.6f;
                        continue block14;
                    }
                    case GREYISH: {
                        Smin = 0.0f;
                        Smax = 0.2f;
                    }
                    case GREYSCALE: {
                        Smin = 0.0f;
                        Smax = 0.0f;
                        Bmin = 0.1f;
                        Bmax = 0.9f;
                        continue block14;
                    }
                    case BRIGHT: {
                        Bmin = 1.0f;
                        Bmax = 1.0f;
                        continue block14;
                    }
                    case MEDIUM: {
                        Bmin = 0.6f;
                        Bmax = 0.8f;
                    }
                    case DARK: {
                        Bmin = 0.1f;
                        Bmax = 0.4f;
                        continue block14;
                    }
                }
            }
        }
        return new float[]{Hmin, Hmax, Smin, Smax, Bmin, Bmax};
    }

    private static String getHSBColourSpacedCacheKey(String name, String colourScheme) {
        return name.hashCode() + "::" + colourScheme;
    }

    public static void restoreMyHSBSpacedColours(Map<String, Color> colorMap) {
        for (Map.Entry<String, Color> entry : colorMap.entrySet()) {
            String cacheKey = ColorUtils.getHSBColourSpacedCacheKey(entry.getKey(), "NONE");
            myHSBSpacedColours.put(cacheKey, entry.getValue());
        }
    }

    public static Color getColourFromNameAndScheme(String name, String colourScheme) {
        String cacheKey = ColorUtils.getHSBColourSpacedCacheKey(name, colourScheme);
        if (myHSBSpacedColours.containsKey(cacheKey)) {
            return myHSBSpacedColours.get(cacheKey);
        }
        float[] vals = ColorUtils.getHSBRanges(colourScheme);
        Color col = null;
        if (vals.length > 5) {
            col = ColorUtils.getHSBColourspacedColourFromName(name, vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
            int iterationCounter = 0;
            HSB_DISTANCE_THRESHOLD = 0.5f;
            while (!ColorUtils.isColorDistinct(col)) {
                col = ColorUtils.adjustColor(col);
                if (++iterationCounter <= 100) continue;
                HSB_DISTANCE_THRESHOLD -= 0.01f;
                iterationCounter = 0;
            }
            myHSBSpacedColours.put(cacheKey, col);
        }
        return col;
    }

    public static Color getHSBColourspacedColourFromName(String name, float Hmin, float Hmax, float Smin, float Smax, float Bmin, float Bmax) {
        int b;
        int g;
        byte[] hash;
        if (name == null) {
            return Color.white;
        }
        int r = hash.length > 2 ? Byte.toUnsignedInt(hash[2]) : 0;
        float[] hsbf = Color.RGBtoHSB(r, g = hash.length > 1 ? Byte.toUnsignedInt(hash[1]) : 0, b = (hash = StringUtils.getHashedBytes(name)).length > 0 ? Byte.toUnsignedInt(hash[0]) : 0, null);
        if (hsbf.length < 3) {
            Console.warn("Unexpected short length of HSB float array");
        }
        float h0 = hsbf.length > 0 ? hsbf[0] : 0.0f;
        float s0 = hsbf.length > 1 ? hsbf[1] : 0.0f;
        float b0 = hsbf.length > 2 ? hsbf[2] : 0.0f;
        float h1 = 0.0f;
        if (Hmin > Hmax) {
            Hmax += 1.0f;
        }
        if ((h1 = Hmin + (Hmax - Hmin) * h0) > 1.0f) {
            h1 -= 1.0f;
        }
        float s1 = Smin + (Smax - Smin) * s0;
        float b1 = Bmin + (Bmax - Bmin) * b0;
        Console.debug("Setting new colour for '" + name + "' with H=" + h1 + ", S=" + s1 + ", B=" + b1);
        return Color.getHSBColor(h1, s1, b1);
    }

    private static boolean isColorDistinct(Color newColor) {
        float[] newHSB = ColorUtils.convertRGBColorToHSB(newColor);
        for (Color existingColor : myHSBSpacedColours.values()) {
            float[] existingHSB = ColorUtils.convertRGBColorToHSB(existingColor);
            float distanceFromExistingColor = ColorUtils.hsbDistance(newHSB, existingHSB);
            if (!(distanceFromExistingColor < HSB_DISTANCE_THRESHOLD)) continue;
            return false;
        }
        return true;
    }

    private static Color adjustColor(Color col) {
        float[] hsbComponents = ColorUtils.convertRGBColorToHSB(col);
        hsbComponents[0] = (float)(((double)hsbComponents[0] + 0.6180339887) % 1.0);
        if (hsbComponents[0] > 1.0f) {
            hsbComponents[0] = hsbComponents[0] - 1.0f;
        }
        hsbComponents[1] = 0.4f + hsbComponents[0] * 0.5f;
        hsbComponents[2] = 0.5f + hsbComponents[0] * 0.4f;
        Color adjustedColor = Color.getHSBColor(hsbComponents[0], hsbComponents[1], hsbComponents[2]);
        return adjustedColor;
    }

    private static float[] convertRGBColorToHSB(Color color) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return hsb;
    }

    private static float hsbDistance(float[] hsbX, float[] hsbY) {
        float diffH = Math.abs(hsbX[0] - hsbY[0]);
        if ((double)diffH > 0.5) {
            diffH = 1.0f - diffH;
        }
        float diffS = hsbX[1] - hsbY[1];
        float diffB = hsbX[2] - hsbY[2];
        return (float)Math.sqrt(diffH * diffH + diffS * diffS + diffB * diffB);
    }

    public static enum ColourScheme {
        NONE,
        AVOID_RED,
        AVOID_GREEN,
        AVOID_BLUE,
        SATURATED,
        MEDIUM_SATURATION,
        DESATURATED,
        GREYISH,
        GREYSCALE,
        BRIGHT,
        MEDIUM,
        DARK;

    }
}

