/*
 * Decompiled with CFR 0.152.
 */
package jalview.structures.models;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.SequenceRenderer;
import jalview.api.StructureSelectionManagerProvider;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.StructureViewer;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.structure.AtomSpec;
import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureCommandsI;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.SequenceStructureBindingModel;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class AAStructureBindingModel
extends SequenceStructureBindingModel
implements StructureListener,
StructureSelectionManagerProvider {
    private static final int MIN_POS_TO_SUPERPOSE = 4;
    private static final String COLOURING_STRUCTURES = MessageManager.getString("status.colouring_structures");
    private JalviewStructureDisplayI viewer;
    private StructureCommandsI commandGenerator;
    private StructureSelectionManager ssm;
    private List<String> chainNames;
    private Map<String, String> chainFile;
    private PDBEntry[] pdbEntry;
    private SequenceI[][] sequence;
    private String[][] chains;
    DataSourceType protocol = null;
    protected boolean colourBySequence = true;
    private boolean nucleotide;
    private boolean finishedInit = false;
    protected String[] modelFileNames = null;
    public String fileLoadingError;
    protected Thread externalViewerMonitor;

    public AAStructureBindingModel(StructureSelectionManager ssm, SequenceI[][] seqs) {
        this.ssm = ssm;
        this.sequence = seqs;
        this.chainNames = new ArrayList<String>();
        this.chainFile = new HashMap<String, String>();
    }

    public AAStructureBindingModel(StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        this(ssm, sequenceIs);
        this.nucleotide = Comparison.isNucleotide(sequenceIs);
        this.pdbEntry = pdbentry;
        this.protocol = protocol;
        this.resolveChains();
    }

    private boolean resolveChains() {
        int chainmaps = 0;
        String[][] newchains = new String[this.pdbEntry.length][];
        int pe = 0;
        for (PDBEntry pdb : this.pdbEntry) {
            SequenceI[] seqsForPdb = this.sequence[pe];
            if (seqsForPdb == null) continue;
            newchains[pe] = new String[seqsForPdb.length];
            int se = 0;
            for (SequenceI asq : seqsForPdb) {
                SequenceI sq;
                String chain = this.chains != null && this.chains[pe] != null ? this.chains[pe][se] : null;
                SequenceI sequenceI = sq = asq.getDatasetSequence() == null ? asq : asq.getDatasetSequence();
                if (sq.getAllPDBEntries() != null) {
                    for (PDBEntry pdbentry : sq.getAllPDBEntries()) {
                        String chaincode;
                        if (pdb.getFile() == null || pdbentry.getFile() == null || !pdb.getFile().equals(pdbentry.getFile()) || (chaincode = pdbentry.getChainCode()) == null || chaincode.length() <= 0) continue;
                        chain = chaincode;
                        ++chainmaps;
                        break;
                    }
                }
                newchains[pe][se] = chain;
                ++se;
            }
            ++pe;
        }
        this.chains = newchains;
        return chainmaps > 0;
    }

    public StructureSelectionManager getSsm() {
        return this.ssm;
    }

    public PDBEntry getPdbEntry(int i) {
        return this.pdbEntry != null && this.pdbEntry.length > i ? this.pdbEntry[i] : null;
    }

    public boolean hasPdbId(String pdbId) {
        if (this.pdbEntry != null) {
            for (PDBEntry pdb : this.pdbEntry) {
                if (!pdb.getId().equals(pdbId)) continue;
                return true;
            }
        }
        return false;
    }

    public int getPdbCount() {
        return this.pdbEntry == null ? 0 : this.pdbEntry.length;
    }

    public SequenceI[][] getSequence() {
        return this.sequence;
    }

    public String[][] getChains() {
        return this.chains;
    }

    public DataSourceType getProtocol() {
        return this.protocol;
    }

    protected void setPdbentry(PDBEntry[] pdbentry) {
        this.pdbEntry = pdbentry;
    }

    protected void setSequence(SequenceI[][] sequence) {
        this.sequence = sequence;
    }

    protected void setChains(String[][] chains) {
        this.chains = chains;
    }

    public String getDynamicViewerTitle(String viewerName, boolean verbose) {
        if (this.getSequence() == null || this.getSequence().length < 1 || this.getPdbCount() < 1 || this.getSequence()[0].length < 1) {
            return "Jalview " + viewerName + " Window";
        }
        StringBuilder title = new StringBuilder(64);
        PDBEntry pdbe = this.getPdbEntry(0);
        title.append(viewerName + " view for " + this.getSequence()[0][0].getName() + ":" + pdbe.getId());
        if (verbose) {
            String chain;
            String method = (String)pdbe.getProperty("method");
            if (method != null) {
                title.append(" Method: ").append(method);
            }
            if ((chain = (String)pdbe.getProperty("chains")) != null) {
                title.append(" Chain:").append(chain);
            }
        }
        return title.toString();
    }

    protected void releaseUIResources() {
    }

    @Override
    public void releaseReferences(Object svl) {
    }

    public boolean isColourBySequence() {
        return this.colourBySequence;
    }

    public void refreshGUI() {
    }

    public void refreshPdbEntries() {
    }

    public void setColourBySequence(boolean colourBySequence) {
        this.colourBySequence = colourBySequence;
    }

    protected void addSequenceAndChain(int pe, SequenceI[] seq, String[] tchain) {
        int i;
        if (pe < 0 || pe >= this.getPdbCount()) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_no_pdbentry_from_index", Integer.valueOf(pe).toString()));
        }
        String nullChain = "TheNullChain";
        ArrayList<SequenceI> s = new ArrayList<SequenceI>();
        ArrayList<String> c = new ArrayList<String>();
        if (this.getChains() == null) {
            this.setChains(new String[this.getPdbCount()][]);
        }
        if (this.getSequence()[pe] != null) {
            for (i = 0; i < this.getSequence()[pe].length; ++i) {
                s.add(this.getSequence()[pe][i]);
                if (this.getChains()[pe] != null) {
                    if (i < this.getChains()[pe].length) {
                        c.add(this.getChains()[pe][i]);
                        continue;
                    }
                    c.add("TheNullChain");
                    continue;
                }
                if (tchain == null || tchain.length <= 0) continue;
                c.add("TheNullChain");
            }
        }
        for (i = 0; i < seq.length; ++i) {
            if (s.contains(seq[i])) continue;
            s.add(seq[i]);
            if (tchain == null || i >= tchain.length) continue;
            c.add(tchain[i] == null ? "TheNullChain" : tchain[i]);
        }
        SequenceI[] tmp = s.toArray(new SequenceI[s.size()]);
        this.getSequence()[pe] = tmp;
        if (c.size() > 0) {
            String[] tch = c.toArray(new String[c.size()]);
            for (int i2 = 0; i2 < tch.length; ++i2) {
                if (tch[i2] != "TheNullChain") continue;
                tch[i2] = null;
            }
            this.getChains()[pe] = tch;
        } else {
            this.getChains()[pe] = null;
        }
    }

    public synchronized PDBEntry[] addSequenceAndChain(PDBEntry[] pdbe, SequenceI[][] seq, String[][] chns) {
        int i;
        ArrayList<PDBEntry> v = new ArrayList<PDBEntry>();
        ArrayList<int[]> rtn = new ArrayList<int[]>();
        for (i = 0; i < this.getPdbCount(); ++i) {
            v.add(this.getPdbEntry(i));
        }
        for (i = 0; i < pdbe.length; ++i) {
            int r = v.indexOf(pdbe[i]);
            if (r == -1 || r >= this.getPdbCount()) {
                rtn.add(new int[]{v.size(), i});
                v.add(pdbe[i]);
                continue;
            }
            this.addSequenceAndChain(r, seq[i], chns[i]);
        }
        pdbe = v.toArray(new PDBEntry[v.size()]);
        this.setPdbentry(pdbe);
        if (rtn.size() > 0) {
            SequenceI[][] sqs = new SequenceI[this.getPdbCount()][];
            String[][] sch = new String[this.getPdbCount()][];
            System.arraycopy(this.getSequence(), 0, sqs, 0, this.getSequence().length);
            System.arraycopy(this.getChains(), 0, sch, 0, this.getChains().length);
            this.setSequence(sqs);
            this.setChains(sch);
            pdbe = new PDBEntry[rtn.size()];
            for (int r = 0; r < pdbe.length; ++r) {
                int[] stri = (int[])rtn.get(r);
                pdbe[r] = this.getPdbEntry(stri[0]);
                this.addSequenceAndChain(stri[0], seq[stri[1]], chns[stri[1]]);
            }
        } else {
            pdbe = null;
        }
        return pdbe;
    }

    public void addSequence(int pe, SequenceI[] seq) {
        this.addSequenceAndChain(pe, seq, null);
    }

    public void addSequenceForStructFile(String pdbFile, SequenceI[] seq) {
        for (int pe = 0; pe < this.getPdbCount(); ++pe) {
            if (!this.getPdbEntry(pe).getFile().equals(pdbFile)) continue;
            this.addSequence(pe, seq);
        }
    }

    @Override
    public abstract void highlightAtoms(List<AtomSpec> var1);

    protected boolean isNucleotide() {
        return this.nucleotide;
    }

    public String printMappings() {
        if (this.pdbEntry == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (int pdbe = 0; pdbe < this.getPdbCount(); ++pdbe) {
            String pdbfile = this.getPdbEntry(pdbe).getFile();
            List<SequenceI> seqs = Arrays.asList(this.getSequence()[pdbe]);
            sb.append(this.getSsm().printMappings(pdbfile, seqs));
        }
        return sb.toString();
    }

    protected int getMappedPosition(SequenceI seq, int alignedPos, StructureMapping mapping) {
        if (alignedPos >= seq.getLength()) {
            return -1;
        }
        if (Comparison.isGap(seq.getCharAt(alignedPos))) {
            return -1;
        }
        int seqPos = seq.findPosition(alignedPos);
        int pos = mapping.getPDBResNum(seqPos);
        return pos;
    }

    protected int findSuperposableResidues(AlignmentI alignment, BitSet matched, SuperposeData[] structures) {
        int refStructure = -1;
        String[] files = this.getStructureFiles();
        if (files == null) {
            return -1;
        }
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mappings = this.getSsm().getMapping(files[pdbfnum]);
            int lastPos = -1;
            int seqCountForPdbFile = this.getSequence()[pdbfnum].length;
            block1: for (int s = 0; s < seqCountForPdbFile; ++s) {
                for (StructureMapping mapping : mappings) {
                    SequenceI theSequence = this.getSequence()[pdbfnum][s];
                    if (mapping.getSequence() != theSequence || alignment.findIndex(theSequence) <= -1) continue;
                    if (refStructure < 0) {
                        refStructure = pdbfnum;
                    }
                    for (int r = 0; r < alignment.getWidth(); ++r) {
                        if (!matched.get(r)) continue;
                        int pos = this.getMappedPosition(theSequence, r, mapping);
                        if (pos < 1 || pos == lastPos) {
                            matched.clear(r);
                            continue;
                        }
                        lastPos = pos;
                        structures[pdbfnum].pdbResNo[r] = pos;
                    }
                    String chain = mapping.getChain();
                    if (chain != null && chain.trim().length() > 0) {
                        structures[pdbfnum].chain = chain;
                    }
                    structures[pdbfnum].pdbId = mapping.getPdbId();
                    structures[pdbfnum].isRna = !theSequence.isProtein();
                    s = seqCountForPdbFile;
                    continue block1;
                }
            }
        }
        return refStructure;
    }

    protected boolean waitForFileLoad(String[] files) {
        long starttime = System.currentTimeMillis();
        long endTime = (long)(10000 + 1000 * files.length) + starttime;
        String notLoaded = null;
        boolean waiting = true;
        while (waiting && System.currentTimeMillis() < endTime) {
            waiting = false;
            String[] stringArray = files;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String file;
                notLoaded = file = stringArray[i];
                if (file == null) continue;
                try {
                    StructureMapping[] sm = this.getSsm().getMapping(file);
                    if (sm != null && sm.length != 0) continue;
                    waiting = true;
                    continue;
                }
                catch (Throwable x) {
                    waiting = true;
                }
            }
        }
        if (waiting) {
            Console.errPrintln("Timed out waiting for structure viewer to load file " + notLoaded);
            return false;
        }
        return true;
    }

    @Override
    public boolean isListeningFor(SequenceI seq) {
        if (this.sequence != null) {
            for (SequenceI[] seqs : this.sequence) {
                if (seqs == null) continue;
                for (SequenceI s : seqs) {
                    if (s != seq && (s.getDatasetSequence() == null || s.getDatasetSequence() != seq.getDatasetSequence())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFinishedInit() {
        return this.finishedInit;
    }

    public void setFinishedInit(boolean fi) {
        this.finishedInit = fi;
    }

    public List<String> getChainNames() {
        return this.chainNames;
    }

    public JalviewStructureDisplayI getViewer() {
        return this.viewer;
    }

    public void setViewer(JalviewStructureDisplayI v) {
        this.viewer = v;
    }

    public String superposeStructures(List<AlignmentViewPanel> alignWith) {
        Object error = "";
        String[] files = this.getStructureFiles();
        if (!this.waitForFileLoad(files)) {
            return null;
        }
        this.refreshPdbEntries();
        for (AlignmentViewPanel view : alignWith) {
            AlignmentI alignment = view.getAlignment();
            HiddenColumns hiddenCols = alignment.getHiddenColumns();
            int width = alignment.getWidth();
            BitSet matched = new BitSet();
            ColumnSelection cs = view.getAlignViewport().getColumnSelection();
            if (cs != null && cs.hasSelectedColumns() && cs.getSelected().size() >= 4) {
                for (int s : cs.getSelected()) {
                    matched.set(s);
                }
            } else {
                for (int m = 0; m < width; ++m) {
                    if (hiddenCols != null && !hiddenCols.isVisible(m)) continue;
                    matched.set(m);
                }
            }
            SuperposeData[] structures = new SuperposeData[files.length];
            for (int f = 0; f < files.length; ++f) {
                structures[f] = new SuperposeData(width, this.getModelIdForFile(files[f]));
            }
            int refStructure = this.findSuperposableResidues(alignment, matched, structures);
            int nmatched = matched.cardinality();
            if (nmatched < 4) {
                String msg = MessageManager.formatMessage("label.insufficient_residues", nmatched);
                error = (String)error + view.getViewName() + ": " + msg + "; ";
                continue;
            }
            AtomSpecModel refAtoms = this.getAtomSpec(structures[refStructure], matched);
            this.executeCommands(this.commandGenerator.showBackbone(), true, null);
            StructureCommandsI.AtomSpecType backbone = structures[refStructure].isRna ? StructureCommandsI.AtomSpecType.PHOSPHATE : StructureCommandsI.AtomSpecType.ALPHA;
            ArrayList<AtomSpecModel> models = new ArrayList<AtomSpecModel>();
            models.add(refAtoms);
            for (int i = 0; i < structures.length; ++i) {
                if (i == refStructure) continue;
                AtomSpecModel atomSpec = this.getAtomSpec(structures[i], matched);
                List<StructureCommandI> commands = this.commandGenerator.superposeStructures(refAtoms, atomSpec, backbone);
                List<String> replies = this.executeCommands(commands, true, null);
                for (String reply : replies) {
                    if (!reply.toLowerCase(Locale.ROOT).contains("unequal numbers of atoms")) continue;
                    error = (String)error + "; " + reply;
                }
                models.add(atomSpec);
            }
            List<StructureCommandI> finalView = this.commandGenerator.centerViewOn(models);
            if (finalView == null || finalView.size() <= 0) continue;
            this.executeCommands(finalView, false, "Centered on Superposition");
        }
        return error;
    }

    private AtomSpecModel getAtomSpec(SuperposeData superposeData, BitSet matched) {
        AtomSpecModel model = new AtomSpecModel();
        int nextColumnMatch = matched.nextSetBit(0);
        while (nextColumnMatch != -1) {
            int pdbResNum = superposeData.pdbResNo[nextColumnMatch];
            model.addRange(superposeData.modelId, pdbResNum, pdbResNum, superposeData.chain);
            nextColumnMatch = matched.nextSetBit(nextColumnMatch + 1);
        }
        return model;
    }

    public abstract SequenceRenderer getSequenceRenderer(AlignmentViewPanel var1);

    public void colourByChain() {
        this.colourBySequence = false;
        this.executeCommand(false, COLOURING_STRUCTURES, this.commandGenerator.colourByChain());
    }

    public void colourByCharge() {
        this.colourBySequence = false;
        this.executeCommands(this.commandGenerator.colourByCharge(), false, COLOURING_STRUCTURES);
    }

    public void colourByJalviewColourScheme(ColourSchemeI cs) {
        this.colourBySequence = false;
        if (cs == null || !cs.isSimple()) {
            return;
        }
        HashMap<String, Color> colours = new HashMap<String, Color>();
        List<String> residues = ResidueProperties.getResidues(this.isNucleotide(), false);
        for (String resName : residues) {
            char res = resName.length() == 3 ? ResidueProperties.getSingleCharacterCode(resName) : resName.charAt(0);
            Color colour = cs.findColour(res, 0, null, null, 0.0f);
            colours.put(resName, colour);
        }
        List<StructureCommandI> cmd = this.commandGenerator.colourByResidues(colours);
        this.executeCommands(cmd, false, COLOURING_STRUCTURES);
    }

    public void setBackgroundColour(Color col) {
        StructureCommandI cmd = this.commandGenerator.setBackgroundColour(col);
        this.executeCommand(false, null, cmd);
    }

    protected abstract List<String> executeCommand(StructureCommandI var1, boolean var2);

    public List<String> executeCommands(List<StructureCommandI> commands, boolean getReply, String msg) {
        return this.executeCommand(getReply, msg, commands.toArray(new StructureCommandI[commands.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> executeCommand(boolean getReply, final String msg, final StructureCommandI ... cmds) {
        long handle;
        final JalviewStructureDisplayI theViewer = this.getViewer();
        long l = handle = msg == null ? 0L : theViewer.startProgressBar(msg);
        if (getReply) {
            ArrayList<String> response = new ArrayList<String>();
            try {
                for (StructureCommandI cmd : cmds) {
                    List<String> replies = this.executeCommand(cmd, true);
                    if (replies == null) continue;
                    response.addAll(replies);
                }
                ArrayList<String> arrayList = response;
                return arrayList;
            }
            finally {
                if (msg != null) {
                    theViewer.stopProgressBar(null, handle);
                }
            }
        }
        String threadName = msg == null ? "StructureCommand" : msg;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    for (StructureCommandI cmd : cmds) {
                        AAStructureBindingModel.this.executeCommand(cmd, false);
                    }
                    if (msg == null) return;
                }
                catch (Throwable throwable) {
                    if (msg == null) throw throwable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            theViewer.stopProgressBar(null, handle);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }, threadName).start();
        return null;
    }

    public void colourBySequence(AlignmentViewPanel alignmentv) {
        if (!this.colourBySequence || !this.isLoadingFinished() || this.getSsm() == null) {
            return;
        }
        Map<Object, AtomSpecModel> colourMap = this.buildColoursMap(this.ssm, this.sequence, alignmentv);
        List<StructureCommandI> colourBySequenceCommands = this.commandGenerator.colourBySequence(colourMap);
        this.executeCommands(colourBySequenceCommands, false, COLOURING_STRUCTURES);
    }

    public void focusView() {
        this.executeCommand(false, null, this.commandGenerator.focusView());
    }

    public void showChains(List<String> toShow) {
        ArrayList<String> showThese = new ArrayList<String>();
        for (String chainId : toShow) {
            String[] tokens = chainId.split("\\:");
            if (tokens.length != 2) continue;
            String pdbFile = this.getFileForChain(chainId);
            String model = this.getModelIdForFile(pdbFile);
            showThese.add(model + ":" + tokens[1]);
        }
        this.executeCommands(this.commandGenerator.showChains(showThese), false, null);
    }

    public void showAllChains() {
        this.showChains(this.getChainNames());
    }

    protected abstract String getModelIdForFile(String var1);

    public boolean hasFileLoadingError() {
        return this.fileLoadingError != null && this.fileLoadingError.length() > 0;
    }

    public FeatureRenderer getFeatureRenderer(AlignmentViewPanel avp) {
        AlignmentViewPanel ap;
        AlignmentViewPanel alignmentViewPanel = ap = avp == null ? this.getViewer().getAlignmentPanel() : avp;
        if (ap == null) {
            return null;
        }
        return ap.getFeatureRenderer();
    }

    protected void setStructureCommands(StructureCommandsI cmd) {
        this.commandGenerator = cmd;
    }

    public void addChainFile(String chainId, String fileName) {
        this.chainFile.put(chainId, fileName);
    }

    protected String getFileForChain(String chainId) {
        return this.chainFile.get(chainId);
    }

    @Override
    public void updateColours(Object source) {
        if (this.getViewer() == null) {
            return;
        }
        AlignmentViewPanel ap = (AlignmentViewPanel)source;
        if (!this.getViewer().isUsedForColourBy(ap)) {
            return;
        }
        if (!this.isLoadingFromArchive()) {
            this.colourBySequence(ap);
        }
    }

    public StructureCommandsI getCommandGenerator() {
        return this.commandGenerator;
    }

    protected abstract StructureViewer.ViewerType getViewerType();

    protected Map<Object, AtomSpecModel> buildColoursMap(StructureSelectionManager ssm, SequenceI[][] sequence, AlignmentViewPanel viewPanel) {
        String[] files = this.getStructureFiles();
        SequenceRenderer sr = this.getSequenceRenderer(viewPanel);
        FeatureRenderer fr = viewPanel.getFeatureRenderer();
        FeatureColourFinder finder = new FeatureColourFinder(fr);
        AlignViewportI viewport = viewPanel.getAlignViewport();
        HiddenColumns cs = viewport.getAlignment().getHiddenColumns();
        AlignmentI al = viewport.getAlignment();
        LinkedHashMap<Object, AtomSpecModel> colourMap = new LinkedHashMap<Object, AtomSpecModel>();
        Color lastColour = null;
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            String modelId = this.getModelIdForFile(files[pdbfnum]);
            StructureMapping[] mapping = ssm.getMapping(files[pdbfnum]);
            if (mapping == null || mapping.length < 1) continue;
            int startPos = -1;
            int lastPos = -1;
            String lastChain = "";
            for (int s = 0; s < sequence[pdbfnum].length; ++s) {
                for (int m = 0; m < mapping.length; ++m) {
                    int sp;
                    SequenceI seq = sequence[pdbfnum][s];
                    if (mapping[m].getSequence() != seq || (sp = al.findIndex(seq)) <= -1) continue;
                    SequenceI asp = al.getSequenceAt(sp);
                    for (int r = 0; r < asp.getLength(); ++r) {
                        boolean newChain;
                        int pos;
                        if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) < 1 || pos == lastPos) continue;
                        Color colour = sr.getResidueColour(seq, r, finder);
                        if (!cs.isVisible(r)) {
                            colour = Color.GRAY;
                        }
                        String chain = mapping[m].getChain();
                        boolean newColour = !colour.equals(lastColour);
                        boolean nonContig = lastPos + 1 != pos;
                        boolean bl = newChain = !chain.equals(lastChain);
                        if (newColour || nonContig || newChain) {
                            if (startPos != -1) {
                                AAStructureBindingModel.addAtomSpecRange(colourMap, lastColour, modelId, startPos, lastPos, lastChain);
                            }
                            startPos = pos;
                        }
                        lastColour = colour;
                        lastPos = pos;
                        lastChain = chain;
                    }
                    if (lastColour == null) continue;
                    AAStructureBindingModel.addAtomSpecRange(colourMap, lastColour, modelId, startPos, lastPos, lastChain);
                }
            }
        }
        return colourMap;
    }

    protected String getModelId(int pdbfnum, String file) {
        return String.valueOf(pdbfnum);
    }

    public void stashFoundChains(StructureFile pdb, String file) {
        for (int i = 0; i < pdb.getChains().size(); ++i) {
            String chid = pdb.getId() + ":" + pdb.getChains().elementAt((int)i).id;
            this.addChainFile(chid, file);
            this.getChainNames().add(chid);
        }
    }

    public static final void addAtomSpecRange(Map<Object, AtomSpecModel> map, Object value, String model, int startPos, int endPos, String chain) {
        AtomSpecModel atomSpec = map.get(value);
        if (atomSpec == null) {
            atomSpec = new AtomSpecModel();
            map.put(value, atomSpec);
        }
        atomSpec.addRange(model, startPos, endPos, chain);
    }

    public String getSessionFileExtension() {
        return null;
    }

    public File saveSession() {
        String prefix = this.getViewerType().toString();
        String suffix = this.getSessionFileExtension();
        File f = null;
        try {
            f = File.createTempFile(prefix, suffix);
            this.saveSession(f);
        }
        catch (IOException e) {
            Console.error(String.format("Error saving %s session: %s", prefix, e.toString()));
        }
        return f;
    }

    public void restoreSession(String absolutePath) {
        String prefix = this.getViewerType().toString();
        try {
            StructureCommandI cmd = this.commandGenerator.restoreSession(absolutePath);
            if (cmd != null) {
                this.executeCommand(cmd, false);
            }
        }
        catch (Throwable e) {
            Console.error(String.format("Error restoring %s session: %s", prefix, e.toString()));
        }
    }

    protected void saveSession(File f) {
        try {
            Console.trace("Saving session to " + f.getCanonicalPath().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StructureCommandI cmd = this.commandGenerator.saveSession(f.getPath());
        if (cmd != null) {
            this.executeCommand(cmd, true);
        }
        try {
            Console.trace("Done saving session to " + f.getCanonicalPath().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isViewerRunning() {
        return false;
    }

    public void closeViewer(boolean forceClose) {
        StructureCommandI cmd;
        this.getSsm().removeStructureViewerListener(this, this.getStructureFiles());
        this.releaseUIResources();
        if (this.externalViewerMonitor != null) {
            this.externalViewerMonitor.interrupt();
            this.externalViewerMonitor = null;
        }
        this.stopListening();
        if (forceClose && (cmd = this.getCommandGenerator().closeViewer()) != null) {
            this.executeCommand(cmd, false);
        }
    }

    public String getHelpURL() {
        return null;
    }

    protected Map<String, Map<Object, AtomSpecModel>> buildFeaturesMap(AlignmentViewPanel viewPanel) {
        AlignViewportI comp;
        LinkedHashMap<String, Map<Object, AtomSpecModel>> theMap = new LinkedHashMap<String, Map<Object, AtomSpecModel>>();
        String[] files = this.getStructureFiles();
        if (files == null) {
            return theMap;
        }
        FeatureRenderer fr = viewPanel.getFeatureRenderer();
        if (fr == null) {
            return theMap;
        }
        AlignViewportI viewport = viewPanel.getAlignViewport();
        List<String> visibleFeatures = fr.getDisplayedFeatureTypes();
        boolean showLinkedFeatures = viewport.isShowComplementFeatures();
        List<Object> complementFeatures = new ArrayList();
        jalview.gui.FeatureRenderer complementRenderer = null;
        if (showLinkedFeatures && (comp = fr.getViewport().getCodingComplement()) != null) {
            complementRenderer = Desktop.getAlignFrameFor(comp).getFeatureRenderer();
            complementFeatures = complementRenderer.getDisplayedFeatureTypes();
        }
        if (visibleFeatures.isEmpty() && complementFeatures.isEmpty()) {
            return theMap;
        }
        AlignmentI alignment = viewPanel.getAlignment();
        SequenceI[][] seqs = this.getSequence();
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            String modelId = this.getModelIdForFile(files[pdbfnum]);
            StructureMapping[] mapping = this.ssm.getMapping(files[pdbfnum]);
            if (mapping == null || mapping.length < 1) continue;
            for (int seqNo = 0; seqNo < seqs[pdbfnum].length; ++seqNo) {
                for (int m = 0; m < mapping.length; ++m) {
                    SequenceI seq = seqs[pdbfnum][seqNo];
                    int sp = alignment.findIndex(seq);
                    StructureMapping structureMapping = mapping[m];
                    if (structureMapping.getSequence() != seq || sp <= -1) continue;
                    if (!visibleFeatures.isEmpty()) {
                        AAStructureBindingModel.scanSequenceFeatures(visibleFeatures, structureMapping, seq, theMap, modelId);
                    }
                    if (!showLinkedFeatures) continue;
                    AAStructureBindingModel.scanComplementFeatures(complementRenderer, structureMapping, seq, theMap, modelId);
                }
            }
        }
        return theMap;
    }

    public boolean openSession(String filepath) {
        StructureCommandI cmd = this.getCommandGenerator().openSession(filepath);
        if (cmd == null) {
            return false;
        }
        this.executeCommand(cmd, true);
        return true;
    }

    protected static void scanComplementFeatures(FeatureRenderer complementRenderer, StructureMapping structureMapping, SequenceI seq, Map<String, Map<Object, AtomSpecModel>> theMap, String modelNumber) {
        for (int seqPos : structureMapping.getMapping().keySet()) {
            MappedFeatures mf = complementRenderer.findComplementFeaturesAtResidue(seq, seqPos);
            if (mf == null) continue;
            for (SequenceFeature sf : mf.features) {
                Map<Object, AtomSpecModel> featureValues;
                float score;
                List<int[]> mappedRanges;
                String type = sf.getType();
                if ("Chimera".equals(sf.getFeatureGroup()) || (mappedRanges = structureMapping.getPDBResNumRanges(seqPos, seqPos)).isEmpty()) continue;
                String value = sf.getDescription();
                if (value == null || value.length() == 0) {
                    value = type;
                }
                if ((score = sf.getScore()) != 0.0f && !Float.isNaN(score)) {
                    value = Float.toString(score);
                }
                if ((featureValues = theMap.get(type)) == null) {
                    featureValues = new HashMap<Object, AtomSpecModel>();
                    theMap.put(type, featureValues);
                }
                for (int[] range : mappedRanges) {
                    AAStructureBindingModel.addAtomSpecRange(featureValues, value, modelNumber, range[0], range[1], structureMapping.getChain());
                }
            }
        }
    }

    protected static void scanSequenceFeatures(List<String> visibleFeatures, StructureMapping mapping, SequenceI seq, Map<String, Map<Object, AtomSpecModel>> theMap, String modelId) {
        List<SequenceFeature> sfs = seq.getFeatures().getPositionalFeatures(visibleFeatures.toArray(new String[visibleFeatures.size()]));
        for (SequenceFeature sf : sfs) {
            Map<Object, AtomSpecModel> featureValues;
            float score;
            List<int[]> mappedRanges;
            String type = sf.getType();
            if ("Chimera".equals(sf.getFeatureGroup()) || (mappedRanges = mapping.getPDBResNumRanges(sf.getBegin(), sf.getEnd())).isEmpty()) continue;
            String value = sf.getDescription();
            if (value == null || value.length() == 0) {
                value = type;
            }
            if ((score = sf.getScore()) != 0.0f && !Float.isNaN(score)) {
                value = Float.toString(score);
            }
            if ((featureValues = theMap.get(type)) == null) {
                featureValues = new HashMap<Object, AtomSpecModel>();
                theMap.put(type, featureValues);
            }
            for (int[] range : mappedRanges) {
                AAStructureBindingModel.addAtomSpecRange(featureValues, value, modelId, range[0], range[1], mapping.getChain());
            }
        }
    }

    public int getMappedStructureCount() {
        String[] files = this.getStructureFiles();
        return files == null ? 0 : files.length;
    }

    protected void startExternalViewerMonitor(final Process p) {
        this.externalViewerMonitor = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    p.waitFor();
                    JalviewStructureDisplayI display = AAStructureBindingModel.this.getViewer();
                    if (display != null) {
                        display.closeViewer(false);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.externalViewerMonitor.start();
    }

    protected void startListening(String uri) {
        List<StructureCommandI> commands = this.getCommandGenerator().startNotifications(uri);
        if (commands != null) {
            this.executeCommands(commands, false, null);
        }
    }

    protected void stopListening() {
        List<StructureCommandI> commands = this.getCommandGenerator().stopNotifications();
        if (commands != null) {
            this.executeCommands(commands, false, null);
        }
    }

    public int copyStructureAttributesToFeatures(String attName, AlignmentPanel alignmentPanel) {
        StructureCommandI cmd = this.getCommandGenerator().getResidueAttributes(attName);
        if (cmd == null) {
            return 0;
        }
        List<String> residueAttributes = this.executeCommand(cmd, true);
        int featuresAdded = this.createFeaturesForAttributes(attName, residueAttributes);
        if (featuresAdded > 0) {
            alignmentPanel.getFeatureRenderer().featuresAdded();
        }
        return featuresAdded;
    }

    protected int createFeaturesForAttributes(String attName, List<String> residueAttributes) {
        return 0;
    }

    public Map<String, String> getHetatmNames() {
        return Collections.EMPTY_MAP;
    }

    public void showHetatms(List<String> toShow) {
        this.executeCommands(this.commandGenerator.showHetatms(toShow), false, "Adjusting hetatm visibility");
    }

    public static class SuperposeData {
        public String filename;
        public String pdbId;
        public String chain = "";
        public boolean isRna;
        public int[] pdbResNo;
        public String modelId;

        public SuperposeData(int width, String model) {
            this.pdbResNo = new int[width];
            this.modelId = model;
        }
    }
}

