/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.util.ColorUtils;
import jalview.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class UserColourScheme
extends ResidueColourScheme {
    Color[] lowerCaseColours;
    protected String schemeName;

    public UserColourScheme() {
        super(ResidueProperties.aaIndex);
    }

    public UserColourScheme(Color[] newColors) {
        super(ResidueProperties.aaIndex);
        this.colors = newColors;
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI sg) {
        return new UserColourScheme(this);
    }

    protected UserColourScheme(UserColourScheme from) {
        this(from.colors);
        this.schemeName = from.schemeName;
        if (from.lowerCaseColours != null) {
            this.lowerCaseColours = new Color[from.lowerCaseColours.length];
            System.arraycopy(from.lowerCaseColours, 0, this.lowerCaseColours, 0, from.lowerCaseColours.length);
        }
    }

    public UserColourScheme(String colour) {
        super(ResidueProperties.aaIndex);
        if (colour.contains("=")) {
            this.parseAppletParameter(colour);
            return;
        }
        Color col = ColorUtils.parseColourString(colour);
        if (col == null) {
            Console.outPrintln("Making colour from name: " + colour);
            col = ColorUtils.createColourFromName(colour);
        }
        this.setAll(col);
        this.schemeName = colour;
    }

    protected void setAll(Color col) {
        if (this.symbolIndex == null) {
            return;
        }
        int max = 0;
        for (int index : this.symbolIndex) {
            max = Math.max(max, index);
        }
        this.colors = new Color[max + 1];
        for (int i = 0; i <= max; ++i) {
            this.colors[i] = col;
        }
    }

    public Color[] getColours() {
        return this.colors;
    }

    public Color[] getLowerCaseColours() {
        return this.lowerCaseColours;
    }

    public void setName(String name) {
        this.schemeName = name;
    }

    public String getName() {
        return this.schemeName;
    }

    void parseAppletParameter(String paramValue) {
        this.setAll(Color.white);
        StringTokenizer st = new StringTokenizer(paramValue, ";");
        String token = null;
        try {
            while (st.hasMoreElements()) {
                token = st.nextToken().trim();
                String residues = token.substring(0, token.indexOf("="));
                String colour = token.substring(token.indexOf("=") + 1);
                StringTokenizer st2 = new StringTokenizer(residues, " ,");
                while (st2.hasMoreTokens()) {
                    String residue = st2.nextToken();
                    int colIndex = ResidueProperties.aaIndex[residue.charAt(0)];
                    if (colIndex == -1) continue;
                    if (residue.equalsIgnoreCase("lowerCase")) {
                        if (this.lowerCaseColours == null) {
                            this.lowerCaseColours = new Color[this.colors.length];
                        }
                        for (int i = 0; i < this.lowerCaseColours.length; ++i) {
                            if (this.lowerCaseColours[i] != null) continue;
                            this.lowerCaseColours[i] = ColorUtils.parseColourString(colour);
                        }
                        continue;
                    }
                    if (residue.equals(residue.toLowerCase(Locale.ROOT))) {
                        if (this.lowerCaseColours == null) {
                            this.lowerCaseColours = new Color[this.colors.length];
                        }
                        this.lowerCaseColours[colIndex] = ColorUtils.parseColourString(colour);
                        continue;
                    }
                    this.colors[colIndex] = ColorUtils.parseColourString(colour);
                }
            }
        }
        catch (Exception ex) {
            Console.outPrintln("Error parsing userDefinedColours:\n" + token + "\n" + ex);
        }
    }

    public void setLowerCaseColours(Color[] lcolours) {
        this.lowerCaseColours = lcolours;
    }

    @Override
    public Color findColour(char c) {
        Color colour;
        if ('a' <= c && c <= 'z' && this.lowerCaseColours != null && (colour = this.lowerCaseColours[this.symbolIndex[c]]) != null) {
            return colour;
        }
        return super.findColour(c);
    }

    @Override
    public String getSchemeName() {
        if (this.schemeName != null && this.schemeName.length() > 0) {
            return this.schemeName;
        }
        return "User Defined";
    }

    public String toAppletParameter() {
        HashMap colours = new HashMap();
        for (char symbol = 'A'; symbol <= 'Z'; symbol = (char)(symbol + '\u0001')) {
            String residue = String.valueOf(symbol);
            int index = this.symbolIndex[symbol];
            Color c = this.colors[index];
            if (c != null && !c.equals(Color.white)) {
                if (colours.get(c) == null) {
                    colours.put(c, new ArrayList());
                }
                ((List)colours.get(c)).add(residue);
            }
            if (this.lowerCaseColours == null || (c = this.lowerCaseColours[index]) == null || c.equals(Color.white)) continue;
            residue = residue.toLowerCase(Locale.ROOT);
            if (colours.get(c) == null) {
                colours.put(c, new ArrayList());
            }
            ((List)colours.get(c)).add(residue);
        }
        ArrayList<String> residueColours = new ArrayList<String>();
        for (Map.Entry cols : colours.entrySet()) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (String residue : (List)cols.getValue()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(residue);
                first = false;
            }
            sb.append("=");
            String hexString = Integer.toHexString(((Color)cols.getKey()).getRGB()).substring(2);
            sb.append(hexString);
            residueColours.add(sb.toString());
        }
        Collections.sort(residueColours);
        return StringUtils.listToDelimitedString(residueColours, ";");
    }

    @Override
    public boolean hasGapColour() {
        return this.findColour(' ') != null;
    }
}

