/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ScoreColourScheme;
import java.awt.Color;

public class HelixColourScheme
extends ScoreColourScheme {
    public HelixColourScheme() {
        super(ResidueProperties.aaIndex, ResidueProperties.helix, 0.57, 1.51);
    }

    @Override
    public Color makeColour(float c) {
        return new Color(c, 1.0f - c, c);
    }

    @Override
    public boolean isPeptideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.Helix.toString();
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new HelixColourScheme();
    }
}

