/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.util.ColorUtils;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;

public class CovariationColourScheme
extends ResidueColourScheme {
    public Map<String, Color> helixcolorhash = new Hashtable<String, Color>();
    public Map<Integer, String> positionsToHelix = new Hashtable<Integer, String>();
    int numHelix = 0;
    public AlignmentAnnotation annotation;

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new CovariationColourScheme(coll.getAlignmentAnnotation()[0]);
    }

    public CovariationColourScheme(AlignmentAnnotation annotation) {
        this.annotation = annotation;
        for (int x = 0; x < this.annotation._rnasecstr.length; ++x) {
            this.positionsToHelix.put(this.annotation._rnasecstr[x].getBegin(), this.annotation._rnasecstr[x].getFeatureGroup());
            this.positionsToHelix.put(this.annotation._rnasecstr[x].getEnd(), this.annotation._rnasecstr[x].getFeatureGroup());
            if (Integer.parseInt(this.annotation._rnasecstr[x].getFeatureGroup()) <= this.numHelix) continue;
            this.numHelix = Integer.parseInt(this.annotation._rnasecstr[x].getFeatureGroup());
        }
        for (int j = 0; j <= this.numHelix; ++j) {
            this.helixcolorhash.put(String.valueOf(j), ColorUtils.generateRandomColor(Color.white));
        }
    }

    @Override
    public Color findColour(char c) {
        return ResidueProperties.purinepyrimidine[ResidueProperties.purinepyrimidineIndex[c]];
    }

    public Color findColour(char c, int j) {
        Color currentColour = Color.white;
        String currentHelix = null;
        currentHelix = this.positionsToHelix.get(j);
        if (currentHelix != null) {
            currentColour = this.helixcolorhash.get(currentHelix);
        }
        return currentColour;
    }

    @Override
    public boolean isNucleotideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return "Covariation";
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

