/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContactListI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.VisibleContigsIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ContactGeometry {
    final ContactListI contacts;
    final int pixels_step;
    final double contacts_per_pixel;
    final int contact_height;
    final int graphHeight;
    final double contacts_step;
    final int lastStep;

    public ContactGeometry(ContactListI contacts, int graphHeight) {
        this.contacts = contacts;
        this.graphHeight = graphHeight;
        this.contact_height = contacts.getContactHeight();
        this.contacts_per_pixel = graphHeight <= 1 ? (double)this.contact_height : (double)this.contact_height / (double)graphHeight;
        this.pixels_step = this.contacts_per_pixel >= 1.0 ? 1 : (int)Math.ceil((double)graphHeight / (double)this.contact_height);
        this.contacts_step = (double)this.pixels_step * this.contacts_per_pixel;
        this.lastStep = (int)Math.min((double)graphHeight, (double)graphHeight / (double)this.pixels_step);
    }

    boolean intersects(contactInterval ci, ColumnSelection columnSelection, HiddenColumns hiddenColumns, boolean visibleOnly) {
        boolean rowsel = false;
        int[] mappedRange = this.contacts.getMappedPositionsFor(ci.cStart, ci.cEnd);
        if (mappedRange == null) {
            return false;
        }
        for (int p = 0; p < mappedRange.length && !rowsel; p += 2) {
            boolean containsHidden = false;
            if (visibleOnly && hiddenColumns != null && hiddenColumns.hasHiddenColumns()) {
                VisibleContigsIterator viscont = hiddenColumns.getVisContigsIterator(-1 + mappedRange[p], -1 + mappedRange[p + 1], false);
                boolean bl = containsHidden = !viscont.hasNext();
                if (containsHidden) continue;
                int[] interval = (int[])viscont.next();
                while (viscont.hasNext()) {
                    rowsel |= columnSelection.intersects(interval[p], interval[p + 1]);
                }
                continue;
            }
            rowsel = columnSelection.intersects(-1 + mappedRange[p], -1 + mappedRange[p + 1]);
        }
        return rowsel;
    }

    public contactInterval mapFor(int pStart, int pEnd) {
        if (pStart < 0) {
            pStart = 0;
        }
        if (pEnd < pStart) {
            pEnd = pStart;
        }
        if (pEnd >= this.graphHeight) {
            pEnd = this.graphHeight - 1;
        }
        if (pStart >= this.graphHeight) {
            pStart = this.graphHeight - this.pixels_step;
        }
        int step = Math.floorDiv(pStart, this.pixels_step);
        return this.findStep(step);
    }

    contactInterval findStep(int step) {
        if (step < 0 || step > this.lastStep) {
            return null;
        }
        return new contactInterval((int)Math.floor(this.contacts_step * (double)step), -1 + (int)Math.min((double)this.contact_height, Math.floor(this.contacts_step * (double)(step + 1))), this.pixels_step * step, Math.min(this.graphHeight, (step + 1) * this.pixels_step) - 1);
    }

    public contactInterval mapFor(int pCentre) {
        if (pCentre >= this.graphHeight + this.pixels_step) {
            return null;
        }
        int step = Math.floorDiv(pCentre, this.pixels_step);
        return this.findStep(step);
    }

    public List<contactInterval> allSteps() {
        contactInterval[] array = new contactInterval[this.lastStep + 1];
        int csum = 0;
        int psum = 0;
        for (int i = 0; i <= this.lastStep; ++i) {
            array[i] = this.findStep(i);
            csum += 1 + array[i].cEnd - array[i].cStart;
            psum += 1 + array[i].pEnd - array[i].pStart;
        }
        if (csum != this.contact_height || psum != this.graphHeight) {
            System.err.println("csum = " + csum + " not " + this.contact_height + "\npsum = " + psum + " not " + this.graphHeight);
            return null;
        }
        return Arrays.asList(array);
    }

    public Iterator<contactInterval> iterateOverContactIntervals(int graphHeight) {
        return null;
    }

    public class contactInterval {
        public final int cStart;
        public final int cEnd;
        public final int pStart;
        public final int pEnd;

        public contactInterval(int cStart, int cEnd, int pStart, int pEnd) {
            this.cStart = cStart;
            this.cEnd = cEnd;
            this.pStart = pStart;
            this.pEnd = pEnd;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof contactInterval)) {
                return false;
            }
            contactInterval them = (contactInterval)obj;
            return this.cStart == them.cStart && this.cEnd == them.cEnd && this.pEnd == them.pEnd && this.pStart == them.pStart;
        }

        public String toString() {
            return "Contacts [" + this.cStart + "," + this.cEnd + "] : Pixels [" + this.pStart + "," + this.pEnd + "]";
        }
    }
}

